/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.support.annotation.Nullable;
import com.facebook.litho.AnimatableItem;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.DisplayListContainer;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.litho.displaylist.DisplayList;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.atomic.AtomicInteger;

class LayoutOutput
implements Cloneable,
AnimatableItem {
    public static final int TYPE_CONTENT = 0;
    public static final int TYPE_BACKGROUND = 1;
    public static final int TYPE_FOREGROUND = 2;
    public static final int TYPE_HOST = 3;
    public static final int TYPE_BORDER = 4;
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_UPDATED = 1;
    public static final int STATE_DIRTY = 2;
    @Nullable
    private NodeInfo mNodeInfo;
    private ViewNodeInfo mViewNodeInfo;
    private long mId;
    private Component<?> mComponent;
    private final Rect mBounds = new Rect();
    private int mHostTranslationX;
    private int mHostTranslationY;
    private int mFlags;
    private long mHostMarker = -1L;
    private AtomicInteger mRefCount = new AtomicInteger(0);
    private int mUpdateState = 0;
    private int mImportantForAccessibility = 0;
    @Nullable
    private DisplayListContainer mDisplayListContainer;

    Component<?> getComponent() {
        return this.mComponent;
    }

    void setComponent(Component<?> component) {
        this.mComponent = component;
    }

    void getMountBounds(Rect outRect) {
        outRect.left = this.mBounds.left - this.mHostTranslationX;
        outRect.top = this.mBounds.top - this.mHostTranslationY;
        outRect.right = this.mBounds.right - this.mHostTranslationX;
        outRect.bottom = this.mBounds.bottom - this.mHostTranslationY;
    }

    @Override
    public Rect getBounds() {
        return this.mBounds;
    }

    @Override
    public float getScale() {
        return this.mNodeInfo != null ? this.mNodeInfo.getScale() : 1.0f;
    }

    @Override
    public float getAlpha() {
        return this.mNodeInfo != null ? this.mNodeInfo.getAlpha() : 1.0f;
    }

    @Override
    public boolean isScaleSet() {
        return this.mNodeInfo != null && this.mNodeInfo.isScaleSet();
    }

    @Override
    public boolean isAlphaSet() {
        return this.mNodeInfo != null && this.mNodeInfo.isAlphaSet();
    }

    void setBounds(int l, int t, int r, int b) {
        this.mBounds.set(l, t, r, b);
    }

    void setHostTranslationX(int hostTranslationX) {
        this.mHostTranslationX = hostTranslationX;
    }

    void setHostTranslationY(int hostTranslationY) {
        this.mHostTranslationY = hostTranslationY;
    }

    int getFlags() {
        return this.mFlags;
    }

    void setFlags(int flags) {
        this.mFlags = flags;
    }

    long getHostMarker() {
        return this.mHostMarker;
    }

    void setHostMarker(long hostMarker) {
        this.mHostMarker = hostMarker;
    }

    long getId() {
        return this.mId;
    }

    void setId(long id2) {
        this.mId = id2;
    }

    void setNodeInfo(NodeInfo nodeInfo) {
        if (this.mNodeInfo != null) {
            throw new IllegalStateException("NodeInfo set more than once on the same LayoutOutput.");
        }
        if (nodeInfo != null) {
            this.mNodeInfo = nodeInfo.acquireRef();
        }
    }

    NodeInfo getNodeInfo() {
        return this.mNodeInfo;
    }

    public void setUpdateState(int state) {
        this.mUpdateState = state;
    }

    public int getUpdateState() {
        return this.mUpdateState;
    }

    public int getImportantForAccessibility() {
        return this.mImportantForAccessibility;
    }

    public void setImportantForAccessibility(int importantForAccessibility) {
        this.mImportantForAccessibility = importantForAccessibility;
    }

    void initDisplayListContainer(String name, boolean canCacheDrawingDisplayList) {
        if (this.mDisplayListContainer != null) {
            throw new IllegalStateException("Trying to init displaylistcontainer but it already exists");
        }
        this.mDisplayListContainer = ComponentsPools.acquireDisplayListContainer();
        this.mDisplayListContainer.init(name, canCacheDrawingDisplayList);
    }

    void setDisplayListContainer(DisplayListContainer displayListContainer) {
        if (this.mDisplayListContainer != null) {
            this.mDisplayListContainer.release();
        }
        this.mDisplayListContainer = displayListContainer;
    }

    @Nullable
    DisplayListContainer getDisplayListContainer() {
        return this.mDisplayListContainer;
    }

    boolean hasDisplayListContainer() {
        return this.mDisplayListContainer != null;
    }

    boolean hasValidDisplayList() {
        if (this.mDisplayListContainer == null) {
            throw new IllegalStateException("Trying to check displaylist validity when generating displaylist is not supported for this output");
        }
        return this.mDisplayListContainer.hasValidDisplayList();
    }

    @Nullable
    DisplayList getDisplayList() {
        if (this.mDisplayListContainer == null) {
            throw new IllegalStateException("Trying to get displaylist when generating displaylist is not supported for this output");
        }
        return this.mDisplayListContainer.getDisplayList();
    }

    void setDisplayList(DisplayList displayList) {
        if (this.mDisplayListContainer != null) {
            this.mDisplayListContainer.setDisplayList(displayList);
        }
    }

    void setViewNodeInfo(ViewNodeInfo viewNodeInfo) {
        if (this.mViewNodeInfo != null) {
            throw new IllegalStateException("Try to set a new ViewNodeInfo in a LayoutOutput that is already initialized with one.");
        }
        this.mViewNodeInfo = viewNodeInfo.acquireRef();
    }

    boolean hasViewNodeInfo() {
        return this.mViewNodeInfo != null;
    }

    ViewNodeInfo getViewNodeInfo() {
        return this.mViewNodeInfo;
    }

    String getTransitionKey() {
        if (this.mViewNodeInfo == null) {
            return null;
        }
        String transitionKey = this.mViewNodeInfo.getTransitionKey();
        if (transitionKey == null || transitionKey.length() == 0) {
            return null;
        }
        return transitionKey;
    }

    void acquire() {
        if (this.mRefCount.getAndSet(1) != 0) {
            throw new RuntimeException("Tried to acquire LayoutOutput that already had a non-zero ref count!");
        }
    }

    public void incrementRefCount() {
        if (this.mRefCount.getAndIncrement() < 1) {
            throw new RuntimeException("Tried to increment ref count of a released LayoutOutput!");
        }
    }

    public void decrementRefCount() {
        if (this.mRefCount.decrementAndGet() < 1) {
            throw new RuntimeException("Decremented external ref count below 1!");
        }
    }

    void release() {
        if (this.mRefCount.getAndSet(0) != 1) {
            throw new RuntimeException("Trying to release LayoutOutput that still has external references!");
        }
        if (this.mComponent != null) {
            this.mComponent.release();
            this.mComponent = null;
        }
        if (this.mNodeInfo != null) {
            this.mNodeInfo.release();
            this.mNodeInfo = null;
        }
        if (this.mViewNodeInfo != null) {
            this.mViewNodeInfo.release();
            this.mViewNodeInfo = null;
        }
        if (this.mDisplayListContainer != null) {
            this.mDisplayListContainer.release();
            this.mDisplayListContainer = null;
        }
        this.mBounds.setEmpty();
        this.mHostTranslationX = 0;
        this.mHostTranslationY = 0;
        this.mFlags = 0;
        this.mHostMarker = -1L;
        this.mUpdateState = 0;
        this.mImportantForAccessibility = 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UpdateState {
    }
}

