/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.DrawableRes;
import android.support.annotation.Px;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.ViewOutlineProvider;
import com.facebook.infer.annotation.ReturnsOwnership;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.Border;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.DiffNode;
import com.facebook.litho.DispatchPopulateAccessibilityEventEvent;
import com.facebook.litho.Edges;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FastMath;
import com.facebook.litho.FocusChangedEvent;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.Layout;
import com.facebook.litho.LongClickEvent;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.OnInitializeAccessibilityEventEvent;
import com.facebook.litho.OnInitializeAccessibilityNodeInfoEvent;
import com.facebook.litho.OnPopulateAccessibilityEventEvent;
import com.facebook.litho.OnRequestSendAccessibilityEventEvent;
import com.facebook.litho.PerformAccessibilityActionEvent;
import com.facebook.litho.R;
import com.facebook.litho.ResourceResolver;
import com.facebook.litho.SendAccessibilityEventEvent;
import com.facebook.litho.SendAccessibilityEventUncheckedEvent;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.TouchEvent;
import com.facebook.litho.TreeProps;
import com.facebook.litho.TypedArrayUtils;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.reference.DrawableReference;
import com.facebook.litho.reference.Reference;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaBaselineFunction;
import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaNode;
import com.facebook.yoga.YogaPositionType;
import com.facebook.yoga.YogaWrap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

@ThreadConfined(value="ANY")
class InternalNode
implements ComponentLayout,
ComponentLayout.ContainerBuilder {
    private static final boolean SUPPORTS_RTL = Build.VERSION.SDK_INT >= 17;
    private static final long PFLAG_LAYOUT_DIRECTION_IS_SET = 1L;
    private static final long PFLAG_ALIGN_SELF_IS_SET = 2L;
    private static final long PFLAG_POSITION_TYPE_IS_SET = 4L;
    private static final long PFLAG_FLEX_IS_SET = 8L;
    private static final long PFLAG_FLEX_GROW_IS_SET = 16L;
    private static final long PFLAG_FLEX_SHRINK_IS_SET = 32L;
    private static final long PFLAG_FLEX_BASIS_IS_SET = 64L;
    private static final long PFLAG_IMPORTANT_FOR_ACCESSIBILITY_IS_SET = 128L;
    private static final long PFLAG_DUPLICATE_PARENT_STATE_IS_SET = 256L;
    private static final long PFLAG_MARGIN_IS_SET = 512L;
    private static final long PFLAG_PADDING_IS_SET = 1024L;
    private static final long PFLAG_POSITION_IS_SET = 2048L;
    private static final long PFLAG_WIDTH_IS_SET = 4096L;
    private static final long PFLAG_MIN_WIDTH_IS_SET = 8192L;
    private static final long PFLAG_MAX_WIDTH_IS_SET = 16384L;
    private static final long PFLAG_HEIGHT_IS_SET = 32768L;
    private static final long PFLAG_MIN_HEIGHT_IS_SET = 65536L;
    private static final long PFLAG_MAX_HEIGHT_IS_SET = 131072L;
    private static final long PFLAG_BACKGROUND_IS_SET = 262144L;
    private static final long PFLAG_FOREGROUND_IS_SET = 524288L;
    private static final long PFLAG_VISIBLE_HANDLER_IS_SET = 0x100000L;
    private static final long PFLAG_FOCUSED_HANDLER_IS_SET = 0x200000L;
    private static final long PFLAG_FULL_IMPRESSION_HANDLER_IS_SET = 0x400000L;
    private static final long PFLAG_INVISIBLE_HANDLER_IS_SET = 0x800000L;
    private static final long PFLAG_UNFOCUSED_HANDLER_IS_SET = 0x1000000L;
    private static final long PFLAG_TOUCH_EXPANSION_IS_SET = 0x2000000L;
    private static final long PFLAG_ASPECT_RATIO_IS_SET = 0x4000000L;
    private static final long PFLAG_TRANSITION_KEY_IS_SET = 0x8000000L;
    private static final long PFLAG_BORDER_IS_SET = 0x10000000L;
    private final ResourceResolver mResourceResolver = new ResourceResolver();
    YogaNode mYogaNode;
    private ComponentContext mComponentContext;
    private Resources mResources;
    @ThreadConfined(value="ANY")
    private final List<Component> mComponents = new ArrayList<Component>(1);
    private int mImportantForAccessibility = 0;
    private boolean mDuplicateParentState;
    private boolean mIsNestedTreeHolder;
    private InternalNode mNestedTree;
    private InternalNode mNestedTreeHolder;
    private long mPrivateFlags;
    private Reference<? extends Drawable> mBackground;
    private Drawable mForeground;
    private final int[] mBorderColors = new int[4];
    @Nullable
    private PathEffect mBorderPathEffect;
    private NodeInfo mNodeInfo;
    private boolean mForceViewWrapping;
    private String mTransitionKey;
    private float mVisibleHeightRatio;
    private float mVisibleWidthRatio;
    private EventHandler<VisibleEvent> mVisibleHandler;
    private EventHandler<FocusedVisibleEvent> mFocusedHandler;
    private EventHandler<UnfocusedVisibleEvent> mUnfocusedHandler;
    private EventHandler<FullImpressionVisibleEvent> mFullImpressionHandler;
    private EventHandler<InvisibleEvent> mInvisibleHandler;
    private String mTestKey;
    private Edges mTouchExpansion;
    private Edges mNestedTreePadding;
    private Edges mNestedTreeBorderWidth;
    private boolean[] mIsPaddingPercent;
    private float mResolvedTouchExpansionLeft = Float.NaN;
    private float mResolvedTouchExpansionRight = Float.NaN;
    private float mResolvedX = Float.NaN;
    private float mResolvedY = Float.NaN;
    private float mResolvedWidth = Float.NaN;
    private float mResolvedHeight = Float.NaN;
    private int mLastWidthSpec = -1;
    private int mLastHeightSpec = -1;
    private float mLastMeasuredWidth = -1.0f;
    private float mLastMeasuredHeight = -1.0f;
    private DiffNode mDiffNode;
    private boolean mCachedMeasuresValid;
    private TreeProps mPendingTreeProps;
    private int mGeneration;

    InternalNode() {
    }

    void init(YogaNode yogaNode, ComponentContext componentContext) {
        ++this.mGeneration;
        yogaNode.setData((Object)this);
        this.mYogaNode = yogaNode;
        this.mComponentContext = componentContext;
        this.mResources = componentContext.getResources();
        this.mResourceResolver.init(this.mComponentContext, componentContext.getResourceCache());
    }

    @Override
    @Px
    public int getX() {
        if (YogaConstants.isUndefined((float)this.mResolvedX)) {
            this.mResolvedX = this.mYogaNode.getLayoutX();
        }
        return (int)this.mResolvedX;
    }

    @Override
    @Px
    public int getY() {
        if (YogaConstants.isUndefined((float)this.mResolvedY)) {
            this.mResolvedY = this.mYogaNode.getLayoutY();
        }
        return (int)this.mResolvedY;
    }

    @Override
    @Px
    public int getWidth() {
        if (YogaConstants.isUndefined((float)this.mResolvedWidth)) {
            this.mResolvedWidth = this.mYogaNode.getLayoutWidth();
        }
        return (int)this.mResolvedWidth;
    }

    @Override
    @Px
    public int getHeight() {
        if (YogaConstants.isUndefined((float)this.mResolvedHeight)) {
            this.mResolvedHeight = this.mYogaNode.getLayoutHeight();
        }
        return (int)this.mResolvedHeight;
    }

    @Override
    @Px
    public int getPaddingLeft() {
        return FastMath.round(this.mYogaNode.getLayoutPadding(YogaEdge.LEFT));
    }

    @Override
    @Px
    public int getPaddingTop() {
        return FastMath.round(this.mYogaNode.getLayoutPadding(YogaEdge.TOP));
    }

    @Override
    @Px
    public int getPaddingRight() {
        return FastMath.round(this.mYogaNode.getLayoutPadding(YogaEdge.RIGHT));
    }

    @Override
    @Px
    public int getPaddingBottom() {
        return FastMath.round(this.mYogaNode.getLayoutPadding(YogaEdge.BOTTOM));
    }

    public Reference<? extends Drawable> getBackground() {
        return this.mBackground;
    }

    public Drawable getForeground() {
        return this.mForeground;
    }

    public void setCachedMeasuresValid(boolean valid) {
        this.mCachedMeasuresValid = valid;
    }

    public int getLastWidthSpec() {
        return this.mLastWidthSpec;
    }

    public void setLastWidthSpec(int widthSpec) {
        this.mLastWidthSpec = widthSpec;
    }

    public int getLastHeightSpec() {
        return this.mLastHeightSpec;
    }

    public void setLastHeightSpec(int heightSpec) {
        this.mLastHeightSpec = heightSpec;
    }

    public boolean hasVisibilityHandlers() {
        return this.mVisibleHandler != null || this.mFocusedHandler != null || this.mUnfocusedHandler != null || this.mFullImpressionHandler != null || this.mInvisibleHandler != null;
    }

    float getLastMeasuredWidth() {
        return this.mLastMeasuredWidth;
    }

    void setLastMeasuredWidth(float lastMeasuredWidth) {
        this.mLastMeasuredWidth = lastMeasuredWidth;
    }

    float getLastMeasuredHeight() {
        return this.mLastMeasuredHeight;
    }

    void setLastMeasuredHeight(float lastMeasuredHeight) {
        this.mLastMeasuredHeight = lastMeasuredHeight;
    }

    DiffNode getDiffNode() {
        return this.mDiffNode;
    }

    boolean areCachedMeasuresValid() {
        return this.mCachedMeasuresValid;
    }

    void setDiffNode(DiffNode diffNode) {
        this.mDiffNode = diffNode;
    }

    void markIsNestedTreeHolder(TreeProps currentTreeProps) {
        this.mIsNestedTreeHolder = true;
        this.mPendingTreeProps = TreeProps.copy(currentTreeProps);
    }

    boolean isNestedTreeHolder() {
        return this.mIsNestedTreeHolder;
    }

    @Override
    public YogaDirection getResolvedLayoutDirection() {
        return this.mYogaNode.getLayoutDirection();
    }

    @Override
    public InternalNode layoutDirection(YogaDirection direction) {
        this.mPrivateFlags |= 1L;
        this.mYogaNode.setDirection(direction);
        return this;
    }

    InternalNode flexDirection(YogaFlexDirection direction) {
        this.mYogaNode.setFlexDirection(direction);
        return this;
    }

    @Override
    public InternalNode wrap(YogaWrap wrap) {
        this.mYogaNode.setWrap(wrap);
        return this;
    }

    @Override
    public InternalNode justifyContent(YogaJustify justifyContent) {
        this.mYogaNode.setJustifyContent(justifyContent);
        return this;
    }

    @Override
    public InternalNode alignItems(YogaAlign alignItems) {
        this.mYogaNode.setAlignItems(alignItems);
        return this;
    }

    @Override
    public InternalNode alignContent(YogaAlign alignContent) {
        this.mYogaNode.setAlignContent(alignContent);
        return this;
    }

    @Override
    public InternalNode alignSelf(YogaAlign alignSelf) {
        this.mPrivateFlags |= 2L;
        this.mYogaNode.setAlignSelf(alignSelf);
        return this;
    }

    @Override
    public InternalNode positionType(YogaPositionType positionType) {
        this.mPrivateFlags |= 4L;
        this.mYogaNode.setPositionType(positionType);
        return this;
    }

    @Override
    public InternalNode flex(float flex) {
        this.mPrivateFlags |= 8L;
        this.mYogaNode.setFlex(flex);
        return this;
    }

    @Override
    public InternalNode flexGrow(float flexGrow) {
        this.mPrivateFlags |= 0x10L;
        this.mYogaNode.setFlexGrow(flexGrow);
        return this;
    }

    @Override
    public InternalNode flexShrink(float flexShrink) {
        this.mPrivateFlags |= 0x20L;
        this.mYogaNode.setFlexShrink(flexShrink);
        return this;
    }

    @Override
    public InternalNode flexBasisPx(@Px int flexBasis) {
        this.mPrivateFlags |= 0x40L;
        this.mYogaNode.setFlexBasis((float)flexBasis);
        return this;
    }

    InternalNode flexBasisAuto() {
        this.mYogaNode.setFlexBasisAuto();
        return this;
    }

    @Override
    public InternalNode flexBasisPercent(float percent) {
        this.mPrivateFlags |= 0x40L;
        this.mYogaNode.setFlexBasisPercent(percent);
        return this;
    }

    @Override
    public InternalNode flexBasisAttr(@AttrRes int resId, @DimenRes int defaultResId) {
        return this.flexBasisPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
    }

    @Override
    public InternalNode flexBasisAttr(@AttrRes int resId) {
        return this.flexBasisAttr(resId, 0);
    }

    @Override
    public InternalNode flexBasisRes(@DimenRes int resId) {
        return this.flexBasisPx(this.mResourceResolver.resolveDimenSizeRes(resId));
    }

    @Override
    public InternalNode flexBasisDip(@Dimension(unit=0) float flexBasis) {
        return this.flexBasisPx(this.mResourceResolver.dipsToPixels(flexBasis));
    }

    @Override
    public InternalNode importantForAccessibility(int importantForAccessibility) {
        this.mPrivateFlags |= 0x80L;
        this.mImportantForAccessibility = importantForAccessibility;
        return this;
    }

    @Override
    public InternalNode duplicateParentState(boolean duplicateParentState) {
        this.mPrivateFlags |= 0x100L;
        this.mDuplicateParentState = duplicateParentState;
        return this;
    }

    @Override
    public InternalNode marginPx(YogaEdge edge, @Px int margin) {
        this.mPrivateFlags |= 0x200L;
        this.mYogaNode.setMargin(edge, (float)margin);
        return this;
    }

    @Override
    public InternalNode marginPercent(YogaEdge edge, float percent) {
        this.mPrivateFlags |= 0x200L;
        this.mYogaNode.setMarginPercent(edge, percent);
        return this;
    }

    @Override
    public InternalNode marginAuto(YogaEdge edge) {
        this.mPrivateFlags |= 0x200L;
        this.mYogaNode.setMarginAuto(edge);
        return this;
    }

    @Override
    public InternalNode marginAttr(YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
        return this.marginPx(edge, this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
    }

    @Override
    public InternalNode marginAttr(YogaEdge edge, @AttrRes int resId) {
        return this.marginAttr(edge, resId, 0);
    }

    @Override
    public InternalNode marginRes(YogaEdge edge, @DimenRes int resId) {
        return this.marginPx(edge, this.mResourceResolver.resolveDimenSizeRes(resId));
    }

    @Override
    public InternalNode marginDip(YogaEdge edge, @Dimension(unit=0) float margin) {
        return this.marginPx(edge, this.mResourceResolver.dipsToPixels(margin));
    }

    @ReturnsOwnership
    private Edges getNestedTreePadding() {
        if (this.mNestedTreePadding == null) {
            this.mNestedTreePadding = ComponentsPools.acquireEdges();
        }
        return this.mNestedTreePadding;
    }

    @Override
    public InternalNode paddingPx(YogaEdge edge, @Px int padding) {
        this.mPrivateFlags |= 0x400L;
        if (this.mIsNestedTreeHolder) {
            this.getNestedTreePadding().set(edge, padding);
            this.setIsPaddingPercent(edge, false);
        } else {
            this.mYogaNode.setPadding(edge, (float)padding);
        }
        return this;
    }

    @Override
    public InternalNode paddingPercent(YogaEdge edge, float percent) {
        this.mPrivateFlags |= 0x400L;
        if (this.mIsNestedTreeHolder) {
            this.getNestedTreePadding().set(edge, percent);
            this.setIsPaddingPercent(edge, true);
        } else {
            this.mYogaNode.setPaddingPercent(edge, percent);
        }
        return this;
    }

    @Override
    public InternalNode paddingAttr(YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
        return this.paddingPx(edge, this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
    }

    @Override
    public InternalNode paddingAttr(YogaEdge edge, @AttrRes int resId) {
        return this.paddingAttr(edge, resId, 0);
    }

    @Override
    public InternalNode paddingRes(YogaEdge edge, @DimenRes int resId) {
        return this.paddingPx(edge, this.mResourceResolver.resolveDimenSizeRes(resId));
    }

    @Override
    public InternalNode paddingDip(YogaEdge edge, @Dimension(unit=0) float padding) {
        return this.paddingPx(edge, this.mResourceResolver.dipsToPixels(padding));
    }

    @Override
    public InternalNode border(Border border) {
        this.mPrivateFlags |= 0x10000000L;
        int length = border.mEdgeWidths.length;
        for (int i = 0; i < length; ++i) {
            this.setBorderWidth(Border.edgeFromIndex(i), border.mEdgeWidths[i]);
        }
        System.arraycopy(border.mEdgeColors, 0, this.mBorderColors, 0, this.mBorderColors.length);
        this.mBorderPathEffect = border.mPathEffect;
        return this;
    }

    void setBorderWidth(YogaEdge edge, @Px int borderWidth) {
        if (this.mIsNestedTreeHolder) {
            if (this.mNestedTreeBorderWidth == null) {
                this.mNestedTreeBorderWidth = ComponentsPools.acquireEdges();
            }
            this.mNestedTreeBorderWidth.set(edge, borderWidth);
        } else {
            this.mYogaNode.setBorder(edge, (float)borderWidth);
        }
    }

    @Override
    public InternalNode positionPx(YogaEdge edge, @Px int position) {
        this.mPrivateFlags |= 0x800L;
        this.mYogaNode.setPosition(edge, (float)position);
        return this;
    }

    @Override
    public InternalNode positionPercent(YogaEdge edge, float percent) {
        this.mPrivateFlags |= 0x800L;
        this.mYogaNode.setPositionPercent(edge, percent);
        return this;
    }

    @Override
    public InternalNode positionAttr(YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
        return this.positionPx(edge, this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
    }

    @Override
    public InternalNode positionAttr(YogaEdge edge, @AttrRes int resId) {
        return this.positionAttr(edge, resId, 0);
    }

    @Override
    public InternalNode positionRes(YogaEdge edge, @DimenRes int resId) {
        return this.positionPx(edge, this.mResourceResolver.resolveDimenSizeRes(resId));
    }

    @Override
    public InternalNode positionDip(YogaEdge edge, @Dimension(unit=0) float position) {
        return this.positionPx(edge, this.mResourceResolver.dipsToPixels(position));
    }

    @Override
    public InternalNode widthPx(@Px int width) {
        this.mPrivateFlags |= 0x1000L;
        this.mYogaNode.setWidth((float)width);
        return this;
    }

    InternalNode widthAuto() {
        this.mYogaNode.setWidthAuto();
        return this;
    }

    @Override
    public InternalNode widthPercent(float percent) {
        this.mPrivateFlags |= 0x1000L;
        this.mYogaNode.setWidthPercent(percent);
        return this;
    }

    @Override
    public InternalNode widthRes(@DimenRes int resId) {
        return this.widthPx(this.mResourceResolver.resolveDimenSizeRes(resId));
    }

    @Override
    public InternalNode widthAttr(@AttrRes int resId, @DimenRes int defaultResId) {
        return this.widthPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
    }

    @Override
    public InternalNode widthAttr(@AttrRes int resId) {
        return this.widthAttr(resId, 0);
    }

    @Override
    public InternalNode widthDip(@Dimension(unit=0) float width) {
        return this.widthPx(this.mResourceResolver.dipsToPixels(width));
    }

    @Override
    public InternalNode minWidthPx(@Px int minWidth) {
        this.mPrivateFlags |= 0x2000L;
        this.mYogaNode.setMinWidth((float)minWidth);
        return this;
    }

    @Override
    public InternalNode minWidthPercent(float percent) {
        this.mPrivateFlags |= 0x2000L;
        this.mYogaNode.setMinWidthPercent(percent);
        return this;
    }

    @Override
    public InternalNode minWidthAttr(@AttrRes int resId, @DimenRes int defaultResId) {
        return this.minWidthPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
    }

    @Override
    public InternalNode minWidthAttr(@AttrRes int resId) {
        return this.minWidthAttr(resId, 0);
    }

    @Override
    public InternalNode minWidthRes(@DimenRes int resId) {
        return this.minWidthPx(this.mResourceResolver.resolveDimenSizeRes(resId));
    }

    @Override
    public InternalNode minWidthDip(@Dimension(unit=0) float minWidth) {
        return this.minWidthPx(this.mResourceResolver.dipsToPixels(minWidth));
    }

    @Override
    public InternalNode maxWidthPx(@Px int maxWidth) {
        this.mPrivateFlags |= 0x4000L;
        this.mYogaNode.setMaxWidth((float)maxWidth);
        return this;
    }

    @Override
    public InternalNode maxWidthPercent(float percent) {
        this.mPrivateFlags |= 0x4000L;
        this.mYogaNode.setMaxWidthPercent(percent);
        return this;
    }

    @Override
    public InternalNode maxWidthAttr(@AttrRes int resId, @DimenRes int defaultResId) {
        return this.maxWidthPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
    }

    @Override
    public InternalNode maxWidthAttr(@AttrRes int resId) {
        return this.maxWidthAttr(resId, 0);
    }

    @Override
    public InternalNode maxWidthRes(@DimenRes int resId) {
        return this.maxWidthPx(this.mResourceResolver.resolveDimenSizeRes(resId));
    }

    @Override
    public InternalNode maxWidthDip(@Dimension(unit=0) float maxWidth) {
        return this.maxWidthPx(this.mResourceResolver.dipsToPixels(maxWidth));
    }

    @Override
    public InternalNode heightPx(@Px int height) {
        this.mPrivateFlags |= 0x8000L;
        this.mYogaNode.setHeight((float)height);
        return this;
    }

    InternalNode heightAuto() {
        this.mYogaNode.setHeightAuto();
        return this;
    }

    @Override
    public InternalNode heightPercent(float percent) {
        this.mPrivateFlags |= 0x8000L;
        this.mYogaNode.setHeightPercent(percent);
        return this;
    }

    @Override
    public InternalNode heightRes(@DimenRes int resId) {
        return this.heightPx(this.mResourceResolver.resolveDimenSizeRes(resId));
    }

    @Override
    public InternalNode heightAttr(@AttrRes int resId, @DimenRes int defaultResId) {
        return this.heightPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
    }

    @Override
    public InternalNode heightAttr(@AttrRes int resId) {
        return this.heightAttr(resId, 0);
    }

    @Override
    public InternalNode heightDip(@Dimension(unit=0) float height) {
        return this.heightPx(this.mResourceResolver.dipsToPixels(height));
    }

    @Override
    public InternalNode minHeightPx(@Px int minHeight) {
        this.mPrivateFlags |= 0x10000L;
        this.mYogaNode.setMinHeight((float)minHeight);
        return this;
    }

    @Override
    public InternalNode minHeightPercent(float percent) {
        this.mPrivateFlags |= 0x10000L;
        this.mYogaNode.setMinHeightPercent(percent);
        return this;
    }

    @Override
    public InternalNode minHeightAttr(@AttrRes int resId, @DimenRes int defaultResId) {
        return this.minHeightPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
    }

    @Override
    public InternalNode minHeightAttr(@AttrRes int resId) {
        return this.minHeightAttr(resId, 0);
    }

    @Override
    public InternalNode minHeightRes(@DimenRes int resId) {
        return this.minHeightPx(this.mResourceResolver.resolveDimenSizeRes(resId));
    }

    @Override
    public InternalNode minHeightDip(@Dimension(unit=0) float minHeight) {
        return this.minHeightPx(this.mResourceResolver.dipsToPixels(minHeight));
    }

    @Override
    public InternalNode maxHeightPx(@Px int maxHeight) {
        this.mPrivateFlags |= 0x20000L;
        this.mYogaNode.setMaxHeight((float)maxHeight);
        return this;
    }

    @Override
    public InternalNode maxHeightPercent(float percent) {
        this.mPrivateFlags |= 0x20000L;
        this.mYogaNode.setMaxHeightPercent(percent);
        return this;
    }

    @Override
    public InternalNode maxHeightAttr(@AttrRes int resId, @DimenRes int defaultResId) {
        return this.maxHeightPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
    }

    @Override
    public InternalNode maxHeightAttr(@AttrRes int resId) {
        return this.maxHeightAttr(resId, 0);
    }

    @Override
    public InternalNode maxHeightRes(@DimenRes int resId) {
        return this.maxHeightPx(this.mResourceResolver.resolveDimenSizeRes(resId));
    }

    @Override
    public InternalNode maxHeightDip(@Dimension(unit=0) float maxHeight) {
        return this.maxHeightPx(this.mResourceResolver.dipsToPixels(maxHeight));
    }

    @Override
    public InternalNode aspectRatio(float aspectRatio) {
        this.mPrivateFlags |= 0x4000000L;
        this.mYogaNode.setAspectRatio(aspectRatio);
        return this;
    }

    private boolean shouldApplyTouchExpansion() {
        return this.mTouchExpansion != null && this.mNodeInfo != null && this.mNodeInfo.hasTouchEventHandlers();
    }

    boolean hasTouchExpansion() {
        return (this.mPrivateFlags & 0x2000000L) != 0L;
    }

    Edges getTouchExpansion() {
        return this.mTouchExpansion;
    }

    int getTouchExpansionLeft() {
        if (!this.shouldApplyTouchExpansion()) {
            return 0;
        }
        if (YogaConstants.isUndefined((float)this.mResolvedTouchExpansionLeft)) {
            this.mResolvedTouchExpansionLeft = this.resolveHorizontalEdges(this.mTouchExpansion, YogaEdge.LEFT);
        }
        return FastMath.round(this.mResolvedTouchExpansionLeft);
    }

    int getTouchExpansionTop() {
        if (!this.shouldApplyTouchExpansion()) {
            return 0;
        }
        return FastMath.round(this.mTouchExpansion.get(YogaEdge.TOP));
    }

    int getTouchExpansionRight() {
        if (!this.shouldApplyTouchExpansion()) {
            return 0;
        }
        if (YogaConstants.isUndefined((float)this.mResolvedTouchExpansionRight)) {
            this.mResolvedTouchExpansionRight = this.resolveHorizontalEdges(this.mTouchExpansion, YogaEdge.RIGHT);
        }
        return FastMath.round(this.mResolvedTouchExpansionRight);
    }

    int getTouchExpansionBottom() {
        if (!this.shouldApplyTouchExpansion()) {
            return 0;
        }
        return FastMath.round(this.mTouchExpansion.get(YogaEdge.BOTTOM));
    }

    @Override
    public InternalNode touchExpansionPx(YogaEdge edge, @Px int touchExpansion) {
        if (this.mTouchExpansion == null) {
            this.mTouchExpansion = ComponentsPools.acquireEdges();
        }
        this.mPrivateFlags |= 0x2000000L;
        this.mTouchExpansion.set(edge, touchExpansion);
        return this;
    }

    @Override
    public InternalNode touchExpansionAttr(YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
        return this.touchExpansionPx(edge, this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
    }

    @Override
    public InternalNode touchExpansionAttr(YogaEdge edge, @AttrRes int resId) {
        return this.touchExpansionAttr(edge, resId, 0);
    }

    @Override
    public InternalNode touchExpansionRes(YogaEdge edge, @DimenRes int resId) {
        return this.touchExpansionPx(edge, this.mResourceResolver.resolveDimenSizeRes(resId));
    }

    @Override
    public InternalNode touchExpansionDip(YogaEdge edge, @Dimension(unit=0) float touchExpansion) {
        return this.touchExpansionPx(edge, this.mResourceResolver.dipsToPixels(touchExpansion));
    }

    @Override
    public InternalNode child(ComponentLayout child) {
        if (child != null && child != ComponentContext.NULL_LAYOUT) {
            this.addChildAt((InternalNode)child, this.mYogaNode.getChildCount());
        }
        return this;
    }

    @Override
    public InternalNode child(ComponentLayout.Builder child) {
        if (child != null && child != ComponentContext.NULL_LAYOUT) {
            this.child(child.build());
        }
        return this;
    }

    @Override
    public InternalNode child(Component<?> child) {
        if (child != null) {
            this.child(Layout.create(this.mComponentContext, child));
        }
        return this;
    }

    @Override
    public InternalNode child(Component.Builder<?, ?> child) {
        if (child != null) {
            this.child((Component)child.build());
        }
        return this;
    }

    @Override
    public InternalNode background(Reference<? extends Drawable> background) {
        this.mPrivateFlags |= 0x40000L;
        this.mBackground = background;
        this.setPaddingFromDrawableReference(background);
        return this;
    }

    @Override
    public InternalNode background(Reference.Builder<? extends Drawable> builder) {
        return this.background((Reference)builder.build());
    }

    @Override
    public InternalNode background(Drawable background) {
        return this.background((Reference.Builder)DrawableReference.create().drawable(background));
    }

    @Override
    public InternalNode backgroundAttr(@AttrRes int resId, @DrawableRes int defaultResId) {
        return this.backgroundRes(this.mResourceResolver.resolveResIdAttr(resId, defaultResId));
    }

    @Override
    public InternalNode backgroundAttr(@AttrRes int resId) {
        return this.backgroundAttr(resId, 0);
    }

    @Override
    public InternalNode backgroundRes(@DrawableRes int resId) {
        if (resId == 0) {
            return this.background((Reference)null);
        }
        return this.background(this.mComponentContext.getResources().getDrawable(resId));
    }

    @Override
    public InternalNode backgroundColor(@ColorInt int backgroundColor) {
        return this.background((Drawable)new ColorDrawable(backgroundColor));
    }

    @Override
    public InternalNode foreground(Drawable foreground) {
        this.mPrivateFlags |= 0x80000L;
        this.mForeground = foreground;
        return this;
    }

    @Override
    public InternalNode foregroundAttr(@AttrRes int resId, @DrawableRes int defaultResId) {
        return this.foregroundRes(this.mResourceResolver.resolveResIdAttr(resId, defaultResId));
    }

    @Override
    public InternalNode foregroundAttr(@AttrRes int resId) {
        return this.foregroundAttr(resId, 0);
    }

    @Override
    public InternalNode foregroundRes(@DrawableRes int resId) {
        if (resId == 0) {
            return this.foreground(null);
        }
        return this.foreground(this.mResources.getDrawable(resId));
    }

    @Override
    public InternalNode foregroundColor(@ColorInt int foregroundColor) {
        return this.foreground((Drawable)new ColorDrawable(foregroundColor));
    }

    @Override
    public InternalNode wrapInView() {
        this.mForceViewWrapping = true;
        return this;
    }

    boolean isForceViewWrapping() {
        return this.mForceViewWrapping;
    }

    EventHandler<ClickEvent> getClickHandler() {
        return this.getOrCreateNodeInfo().getClickHandler();
    }

    @Override
    public InternalNode clickHandler(EventHandler<ClickEvent> clickHandler) {
        this.getOrCreateNodeInfo().setClickHandler(clickHandler);
        return this;
    }

    @Override
    public InternalNode longClickHandler(EventHandler<LongClickEvent> longClickHandler) {
        this.getOrCreateNodeInfo().setLongClickHandler(longClickHandler);
        return this;
    }

    @Override
    public InternalNode focusChangeHandler(EventHandler<FocusChangedEvent> focusChangeHandler) {
        this.getOrCreateNodeInfo().setFocusChangeHandler(focusChangeHandler);
        return this;
    }

    @Override
    public InternalNode touchHandler(EventHandler<TouchEvent> touchHandler) {
        this.getOrCreateNodeInfo().setTouchHandler(touchHandler);
        return this;
    }

    public InternalNode interceptTouchHandler(EventHandler interceptTouchHandler) {
        this.getOrCreateNodeInfo().setInterceptTouchHandler(interceptTouchHandler);
        return this;
    }

    @Override
    public ComponentLayout.ContainerBuilder focusable(boolean isFocusable) {
        this.getOrCreateNodeInfo().setFocusable(isFocusable);
        return this;
    }

    @Override
    public ComponentLayout.ContainerBuilder enabled(boolean isEnabled) {
        this.getOrCreateNodeInfo().setEnabled(isEnabled);
        return this;
    }

    @Override
    public ComponentLayout.ContainerBuilder visibleHeightRatio(float visibleHeightRatio) {
        this.mVisibleHeightRatio = visibleHeightRatio;
        return this;
    }

    float getVisibleHeightRatio() {
        return this.mVisibleHeightRatio;
    }

    @Override
    public ComponentLayout.ContainerBuilder visibleWidthRatio(float visibleWidthRatio) {
        this.mVisibleWidthRatio = visibleWidthRatio;
        return this;
    }

    float getVisibleWidthRatio() {
        return this.mVisibleWidthRatio;
    }

    @Override
    public InternalNode visibleHandler(EventHandler<VisibleEvent> visibleHandler) {
        this.mPrivateFlags |= 0x100000L;
        this.mVisibleHandler = visibleHandler;
        return this;
    }

    EventHandler<VisibleEvent> getVisibleHandler() {
        return this.mVisibleHandler;
    }

    @Override
    public InternalNode focusedHandler(EventHandler<FocusedVisibleEvent> focusedHandler) {
        this.mPrivateFlags |= 0x200000L;
        this.mFocusedHandler = focusedHandler;
        return this;
    }

    EventHandler<FocusedVisibleEvent> getFocusedHandler() {
        return this.mFocusedHandler;
    }

    @Override
    public InternalNode unfocusedHandler(EventHandler<UnfocusedVisibleEvent> unfocusedHandler) {
        this.mPrivateFlags |= 0x1000000L;
        this.mUnfocusedHandler = unfocusedHandler;
        return this;
    }

    EventHandler<UnfocusedVisibleEvent> getUnfocusedHandler() {
        return this.mUnfocusedHandler;
    }

    @Override
    public InternalNode fullImpressionHandler(EventHandler<FullImpressionVisibleEvent> fullImpressionHandler) {
        this.mPrivateFlags |= 0x400000L;
        this.mFullImpressionHandler = fullImpressionHandler;
        return this;
    }

    EventHandler<FullImpressionVisibleEvent> getFullImpressionHandler() {
        return this.mFullImpressionHandler;
    }

    @Override
    public InternalNode invisibleHandler(EventHandler<InvisibleEvent> invisibleHandler) {
        this.mPrivateFlags |= 0x800000L;
        this.mInvisibleHandler = invisibleHandler;
        return this;
    }

    EventHandler<InvisibleEvent> getInvisibleHandler() {
        return this.mInvisibleHandler;
    }

    @Override
    public InternalNode contentDescription(CharSequence contentDescription) {
        this.getOrCreateNodeInfo().setContentDescription(contentDescription);
        return this;
    }

    @Override
    public InternalNode contentDescription(@StringRes int stringId) {
        return this.contentDescription(this.mResources.getString(stringId));
    }

    @Override
    public InternalNode contentDescription(@StringRes int stringId, Object ... formatArgs) {
        return this.contentDescription(this.mResources.getString(stringId, formatArgs));
    }

    @Override
    public InternalNode viewTag(Object viewTag) {
        this.getOrCreateNodeInfo().setViewTag(viewTag);
        return this;
    }

    @Override
    public InternalNode viewTags(SparseArray<Object> viewTags) {
        this.getOrCreateNodeInfo().setViewTags(viewTags);
        return this;
    }

    @Override
    public ComponentLayout.ContainerBuilder shadowElevationPx(float shadowElevation) {
        this.getOrCreateNodeInfo().setShadowElevation(shadowElevation);
        return this;
    }

    @Override
    public ComponentLayout.ContainerBuilder shadowElevationAttr(@AttrRes int resId, @DimenRes int defaultResId) {
        return this.shadowElevationPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
    }

    @Override
    public ComponentLayout.ContainerBuilder shadowElevationAttr(@AttrRes int resId) {
        return this.shadowElevationAttr(resId, 0);
    }

    @Override
    public ComponentLayout.ContainerBuilder shadowElevationRes(@DimenRes int resId) {
        return this.shadowElevationPx(this.mResourceResolver.resolveDimenSizeRes(resId));
    }

    @Override
    public ComponentLayout.ContainerBuilder shadowElevationDip(@Dimension(unit=0) float shadowElevation) {
        return this.shadowElevationPx(this.mResourceResolver.dipsToPixels(shadowElevation));
    }

    @Override
    public ComponentLayout.ContainerBuilder outlineProvider(ViewOutlineProvider outlineProvider) {
        this.getOrCreateNodeInfo().setOutlineProvider(outlineProvider);
        return this;
    }

    @Override
    public ComponentLayout.ContainerBuilder clipToOutline(boolean clipToOutline) {
        this.getOrCreateNodeInfo().setClipToOutline(clipToOutline);
        return this;
    }

    @Override
    public InternalNode testKey(String testKey) {
        this.mTestKey = testKey;
        return this;
    }

    @Override
    public ComponentLayout.ContainerBuilder scale(float scale) {
        this.wrapInView();
        this.getOrCreateNodeInfo().setScale(scale);
        return this;
    }

    @Override
    public ComponentLayout.ContainerBuilder alpha(float alpha) {
        this.wrapInView();
        this.getOrCreateNodeInfo().setAlpha(alpha);
        return this;
    }

    @Override
    public InternalNode dispatchPopulateAccessibilityEventHandler(EventHandler<DispatchPopulateAccessibilityEventEvent> dispatchPopulateAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setDispatchPopulateAccessibilityEventHandler(dispatchPopulateAccessibilityEventHandler);
        return this;
    }

    @Override
    public InternalNode onInitializeAccessibilityEventHandler(EventHandler<OnInitializeAccessibilityEventEvent> onInitializeAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setOnInitializeAccessibilityEventHandler(onInitializeAccessibilityEventHandler);
        return this;
    }

    @Override
    public InternalNode onInitializeAccessibilityNodeInfoHandler(EventHandler<OnInitializeAccessibilityNodeInfoEvent> onInitializeAccessibilityNodeInfoHandler) {
        this.getOrCreateNodeInfo().setOnInitializeAccessibilityNodeInfoHandler(onInitializeAccessibilityNodeInfoHandler);
        return this;
    }

    @Override
    public InternalNode onPopulateAccessibilityEventHandler(EventHandler<OnPopulateAccessibilityEventEvent> onPopulateAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setOnPopulateAccessibilityEventHandler(onPopulateAccessibilityEventHandler);
        return this;
    }

    @Override
    public InternalNode onRequestSendAccessibilityEventHandler(EventHandler<OnRequestSendAccessibilityEventEvent> onRequestSendAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setOnRequestSendAccessibilityEventHandler(onRequestSendAccessibilityEventHandler);
        return this;
    }

    @Override
    public InternalNode performAccessibilityActionHandler(EventHandler<PerformAccessibilityActionEvent> performAccessibilityActionHandler) {
        this.getOrCreateNodeInfo().setPerformAccessibilityActionHandler(performAccessibilityActionHandler);
        return this;
    }

    @Override
    public InternalNode sendAccessibilityEventHandler(EventHandler<SendAccessibilityEventEvent> sendAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setSendAccessibilityEventHandler(sendAccessibilityEventHandler);
        return this;
    }

    @Override
    public InternalNode sendAccessibilityEventUncheckedHandler(EventHandler<SendAccessibilityEventUncheckedEvent> sendAccessibilityEventUncheckedHandler) {
        this.getOrCreateNodeInfo().setSendAccessibilityEventUncheckedHandler(sendAccessibilityEventUncheckedHandler);
        return this;
    }

    @Override
    public ComponentLayout.ContainerBuilder transitionKey(String key) {
        if (Build.VERSION.SDK_INT >= 14 && !TextUtils.isEmpty((CharSequence)key)) {
            this.mPrivateFlags |= 0x8000000L;
            this.mTransitionKey = key;
            this.wrapInView();
        }
        return this;
    }

    String getTransitionKey() {
        return this.mTransitionKey;
    }

    boolean hasTransitionKey() {
        return !TextUtils.isEmpty((CharSequence)this.mTransitionKey);
    }

    String getTestKey() {
        return this.mTestKey;
    }

    void setMeasureFunction(YogaMeasureFunction measureFunction) {
        this.mYogaNode.setMeasureFunction(measureFunction);
    }

    void setBaselineFunction(YogaBaselineFunction baselineFunction) {
        this.mYogaNode.setBaselineFunction(baselineFunction);
    }

    boolean hasNewLayout() {
        return this.mYogaNode.hasNewLayout();
    }

    void markLayoutSeen() {
        this.mYogaNode.markLayoutSeen();
    }

    float getStyleWidth() {
        return this.mYogaNode.getWidth().value;
    }

    float getMinWidth() {
        return this.mYogaNode.getMinWidth().value;
    }

    float getMaxWidth() {
        return this.mYogaNode.getMaxWidth().value;
    }

    float getStyleHeight() {
        return this.mYogaNode.getHeight().value;
    }

    float getMinHeight() {
        return this.mYogaNode.getMinHeight().value;
    }

    float getMaxHeight() {
        return this.mYogaNode.getMaxHeight().value;
    }

    void calculateLayout(float width, float height) {
        if (ComponentsConfiguration.isDebugModeEnabled) {
            InternalNode.applyOverridesRecursive(this);
        }
        this.mYogaNode.calculateLayout(width, height);
    }

    private static void applyOverridesRecursive(InternalNode node) {
        DebugComponent.getInstance(node, 0).applyOverrides();
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            InternalNode.applyOverridesRecursive(node.getChildAt(i));
        }
        if (node.hasNestedTree()) {
            InternalNode.applyOverridesRecursive(node.getNestedTree());
        }
    }

    void calculateLayout() {
        this.calculateLayout(Float.NaN, Float.NaN);
    }

    int getChildCount() {
        return this.mYogaNode.getChildCount();
    }

    YogaDirection getStyleDirection() {
        return this.mYogaNode.getStyleDirection();
    }

    InternalNode getChildAt(int index) {
        if (this.mYogaNode.getChildAt(index) == null) {
            return null;
        }
        return (InternalNode)this.mYogaNode.getChildAt(index).getData();
    }

    int getChildIndex(InternalNode child) {
        int count = this.mYogaNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            if (this.mYogaNode.getChildAt(i) != child.mYogaNode) continue;
            return i;
        }
        return -1;
    }

    InternalNode getParent() {
        if (this.mYogaNode == null || this.mYogaNode.getParent() == null) {
            return null;
        }
        return (InternalNode)this.mYogaNode.getParent().getData();
    }

    void addChildAt(InternalNode child, int index) {
        this.mYogaNode.addChildAt(child.mYogaNode, index);
    }

    InternalNode removeChildAt(int index) {
        return (InternalNode)this.mYogaNode.removeChildAt(index).getData();
    }

    @Override
    public ComponentLayout build() {
        return this;
    }

    private float resolveHorizontalEdges(Edges spacing, YogaEdge edge) {
        YogaEdge resolvedEdge;
        boolean isRtl = this.mYogaNode.getLayoutDirection() == YogaDirection.RTL;
        switch (edge) {
            case LEFT: {
                resolvedEdge = isRtl ? YogaEdge.END : YogaEdge.START;
                break;
            }
            case RIGHT: {
                resolvedEdge = isRtl ? YogaEdge.START : YogaEdge.END;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not an horizontal padding edge: " + edge);
            }
        }
        float result = spacing.getRaw(resolvedEdge);
        if (YogaConstants.isUndefined((float)result)) {
            result = spacing.get(edge);
        }
        return result;
    }

    ComponentContext getContext() {
        return this.mComponentContext;
    }

    List<Component> getComponents() {
        return this.mComponents;
    }

    Component getRootComponent() {
        return this.mComponents.size() == 0 ? null : this.mComponents.get(0);
    }

    int[] getBorderColors() {
        return this.mBorderColors;
    }

    @Nullable
    PathEffect getBorderPathEffect() {
        return this.mBorderPathEffect;
    }

    boolean shouldDrawBorders() {
        boolean hasColor = false;
        for (int color : this.mBorderColors) {
            if (color == 0) continue;
            hasColor = true;
            break;
        }
        return hasColor && (this.mYogaNode.getLayoutBorder(YogaEdge.LEFT) != 0.0f || this.mYogaNode.getLayoutBorder(YogaEdge.TOP) != 0.0f || this.mYogaNode.getLayoutBorder(YogaEdge.RIGHT) != 0.0f || this.mYogaNode.getLayoutBorder(YogaEdge.BOTTOM) != 0.0f);
    }

    void appendComponent(Component component) {
        if (this.mComponents.size() == 0 || ComponentsConfiguration.isDebugModeEnabled) {
            this.mComponents.add(component);
        }
    }

    boolean hasNestedTree() {
        return this.mNestedTree != null;
    }

    @Nullable
    InternalNode getNestedTree() {
        return this.mNestedTree;
    }

    InternalNode getNestedTreeHolder() {
        return this.mNestedTreeHolder;
    }

    int getGeneration() {
        return this.mGeneration;
    }

    void setNestedTree(InternalNode nestedTree) {
        nestedTree.mNestedTreeHolder = this;
        this.mNestedTree = nestedTree;
    }

    NodeInfo getNodeInfo() {
        return this.mNodeInfo;
    }

    void copyInto(InternalNode node) {
        YogaNode yogaNode;
        if (this.mNodeInfo != null) {
            if (node.mNodeInfo == null) {
                node.mNodeInfo = this.mNodeInfo.acquireRef();
            } else {
                node.mNodeInfo.updateWith(this.mNodeInfo);
            }
        }
        if ((node.mPrivateFlags & 1L) == 0L || node.getResolvedLayoutDirection() == YogaDirection.INHERIT) {
            node.layoutDirection(this.getResolvedLayoutDirection());
        }
        if ((node.mPrivateFlags & 0x80L) == 0L || node.mImportantForAccessibility == 0) {
            node.mImportantForAccessibility = this.mImportantForAccessibility;
        }
        if ((this.mPrivateFlags & 0x100L) != 0L) {
            node.mDuplicateParentState = this.mDuplicateParentState;
        }
        if ((this.mPrivateFlags & 0x40000L) != 0L) {
            node.mBackground = this.mBackground;
        }
        if ((this.mPrivateFlags & 0x80000L) != 0L) {
            node.mForeground = this.mForeground;
        }
        if (this.mForceViewWrapping) {
            node.mForceViewWrapping = true;
        }
        if ((this.mPrivateFlags & 0x100000L) != 0L) {
            node.mVisibleHandler = this.mVisibleHandler;
        }
        if ((this.mPrivateFlags & 0x200000L) != 0L) {
            node.mFocusedHandler = this.mFocusedHandler;
        }
        if ((this.mPrivateFlags & 0x400000L) != 0L) {
            node.mFullImpressionHandler = this.mFullImpressionHandler;
        }
        if ((this.mPrivateFlags & 0x800000L) != 0L) {
            node.mInvisibleHandler = this.mInvisibleHandler;
        }
        if ((this.mPrivateFlags & 0x1000000L) != 0L) {
            node.mUnfocusedHandler = this.mUnfocusedHandler;
        }
        if (this.mTestKey != null) {
            node.mTestKey = this.mTestKey;
        }
        if ((this.mPrivateFlags & 0x400L) != 0L) {
            if (this.mNestedTreePadding == null) {
                throw new IllegalStateException("copyInto() must be used when resolving a nestedTree. If padding was set on the holder node, we must have a mNestedTreePadding instance");
            }
            yogaNode = node.mYogaNode;
            node.mPrivateFlags |= 0x400L;
            if (this.isPaddingPercent(YogaEdge.LEFT)) {
                yogaNode.setPaddingPercent(YogaEdge.LEFT, this.mNestedTreePadding.getRaw(YogaEdge.LEFT));
            } else {
                yogaNode.setPadding(YogaEdge.LEFT, this.mNestedTreePadding.getRaw(YogaEdge.LEFT));
            }
            if (this.isPaddingPercent(YogaEdge.TOP)) {
                yogaNode.setPaddingPercent(YogaEdge.TOP, this.mNestedTreePadding.getRaw(YogaEdge.TOP));
            } else {
                yogaNode.setPadding(YogaEdge.TOP, this.mNestedTreePadding.getRaw(YogaEdge.TOP));
            }
            if (this.isPaddingPercent(YogaEdge.RIGHT)) {
                yogaNode.setPaddingPercent(YogaEdge.RIGHT, this.mNestedTreePadding.getRaw(YogaEdge.RIGHT));
            } else {
                yogaNode.setPadding(YogaEdge.RIGHT, this.mNestedTreePadding.getRaw(YogaEdge.RIGHT));
            }
            if (this.isPaddingPercent(YogaEdge.BOTTOM)) {
                yogaNode.setPaddingPercent(YogaEdge.BOTTOM, this.mNestedTreePadding.getRaw(YogaEdge.BOTTOM));
            } else {
                yogaNode.setPadding(YogaEdge.BOTTOM, this.mNestedTreePadding.getRaw(YogaEdge.BOTTOM));
            }
            if (this.isPaddingPercent(YogaEdge.VERTICAL)) {
                yogaNode.setPaddingPercent(YogaEdge.VERTICAL, this.mNestedTreePadding.getRaw(YogaEdge.VERTICAL));
            } else {
                yogaNode.setPadding(YogaEdge.VERTICAL, this.mNestedTreePadding.getRaw(YogaEdge.VERTICAL));
            }
            if (this.isPaddingPercent(YogaEdge.HORIZONTAL)) {
                yogaNode.setPaddingPercent(YogaEdge.HORIZONTAL, this.mNestedTreePadding.getRaw(YogaEdge.HORIZONTAL));
            } else {
                yogaNode.setPadding(YogaEdge.HORIZONTAL, this.mNestedTreePadding.getRaw(YogaEdge.HORIZONTAL));
            }
            if (this.isPaddingPercent(YogaEdge.START)) {
                yogaNode.setPaddingPercent(YogaEdge.START, this.mNestedTreePadding.getRaw(YogaEdge.START));
            } else {
                yogaNode.setPadding(YogaEdge.START, this.mNestedTreePadding.getRaw(YogaEdge.START));
            }
            if (this.isPaddingPercent(YogaEdge.END)) {
                yogaNode.setPaddingPercent(YogaEdge.END, this.mNestedTreePadding.getRaw(YogaEdge.END));
            } else {
                yogaNode.setPadding(YogaEdge.END, this.mNestedTreePadding.getRaw(YogaEdge.END));
            }
            if (this.isPaddingPercent(YogaEdge.ALL)) {
                yogaNode.setPaddingPercent(YogaEdge.ALL, this.mNestedTreePadding.getRaw(YogaEdge.ALL));
            } else {
                yogaNode.setPadding(YogaEdge.ALL, this.mNestedTreePadding.getRaw(YogaEdge.ALL));
            }
        }
        if ((this.mPrivateFlags & 0x10000000L) != 0L) {
            if (this.mNestedTreeBorderWidth == null) {
                throw new IllegalStateException("copyInto() must be used when resolving a nestedTree. If border width was set on the holder node, we must have a mNestedTreeBorderWidth instance");
            }
            yogaNode = node.mYogaNode;
            node.mPrivateFlags |= 0x10000000L;
            yogaNode.setBorder(YogaEdge.LEFT, this.mNestedTreeBorderWidth.getRaw(YogaEdge.LEFT));
            yogaNode.setBorder(YogaEdge.TOP, this.mNestedTreeBorderWidth.getRaw(YogaEdge.TOP));
            yogaNode.setBorder(YogaEdge.RIGHT, this.mNestedTreeBorderWidth.getRaw(YogaEdge.RIGHT));
            yogaNode.setBorder(YogaEdge.BOTTOM, this.mNestedTreeBorderWidth.getRaw(YogaEdge.BOTTOM));
            yogaNode.setBorder(YogaEdge.VERTICAL, this.mNestedTreeBorderWidth.getRaw(YogaEdge.VERTICAL));
            yogaNode.setBorder(YogaEdge.HORIZONTAL, this.mNestedTreeBorderWidth.getRaw(YogaEdge.HORIZONTAL));
            yogaNode.setBorder(YogaEdge.START, this.mNestedTreeBorderWidth.getRaw(YogaEdge.START));
            yogaNode.setBorder(YogaEdge.END, this.mNestedTreeBorderWidth.getRaw(YogaEdge.END));
            yogaNode.setBorder(YogaEdge.ALL, this.mNestedTreeBorderWidth.getRaw(YogaEdge.ALL));
            System.arraycopy(this.mBorderColors, 0, node.mBorderColors, 0, this.mBorderColors.length);
        }
        if ((this.mPrivateFlags & 0x8000000L) != 0L) {
            node.mTransitionKey = this.mTransitionKey;
        }
        if (this.mVisibleHeightRatio != 0.0f) {
            node.mVisibleHeightRatio = this.mVisibleHeightRatio;
        }
        if (this.mVisibleWidthRatio != 0.0f) {
            node.mVisibleWidthRatio = this.mVisibleWidthRatio;
        }
    }

    void setStyleWidthFromSpec(int widthSpec) {
        switch (SizeSpec.getMode(widthSpec)) {
            case 0: {
                this.mYogaNode.setWidth(Float.NaN);
                break;
            }
            case -2147483648: {
                this.mYogaNode.setMaxWidth((float)SizeSpec.getSize(widthSpec));
                break;
            }
            case 0x40000000: {
                this.mYogaNode.setWidth((float)SizeSpec.getSize(widthSpec));
            }
        }
    }

    void setStyleHeightFromSpec(int heightSpec) {
        switch (SizeSpec.getMode(heightSpec)) {
            case 0: {
                this.mYogaNode.setHeight(Float.NaN);
                break;
            }
            case -2147483648: {
                this.mYogaNode.setMaxHeight((float)SizeSpec.getSize(heightSpec));
                break;
            }
            case 0x40000000: {
                this.mYogaNode.setHeight((float)SizeSpec.getSize(heightSpec));
            }
        }
    }

    int getImportantForAccessibility() {
        return this.mImportantForAccessibility;
    }

    boolean isDuplicateParentStateEnabled() {
        return this.mDuplicateParentState;
    }

    void applyAttributes(TypedArray a) {
        int size = a.getIndexCount();
        for (int i = 0; i < size; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.ComponentLayout_android_layout_width) {
                int width = a.getLayoutDimension(attr2, -1);
                if (width < 0) continue;
                this.widthPx(width);
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_layout_height) {
                int height = a.getLayoutDimension(attr2, -1);
                if (height < 0) continue;
                this.heightPx(height);
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_paddingLeft) {
                this.paddingPx(YogaEdge.LEFT, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_paddingTop) {
                this.paddingPx(YogaEdge.TOP, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_paddingRight) {
                this.paddingPx(YogaEdge.RIGHT, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_paddingBottom) {
                this.paddingPx(YogaEdge.BOTTOM, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_paddingStart && SUPPORTS_RTL) {
                this.paddingPx(YogaEdge.START, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_paddingEnd && SUPPORTS_RTL) {
                this.paddingPx(YogaEdge.END, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_padding) {
                this.paddingPx(YogaEdge.ALL, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_layout_marginLeft) {
                this.marginPx(YogaEdge.LEFT, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_layout_marginTop) {
                this.marginPx(YogaEdge.TOP, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_layout_marginRight) {
                this.marginPx(YogaEdge.RIGHT, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_layout_marginBottom) {
                this.marginPx(YogaEdge.BOTTOM, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_layout_marginStart && SUPPORTS_RTL) {
                this.marginPx(YogaEdge.START, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_layout_marginEnd && SUPPORTS_RTL) {
                this.marginPx(YogaEdge.END, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_layout_margin) {
                this.marginPx(YogaEdge.ALL, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_importantForAccessibility && Build.VERSION.SDK_INT >= 16) {
                this.importantForAccessibility(a.getInt(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_duplicateParentState) {
                this.duplicateParentState(a.getBoolean(attr2, false));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_background) {
                if (TypedArrayUtils.isColorAttribute(a, R.styleable.ComponentLayout_android_background)) {
                    this.backgroundColor(a.getColor(attr2, 0));
                    continue;
                }
                this.backgroundRes(a.getResourceId(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_foreground) {
                if (TypedArrayUtils.isColorAttribute(a, R.styleable.ComponentLayout_android_foreground)) {
                    this.foregroundColor(a.getColor(attr2, 0));
                    continue;
                }
                this.foregroundRes(a.getResourceId(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_android_contentDescription) {
                this.contentDescription(a.getString(attr2));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_flex_direction) {
                this.flexDirection(YogaFlexDirection.fromInt((int)a.getInteger(attr2, 0)));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_flex_wrap) {
                this.wrap(YogaWrap.fromInt((int)a.getInteger(attr2, 0)));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_flex_justifyContent) {
                this.justifyContent(YogaJustify.fromInt((int)a.getInteger(attr2, 0)));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_flex_alignItems) {
                this.alignItems(YogaAlign.fromInt((int)a.getInteger(attr2, 0)));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_flex_alignSelf) {
                this.alignSelf(YogaAlign.fromInt((int)a.getInteger(attr2, 0)));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_flex_positionType) {
                this.positionType(YogaPositionType.fromInt((int)a.getInteger(attr2, 0)));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_flex) {
                float flex = a.getFloat(attr2, -1.0f);
                if (!(flex >= 0.0f)) continue;
                this.flex(flex);
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_flex_left) {
                this.positionPx(YogaEdge.LEFT, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_flex_top) {
                this.positionPx(YogaEdge.TOP, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_flex_right) {
                this.positionPx(YogaEdge.RIGHT, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.ComponentLayout_flex_bottom) {
                this.positionPx(YogaEdge.BOTTOM, a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 != R.styleable.ComponentLayout_flex_layoutDirection) continue;
            int layoutDirection = a.getInteger(attr2, -1);
            this.layoutDirection(YogaDirection.fromInt((int)layoutDirection));
        }
    }

    void release() {
        if (this.mYogaNode.getParent() != null || this.mYogaNode.getChildCount() > 0) {
            throw new IllegalStateException("You should not free an attached Internalnode");
        }
        ComponentsPools.release(this.mYogaNode);
        this.mYogaNode = null;
        this.mResourceResolver.internalRelease();
        this.mResolvedTouchExpansionLeft = Float.NaN;
        this.mResolvedTouchExpansionRight = Float.NaN;
        this.mResolvedX = Float.NaN;
        this.mResolvedY = Float.NaN;
        this.mResolvedWidth = Float.NaN;
        this.mResolvedHeight = Float.NaN;
        this.mComponentContext = null;
        this.mResources = null;
        this.mComponents.clear();
        this.mNestedTree = null;
        this.mNestedTreeHolder = null;
        if (this.mNodeInfo != null) {
            this.mNodeInfo.release();
            this.mNodeInfo = null;
        }
        this.mImportantForAccessibility = 0;
        this.mDuplicateParentState = false;
        this.mBackground = null;
        this.mForeground = null;
        this.mForceViewWrapping = false;
        this.mVisibleHeightRatio = 0.0f;
        this.mVisibleWidthRatio = 0.0f;
        this.mVisibleHandler = null;
        this.mFocusedHandler = null;
        this.mUnfocusedHandler = null;
        this.mFullImpressionHandler = null;
        this.mInvisibleHandler = null;
        this.mPrivateFlags = 0L;
        this.mTransitionKey = null;
        Arrays.fill(this.mBorderColors, 0);
        this.mIsPaddingPercent = null;
        if (this.mTouchExpansion != null) {
            ComponentsPools.release(this.mTouchExpansion);
            this.mTouchExpansion = null;
        }
        if (this.mNestedTreePadding != null) {
            ComponentsPools.release(this.mNestedTreePadding);
            this.mNestedTreePadding = null;
        }
        if (this.mNestedTreeBorderWidth != null) {
            ComponentsPools.release(this.mNestedTreeBorderWidth);
            this.mNestedTreeBorderWidth = null;
        }
        this.mLastWidthSpec = -1;
        this.mLastHeightSpec = -1;
        this.mLastMeasuredHeight = -1.0f;
        this.mLastMeasuredWidth = -1.0f;
        this.mDiffNode = null;
        this.mCachedMeasuresValid = false;
        this.mIsNestedTreeHolder = false;
        this.mTestKey = null;
        if (this.mPendingTreeProps != null) {
            this.mPendingTreeProps.reset();
            ComponentsPools.release(this.mPendingTreeProps);
            this.mPendingTreeProps = null;
        }
        ComponentsPools.release(this);
    }

    private NodeInfo getOrCreateNodeInfo() {
        if (this.mNodeInfo == null) {
            this.mNodeInfo = NodeInfo.acquire();
        }
        return this.mNodeInfo;
    }

    static boolean hasValidLayoutDirectionInNestedTree(InternalNode nestedTreeHolder, InternalNode nestedTree) {
        boolean nestedTreeHasExplicitDirection = (nestedTree.mPrivateFlags & 1L) != 0L;
        boolean hasSameLayoutDirection = nestedTree.getResolvedLayoutDirection() == nestedTreeHolder.getResolvedLayoutDirection();
        return nestedTreeHasExplicitDirection || hasSameLayoutDirection;
    }

    private static <A> List<A> addOrCreateList(@Nullable List<A> list, A item) {
        if (list == null) {
            list = new LinkedList<A>();
        }
        list.add(item);
        return list;
    }

    private void setIsPaddingPercent(YogaEdge edge, boolean isPaddingPercent) {
        if (this.mIsPaddingPercent == null && isPaddingPercent) {
            this.mIsPaddingPercent = new boolean[YogaEdge.ALL.intValue() + 1];
        }
        if (this.mIsPaddingPercent != null) {
            this.mIsPaddingPercent[edge.intValue()] = isPaddingPercent;
        }
    }

    private boolean isPaddingPercent(YogaEdge edge) {
        return this.mIsPaddingPercent != null && this.mIsPaddingPercent[edge.intValue()];
    }

    static void assertContextSpecificStyleNotSet(InternalNode node) {
        List<String> errorTypes = null;
        if ((node.mPrivateFlags & 2L) != 0L) {
            errorTypes = InternalNode.addOrCreateList(errorTypes, "alignSelf");
        }
        if ((node.mPrivateFlags & 4L) != 0L) {
            errorTypes = InternalNode.addOrCreateList(errorTypes, "positionType");
        }
        if ((node.mPrivateFlags & 8L) != 0L) {
            errorTypes = InternalNode.addOrCreateList(errorTypes, "flex");
        }
        if ((node.mPrivateFlags & 0x10L) != 0L) {
            errorTypes = InternalNode.addOrCreateList(errorTypes, "flexGrow");
        }
        if ((node.mPrivateFlags & 0x200L) != 0L) {
            errorTypes = InternalNode.addOrCreateList(errorTypes, "margin");
        }
        if (errorTypes != null) {
            String errorStr = TextUtils.join((CharSequence)", ", errorTypes);
            throw new IllegalStateException("You should not set " + errorStr + " to a root layout in " + node.getRootComponent().getLifecycle());
        }
    }

    public TreeProps getPendingTreeProps() {
        return this.mPendingTreeProps;
    }

    private <T extends Drawable> void setPaddingFromDrawableReference(Reference<T> ref) {
        if (ref == null) {
            return;
        }
        Drawable drawable = (Drawable)Reference.acquire(this.mComponentContext, ref);
        if (drawable != null) {
            Rect backgroundPadding = ComponentsPools.acquireRect();
            if (drawable.getPadding(backgroundPadding)) {
                this.paddingPx(YogaEdge.LEFT, backgroundPadding.left);
                this.paddingPx(YogaEdge.TOP, backgroundPadding.top);
                this.paddingPx(YogaEdge.RIGHT, backgroundPadding.right);
                this.paddingPx(YogaEdge.BOTTOM, backgroundPadding.bottom);
            }
            Reference.release(this.mComponentContext, drawable, ref);
            ComponentsPools.release(backgroundPadding);
        }
    }
}

