/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewParent;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.LithoView;
import com.facebook.litho.config.ComponentsConfiguration;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

class IncrementalMountHelper {
    private final ComponentTree mComponentTree;
    private final List<ViewPagerListener> mViewPagerListeners = new ArrayList<ViewPagerListener>(2);

    IncrementalMountHelper(ComponentTree componentTree) {
        this.mComponentTree = componentTree;
    }

    void onAttach(LithoView lithoView) {
        if (!this.mComponentTree.isIncrementalMountEnabled()) {
            return;
        }
        for (ViewParent viewParent = lithoView.getParent(); viewParent != null; viewParent = viewParent.getParent()) {
            if (ComponentsConfiguration.incrementalMountUsesLocalVisibleBounds && viewParent instanceof ViewPager) {
                ViewPager viewPager = (ViewPager)viewParent;
                ViewPagerListener viewPagerListener = new ViewPagerListener(this.mComponentTree, viewPager);
                viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)viewPagerListener);
                this.mViewPagerListeners.add(viewPagerListener);
            }
            if (!(viewParent instanceof LithoView) || !((LithoView)viewParent).doesOwnIncrementalMount()) continue;
            lithoView.setDoesOwnIncrementalMount(true);
        }
    }

    void onDetach(LithoView lithoView) {
        int size = this.mViewPagerListeners.size();
        for (int i = 0; i < size; ++i) {
            ViewPagerListener viewPagerListener = this.mViewPagerListeners.get(i);
            viewPagerListener.release();
        }
        this.mViewPagerListeners.clear();
    }

    private static class ViewPagerListener
    extends ViewPager.SimpleOnPageChangeListener {
        private final WeakReference<ComponentTree> mComponentTree;
        private final WeakReference<ViewPager> mViewPager;

        private ViewPagerListener(ComponentTree componentTree, ViewPager viewPager) {
            this.mComponentTree = new WeakReference<ComponentTree>(componentTree);
            this.mViewPager = new WeakReference<ViewPager>(viewPager);
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            ComponentTree componentTree = (ComponentTree)this.mComponentTree.get();
            if (componentTree != null) {
                componentTree.incrementalMountComponent();
            }
        }

        private void release() {
            final ViewPager viewPager = (ViewPager)this.mViewPager.get();
            if (viewPager != null) {
                ViewCompat.postOnAnimation((View)viewPager, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)ViewPagerListener.this);
                    }
                });
            }
        }
    }
}

