/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.os.Bundle;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.DispatchPopulateAccessibilityEventEvent;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FocusChangedEvent;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.LongClickEvent;
import com.facebook.litho.OnInitializeAccessibilityEventEvent;
import com.facebook.litho.OnInitializeAccessibilityNodeInfoEvent;
import com.facebook.litho.OnPopulateAccessibilityEventEvent;
import com.facebook.litho.OnRequestSendAccessibilityEventEvent;
import com.facebook.litho.PerformAccessibilityActionEvent;
import com.facebook.litho.SendAccessibilityEventEvent;
import com.facebook.litho.SendAccessibilityEventUncheckedEvent;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.TouchEvent;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.VisibleEvent;

class EventDispatcherUtils {
    private static ClickEvent sClickEvent;
    private static FocusChangedEvent sFocusChangedEvent;
    private static LongClickEvent sLongClickEvent;
    private static TouchEvent sTouchEvent;
    private static InterceptTouchEvent sInterceptTouchEvent;
    private static VisibleEvent sVisibleEvent;
    private static InvisibleEvent sInvisibleEvent;
    private static FocusedVisibleEvent sFocusedVisibleEvent;
    private static UnfocusedVisibleEvent sUnfocusedVisibleEvent;
    private static FullImpressionVisibleEvent sFullImpressionVisibleEvent;
    private static DispatchPopulateAccessibilityEventEvent sDispatchPopulateAccessibilityEventEvent;
    private static OnInitializeAccessibilityEventEvent sOnInitializeAccessibilityEventEvent;
    private static OnInitializeAccessibilityNodeInfoEvent sOnInitializeAccessibilityNodeInfoEvent;
    private static OnPopulateAccessibilityEventEvent sOnPopulateAccessibilityEventEvent;
    private static OnRequestSendAccessibilityEventEvent sOnRequestSendAccessibilityEventEvent;
    private static PerformAccessibilityActionEvent sPerformAccessibilityActionEvent;
    private static SendAccessibilityEventEvent sSendAccessibilityEventEvent;
    private static SendAccessibilityEventUncheckedEvent sSendAccessibilityEventUncheckedEvent;

    EventDispatcherUtils() {
    }

    static void dispatchOnClick(EventHandler<ClickEvent> clickHandler, View view) {
        ThreadUtils.assertMainThread();
        if (sClickEvent == null) {
            sClickEvent = new ClickEvent();
        }
        EventDispatcherUtils.sClickEvent.view = view;
        EventDispatcher eventDispatcher = clickHandler.mHasEventDispatcher.getEventDispatcher();
        eventDispatcher.dispatchOnEvent(clickHandler, sClickEvent);
        EventDispatcherUtils.sClickEvent.view = null;
    }

    static void dispatchOnFocusChanged(EventHandler<FocusChangedEvent> focusChangeHandler, View view, boolean hasFocus) {
        ThreadUtils.assertMainThread();
        if (sFocusChangedEvent == null) {
            sFocusChangedEvent = new FocusChangedEvent();
        }
        EventDispatcherUtils.sFocusChangedEvent.view = view;
        EventDispatcherUtils.sFocusChangedEvent.hasFocus = hasFocus;
        EventDispatcher eventDispatcher = focusChangeHandler.mHasEventDispatcher.getEventDispatcher();
        eventDispatcher.dispatchOnEvent(focusChangeHandler, sFocusChangedEvent);
        EventDispatcherUtils.sFocusChangedEvent.view = null;
    }

    static void dispatchOnVisible(EventHandler<VisibleEvent> visibleHandler) {
        ThreadUtils.assertMainThread();
        if (sVisibleEvent == null) {
            sVisibleEvent = new VisibleEvent();
        }
        EventDispatcher eventDispatcher = visibleHandler.mHasEventDispatcher.getEventDispatcher();
        eventDispatcher.dispatchOnEvent(visibleHandler, sVisibleEvent);
    }

    static void dispatchOnFocused(EventHandler<FocusedVisibleEvent> focusedHandler) {
        ThreadUtils.assertMainThread();
        if (sFocusedVisibleEvent == null) {
            sFocusedVisibleEvent = new FocusedVisibleEvent();
        }
        EventDispatcher eventDispatcher = focusedHandler.mHasEventDispatcher.getEventDispatcher();
        eventDispatcher.dispatchOnEvent(focusedHandler, sFocusedVisibleEvent);
    }

    static void dispatchOnUnfocused(EventHandler<UnfocusedVisibleEvent> unfocusedHandler) {
        ThreadUtils.assertMainThread();
        if (sUnfocusedVisibleEvent == null) {
            sUnfocusedVisibleEvent = new UnfocusedVisibleEvent();
        }
        EventDispatcher eventDispatcher = unfocusedHandler.mHasEventDispatcher.getEventDispatcher();
        eventDispatcher.dispatchOnEvent(unfocusedHandler, sUnfocusedVisibleEvent);
    }

    static void dispatchOnFullImpression(EventHandler<FullImpressionVisibleEvent> fullImpressionHandler) {
        ThreadUtils.assertMainThread();
        if (sFullImpressionVisibleEvent == null) {
            sFullImpressionVisibleEvent = new FullImpressionVisibleEvent();
        }
        EventDispatcher eventDispatcher = fullImpressionHandler.mHasEventDispatcher.getEventDispatcher();
        eventDispatcher.dispatchOnEvent(fullImpressionHandler, sFullImpressionVisibleEvent);
    }

    static void dispatchOnInvisible(EventHandler<InvisibleEvent> invisibleHandler) {
        ThreadUtils.assertMainThread();
        if (sInvisibleEvent == null) {
            sInvisibleEvent = new InvisibleEvent();
        }
        EventDispatcher eventDispatcher = invisibleHandler.mHasEventDispatcher.getEventDispatcher();
        eventDispatcher.dispatchOnEvent(invisibleHandler, sInvisibleEvent);
    }

    static boolean dispatchOnLongClick(EventHandler<LongClickEvent> longClickHandler, View view) {
        ThreadUtils.assertMainThread();
        if (sLongClickEvent == null) {
            sLongClickEvent = new LongClickEvent();
        }
        EventDispatcherUtils.sLongClickEvent.view = view;
        EventDispatcher eventDispatcher = longClickHandler.mHasEventDispatcher.getEventDispatcher();
        boolean returnValue = (Boolean)eventDispatcher.dispatchOnEvent(longClickHandler, sLongClickEvent);
        EventDispatcherUtils.sLongClickEvent.view = null;
        return returnValue;
    }

    static boolean dispatchOnTouch(EventHandler<TouchEvent> touchHandler, View view, MotionEvent event) {
        ThreadUtils.assertMainThread();
        if (sTouchEvent == null) {
            sTouchEvent = new TouchEvent();
        }
        EventDispatcherUtils.sTouchEvent.view = view;
        EventDispatcherUtils.sTouchEvent.motionEvent = event;
        EventDispatcher eventDispatcher = touchHandler.mHasEventDispatcher.getEventDispatcher();
        boolean returnValue = (Boolean)eventDispatcher.dispatchOnEvent(touchHandler, sTouchEvent);
        EventDispatcherUtils.sTouchEvent.view = null;
        EventDispatcherUtils.sTouchEvent.motionEvent = null;
        return returnValue;
    }

    static boolean dispatchOnInterceptTouch(EventHandler<InterceptTouchEvent> interceptTouchHandler, MotionEvent event) {
        ThreadUtils.assertMainThread();
        if (sInterceptTouchEvent == null) {
            sInterceptTouchEvent = new InterceptTouchEvent();
        }
        EventDispatcherUtils.sInterceptTouchEvent.motionEvent = event;
        EventDispatcher eventDispatcher = interceptTouchHandler.mHasEventDispatcher.getEventDispatcher();
        boolean returnValue = (Boolean)eventDispatcher.dispatchOnEvent(interceptTouchHandler, sInterceptTouchEvent);
        EventDispatcherUtils.sInterceptTouchEvent.motionEvent = null;
        return returnValue;
    }

    static boolean dispatchDispatchPopulateAccessibilityEvent(EventHandler<DispatchPopulateAccessibilityEventEvent> eventHandler, View host, AccessibilityEvent event, AccessibilityDelegateCompat superDelegate) {
        ThreadUtils.assertMainThread();
        if (sDispatchPopulateAccessibilityEventEvent == null) {
            sDispatchPopulateAccessibilityEventEvent = new DispatchPopulateAccessibilityEventEvent();
        }
        EventDispatcherUtils.sDispatchPopulateAccessibilityEventEvent.host = host;
        EventDispatcherUtils.sDispatchPopulateAccessibilityEventEvent.event = event;
        EventDispatcherUtils.sDispatchPopulateAccessibilityEventEvent.superDelegate = superDelegate;
        EventDispatcher eventDispatcher = eventHandler.mHasEventDispatcher.getEventDispatcher();
        boolean returnValue = (Boolean)eventDispatcher.dispatchOnEvent(eventHandler, sDispatchPopulateAccessibilityEventEvent);
        EventDispatcherUtils.sDispatchPopulateAccessibilityEventEvent.host = null;
        EventDispatcherUtils.sDispatchPopulateAccessibilityEventEvent.event = null;
        EventDispatcherUtils.sDispatchPopulateAccessibilityEventEvent.superDelegate = null;
        return returnValue;
    }

    static void dispatchOnInitializeAccessibilityEvent(EventHandler<OnInitializeAccessibilityEventEvent> eventHandler, View host, AccessibilityEvent event, AccessibilityDelegateCompat superDelegate) {
        ThreadUtils.assertMainThread();
        if (sOnInitializeAccessibilityEventEvent == null) {
            sOnInitializeAccessibilityEventEvent = new OnInitializeAccessibilityEventEvent();
        }
        EventDispatcherUtils.sOnInitializeAccessibilityEventEvent.host = host;
        EventDispatcherUtils.sOnInitializeAccessibilityEventEvent.event = event;
        EventDispatcherUtils.sOnInitializeAccessibilityEventEvent.superDelegate = superDelegate;
        EventDispatcher eventDispatcher = eventHandler.mHasEventDispatcher.getEventDispatcher();
        eventDispatcher.dispatchOnEvent(eventHandler, sOnInitializeAccessibilityEventEvent);
        EventDispatcherUtils.sOnInitializeAccessibilityEventEvent.host = null;
        EventDispatcherUtils.sOnInitializeAccessibilityEventEvent.event = null;
        EventDispatcherUtils.sOnInitializeAccessibilityEventEvent.superDelegate = null;
    }

    static void dispatchOnInitializeAccessibilityNodeInfoEvent(EventHandler<OnInitializeAccessibilityNodeInfoEvent> eventHandler, View host, AccessibilityNodeInfoCompat info, AccessibilityDelegateCompat superDelegate) {
        ThreadUtils.assertMainThread();
        if (sOnInitializeAccessibilityNodeInfoEvent == null) {
            sOnInitializeAccessibilityNodeInfoEvent = new OnInitializeAccessibilityNodeInfoEvent();
        }
        EventDispatcherUtils.sOnInitializeAccessibilityNodeInfoEvent.host = host;
        EventDispatcherUtils.sOnInitializeAccessibilityNodeInfoEvent.info = info;
        EventDispatcherUtils.sOnInitializeAccessibilityNodeInfoEvent.superDelegate = superDelegate;
        EventDispatcher eventDispatcher = eventHandler.mHasEventDispatcher.getEventDispatcher();
        eventDispatcher.dispatchOnEvent(eventHandler, sOnInitializeAccessibilityNodeInfoEvent);
        EventDispatcherUtils.sOnInitializeAccessibilityNodeInfoEvent.host = null;
        EventDispatcherUtils.sOnInitializeAccessibilityNodeInfoEvent.info = null;
        EventDispatcherUtils.sOnInitializeAccessibilityNodeInfoEvent.superDelegate = null;
    }

    static void dispatchOnPopulateAccessibilityEvent(EventHandler<OnPopulateAccessibilityEventEvent> eventHandler, View host, AccessibilityEvent event, AccessibilityDelegateCompat superDelegate) {
        ThreadUtils.assertMainThread();
        if (sOnPopulateAccessibilityEventEvent == null) {
            sOnPopulateAccessibilityEventEvent = new OnPopulateAccessibilityEventEvent();
        }
        EventDispatcherUtils.sOnPopulateAccessibilityEventEvent.host = host;
        EventDispatcherUtils.sOnPopulateAccessibilityEventEvent.event = event;
        EventDispatcherUtils.sOnPopulateAccessibilityEventEvent.superDelegate = superDelegate;
        EventDispatcher eventDispatcher = eventHandler.mHasEventDispatcher.getEventDispatcher();
        eventDispatcher.dispatchOnEvent(eventHandler, sOnPopulateAccessibilityEventEvent);
        EventDispatcherUtils.sOnPopulateAccessibilityEventEvent.host = null;
        EventDispatcherUtils.sOnPopulateAccessibilityEventEvent.event = null;
        EventDispatcherUtils.sOnPopulateAccessibilityEventEvent.superDelegate = null;
    }

    static boolean dispatchOnRequestSendAccessibilityEvent(EventHandler<OnRequestSendAccessibilityEventEvent> eventHandler, ViewGroup host, View child, AccessibilityEvent event, AccessibilityDelegateCompat superDelegate) {
        ThreadUtils.assertMainThread();
        if (sOnRequestSendAccessibilityEventEvent == null) {
            sOnRequestSendAccessibilityEventEvent = new OnRequestSendAccessibilityEventEvent();
        }
        EventDispatcherUtils.sOnRequestSendAccessibilityEventEvent.host = host;
        EventDispatcherUtils.sOnRequestSendAccessibilityEventEvent.child = child;
        EventDispatcherUtils.sOnRequestSendAccessibilityEventEvent.event = event;
        EventDispatcherUtils.sOnRequestSendAccessibilityEventEvent.superDelegate = superDelegate;
        EventDispatcher eventDispatcher = eventHandler.mHasEventDispatcher.getEventDispatcher();
        boolean returnValue = (Boolean)eventDispatcher.dispatchOnEvent(eventHandler, sOnRequestSendAccessibilityEventEvent);
        EventDispatcherUtils.sOnRequestSendAccessibilityEventEvent.host = null;
        EventDispatcherUtils.sOnRequestSendAccessibilityEventEvent.child = null;
        EventDispatcherUtils.sOnRequestSendAccessibilityEventEvent.event = null;
        EventDispatcherUtils.sOnRequestSendAccessibilityEventEvent.superDelegate = null;
        return returnValue;
    }

    static boolean dispatchPerformAccessibilityActionEvent(EventHandler<PerformAccessibilityActionEvent> eventHandler, View host, int action, Bundle args, AccessibilityDelegateCompat superDelegate) {
        ThreadUtils.assertMainThread();
        if (sPerformAccessibilityActionEvent == null) {
            sPerformAccessibilityActionEvent = new PerformAccessibilityActionEvent();
        }
        EventDispatcherUtils.sPerformAccessibilityActionEvent.host = host;
        EventDispatcherUtils.sPerformAccessibilityActionEvent.action = action;
        EventDispatcherUtils.sPerformAccessibilityActionEvent.args = args;
        EventDispatcherUtils.sPerformAccessibilityActionEvent.superDelegate = superDelegate;
        EventDispatcher eventDispatcher = eventHandler.mHasEventDispatcher.getEventDispatcher();
        boolean returnValue = (Boolean)eventDispatcher.dispatchOnEvent(eventHandler, sPerformAccessibilityActionEvent);
        EventDispatcherUtils.sPerformAccessibilityActionEvent.host = null;
        EventDispatcherUtils.sPerformAccessibilityActionEvent.action = 0;
        EventDispatcherUtils.sPerformAccessibilityActionEvent.args = null;
        EventDispatcherUtils.sPerformAccessibilityActionEvent.superDelegate = null;
        return returnValue;
    }

    static void dispatchSendAccessibilityEvent(EventHandler<SendAccessibilityEventEvent> eventHandler, View host, int eventType, AccessibilityDelegateCompat superDelegate) {
        ThreadUtils.assertMainThread();
        if (sSendAccessibilityEventEvent == null) {
            sSendAccessibilityEventEvent = new SendAccessibilityEventEvent();
        }
        EventDispatcherUtils.sSendAccessibilityEventEvent.host = host;
        EventDispatcherUtils.sSendAccessibilityEventEvent.eventType = eventType;
        EventDispatcherUtils.sSendAccessibilityEventEvent.superDelegate = superDelegate;
        EventDispatcher eventDispatcher = eventHandler.mHasEventDispatcher.getEventDispatcher();
        eventDispatcher.dispatchOnEvent(eventHandler, sSendAccessibilityEventEvent);
        EventDispatcherUtils.sSendAccessibilityEventEvent.host = null;
        EventDispatcherUtils.sSendAccessibilityEventEvent.eventType = 0;
        EventDispatcherUtils.sSendAccessibilityEventEvent.superDelegate = null;
    }

    static void dispatchSendAccessibilityEventUnchecked(EventHandler<SendAccessibilityEventUncheckedEvent> eventHandler, View host, AccessibilityEvent event, AccessibilityDelegateCompat superDelegate) {
        ThreadUtils.assertMainThread();
        if (sSendAccessibilityEventUncheckedEvent == null) {
            sSendAccessibilityEventUncheckedEvent = new SendAccessibilityEventUncheckedEvent();
        }
        EventDispatcherUtils.sSendAccessibilityEventUncheckedEvent.host = host;
        EventDispatcherUtils.sSendAccessibilityEventUncheckedEvent.event = event;
        EventDispatcherUtils.sSendAccessibilityEventUncheckedEvent.superDelegate = superDelegate;
        EventDispatcher eventDispatcher = eventHandler.mHasEventDispatcher.getEventDispatcher();
        eventDispatcher.dispatchOnEvent(eventHandler, sSendAccessibilityEventUncheckedEvent);
        EventDispatcherUtils.sSendAccessibilityEventUncheckedEvent.host = null;
        EventDispatcherUtils.sSendAccessibilityEventUncheckedEvent.event = null;
        EventDispatcherUtils.sSendAccessibilityEventUncheckedEvent.superDelegate = null;
    }
}

