/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaEdge;
import java.util.Arrays;

public class Edges {
    private static final int[] sFlagsMap = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256};
    private final float[] mEdges = new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN};
    private int mValueFlags = 0;
    private final float mDefaultValue = 0.0f;
    private boolean mHasAliasesSet;

    public boolean set(YogaEdge edge, float value) {
        if (!Edges.floatsEqual(this.mEdges[edge.intValue()], value)) {
            this.mEdges[edge.intValue()] = value;
            this.mValueFlags = YogaConstants.isUndefined((float)value) ? (this.mValueFlags &= ~sFlagsMap[edge.intValue()]) : (this.mValueFlags |= sFlagsMap[edge.intValue()]);
            this.mHasAliasesSet = (this.mValueFlags & sFlagsMap[YogaEdge.ALL.intValue()]) != 0 || (this.mValueFlags & sFlagsMap[YogaEdge.VERTICAL.intValue()]) != 0 || (this.mValueFlags & sFlagsMap[YogaEdge.HORIZONTAL.intValue()]) != 0;
            return true;
        }
        return false;
    }

    public float get(YogaEdge edge) {
        float defaultValue;
        float f = defaultValue = edge == YogaEdge.START || edge == YogaEdge.END ? Float.NaN : 0.0f;
        if (this.mValueFlags == 0) {
            return defaultValue;
        }
        if ((this.mValueFlags & sFlagsMap[edge.intValue()]) != 0) {
            return this.mEdges[edge.intValue()];
        }
        if (this.mHasAliasesSet) {
            YogaEdge secondType;
            YogaEdge yogaEdge = secondType = edge == YogaEdge.TOP || edge == YogaEdge.BOTTOM ? YogaEdge.VERTICAL : YogaEdge.HORIZONTAL;
            if ((this.mValueFlags & sFlagsMap[secondType.intValue()]) != 0) {
                return this.mEdges[secondType.intValue()];
            }
            if ((this.mValueFlags & sFlagsMap[YogaEdge.ALL.intValue()]) != 0) {
                return this.mEdges[YogaEdge.ALL.intValue()];
            }
        }
        return defaultValue;
    }

    public float getRaw(YogaEdge edge) {
        return this.mEdges[edge.intValue()];
    }

    public void reset() {
        Arrays.fill(this.mEdges, Float.NaN);
        this.mHasAliasesSet = false;
        this.mValueFlags = 0;
    }

    private static boolean floatsEqual(float f1, float f2) {
        if (Float.isNaN(f1) || Float.isNaN(f2)) {
            return Float.isNaN(f1) && Float.isNaN(f2);
        }
        return Math.abs(f2 - f1) < 1.0E-5f;
    }
}

