/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.FastMath;

public final class DrawableMatrix
extends Matrix {
    private boolean mShouldClipRect;

    private DrawableMatrix() {
    }

    public boolean shouldClipRect() {
        return this.mShouldClipRect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DrawableMatrix create(Drawable d, ImageView.ScaleType scaleType, int width, int height) {
        if (scaleType == null) {
            scaleType = ImageView.ScaleType.FIT_CENTER;
        }
        if (d == null) {
            return null;
        }
        int intrinsicWidth = d.getIntrinsicWidth();
        int intrinsicHeight = d.getIntrinsicHeight();
        if (intrinsicWidth <= 0 || intrinsicHeight <= 0 || ImageView.ScaleType.FIT_XY == scaleType || ImageView.ScaleType.MATRIX == scaleType) {
            return null;
        }
        if (width == intrinsicWidth && height == intrinsicHeight) {
            return null;
        }
        DrawableMatrix result = new DrawableMatrix();
        if (ImageView.ScaleType.CENTER == scaleType) {
            result.setTranslate(FastMath.round((float)(width - intrinsicWidth) * 0.5f), FastMath.round((float)(height - intrinsicHeight) * 0.5f));
            result.mShouldClipRect = intrinsicWidth > width || intrinsicHeight > height;
        } else if (ImageView.ScaleType.CENTER_CROP == scaleType) {
            float scale;
            float dx = 0.0f;
            float dy = 0.0f;
            if (intrinsicWidth * height > width * intrinsicHeight) {
                scale = (float)height / (float)intrinsicHeight;
                dx = ((float)width - (float)intrinsicWidth * scale) * 0.5f;
            } else {
                scale = (float)width / (float)intrinsicWidth;
                dy = ((float)height - (float)intrinsicHeight * scale) * 0.5f;
            }
            result.setScale(scale, scale);
            result.postTranslate(FastMath.round(dx), FastMath.round(dy));
            result.mShouldClipRect = true;
        } else if (ImageView.ScaleType.CENTER_INSIDE == scaleType) {
            float scale = intrinsicWidth <= width && intrinsicHeight <= height ? 1.0f : Math.min((float)width / (float)intrinsicWidth, (float)height / (float)intrinsicHeight);
            float dx = FastMath.round(((float)width - (float)intrinsicWidth * scale) * 0.5f);
            float dy = FastMath.round(((float)height - (float)intrinsicHeight * scale) * 0.5f);
            result.setScale(scale, scale);
            result.postTranslate(dx, dy);
        } else {
            RectF src = ComponentsPools.acquireRectF();
            RectF dest = ComponentsPools.acquireRectF();
            try {
                src.set(0.0f, 0.0f, (float)intrinsicWidth, (float)intrinsicHeight);
                dest.set(0.0f, 0.0f, (float)width, (float)height);
                result.setRectToRect(src, dest, DrawableMatrix.scaleTypeToScaleToFit(scaleType));
            }
            finally {
                ComponentsPools.releaseRectF(src);
                ComponentsPools.releaseRectF(dest);
            }
        }
        return result;
    }

    private static Matrix.ScaleToFit scaleTypeToScaleToFit(ImageView.ScaleType st) {
        switch (st) {
            case FIT_XY: {
                return Matrix.ScaleToFit.FILL;
            }
            case FIT_START: {
                return Matrix.ScaleToFit.START;
            }
            case FIT_CENTER: {
                return Matrix.ScaleToFit.CENTER;
            }
            case FIT_END: {
                return Matrix.ScaleToFit.END;
            }
        }
        throw new IllegalArgumentException("Only FIT_... values allowed");
    }
}

