/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.drawable.Drawable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.MatrixDrawable;
import com.facebook.litho.reference.Reference;

class DrawableComponent<T extends Drawable>
extends ComponentLifecycle {
    static DrawableComponent sInstance;

    DrawableComponent() {
    }

    static synchronized DrawableComponent get() {
        if (sInstance == null) {
            sInstance = new DrawableComponent();
        }
        return sInstance;
    }

    @Override
    protected void onBoundsDefined(ComponentContext c, ComponentLayout layout, Component<?> component) {
        State state = (State)component;
        state.setDrawableWidth(layout.getWidth());
        state.setDrawableHeight(layout.getHeight());
    }

    @Override
    protected Object onCreateMountContent(ComponentContext c) {
        return new MatrixDrawable();
    }

    protected void onMount(ComponentContext context, Object content, Component component) {
        MatrixDrawable drawable = (MatrixDrawable)content;
        State state = (State)component;
        drawable.mount((Drawable)Reference.acquire(context, state.getDrawable()));
    }

    @Override
    protected void onBind(ComponentContext c, Object mountedContent, Component<?> component) {
        MatrixDrawable mountedDrawable = (MatrixDrawable)mountedContent;
        State state = (State)component;
        mountedDrawable.bind(state.getDrawableWidth(), state.getDrawableHeight());
    }

    @Override
    protected void onUnmount(ComponentContext context, Object mountedContent, Component<?> component) {
        State state = (State)component;
        MatrixDrawable matrixDrawable = (MatrixDrawable)mountedContent;
        Reference.release(context, matrixDrawable.getMountedDrawable(), state.getDrawable());
        matrixDrawable.unmount();
    }

    @Override
    protected boolean isPureRender() {
        return true;
    }

    @Override
    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.DRAWABLE;
    }

    public static Component create(Reference<? extends Drawable> drawable) {
        return new State<Drawable>(drawable);
    }

    @Override
    protected boolean shouldUpdate(Component previous, Component next) {
        Reference previousReference = ((State)previous).getDrawable();
        Reference nextReference = ((State)next).getDrawable();
        return Reference.shouldUpdate(previousReference, nextReference);
    }

    private static class State<T extends Drawable>
    extends Component<DrawableComponent>
    implements Cloneable {
        Reference<T> mDrawable;
        int mDrawableWidth;
        int mDrawableHeight;

        protected State(Reference<T> drawable) {
            super(DrawableComponent.get());
            this.mDrawable = drawable;
        }

        @Override
        public String getSimpleName() {
            return this.mDrawable.getSimpleName();
        }

        private Reference<T> getDrawable() {
            return this.mDrawable;
        }

        @Override
        public boolean isEquivalentTo(Component<?> o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.mDrawable.equals(state.mDrawable);
        }

        private void setDrawableWidth(int drawableWidth) {
            this.mDrawableWidth = drawableWidth;
        }

        private int getDrawableWidth() {
            return this.mDrawableWidth;
        }

        private void setDrawableHeight(int drawableHeight) {
            this.mDrawableHeight = drawableHeight;
        }

        private int getDrawableHeight() {
            return this.mDrawableHeight;
        }
    }
}

