/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.annotation.TargetApi;
import android.view.Display;
import android.view.View;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LayoutState;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

@TargetApi(value=21)
public final class DisplayListPrefetcher
implements Runnable {
    private static final AverageDLPrefetchDuration sAverageDLPrefetchDurationNs = new AverageDLPrefetchDuration();
    private static final DisplayListPrefetcher sDisplayListPrefetcher = new DisplayListPrefetcher();
    private final Queue<WeakReference<LayoutState>> mLayoutStates = new LinkedList<WeakReference<LayoutState>>();
    private long mFrameIntervalNs;
    private WeakReference<View> mHostingView;

    private DisplayListPrefetcher() {
    }

    public static DisplayListPrefetcher getInstance() {
        return sDisplayListPrefetcher;
    }

    public synchronized void setHostingView(View view) {
        if (this.mHostingView == null || this.mHostingView.get() != view) {
            this.mHostingView = new WeakReference<View>(view);
        }
        this.initIfNeeded(view);
    }

    private void initIfNeeded(View view) {
        float displayRefreshRate;
        if (this.mFrameIntervalNs > 0L) {
            return;
        }
        Display display = view.getDisplay();
        float refreshRate = 60.0f;
        if (!view.isInEditMode() && display != null && (displayRefreshRate = display.getRefreshRate()) >= 30.0f) {
            refreshRate = displayRefreshRate;
        }
        this.mFrameIntervalNs = (long)(1.0E9f / refreshRate);
    }

    synchronized void addLayoutState(LayoutState layoutState) {
        this.mLayoutStates.add(new WeakReference<LayoutState>(layoutState));
    }

    @Override
    public void run() {
        LayoutState currentLayoutState;
        if (this.mFrameIntervalNs == 0L) {
            return;
        }
        View hostingView = (View)this.mHostingView.get();
        if (hostingView == null) {
            return;
        }
        long latestFrameVsyncNs = TimeUnit.MILLISECONDS.toNanos(hostingView.getDrawingTime());
        long nextVsyncNs = latestFrameVsyncNs + this.mFrameIntervalNs;
        if (System.nanoTime() > nextVsyncNs) {
            return;
        }
        ComponentsSystrace.beginSection("DisplayListPrefetcher");
        while ((currentLayoutState = this.getValidLayoutStateFromQueue()) != null) {
            long startPrefetchNs;
            if (!currentLayoutState.isActivityValid()) {
                this.mLayoutStates.remove();
                continue;
            }
            LayoutOutput currentLayoutOutput = currentLayoutState.getNextLayoutOutputForDLPrefetch();
            String currentComponentType = currentLayoutOutput.getComponent().getSimpleName();
            if (!this.canPrefetchOnTime(currentComponentType, startPrefetchNs = System.nanoTime(), nextVsyncNs)) break;
            currentLayoutState.createDisplayList(currentLayoutOutput);
            if (!currentLayoutOutput.hasDisplayListContainer() || !currentLayoutOutput.hasValidDisplayList()) continue;
            long actualElapsedNs = System.nanoTime() - startPrefetchNs;
            this.updateAveragePrefetchDuration(currentComponentType, actualElapsedNs);
        }
        ComponentsSystrace.endSection();
    }

    private boolean canPrefetchOnTime(String componentType, long startTimeNs, long deadlineNs) {
        long expectedPrefetchDurationNs = sAverageDLPrefetchDurationNs.get(componentType);
        return expectedPrefetchDurationNs == -1L || startTimeNs + expectedPrefetchDurationNs < deadlineNs;
    }

    private LayoutState getValidLayoutStateFromQueue() {
        WeakReference<LayoutState> currentLayoutState = this.mLayoutStates.peek();
        while (currentLayoutState != null) {
            LayoutState layoutState = (LayoutState)currentLayoutState.get();
            if (layoutState != null) {
                layoutState.trimDisplayListItemsQueue();
            }
            if (layoutState != null && layoutState.hasItemsForDLPrefetch()) break;
            this.mLayoutStates.remove();
            currentLayoutState = this.mLayoutStates.peek();
        }
        if (currentLayoutState == null) {
            return null;
        }
        return (LayoutState)currentLayoutState.get();
    }

    private void updateAveragePrefetchDuration(String componentType, long actualElapsedNs) {
        long expectedPrefetchDurationNs = sAverageDLPrefetchDurationNs.get(componentType);
        long updatedValue = expectedPrefetchDurationNs == -1L ? actualElapsedNs : expectedPrefetchDurationNs / 4L * 3L + actualElapsedNs / 4L;
        sAverageDLPrefetchDurationNs.put(componentType, updatedValue);
    }

    public synchronized boolean hasPrefetchItems() {
        return !this.mLayoutStates.isEmpty();
    }

    static final class AverageDLPrefetchDuration {
        static final int INITIAL_SIZE = 10;
        private long[] durationsNs = new long[10];
        private final ArrayList<String> componentTypes = new ArrayList();

        AverageDLPrefetchDuration() {
        }

        long get(String componentType) {
            int indexOf = this.componentTypes.indexOf(componentType);
            if (indexOf < 0) {
                return -1L;
            }
            return this.durationsNs[indexOf];
        }

        void put(String componentType, long durationNs) {
            int indexOfKey = this.componentTypes.indexOf(componentType);
            if (indexOfKey == -1) {
                if (this.componentTypes.size() >= this.durationsNs.length) {
                    long[] oldDurationsNs = this.durationsNs;
                    this.durationsNs = new long[this.durationsNs.length + 10];
                    System.arraycopy(oldDurationsNs, 0, this.durationsNs, 0, oldDurationsNs.length);
                }
                this.durationsNs[this.componentTypes.size()] = durationNs;
                this.componentTypes.add(componentType);
            } else {
                this.durationsNs[indexOfKey] = durationNs;
            }
        }
    }
}

