/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.annotation.TargetApi;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.facebook.litho.DisplayListContainer;
import com.facebook.litho.displaylist.DisplayList;
import com.facebook.litho.displaylist.DisplayListException;

class DisplayListDrawable
extends Drawable
implements Drawable.Callback {
    private Drawable mDrawable;
    @Nullable
    private DisplayListContainer mDisplayListContainer;
    private boolean mIgnoreInvalidations;
    private boolean mInvalidated;

    DisplayListDrawable(Drawable drawable, DisplayListContainer displayListContainer) {
        this.setWrappedDrawable(drawable, displayListContainer);
    }

    public void draw(Canvas canvas) {
        if (this.mDisplayListContainer == null) {
            this.mDrawable.draw(canvas);
            return;
        }
        DisplayList displayList = this.mDisplayListContainer.getDisplayList();
        if (displayList == null && this.mDisplayListContainer.canCacheDrawingDisplayLists()) {
            displayList = DisplayList.createDisplayList(this.mDisplayListContainer.getName());
            this.mDisplayListContainer.setDisplayList(displayList);
            this.mInvalidated = true;
        }
        if (displayList == null) {
            this.mDrawable.draw(canvas);
            return;
        }
        try {
            if (this.mInvalidated || !displayList.isValid()) {
                this.drawContentIntoDisplayList();
                this.mInvalidated = false;
            }
            if (displayList.isValid()) {
                displayList.draw(canvas);
            } else {
                this.mDrawable.draw(canvas);
            }
        }
        catch (DisplayListException e) {
            this.mDisplayListContainer = null;
            this.mDrawable.draw(canvas);
        }
    }

    boolean willDrawDisplayList() {
        return this.mDisplayListContainer != null && (this.mDisplayListContainer.hasValidDisplayList() || this.mDisplayListContainer.canCacheDrawingDisplayLists());
    }

    protected void onBoundsChange(Rect bounds) {
        this.mDrawable.setBounds(bounds);
    }

    public void setChangingConfigurations(int configs) {
        this.mDrawable.setChangingConfigurations(configs);
    }

    public int getChangingConfigurations() {
        return this.mDrawable.getChangingConfigurations();
    }

    public void setDither(boolean dither) {
        this.mDrawable.setDither(dither);
    }

    public void setFilterBitmap(boolean filter) {
        this.mDrawable.setFilterBitmap(filter);
    }

    public void setAlpha(int alpha) {
        this.mDrawable.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mDrawable.setColorFilter(cf);
    }

    public boolean isStateful() {
        return this.mDrawable.isStateful();
    }

    public boolean setState(int[] stateSet) {
        return this.mDrawable.setState(stateSet);
    }

    public int[] getState() {
        return this.mDrawable.getState();
    }

    public Drawable getCurrent() {
        return this.mDrawable.getCurrent();
    }

    public boolean setVisible(boolean visible, boolean restart) {
        return super.setVisible(visible, restart) || this.mDrawable.setVisible(visible, restart);
    }

    public int getOpacity() {
        return this.mDrawable.getOpacity();
    }

    public Region getTransparentRegion() {
        return this.mDrawable.getTransparentRegion();
    }

    public int getIntrinsicWidth() {
        return this.mDrawable.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.mDrawable.getIntrinsicHeight();
    }

    public int getMinimumWidth() {
        return this.mDrawable.getMinimumWidth();
    }

    public int getMinimumHeight() {
        return this.mDrawable.getMinimumHeight();
    }

    public boolean getPadding(Rect padding) {
        return this.mDrawable.getPadding(padding);
    }

    public Drawable mutate() {
        Drawable wrapped = this.mDrawable;
        Drawable mutated = wrapped.mutate();
        if (mutated != wrapped) {
            this.setWrappedDrawable(mutated, this.mDisplayListContainer);
        }
        return this;
    }

    public void invalidateDrawable(Drawable who) {
        this.invalidateSelf();
        if (this.mIgnoreInvalidations) {
            return;
        }
        this.setBounds(this.mDrawable.getBounds());
        this.mInvalidated = true;
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        this.unscheduleSelf(what);
    }

    protected boolean onLevelChange(int level) {
        return this.mDrawable.setLevel(level);
    }

    public void setTint(int tint) {
        this.setTintList(ColorStateList.valueOf((int)tint));
    }

    @TargetApi(value=21)
    public void setTintList(ColorStateList tint) {
        this.mDrawable.setTintList(tint);
    }

    @TargetApi(value=21)
    public void setTintMode(PorterDuff.Mode tintMode) {
        this.mDrawable.setTintMode(tintMode);
    }

    void setWrappedDrawable(Drawable drawable, DisplayListContainer displayListContainer) {
        if (this.mDrawable != null) {
            this.mDrawable.setCallback(null);
        }
        this.mDrawable = drawable;
        if (drawable != null) {
            drawable.setCallback((Drawable.Callback)this);
        }
        this.mDisplayListContainer = displayListContainer;
        this.invalidateSelf();
    }

    public void suppressInvalidations(boolean suppress) {
        this.mIgnoreInvalidations = suppress;
    }

    public void release() {
        this.setCallback(null);
        this.mIgnoreInvalidations = false;
        this.mDisplayListContainer = null;
        this.mDrawable.setCallback(null);
        this.mDrawable = null;
    }

    @UiThread
    private void drawContentIntoDisplayList() {
        DisplayList displayList = this.mDisplayListContainer.getDisplayList();
        if (displayList == null) {
            return;
        }
        try {
            Rect bounds = this.mDrawable.getBounds();
            Canvas displayListCanvas = displayList.start(bounds.width(), bounds.height());
            displayListCanvas.translate((float)(-bounds.left), (float)(-bounds.top));
            this.mDrawable.draw(displayListCanvas);
            displayListCanvas.translate((float)bounds.left, (float)bounds.top);
            displayList.end(displayListCanvas);
            displayList.setBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
        }
        catch (DisplayListException displayListException) {
            // empty catch block
        }
    }
}

