/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.util.SimpleArrayMap;
import android.view.View;
import com.facebook.litho.Column;
import com.facebook.litho.ColumnReverse;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.EventHandler;
import com.facebook.litho.InternalNode;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoView;
import com.facebook.litho.MountItem;
import com.facebook.litho.MountState;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.Row;
import com.facebook.litho.RowReverse;
import com.facebook.litho.TextContent;
import com.facebook.litho.reference.Reference;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaNode;
import com.facebook.yoga.YogaPositionType;
import com.facebook.yoga.YogaValue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class DebugComponent {
    private static final SimpleArrayMap<String, DebugComponent> mDebugNodes = new SimpleArrayMap();
    private String mKey;
    private WeakReference<InternalNode> mNode;
    private int mComponentIndex;
    private Overrider mOverrider;
    private int mGeneration;
    private Class mComponentClass;

    private DebugComponent() {
    }

    static synchronized DebugComponent getInstance(InternalNode node, int componentIndex) {
        String globalKey = DebugComponent.createKey(node, componentIndex);
        DebugComponent debugComponent = (DebugComponent)mDebugNodes.get((Object)globalKey);
        if (debugComponent == null) {
            debugComponent = new DebugComponent();
            mDebugNodes.put((Object)globalKey, (Object)debugComponent);
        }
        debugComponent.mKey = globalKey;
        debugComponent.mNode = new WeakReference<InternalNode>(node);
        debugComponent.mComponentIndex = componentIndex;
        debugComponent.mGeneration = node.getGeneration();
        debugComponent.mComponentClass = DebugComponent.getComponentClass(node, componentIndex);
        return debugComponent;
    }

    public boolean isValidInstance() {
        InternalNode node = (InternalNode)this.mNode.get();
        return node != null && node.getGeneration() == this.mGeneration && this.mKey.equals(DebugComponent.createKey(node, this.mComponentIndex));
    }

    @Nullable
    public static DebugComponent getRootInstance(LithoView view) {
        return DebugComponent.getRootInstance(view.getComponentTree());
    }

    @Nullable
    public static DebugComponent getRootInstance(@Nullable ComponentTree componentTree) {
        InternalNode root;
        LayoutState layoutState = componentTree == null ? null : componentTree.getMainThreadLayoutState();
        InternalNode internalNode = root = layoutState == null ? null : layoutState.getLayoutRoot();
        if (root != null) {
            int outerWrapperComponentIndex = Math.max(0, root.getComponents().size() - 1);
            return DebugComponent.getInstance(root, outerWrapperComponentIndex);
        }
        return null;
    }

    public String getName() {
        return this.mComponentClass.getName();
    }

    public String getSimpleName() {
        return this.mComponentClass.getSimpleName();
    }

    public Class getComponentClass() {
        return this.mComponentClass;
    }

    private static Class getComponentClass(InternalNode node, int componentIndex) {
        if (node.getComponents().isEmpty()) {
            switch (node.mYogaNode.getFlexDirection()) {
                case COLUMN: {
                    return Column.class;
                }
                case COLUMN_REVERSE: {
                    return ColumnReverse.class;
                }
                case ROW: {
                    return Row.class;
                }
                case ROW_REVERSE: {
                    return RowReverse.class;
                }
            }
        }
        return node.getComponents().get(componentIndex).getLifecycle().getClass();
    }

    public void setOverrider(Overrider overrider) {
        this.mOverrider = overrider;
    }

    public List<DebugComponent> getChildComponents() {
        InternalNode node = (InternalNode)this.mNode.get();
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.mComponentIndex > 0) {
            int wrappedComponentIndex = this.mComponentIndex - 1;
            return Arrays.asList(DebugComponent.getInstance(node, wrappedComponentIndex));
        }
        ArrayList<DebugComponent> children = new ArrayList<DebugComponent>();
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            InternalNode childNode = node.getChildAt(i);
            int outerWrapperComponentIndex = Math.max(0, childNode.getComponents().size() - 1);
            children.add(DebugComponent.getInstance(childNode, outerWrapperComponentIndex));
        }
        if (node.hasNestedTree()) {
            InternalNode nestedTree = node.getNestedTree();
            int count2 = nestedTree.getChildCount();
            for (int i = 0; i < count2; ++i) {
                InternalNode childNode = nestedTree.getChildAt(i);
                children.add(DebugComponent.getInstance(childNode, Math.max(0, childNode.getComponents().size() - 1)));
            }
        }
        return children;
    }

    @Nullable
    public View getMountedView() {
        Component component;
        InternalNode node = (InternalNode)this.mNode.get();
        Component component2 = component = node == null ? null : node.getRootComponent();
        if (component != null && Component.isMountViewSpec(component)) {
            return (View)this.getMountedContent();
        }
        return null;
    }

    @Nullable
    public Drawable getMountedDrawable() {
        Component component;
        InternalNode node = (InternalNode)this.mNode.get();
        Component component2 = component = node == null ? null : node.getRootComponent();
        if (component != null && Component.isMountDrawableSpec(component)) {
            return (Drawable)this.getMountedContent();
        }
        return null;
    }

    @Nullable
    public LithoView getLithoView() {
        InternalNode node = (InternalNode)this.mNode.get();
        ComponentContext c = node == null ? null : node.getContext();
        ComponentTree tree = c == null ? null : c.getComponentTree();
        return tree == null ? null : tree.getLithoView();
    }

    public Rect getBoundsInLithoView() {
        InternalNode node = (InternalNode)this.mNode.get();
        if (node == null) {
            return new Rect();
        }
        int x = this.getXFromRoot(node);
        int y = this.getYFromRoot(node);
        return new Rect(x, y, x + node.getWidth(), y + node.getHeight());
    }

    public Rect getBounds() {
        InternalNode node = (InternalNode)this.mNode.get();
        if (node == null) {
            return new Rect();
        }
        int x = node.getX();
        int y = node.getY();
        return new Rect(x, y, x + node.getWidth(), y + node.getHeight());
    }

    public ComponentContext getContext() {
        return ((InternalNode)this.mNode.get()).getContext();
    }

    public boolean isLayoutNode() {
        InternalNode node = (InternalNode)this.mNode.get();
        return node != null && (node.getComponents().isEmpty() || this.mComponentIndex == 0);
    }

    @Nullable
    public String getTestKey() {
        return this.isLayoutNode() ? ((InternalNode)this.mNode.get()).getTestKey() : null;
    }

    @Nullable
    public String getTextContent() {
        LithoView lithoView = this.getLithoView();
        Component component = this.getComponent();
        if (lithoView == null || component == null) {
            return null;
        }
        MountState mountState = lithoView.getMountState();
        StringBuilder sb = new StringBuilder();
        int size = mountState.getItemCount();
        for (int i = 0; i < size; ++i) {
            Object content;
            Component<?> mountItemComponent;
            MountItem mountItem = mountState.getItemAt(i);
            Component<?> component2 = mountItemComponent = mountItem == null ? null : mountItem.getComponent();
            if (mountItemComponent == null || !mountItemComponent.isEquivalentTo(component) || !((content = mountItem.getContent()) instanceof TextContent)) continue;
            for (CharSequence charSequence : ((TextContent)content).getTextItems()) {
                sb.append(charSequence);
            }
        }
        return sb.toString();
    }

    @Nullable
    public ComponentHost getComponentHost() {
        LithoView lithoView = this.getLithoView();
        Component component = this.getComponent();
        if (lithoView == null || component == null) {
            return null;
        }
        int size = lithoView.getMountState().getItemCount();
        for (int i = 0; i < size; ++i) {
            Component<?> mountItemComponent;
            MountItem mountItem = lithoView.getMountState().getItemAt(i);
            Component<?> component2 = mountItemComponent = mountItem == null ? null : mountItem.getComponent();
            if (mountItemComponent == null || !mountItemComponent.isEquivalentTo(component)) continue;
            return mountItem.getHost();
        }
        return null;
    }

    @Nullable
    public String getKey() {
        InternalNode node = (InternalNode)this.mNode.get();
        if (node != null && !node.getComponents().isEmpty()) {
            Component component = node.getComponents().get(this.mComponentIndex);
            return component == null ? null : component.getKey();
        }
        return null;
    }

    @Nullable
    public Component getComponent() {
        InternalNode node = (InternalNode)this.mNode.get();
        if (node == null || node.getComponents().isEmpty()) {
            return null;
        }
        return node.getComponents().get(this.mComponentIndex);
    }

    @Nullable
    public YogaNode getYogaNode() {
        InternalNode node = (InternalNode)this.mNode.get();
        if (node == null || !this.isLayoutNode()) {
            return null;
        }
        return node.mYogaNode;
    }

    @Nullable
    public Drawable getForeground() {
        InternalNode node = (InternalNode)this.mNode.get();
        if (node == null || !this.isLayoutNode()) {
            return null;
        }
        return node.getForeground();
    }

    @Nullable
    public Reference<? extends Drawable> getBackground() {
        InternalNode node = (InternalNode)this.mNode.get();
        if (node == null || !this.isLayoutNode()) {
            return null;
        }
        return node.getBackground();
    }

    @Nullable
    public Integer getImportantForAccessibility() {
        InternalNode node = (InternalNode)this.mNode.get();
        return node == null ? null : Integer.valueOf(node.getImportantForAccessibility());
    }

    public boolean getFocusable() {
        NodeInfo nodeInfo = ((InternalNode)this.mNode.get()).getNodeInfo();
        if (nodeInfo != null) {
            return nodeInfo.getFocusState() == 1;
        }
        return false;
    }

    @Nullable
    public CharSequence getContentDescription() {
        NodeInfo nodeInfo = ((InternalNode)this.mNode.get()).getNodeInfo();
        if (nodeInfo != null) {
            return ((InternalNode)this.mNode.get()).getNodeInfo().getContentDescription();
        }
        return null;
    }

    public void rerender() {
        LithoView lithoView = this.getLithoView();
        if (lithoView != null) {
            lithoView.forceRelayout();
        }
    }

    public void setBackgroundColor(int color) {
        ((InternalNode)this.mNode.get()).backgroundColor(color);
    }

    public void setForegroundColor(int color) {
        ((InternalNode)this.mNode.get()).foregroundColor(color);
    }

    public void setLayoutDirection(YogaDirection yogaDirection) {
        ((InternalNode)this.mNode.get()).layoutDirection(yogaDirection);
    }

    public void setFlexDirection(YogaFlexDirection direction) {
        ((InternalNode)this.mNode.get()).flexDirection(direction);
    }

    public void setJustifyContent(YogaJustify yogaJustify) {
        ((InternalNode)this.mNode.get()).justifyContent(yogaJustify);
    }

    public void setAlignItems(YogaAlign yogaAlign) {
        ((InternalNode)this.mNode.get()).alignItems(yogaAlign);
    }

    public void setAlignSelf(YogaAlign yogaAlign) {
        ((InternalNode)this.mNode.get()).alignSelf(yogaAlign);
    }

    public void setAlignContent(YogaAlign yogaAlign) {
        ((InternalNode)this.mNode.get()).alignContent(yogaAlign);
    }

    public void setPositionType(YogaPositionType yogaPositionType) {
        ((InternalNode)this.mNode.get()).positionType(yogaPositionType);
    }

    public void setFlexGrow(float value) {
        ((InternalNode)this.mNode.get()).flexGrow(value);
    }

    public void setFlexShrink(float value) {
        ((InternalNode)this.mNode.get()).flexShrink(value);
    }

    public void setFlexBasis(YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                ((InternalNode)this.mNode.get()).flexBasisAuto();
                break;
            }
            case PERCENT: {
                ((InternalNode)this.mNode.get()).flexBasisPercent(value.value);
                break;
            }
            case POINT: {
                ((InternalNode)this.mNode.get()).flexBasisPx((int)value.value);
            }
        }
    }

    public void setWidth(YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                ((InternalNode)this.mNode.get()).widthAuto();
                break;
            }
            case PERCENT: {
                ((InternalNode)this.mNode.get()).widthPercent(value.value);
                break;
            }
            case POINT: {
                ((InternalNode)this.mNode.get()).widthPx((int)value.value);
            }
        }
    }

    public void setMinWidth(YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                ((InternalNode)this.mNode.get()).minWidthPx(Integer.MIN_VALUE);
                break;
            }
            case PERCENT: {
                ((InternalNode)this.mNode.get()).minWidthPercent(value.value);
                break;
            }
            case POINT: {
                ((InternalNode)this.mNode.get()).minWidthPx((int)value.value);
            }
        }
    }

    public void setMaxWidth(YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                ((InternalNode)this.mNode.get()).maxWidthPx(Integer.MAX_VALUE);
                break;
            }
            case PERCENT: {
                ((InternalNode)this.mNode.get()).maxWidthPercent(value.value);
                break;
            }
            case POINT: {
                ((InternalNode)this.mNode.get()).maxWidthPx((int)value.value);
            }
        }
    }

    public void setHeight(YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                ((InternalNode)this.mNode.get()).heightAuto();
                break;
            }
            case PERCENT: {
                ((InternalNode)this.mNode.get()).heightPercent(value.value);
                break;
            }
            case POINT: {
                ((InternalNode)this.mNode.get()).heightPx((int)value.value);
            }
        }
    }

    public void setMinHeight(YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                ((InternalNode)this.mNode.get()).minHeightPx(Integer.MIN_VALUE);
                break;
            }
            case PERCENT: {
                ((InternalNode)this.mNode.get()).minHeightPercent(value.value);
                break;
            }
            case POINT: {
                ((InternalNode)this.mNode.get()).minHeightPx((int)value.value);
            }
        }
    }

    public void setMaxHeight(YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                ((InternalNode)this.mNode.get()).maxHeightPx(Integer.MAX_VALUE);
                break;
            }
            case PERCENT: {
                ((InternalNode)this.mNode.get()).maxHeightPercent(value.value);
                break;
            }
            case POINT: {
                ((InternalNode)this.mNode.get()).maxHeightPx((int)value.value);
            }
        }
    }

    public void setAspectRatio(float aspectRatio) {
        ((InternalNode)this.mNode.get()).aspectRatio(aspectRatio);
    }

    public void setMargin(YogaEdge edge, YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: {
                ((InternalNode)this.mNode.get()).marginPx(edge, 0);
                break;
            }
            case AUTO: {
                ((InternalNode)this.mNode.get()).marginAuto(edge);
                break;
            }
            case PERCENT: {
                ((InternalNode)this.mNode.get()).marginPercent(edge, value.value);
                break;
            }
            case POINT: {
                ((InternalNode)this.mNode.get()).marginPx(edge, (int)value.value);
            }
        }
    }

    public void setPadding(YogaEdge edge, YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                ((InternalNode)this.mNode.get()).paddingPx(edge, 0);
                break;
            }
            case PERCENT: {
                ((InternalNode)this.mNode.get()).paddingPercent(edge, value.value);
                break;
            }
            case POINT: {
                ((InternalNode)this.mNode.get()).paddingPx(edge, (int)value.value);
            }
        }
    }

    public void setPosition(YogaEdge edge, YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                ((InternalNode)this.mNode.get()).positionPercent(edge, Float.NaN);
                break;
            }
            case PERCENT: {
                ((InternalNode)this.mNode.get()).positionPercent(edge, value.value);
                break;
            }
            case POINT: {
                ((InternalNode)this.mNode.get()).positionPx(edge, (int)value.value);
            }
        }
    }

    public void setBorderWidth(YogaEdge edge, float value) {
        ((InternalNode)this.mNode.get()).setBorderWidth(edge, (int)value);
    }

    public void setContentDescription(CharSequence contentDescription) {
        ((InternalNode)this.mNode.get()).contentDescription(contentDescription);
    }

    public void setImportantForAccessibility(int importantForAccessibility) {
        ((InternalNode)this.mNode.get()).importantForAccessibility(importantForAccessibility);
    }

    public void setFocusable(boolean focusable) {
        ((InternalNode)this.mNode.get()).focusable(focusable);
    }

    @Nullable
    public ComponentLifecycle.StateContainer getStateContainer() {
        Component component = this.getComponent();
        return component == null ? null : component.getStateContainer();
    }

    void applyOverrides() {
        InternalNode node = (InternalNode)this.mNode.get();
        if (node != null && this.mOverrider != null) {
            this.mOverrider.applyOverrides(this);
        }
    }

    private InternalNode parent(InternalNode node) {
        InternalNode parent = node.getParent();
        return parent != null ? parent : node.getNestedTreeHolder();
    }

    private int getXFromRoot(InternalNode node) {
        if (node == null) {
            return 0;
        }
        return node.getX() + this.getXFromRoot(this.parent(node));
    }

    private int getYFromRoot(InternalNode node) {
        if (node == null) {
            return 0;
        }
        return node.getY() + this.getYFromRoot(this.parent(node));
    }

    private static String createKey(InternalNode node, int componentIndex) {
        String key;
        InternalNode parent = node.getParent();
        InternalNode nestedTreeHolder = node.getNestedTreeHolder();
        if (parent != null) {
            key = DebugComponent.createKey(parent, 0) + "." + parent.getChildIndex(node);
        } else if (nestedTreeHolder != null) {
            key = DebugComponent.createKey(nestedTreeHolder, 0) + ".nested";
        } else {
            ComponentContext c = node.getContext();
            ComponentTree tree = c == null ? null : c.getComponentTree();
            key = Integer.toString(System.identityHashCode(tree));
        }
        return key + "(" + componentIndex + ")";
    }

    public String getId() {
        return this.mKey;
    }

    @Nullable
    public EventHandler getClickHandler() {
        if (this.mComponentIndex > 0) {
            return null;
        }
        InternalNode node = (InternalNode)this.mNode.get();
        if (node == null) {
            return null;
        }
        return node.getClickHandler();
    }

    @Nullable
    private Object getMountedContent() {
        MountState mountState;
        if (this.mComponentIndex > 0) {
            return null;
        }
        InternalNode node = (InternalNode)this.mNode.get();
        ComponentContext context = node == null ? null : node.getContext();
        ComponentTree tree = context == null ? null : context.getComponentTree();
        LithoView view = tree == null ? null : tree.getLithoView();
        MountState mountState2 = mountState = view == null ? null : view.getMountState();
        if (mountState != null) {
            int count = mountState.getItemCount();
            for (int i = 0; i < count; ++i) {
                Component<?> component;
                MountItem mountItem = mountState.getItemAt(i);
                Component<?> component2 = component = mountItem == null ? null : mountItem.getComponent();
                if (component == null || component != node.getRootComponent()) continue;
                return mountItem.getContent();
            }
        }
        return null;
    }

    public static interface Overrider {
        public void applyOverrides(DebugComponent var1);
    }
}

