/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.support.annotation.Nullable;

public class ContextUtils {
    @Nullable
    static Activity getValidActivityForContext(Context context) {
        Activity activity = ContextUtils.findActivityInContext(context);
        if (activity == null || activity.isFinishing() || ContextUtils.isActivityDestroyed(activity)) {
            return null;
        }
        return activity;
    }

    @Nullable
    private static Activity findActivityInContext(Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return ContextUtils.findActivityInContext(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    private static boolean isActivityDestroyed(Activity activity) {
        if (Build.VERSION.SDK_INT >= 17) {
            return activity.isDestroyed();
        }
        return true;
    }
}

