/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.util.SparseArrayCompat;
import android.util.SparseArray;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.BorderColorDrawable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.Diff;
import com.facebook.litho.DiffNode;
import com.facebook.litho.DisplayListContainer;
import com.facebook.litho.DisplayListDrawable;
import com.facebook.litho.Edges;
import com.facebook.litho.EventHandler;
import com.facebook.litho.InternalNode;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoView;
import com.facebook.litho.LogEvent;
import com.facebook.litho.MountItem;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.Output;
import com.facebook.litho.RecyclePool;
import com.facebook.litho.RenderState;
import com.facebook.litho.StateHandler;
import com.facebook.litho.TestItem;
import com.facebook.litho.TestOutput;
import com.facebook.litho.Touchable;
import com.facebook.litho.TransitionContext;
import com.facebook.litho.TreeProps;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.litho.VisibilityItem;
import com.facebook.litho.VisibilityOutput;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.internal.ArraySet;
import com.facebook.yoga.YogaConfig;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ComponentsPools {
    private static final int SCRAP_ARRAY_INITIAL_SIZE = 4;
    private static YogaConfig sYogaConfig;
    private static final Object mountContentLock;
    static final RecyclePool<LayoutState> sLayoutStatePool;
    static final RecyclePool<InternalNode> sInternalNodePool;
    static final RecyclePool<NodeInfo> sNodeInfoPool;
    static final RecyclePool<ViewNodeInfo> sViewNodeInfoPool;
    static final RecyclePool<YogaNode> sYogaNodePool;
    static final RecyclePool<MountItem> sMountItemPool;
    static final Map<Context, SparseArray<RecyclePool>> sMountContentPoolsByContext;
    static final RecyclePool<LayoutOutput> sLayoutOutputPool;
    static final RecyclePool<DisplayListContainer> sDisplayListContainerPool;
    static final RecyclePool<VisibilityOutput> sVisibilityOutputPool;
    static RecyclePool<TestOutput> sTestOutputPool;
    static RecyclePool<TestItem> sTestItemPool;
    static final RecyclePool<VisibilityItem> sVisibilityItemPool;
    static final RecyclePool<Output<?>> sOutputPool;
    static final RecyclePool<DiffNode> sDiffNodePool;
    static final RecyclePool<Diff<?>> sDiffPool;
    static final RecyclePool<ComponentTree.Builder> sComponentTreeBuilderPool;
    static final RecyclePool<StateHandler> sStateHandlerPool;
    static final RecyclePool<SparseArrayCompat<MountItem>> sMountItemScrapArrayPool;
    static final RecyclePool<SparseArrayCompat<Touchable>> sTouchableScrapArrayPool;
    static final RecyclePool<RectF> sRectFPool;
    static final RecyclePool<Rect> sRectPool;
    static final RecyclePool<Edges> sEdgesPool;
    static final RecyclePool<TransitionContext> sTransitionContextPool;
    static final RecyclePool<DisplayListDrawable> sDisplayListDrawablePool;
    static final RecyclePool<TreeProps> sTreePropsMapPool;
    static final RecyclePool<ArraySet> sArraySetPool;
    static final RecyclePool<ArrayDeque> sArrayDequePool;
    static final RecyclePool<LogEvent> sLogEventPool;
    static final RecyclePool<RenderState> sRenderStatePool;
    static final RecyclePool<ArrayList<LithoView>> sLithoViewArrayListPool;
    static RecyclePool<BorderColorDrawable> sBorderColorDrawablePool;
    private static PoolsActivityCallback sActivityCallbacks;
    static boolean sIsManualCallbacks;

    private ComponentsPools() {
    }

    static LayoutState acquireLayoutState(ComponentContext context) {
        LayoutState state;
        LayoutState layoutState = state = ComponentsConfiguration.usePooling ? sLayoutStatePool.acquire() : null;
        if (state == null) {
            state = new LayoutState();
        }
        state.init(context);
        return state;
    }

    static synchronized YogaNode acquireYogaNode(ComponentContext c, YogaConfig yogaConfig) {
        YogaNode node;
        YogaNode yogaNode = node = ComponentsConfiguration.usePooling ? sYogaNodePool.acquire() : null;
        if (node == null) {
            node = new YogaNode(yogaConfig);
        }
        return node;
    }

    static synchronized InternalNode acquireInternalNode(ComponentContext componentContext, YogaConfig yogaConfig) {
        InternalNode node;
        InternalNode internalNode = node = ComponentsConfiguration.usePooling ? sInternalNodePool.acquire() : null;
        if (node == null) {
            node = new InternalNode();
        }
        node.init(ComponentsPools.acquireYogaNode(componentContext, yogaConfig), componentContext);
        return node;
    }

    static synchronized InternalNode acquireInternalNode(ComponentContext componentContext) {
        if (sYogaConfig == null) {
            sYogaConfig = new YogaConfig();
            sYogaConfig.setUseWebDefaults(true);
            sYogaConfig.setUseLegacyStretchBehaviour(true);
        }
        if (sYogaConfig.getLogger() != ComponentsConfiguration.YOGA_LOGGER) {
            sYogaConfig.setLogger(ComponentsConfiguration.YOGA_LOGGER);
        }
        return ComponentsPools.acquireInternalNode(componentContext, sYogaConfig);
    }

    static synchronized NodeInfo acquireNodeInfo() {
        NodeInfo nodeInfo;
        NodeInfo nodeInfo2 = nodeInfo = ComponentsConfiguration.usePooling ? sNodeInfoPool.acquire() : null;
        if (nodeInfo == null) {
            nodeInfo = new NodeInfo();
        }
        return nodeInfo;
    }

    static synchronized ViewNodeInfo acquireViewNodeInfo() {
        ViewNodeInfo viewNodeInfo;
        ViewNodeInfo viewNodeInfo2 = viewNodeInfo = ComponentsConfiguration.usePooling ? sViewNodeInfoPool.acquire() : null;
        if (viewNodeInfo == null) {
            viewNodeInfo = new ViewNodeInfo();
        }
        return viewNodeInfo;
    }

    static MountItem acquireRootHostMountItem(Component<?> component, ComponentHost host, Object content) {
        MountItem item;
        MountItem mountItem = item = ComponentsConfiguration.usePooling ? sMountItemPool.acquire() : null;
        if (item == null) {
            item = new MountItem();
        }
        ViewNodeInfo viewNodeInfo = ViewNodeInfo.acquire();
        viewNodeInfo.setLayoutDirection(YogaDirection.INHERIT);
        item.init(component, host, content, null, viewNodeInfo, null, null, 0, 0);
        return item;
    }

    static MountItem acquireMountItem(Component<?> component, ComponentHost host, Object content, LayoutOutput layoutOutput) {
        MountItem item;
        MountItem mountItem = item = ComponentsConfiguration.usePooling ? sMountItemPool.acquire() : null;
        if (item == null) {
            item = new MountItem();
        }
        item.init(component, host, content, layoutOutput, null);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object acquireMountContent(Context context, int componentId, boolean allocatePool) {
        RecyclePool pool;
        if (context instanceof ComponentContext && (context = ((ComponentContext)context).getBaseContext()) instanceof ComponentContext) {
            throw new IllegalStateException("Double wrapped ComponentContext.");
        }
        Object object = mountContentLock;
        synchronized (object) {
            SparseArray<RecyclePool> poolsArray;
            if (allocatePool && sActivityCallbacks == null && !sIsManualCallbacks) {
                if (Build.VERSION.SDK_INT < 14) {
                    throw new RuntimeException("Activity callbacks must be invoked manually below ICS (API level 14)");
                }
                sActivityCallbacks = new PoolsActivityCallback();
                ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sActivityCallbacks);
            }
            if ((poolsArray = sMountContentPoolsByContext.get(context)) == null) {
                if (allocatePool) {
                    sMountContentPoolsByContext.put(context, (SparseArray<RecyclePool>)new SparseArray());
                }
                return null;
            }
            pool = (RecyclePool)poolsArray.get(componentId);
            if (pool == null) {
                return null;
            }
        }
        return pool.acquire();
    }

    static Object acquireMountContent(Context context, int componentId) {
        return ComponentsPools.acquireMountContent(context, componentId, true);
    }

    static LayoutOutput acquireLayoutOutput() {
        LayoutOutput output;
        LayoutOutput layoutOutput = output = ComponentsConfiguration.usePooling ? sLayoutOutputPool.acquire() : null;
        if (output == null) {
            output = new LayoutOutput();
        }
        output.acquire();
        return output;
    }

    static DisplayListContainer acquireDisplayListContainer() {
        DisplayListContainer displayListContainer;
        DisplayListContainer displayListContainer2 = displayListContainer = ComponentsConfiguration.usePooling ? sDisplayListContainerPool.acquire() : null;
        if (displayListContainer == null) {
            displayListContainer = new DisplayListContainer();
        }
        return displayListContainer;
    }

    static VisibilityOutput acquireVisibilityOutput() {
        VisibilityOutput output;
        VisibilityOutput visibilityOutput = output = ComponentsConfiguration.usePooling ? sVisibilityOutputPool.acquire() : null;
        if (output == null) {
            output = new VisibilityOutput();
        }
        return output;
    }

    static VisibilityItem acquireVisibilityItem(String globalKey, EventHandler<InvisibleEvent> invisibleHandler, EventHandler<UnfocusedVisibleEvent> unfocusedHandler) {
        VisibilityItem item;
        VisibilityItem visibilityItem = item = ComponentsConfiguration.usePooling ? sVisibilityItemPool.acquire() : null;
        if (item == null) {
            item = new VisibilityItem();
        }
        item.setGlobalKey(globalKey);
        item.setInvisibleHandler(invisibleHandler);
        item.setUnfocusedHandler(unfocusedHandler);
        return item;
    }

    static TestOutput acquireTestOutput() {
        TestOutput output;
        if (sTestOutputPool == null) {
            sTestOutputPool = new RecyclePool("TestOutput", 64, true);
        }
        TestOutput testOutput = output = ComponentsConfiguration.usePooling ? sTestOutputPool.acquire() : null;
        if (output == null) {
            output = new TestOutput();
        }
        return output;
    }

    static TestItem acquireTestItem() {
        TestItem item;
        if (sTestItemPool == null) {
            sTestItemPool = new RecyclePool("TestItem", 64, true);
        }
        TestItem testItem = item = ComponentsConfiguration.usePooling ? sTestItemPool.acquire() : null;
        if (item == null) {
            item = new TestItem();
        }
        return item;
    }

    static Output acquireOutput() {
        Output<Object> output;
        Output<?> output2 = output = ComponentsConfiguration.usePooling ? sOutputPool.acquire() : null;
        if (output == null) {
            output = new Output();
        }
        return output;
    }

    static DiffNode acquireDiffNode() {
        DiffNode node;
        DiffNode diffNode = node = ComponentsConfiguration.usePooling ? sDiffNodePool.acquire() : null;
        if (node == null) {
            node = new DiffNode();
        }
        return node;
    }

    public static <T> Diff acquireDiff(T previous, T next) {
        Diff<Object> diff;
        Diff<?> diff2 = diff = ComponentsConfiguration.usePooling ? sDiffPool.acquire() : null;
        if (diff == null) {
            diff = new Diff();
        }
        diff.init(previous, next);
        return diff;
    }

    static ComponentTree.Builder acquireComponentTreeBuilder(ComponentContext c, Component<?> root) {
        ComponentTree.Builder componentTreeBuilder;
        ComponentTree.Builder builder = componentTreeBuilder = ComponentsConfiguration.usePooling ? sComponentTreeBuilderPool.acquire() : null;
        if (componentTreeBuilder == null) {
            componentTreeBuilder = new ComponentTree.Builder();
        }
        componentTreeBuilder.init(c, root);
        return componentTreeBuilder;
    }

    static StateHandler acquireStateHandler(StateHandler fromStateHandler) {
        StateHandler stateHandler;
        StateHandler stateHandler2 = stateHandler = ComponentsConfiguration.usePooling ? sStateHandlerPool.acquire() : null;
        if (stateHandler == null) {
            stateHandler = new StateHandler();
        }
        stateHandler.init(fromStateHandler);
        return stateHandler;
    }

    static StateHandler acquireStateHandler() {
        return ComponentsPools.acquireStateHandler(null);
    }

    static TransitionContext acquireTransitionContext() {
        TransitionContext transitionContext;
        TransitionContext transitionContext2 = transitionContext = ComponentsConfiguration.usePooling ? sTransitionContextPool.acquire() : null;
        if (transitionContext == null) {
            transitionContext = new TransitionContext();
        }
        return transitionContext;
    }

    public static TreeProps acquireTreeProps() {
        TreeProps treeProps;
        TreeProps treeProps2 = treeProps = ComponentsConfiguration.usePooling ? sTreePropsMapPool.acquire() : null;
        if (treeProps == null) {
            treeProps = new TreeProps();
        }
        return treeProps;
    }

    public static LogEvent acquireLogEvent(int eventId) {
        LogEvent event;
        LogEvent logEvent = event = ComponentsConfiguration.usePooling ? sLogEventPool.acquire() : null;
        if (event == null) {
            event = new LogEvent();
        }
        event.setEventId(eventId);
        return event;
    }

    @ThreadSafe(enableChecks=false)
    public static void release(TreeProps treeProps) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        treeProps.reset();
        sTreePropsMapPool.release(treeProps);
    }

    @ThreadSafe(enableChecks=false)
    static void release(TransitionContext transitionContext) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        transitionContext.reset();
        sTransitionContextPool.release(transitionContext);
    }

    @ThreadSafe(enableChecks=false)
    static void release(ComponentTree.Builder componentTreeBuilder) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        componentTreeBuilder.release();
        sComponentTreeBuilderPool.release(componentTreeBuilder);
    }

    @ThreadSafe(enableChecks=false)
    static void release(StateHandler stateHandler) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        stateHandler.release();
        sStateHandlerPool.release(stateHandler);
    }

    @ThreadSafe(enableChecks=false)
    static void release(LayoutState state) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        sLayoutStatePool.release(state);
    }

    @ThreadSafe(enableChecks=false)
    static void release(YogaNode node) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        node.reset();
        sYogaNodePool.release(node);
    }

    @ThreadSafe(enableChecks=false)
    static void release(InternalNode node) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        sInternalNodePool.release(node);
    }

    @ThreadSafe(enableChecks=false)
    static void release(NodeInfo nodeInfo) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        sNodeInfoPool.release(nodeInfo);
    }

    @ThreadSafe(enableChecks=false)
    static void release(ViewNodeInfo viewNodeInfo) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        sViewNodeInfoPool.release(viewNodeInfo);
    }

    @ThreadSafe(enableChecks=false)
    static void release(Context context, MountItem item) {
        item.release(context);
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        sMountItemPool.release(item);
    }

    @ThreadSafe(enableChecks=false)
    static void release(LayoutOutput output) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        output.release();
        sLayoutOutputPool.release(output);
    }

    static void release(DisplayListContainer displayListContainer) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        displayListContainer.release();
        sDisplayListContainerPool.release(displayListContainer);
    }

    @ThreadSafe(enableChecks=false)
    static void release(VisibilityOutput output) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        output.release();
        sVisibilityOutputPool.release(output);
    }

    @ThreadSafe(enableChecks=false)
    static void release(VisibilityItem item) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        item.release();
        sVisibilityItemPool.release(item);
    }

    @ThreadSafe(enableChecks=false)
    static void release(TestOutput testOutput) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        testOutput.release();
        sTestOutputPool.release(testOutput);
    }

    @ThreadSafe(enableChecks=false)
    static void release(TestItem testItem) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        testItem.release();
        sTestItemPool.release(testItem);
    }

    @ThreadSafe(enableChecks=false)
    static void release(DiffNode node) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        node.release();
        sDiffNodePool.release(node);
    }

    @ThreadSafe(enableChecks=false)
    static void release(Output output) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        output.release();
        sOutputPool.release(output);
    }

    @ThreadSafe(enableChecks=false)
    public static void release(Diff diff) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        diff.release();
        sDiffPool.release(diff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe(enableChecks=false)
    static void release(Context context, ComponentLifecycle lifecycle, Object mountContent) {
        if (context instanceof ComponentContext && (context = ((ComponentContext)context).getBaseContext()) instanceof ComponentContext) {
            throw new IllegalStateException("Double wrapped ComponentContext.");
        }
        RecyclePool<Object> pool = null;
        Object object = mountContentLock;
        synchronized (object) {
            SparseArray<RecyclePool> poolsArray = sMountContentPoolsByContext.get(context);
            if (poolsArray != null && (pool = (RecyclePool)poolsArray.get(lifecycle.getTypeId())) == null) {
                pool = new RecyclePool<Object>("MountContent - " + lifecycle.getClass().getSimpleName(), lifecycle.poolSize(), true);
                poolsArray.put(lifecycle.getTypeId(), pool);
            }
            if (pool != null) {
                pool.release(mountContent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe(enableChecks=false)
    static boolean canAddMountContentToPool(Context context, ComponentLifecycle lifecycle) {
        Object object = mountContentLock;
        synchronized (object) {
            if (lifecycle.poolSize() == 0) {
                return false;
            }
            SparseArray<RecyclePool> poolsArray = sMountContentPoolsByContext.get(context);
            if (poolsArray == null) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
            RecyclePool pool = (RecyclePool)poolsArray.get(lifecycle.getTypeId());
            return pool == null || !pool.isFull();
        }
    }

    static SparseArrayCompat<MountItem> acquireScrapMountItemsArray() {
        SparseArrayCompat sparseArray;
        SparseArrayCompat sparseArrayCompat = sparseArray = ComponentsConfiguration.usePooling ? sMountItemScrapArrayPool.acquire() : null;
        if (sparseArray == null) {
            sparseArray = new SparseArrayCompat(4);
        }
        return sparseArray;
    }

    @ThreadSafe(enableChecks=false)
    static void releaseScrapMountItemsArray(SparseArrayCompat<MountItem> sparseArray) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        sMountItemScrapArrayPool.release(sparseArray);
    }

    static SparseArrayCompat<Touchable> acquireScrapTouchablesArray() {
        SparseArrayCompat sparseArray;
        SparseArrayCompat sparseArrayCompat = sparseArray = ComponentsConfiguration.usePooling ? sTouchableScrapArrayPool.acquire() : null;
        if (sparseArray == null) {
            sparseArray = new SparseArrayCompat(4);
        }
        return sparseArray;
    }

    @ThreadSafe(enableChecks=false)
    static void releaseScrapTouchablesArray(SparseArrayCompat<Touchable> sparseArray) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        sTouchableScrapArrayPool.release(sparseArray);
    }

    static RectF acquireRectF() {
        RectF rect;
        RectF rectF = rect = ComponentsConfiguration.usePooling ? sRectFPool.acquire() : null;
        if (rect == null) {
            rect = new RectF();
        }
        return rect;
    }

    @ThreadSafe(enableChecks=false)
    static void releaseRectF(RectF rect) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        rect.setEmpty();
        sRectFPool.release(rect);
    }

    static Rect acquireRect() {
        Rect rect;
        Rect rect2 = rect = ComponentsConfiguration.usePooling ? sRectPool.acquire() : null;
        if (rect == null) {
            rect = new Rect();
        }
        return rect;
    }

    @ThreadSafe(enableChecks=false)
    static void release(Rect rect) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        rect.setEmpty();
        sRectPool.release(rect);
    }

    static Edges acquireEdges() {
        Edges spacing;
        Edges edges = spacing = ComponentsConfiguration.usePooling ? sEdgesPool.acquire() : null;
        if (spacing == null) {
            spacing = new Edges();
        }
        return spacing;
    }

    @ThreadSafe(enableChecks=false)
    static void release(Edges edges) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        edges.reset();
        sEdgesPool.release(edges);
    }

    static void onContextCreated(Context context) {
        if (sMountContentPoolsByContext.containsKey(context)) {
            throw new IllegalStateException("The MountContentPools has a reference to an activitythat has just been created");
        }
    }

    static void onContextDestroyed(Context context) {
        sMountContentPoolsByContext.remove(context);
        Iterator<Map.Entry<Context, SparseArray<RecyclePool>>> it = sMountContentPoolsByContext.entrySet().iterator();
        while (it.hasNext()) {
            Context contextKey = it.next().getKey();
            if (!ComponentsPools.isContextWrapper(contextKey, context)) continue;
            it.remove();
        }
    }

    public static void clearMountContentPools() {
        sMountContentPoolsByContext.clear();
    }

    public static void clearInternalUtilPools() {
        sLayoutStatePool.clear();
        sYogaNodePool.clear();
        sInternalNodePool.clear();
        sNodeInfoPool.clear();
        sViewNodeInfoPool.clear();
        sMountItemPool.clear();
        sLayoutOutputPool.clear();
        sDisplayListContainerPool.clear();
        sVisibilityOutputPool.clear();
        sVisibilityItemPool.clear();
        if (sTestOutputPool != null) {
            sTestOutputPool.clear();
        }
        if (sTestItemPool != null) {
            sTestItemPool.clear();
        }
        sOutputPool.clear();
        sDiffNodePool.clear();
        sDiffPool.clear();
        sComponentTreeBuilderPool.clear();
        sStateHandlerPool.clear();
        sTransitionContextPool.clear();
        sTreePropsMapPool.clear();
        sLogEventPool.clear();
        sMountItemScrapArrayPool.clear();
        sTouchableScrapArrayPool.clear();
        sRectFPool.clear();
        sEdgesPool.clear();
        sDisplayListDrawablePool.clear();
        if (sBorderColorDrawablePool != null) {
            sBorderColorDrawablePool.clear();
        }
        sArraySetPool.clear();
        sArrayDequePool.clear();
        sRenderStatePool.clear();
        sLithoViewArrayListPool.clear();
    }

    private static boolean isContextWrapper(Context contextWrapper, Context baseContext) {
        Context currentContext = contextWrapper;
        while (currentContext instanceof ContextWrapper) {
            if ((currentContext = ((ContextWrapper)currentContext).getBaseContext()) != baseContext) continue;
            return true;
        }
        return false;
    }

    public static DisplayListDrawable acquireDisplayListDrawable(Drawable content, DisplayListContainer displayListContainer) {
        DisplayListDrawable displayListDrawable;
        Drawable.Callback callback = content.getCallback();
        DisplayListDrawable displayListDrawable2 = displayListDrawable = ComponentsConfiguration.usePooling ? sDisplayListDrawablePool.acquire() : null;
        if (displayListDrawable == null) {
            displayListDrawable = new DisplayListDrawable(content, displayListContainer);
        } else {
            displayListDrawable.setWrappedDrawable(content, displayListContainer);
        }
        displayListDrawable.setCallback(callback);
        return displayListDrawable;
    }

    @ThreadSafe(enableChecks=false)
    public static void release(DisplayListDrawable displayListDrawable) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        displayListDrawable.release();
        sDisplayListDrawablePool.release(displayListDrawable);
    }

    public static BorderColorDrawable acquireBorderColorDrawable() {
        BorderColorDrawable drawable;
        if (sBorderColorDrawablePool == null) {
            sBorderColorDrawablePool = new RecyclePool("BorderColorDrawable", 10, true);
        }
        BorderColorDrawable borderColorDrawable = drawable = ComponentsConfiguration.usePooling ? sBorderColorDrawablePool.acquire() : null;
        if (drawable == null) {
            drawable = new BorderColorDrawable();
        }
        return drawable;
    }

    @ThreadSafe(enableChecks=false)
    public static void release(BorderColorDrawable borderColorDrawable) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        sBorderColorDrawablePool.release(borderColorDrawable);
    }

    public static <E> ArraySet<E> acquireArraySet() {
        ArraySet set;
        ArraySet arraySet = set = ComponentsConfiguration.usePooling ? sArraySetPool.acquire() : null;
        if (set == null) {
            set = new ArraySet();
        }
        return set;
    }

    @ThreadSafe(enableChecks=false)
    public static void release(ArraySet set) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        set.clear();
        sArraySetPool.release(set);
    }

    public static <E> ArrayDeque<E> acquireArrayDeque() {
        ArrayDeque deque;
        ArrayDeque arrayDeque = deque = ComponentsConfiguration.usePooling ? sArrayDequePool.acquire() : null;
        if (deque == null) {
            deque = new ArrayDeque();
        }
        return deque;
    }

    @ThreadSafe(enableChecks=false)
    public static void release(ArrayDeque deque) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        deque.clear();
        sArrayDequePool.release(deque);
    }

    @ThreadSafe(enableChecks=false)
    public static void release(LogEvent event) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        event.reset();
        sLogEventPool.release(event);
    }

    public static RenderState acquireRenderState() {
        RenderState renderState;
        RenderState renderState2 = renderState = ComponentsConfiguration.usePooling ? sRenderStatePool.acquire() : null;
        if (renderState == null) {
            renderState = new RenderState();
        }
        return renderState;
    }

    @ThreadSafe(enableChecks=false)
    public static void release(RenderState renderState) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        renderState.reset();
        sRenderStatePool.release(renderState);
    }

    public static ArrayList<LithoView> acquireLithoViewArrayList() {
        ArrayList<LithoView> arrayList;
        ArrayList<LithoView> arrayList2 = arrayList = ComponentsConfiguration.usePooling ? sLithoViewArrayListPool.acquire() : null;
        if (arrayList == null) {
            arrayList = new ArrayList(5);
        }
        return arrayList;
    }

    @ThreadSafe(enableChecks=false)
    public static void release(ArrayList<LithoView> arrayList) {
        if (!ComponentsConfiguration.usePooling) {
            return;
        }
        arrayList.clear();
        sLithoViewArrayListPool.release(arrayList);
    }

    static {
        mountContentLock = new Object();
        sLayoutStatePool = new RecyclePool("LayoutState", 64, true);
        sInternalNodePool = new RecyclePool("InternalNode", 256, true);
        sNodeInfoPool = new RecyclePool("NodeInfo", 256, true);
        sViewNodeInfoPool = new RecyclePool("ViewNodeInfo", 64, true);
        sYogaNodePool = new RecyclePool("YogaNode", 256, true);
        sMountItemPool = new RecyclePool("MountItem", 256, true);
        sMountContentPoolsByContext = new ConcurrentHashMap<Context, SparseArray<RecyclePool>>(4);
        sLayoutOutputPool = new RecyclePool("LayoutOutput", 256, true);
        sDisplayListContainerPool = new RecyclePool("DisplayListContainer", 64, true);
        sVisibilityOutputPool = new RecyclePool("VisibilityOutput", 64, true);
        sTestOutputPool = null;
        sTestItemPool = null;
        sVisibilityItemPool = new RecyclePool("VisibilityItem", 64, true);
        sOutputPool = new RecyclePool("Output", 20, true);
        sDiffNodePool = new RecyclePool("DiffNode", 256, true);
        sDiffPool = new RecyclePool("Diff", 20, true);
        sComponentTreeBuilderPool = new RecyclePool("ComponentTree.Builder", 2, true);
        sStateHandlerPool = new RecyclePool("StateHandler", 10, true);
        sMountItemScrapArrayPool = new RecyclePool("MountItemScrapArray", 8, false);
        sTouchableScrapArrayPool = new RecyclePool("TouchableScrapArray", 4, false);
        sRectFPool = new RecyclePool("RectF", 4, true);
        sRectPool = new RecyclePool("Rect", 30, true);
        sEdgesPool = new RecyclePool("Edges", 30, true);
        sTransitionContextPool = new RecyclePool("TransitionContext", 2, true);
        sDisplayListDrawablePool = new RecyclePool("DisplayListDrawable", 10, false);
        sTreePropsMapPool = new RecyclePool("TreeProps", 10, true);
        sArraySetPool = new RecyclePool("ArraySet", 10, true);
        sArrayDequePool = new RecyclePool("ArrayDeque", 10, true);
        sLogEventPool = new RecyclePool("LogEvent", 10, true);
        sRenderStatePool = new RecyclePool("RenderState", 4, true);
        sLithoViewArrayListPool = new RecyclePool("LithoViewArrayList", 4, false);
        sBorderColorDrawablePool = null;
    }

    @TargetApi(value=14)
    private static class PoolsActivityCallback
    implements Application.ActivityLifecycleCallbacks {
        private PoolsActivityCallback() {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            ComponentsPools.onContextCreated((Context)activity);
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            ComponentsPools.onContextDestroyed((Context)activity);
        }
    }
}

