/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Rect;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import android.view.View;
import android.view.ViewParent;
import com.facebook.infer.annotation.ReturnsOwnership;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.DiffNode;
import com.facebook.litho.EventHandler;
import com.facebook.litho.EventTrigger;
import com.facebook.litho.IncrementalMountHelper;
import com.facebook.litho.KeyHandler;
import com.facebook.litho.LayoutHandler;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoDebugInfo;
import com.facebook.litho.LithoTooltip;
import com.facebook.litho.LithoTooltipController;
import com.facebook.litho.LithoView;
import com.facebook.litho.LogEvent;
import com.facebook.litho.RenderState;
import com.facebook.litho.Size;
import com.facebook.litho.StateHandler;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.TooltipPosition;
import com.facebook.litho.config.ComponentsConfiguration;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckReturnValue;
import javax.annotation.concurrent.GuardedBy;

@ThreadSafe
public class ComponentTree {
    public static final int INVALID_ID = -1;
    private static final String TAG = ComponentTree.class.getSimpleName();
    private static final int SIZE_UNINITIALIZED = -1;
    private static final int MESSAGE_WHAT_BACKGROUND_LAYOUT_STATE_UPDATED = 1;
    private static final String DEFAULT_LAYOUT_THREAD_NAME = "ComponentLayoutThread";
    private static final int DEFAULT_LAYOUT_THREAD_PRIORITY = 10;
    private static final int SCHEDULE_NONE = 0;
    private static final int SCHEDULE_LAYOUT_ASYNC = 1;
    private static final int SCHEDULE_LAYOUT_SYNC = 2;
    private LithoDebugInfo mLithoDebugInfo;
    private boolean mReleased;
    private static final AtomicInteger sIdGenerator = new AtomicInteger(0);
    private static final Handler sMainThreadHandler = new ComponentMainThreadHandler();
    @GuardedBy(value="ComponentTree.class")
    private static volatile Looper sDefaultLayoutThreadLooper;
    private static final ThreadLocal<WeakReference<Handler>> sSyncStateUpdatesHandler;
    private static final int[] sCurrentLocation;
    private static final int[] sParentLocation;
    private static final Rect sParentBounds;
    @Nullable
    private final IncrementalMountHelper mIncrementalMountHelper;
    private final Runnable mCalculateLayoutRunnable = new Runnable(){

        @Override
        public void run() {
            ComponentTree.this.calculateLayout(null);
        }
    };
    private final Runnable mPreAllocateMountContentRunnable = new Runnable(){

        @Override
        public void run() {
            ComponentTree.this.preAllocateMountContent();
        }
    };
    private final Runnable mUpdateStateSyncRunnable = new Runnable(){

        @Override
        public void run() {
            ComponentTree.this.updateStateInternal(false);
        }
    };
    private final ComponentContext mContext;
    private final boolean mCanPrefetchDisplayLists;
    private final boolean mCanCacheDrawingDisplayLists;
    private final boolean mShouldClipChildren;
    @Nullable
    private final LayoutHandler mPreAllocateMountContentHandler;
    @ThreadConfined(value="UI")
    private boolean mIsMounting;
    @ThreadConfined(value="UI")
    private final boolean mIncrementalMountEnabled;
    @ThreadConfined(value="UI")
    private final boolean mIsLayoutDiffingEnabled;
    @ThreadConfined(value="UI")
    private boolean mIsAttached;
    @ThreadConfined(value="UI")
    private final boolean mIsAsyncUpdateStateEnabled;
    @ThreadConfined(value="UI")
    private LithoView mLithoView;
    @ThreadConfined(value="UI")
    private LayoutHandler mLayoutThreadHandler;
    @GuardedBy(value="this")
    private boolean mHasViewMeasureSpec;
    private boolean mHasMounted = false;
    @GuardedBy(value="this")
    @Nullable
    private Component<?> mRoot;
    @GuardedBy(value="this")
    private int mWidthSpec = -1;
    @GuardedBy(value="this")
    private int mHeightSpec = -1;
    private LayoutState mMainThreadLayoutState;
    @GuardedBy(value="this")
    private LayoutState mBackgroundLayoutState;
    @GuardedBy(value="this")
    private StateHandler mStateHandler;
    @ThreadConfined(value="UI")
    private RenderState mPreviousRenderState;
    @ThreadConfined(value="UI")
    private boolean mPreviousRenderStateSetFromBuilder = false;
    private final Object mLayoutLock;
    protected final int mId;
    @GuardedBy(value="this")
    private boolean mIsMeasuring;
    @GuardedBy(value="this")
    private int mScheduleLayoutAfterMeasure;
    @Nullable
    private Map<String, EventTrigger> mEventTriggers;
    @GuardedBy(value="this")
    public Map<String, List<EventHandler>> mEventHandlers = new HashMap<String, List<EventHandler>>();

    public static Builder create(ComponentContext context, Component.Builder<?, ?> root) {
        return ComponentTree.create(context, root.build());
    }

    public static Builder create(ComponentContext context, Component<?> root) {
        return ComponentsPools.acquireComponentTreeBuilder(context, root);
    }

    protected ComponentTree(Builder builder) {
        StateHandler builderStateHandler;
        this.mContext = ComponentContext.withComponentTree(builder.context, this);
        this.mRoot = builder.root;
        this.mIncrementalMountEnabled = builder.incrementalMountEnabled;
        this.mIsLayoutDiffingEnabled = builder.isLayoutDiffingEnabled;
        this.mLayoutThreadHandler = builder.layoutThreadHandler;
        this.mPreAllocateMountContentHandler = builder.preAllocateMountContentHandler;
        this.mLayoutLock = builder.layoutLock;
        this.mIsAsyncUpdateStateEnabled = builder.asyncStateUpdates;
        this.mCanPrefetchDisplayLists = builder.canPrefetchDisplayLists;
        this.mCanCacheDrawingDisplayLists = builder.canCacheDrawingDisplayLists;
        this.mShouldClipChildren = builder.shouldClipChildren;
        this.mHasMounted = builder.hasMounted;
        if (this.mLayoutThreadHandler == null) {
            this.mLayoutThreadHandler = new DefaultLayoutHandler(ComponentTree.getDefaultLayoutThreadLooper());
        }
        StateHandler stateHandler = this.mStateHandler = (builderStateHandler = builder.stateHandler) == null ? StateHandler.acquireNewInstance(null) : builderStateHandler;
        if (builder.previousRenderState != null) {
            this.mPreviousRenderState = builder.previousRenderState;
            this.mPreviousRenderStateSetFromBuilder = true;
        }
        this.mId = builder.overrideComponentTreeId != -1 ? builder.overrideComponentTreeId : ComponentTree.generateComponentTreeId();
        this.mIncrementalMountHelper = new IncrementalMountHelper(this);
    }

    @ThreadConfined(value="UI")
    LayoutState getMainThreadLayoutState() {
        return this.mMainThreadLayoutState;
    }

    @VisibleForTesting
    protected LayoutState getBackgroundLayoutState() {
        return this.mBackgroundLayoutState;
    }

    @CheckReturnValue
    @ReturnsOwnership
    @ThreadConfined(value="UI")
    private LayoutState setBestMainThreadLayoutAndReturnOldLayout() {
        ThreadUtils.assertHoldsLock(this);
        boolean isMainThreadLayoutBest = this.isCompatibleComponentAndSpec(this.mMainThreadLayoutState) ? true : !ComponentTree.isCompatibleSpec(this.mBackgroundLayoutState, this.mWidthSpec, this.mHeightSpec) && ComponentTree.isCompatibleSpec(this.mMainThreadLayoutState, this.mWidthSpec, this.mHeightSpec);
        if (isMainThreadLayoutBest) {
            LayoutState toRelease = this.mBackgroundLayoutState;
            this.mBackgroundLayoutState = null;
            return toRelease;
        }
        if (this.mLithoView != null) {
            this.mLithoView.setMountStateDirty();
        }
        LayoutState toRelease = this.mMainThreadLayoutState;
        this.mMainThreadLayoutState = this.mBackgroundLayoutState;
        this.mBackgroundLayoutState = null;
        return toRelease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundLayoutStateUpdated() {
        boolean needsAndroidLayout;
        int componentRootId;
        boolean layoutStateUpdated;
        LayoutState toRelease;
        ThreadUtils.assertMainThread();
        if (!this.mIsAttached) {
            return;
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            LayoutState oldMainThreadLayoutState = this.mMainThreadLayoutState;
            toRelease = this.setBestMainThreadLayoutAndReturnOldLayout();
            layoutStateUpdated = this.mMainThreadLayoutState != oldMainThreadLayoutState;
            componentRootId = this.mRoot.getId();
        }
        if (toRelease != null) {
            toRelease.releaseRef();
            toRelease = null;
        }
        if (!layoutStateUpdated) {
            return;
        }
        int viewWidth = this.mLithoView.getMeasuredWidth();
        int viewHeight = this.mLithoView.getMeasuredHeight();
        if (viewWidth == 0 && viewHeight == 0) {
            return;
        }
        boolean bl = needsAndroidLayout = !ComponentTree.isCompatibleComponentAndSize(this.mMainThreadLayoutState, componentRootId, viewWidth, viewHeight);
        if (needsAndroidLayout) {
            this.mLithoView.requestLayout();
        } else {
            this.mountComponentIfDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attach() {
        boolean needsAndroidLayout;
        int componentRootId;
        LayoutState toRelease;
        ThreadUtils.assertMainThread();
        if (this.mLithoView == null) {
            throw new IllegalStateException("Trying to attach a ComponentTree without a set View");
        }
        if (this.mIncrementalMountHelper != null) {
            this.mIncrementalMountHelper.onAttach(this.mLithoView);
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            this.mIsAttached = true;
            toRelease = this.setBestMainThreadLayoutAndReturnOldLayout();
            componentRootId = this.mRoot.getId();
        }
        if (toRelease != null) {
            toRelease.releaseRef();
            toRelease = null;
        }
        int viewWidth = this.mLithoView.getMeasuredWidth();
        int viewHeight = this.mLithoView.getMeasuredHeight();
        if (viewWidth == 0 && viewHeight == 0) {
            return;
        }
        boolean bl = needsAndroidLayout = !ComponentTree.isCompatibleComponentAndSize(this.mMainThreadLayoutState, componentRootId, viewWidth, viewHeight);
        if (needsAndroidLayout || this.mLithoView.isMountStateDirty()) {
            this.mLithoView.requestLayout();
        } else {
            this.mLithoView.rebind();
        }
    }

    private static boolean hasSameBaseContext(Context context1, Context context2) {
        return ComponentTree.getBaseContext(context1) == ComponentTree.getBaseContext(context2);
    }

    private static Context getBaseContext(Context context) {
        Context baseContext = context;
        while (baseContext instanceof ContextWrapper) {
            baseContext = ((ContextWrapper)baseContext).getBaseContext();
        }
        return baseContext;
    }

    @ThreadConfined(value="UI")
    boolean isMounting() {
        return this.mIsMounting;
    }

    private boolean mountComponentIfDirty() {
        if (this.mLithoView.isMountStateDirty()) {
            if (this.mIncrementalMountEnabled) {
                this.incrementalMountComponent();
            } else {
                this.mountComponent(null, true);
            }
            return true;
        }
        return false;
    }

    void incrementalMountComponent() {
        ThreadUtils.assertMainThread();
        if (!this.mIncrementalMountEnabled) {
            throw new IllegalStateException("Calling incrementalMountComponent() but incremental mount is not enabled");
        }
        if (this.mLithoView == null || this.mLithoView.doesOwnIncrementalMount()) {
            return;
        }
        Rect currentVisibleArea = ComponentsPools.acquireRect();
        if (this.getVisibleRect(currentVisibleArea)) {
            this.mountComponent(currentVisibleArea, true);
        }
        ComponentsPools.release(currentVisibleArea);
    }

    private boolean getVisibleRect(Rect visibleBounds) {
        ThreadUtils.assertMainThread();
        if (ComponentsConfiguration.incrementalMountUsesLocalVisibleBounds) {
            return this.mLithoView.getLocalVisibleRect(visibleBounds);
        }
        ComponentTree.getLocationAndBoundsOnScreen((View)this.mLithoView, sCurrentLocation, visibleBounds);
        ViewParent viewParent = this.mLithoView.getParent();
        if (viewParent instanceof View) {
            View parent = (View)viewParent;
            ComponentTree.getLocationAndBoundsOnScreen(parent, sParentLocation, sParentBounds);
            if (!visibleBounds.setIntersect(visibleBounds, sParentBounds)) {
                return false;
            }
        }
        visibleBounds.offset(-sCurrentLocation[0], -sCurrentLocation[1]);
        return true;
    }

    private static void getLocationAndBoundsOnScreen(View view, int[] location, Rect bounds) {
        ThreadUtils.assertMainThread();
        view.getLocationOnScreen(location);
        bounds.set(location[0], location[1], location[0] + view.getWidth(), location[1] + view.getHeight());
    }

    @ThreadConfined(value="UI")
    boolean hasLithoViewBoundsAnimation() {
        ThreadUtils.assertMainThread();
        return this.mMainThreadLayoutState != null && this.mMainThreadLayoutState.hasLithoViewBoundsAnimation();
    }

    void mountComponent(Rect currentVisibleArea, boolean processVisibilityOutputs) {
        ThreadUtils.assertMainThread();
        boolean isDirtyMount = this.mLithoView.isMountStateDirty();
        this.mIsMounting = true;
        if (isDirtyMount) {
            this.applyPreviousRenderData(this.mMainThreadLayoutState);
        }
        if (!this.mHasMounted) {
            this.mLithoView.getMountState().setIsFirstMountOfComponentTree();
            this.mHasMounted = true;
        }
        this.mLithoView.mount(this.mMainThreadLayoutState, currentVisibleArea, processVisibilityOutputs);
        if (isDirtyMount) {
            this.recordRenderData(this.mMainThreadLayoutState);
        }
        this.mIsMounting = false;
    }

    private void applyPreviousRenderData(LayoutState layoutState) {
        List<Component> components = layoutState.getComponentsNeedingPreviousRenderData();
        if (components == null || components.isEmpty()) {
            return;
        }
        if (this.mPreviousRenderState == null) {
            return;
        }
        this.mPreviousRenderState.applyPreviousRenderData(components);
    }

    private void recordRenderData(LayoutState layoutState) {
        List<Component> components = layoutState.getComponentsNeedingPreviousRenderData();
        if (components == null || components.isEmpty()) {
            return;
        }
        if (this.mPreviousRenderState == null) {
            this.mPreviousRenderState = ComponentsPools.acquireRenderState();
        }
        this.mPreviousRenderState.recordRenderData(components);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detach() {
        ThreadUtils.assertMainThread();
        if (this.mIncrementalMountHelper != null) {
            this.mIncrementalMountHelper.onDetach(this.mLithoView);
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            this.mIsAttached = false;
            this.mHasViewMeasureSpec = false;
        }
    }

    void setLithoView(@NonNull LithoView view) {
        ThreadUtils.assertMainThread();
        if (this.mIsAttached) {
            if (this.mLithoView != null) {
                this.mLithoView.setComponentTree(null);
            } else {
                this.detach();
            }
        } else if (this.mLithoView != null) {
            this.mLithoView.clearComponentTree();
        }
        if (!ComponentTree.hasSameBaseContext(view.getContext(), (Context)this.mContext)) {
            throw new IllegalArgumentException("Base view context differs, view context is: " + view.getContext() + ", ComponentTree context is: " + (Object)((Object)this.mContext));
        }
        this.mLithoView = view;
    }

    void clearLithoView() {
        ThreadUtils.assertMainThread();
        if (this.mIsAttached) {
            throw new IllegalStateException("Clearing the LithoView while the ComponentTree is attached");
        }
        this.mLithoView = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void measure(int widthSpec, int heightSpec, int[] measureOutput, boolean forceLayout) {
        ComponentTree componentTree;
        LayoutState toRelease;
        ThreadUtils.assertMainThread();
        Component<?> component = null;
        ComponentTree componentTree2 = this;
        synchronized (componentTree2) {
            this.mIsMeasuring = true;
            this.mWidthSpec = widthSpec;
            this.mHeightSpec = heightSpec;
            this.mHasViewMeasureSpec = true;
            toRelease = this.setBestMainThreadLayoutAndReturnOldLayout();
            if (forceLayout || !this.isCompatibleComponentAndSpec(this.mMainThreadLayoutState)) {
                component = this.mRoot.makeShallowCopy();
            }
        }
        if (toRelease != null) {
            toRelease.releaseRef();
            toRelease = null;
        }
        if (component != null) {
            LayoutState localLayoutState;
            if (this.mMainThreadLayoutState != null) {
                ComponentTree componentTree3 = this;
                synchronized (componentTree3) {
                    localLayoutState = this.mMainThreadLayoutState;
                    this.mMainThreadLayoutState = null;
                }
                localLayoutState.releaseRef();
            }
            localLayoutState = this.calculateLayoutState(this.mLayoutLock, this.mContext, component, widthSpec, heightSpec, this.mIsLayoutDiffingEnabled, null);
            StateHandler layoutStateStateHandler = localLayoutState.consumeStateHandler();
            componentTree = this;
            synchronized (componentTree) {
                if (layoutStateStateHandler != null) {
                    this.mStateHandler.commit(layoutStateStateHandler);
                }
                for (Component layoutComponent : localLayoutState.getComponents()) {
                    this.bindEventHandler(layoutComponent);
                }
                localLayoutState.clearComponents();
                this.mMainThreadLayoutState = localLayoutState;
                localLayoutState = null;
            }
            this.mLithoView.setMountStateDirty();
        }
        measureOutput[0] = this.mMainThreadLayoutState.getWidth();
        measureOutput[1] = this.mMainThreadLayoutState.getHeight();
        int layoutScheduleType = 0;
        Component<?> root = null;
        componentTree = this;
        synchronized (componentTree) {
            this.mIsMeasuring = false;
            if (this.mScheduleLayoutAfterMeasure != 0) {
                layoutScheduleType = this.mScheduleLayoutAfterMeasure;
                this.mScheduleLayoutAfterMeasure = 0;
                root = this.mRoot.makeShallowCopy();
            }
        }
        if (layoutScheduleType != 0) {
            this.setRootAndSizeSpecInternal(root, -1, -1, layoutScheduleType == 1, null);
        }
    }

    boolean layout() {
        ThreadUtils.assertMainThread();
        return this.mountComponentIfDirty();
    }

    public boolean isIncrementalMountEnabled() {
        return this.mIncrementalMountEnabled;
    }

    synchronized Component getRoot() {
        return this.mRoot;
    }

    public void setRoot(Component<?> rootComponent) {
        if (rootComponent == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecInternal(rootComponent, -1, -1, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe(enableChecks=false)
    private void preAllocateMountContent() {
        LayoutState toPrePopulate;
        if (this.mPreAllocateMountContentHandler != null) {
            this.mPreAllocateMountContentHandler.removeCallbacks(this.mPreAllocateMountContentRunnable);
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            toPrePopulate = this.mMainThreadLayoutState != null ? this.mMainThreadLayoutState : this.mBackgroundLayoutState;
        }
        if (toPrePopulate == null) {
            return;
        }
        toPrePopulate.acquireRef();
        ComponentsLogger logger = this.mContext.getLogger();
        LogEvent event = null;
        if (logger != null) {
            event = logger.newPerformanceEvent(8);
            event.addParam("log_tag", this.mContext.getLogTag());
        }
        toPrePopulate.preAllocateMountContent();
        if (logger != null) {
            logger.log(event);
        }
        toPrePopulate.releaseRef();
    }

    public void setRootAsync(Component<?> rootComponent) {
        if (rootComponent == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecInternal(rootComponent, -1, -1, true, null);
    }

    synchronized void updateStateLazy(String componentKey, ComponentLifecycle.StateUpdate stateUpdate) {
        if (this.mRoot == null) {
            return;
        }
        this.mStateHandler.queueStateUpdate(componentKey, stateUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateState(String componentKey, ComponentLifecycle.StateUpdate stateUpdate) {
        Handler handler;
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            this.mStateHandler.queueStateUpdate(componentKey, stateUpdate);
        }
        Looper looper = Looper.myLooper();
        if (looper == null) {
            Log.w((String)TAG, (String)"You cannot update state synchronously from a thread without a looper, using the default background layout thread instead");
            this.mLayoutThreadHandler.removeCallbacks(this.mUpdateStateSyncRunnable);
            this.mLayoutThreadHandler.post(this.mUpdateStateSyncRunnable);
            return;
        }
        ComponentTree componentTree2 = this;
        synchronized (componentTree2) {
            WeakReference<Handler> handlerWr = sSyncStateUpdatesHandler.get();
            if (handlerWr != null && handlerWr.get() != null) {
                handler = (Handler)handlerWr.get();
                handler.removeCallbacks(this.mUpdateStateSyncRunnable);
            } else {
                handler = new Handler(looper);
                sSyncStateUpdatesHandler.set(new WeakReference<Handler>(handler));
            }
        }
        handler.post(this.mUpdateStateSyncRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStateAsync(String componentKey, ComponentLifecycle.StateUpdate stateUpdate) {
        if (!this.mIsAsyncUpdateStateEnabled) {
            throw new RuntimeException("Triggering async state updates on this component tree is disabled, use sync state updates.");
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            this.mStateHandler.queueStateUpdate(componentKey, stateUpdate);
        }
        this.updateStateInternal(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStateInternal(boolean isAsync) {
        Component<?> root;
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            if (this.mIsMeasuring) {
                if (this.mScheduleLayoutAfterMeasure == 2) {
                    return;
                }
                this.mScheduleLayoutAfterMeasure = isAsync ? 1 : 2;
                return;
            }
            root = this.mRoot.makeShallowCopy();
        }
        this.setRootAndSizeSpecInternal(root, -1, -1, isAsync, null);
    }

    synchronized void bindEventHandler(Component component) {
        String key = component.getGlobalKey();
        if (!this.mEventHandlers.containsKey(key)) {
            return;
        }
        for (EventHandler eventHandler : this.mEventHandlers.get(key)) {
            eventHandler.mHasEventDispatcher = component;
            if (eventHandler.params == null) continue;
            eventHandler.params[0] = component.getScopedContext();
        }
    }

    synchronized void recordEventHandler(Component component, EventHandler eventHandler) {
        String key = component.getGlobalKey();
        if (!this.mEventHandlers.containsKey(key)) {
            ArrayList list = new ArrayList();
            this.mEventHandlers.put(key, list);
        }
        this.mEventHandlers.get(key).add(eventHandler);
    }

    synchronized void recordEventTrigger(String triggerKey, EventTrigger eventTrigger) {
        if (this.mEventTriggers == null) {
            this.mEventTriggers = new ArrayMap();
        }
        this.mEventTriggers.put(triggerKey, eventTrigger);
    }

    synchronized void releaseEventTrigger(String triggerKey) {
        if (this.mEventTriggers == null) {
            return;
        }
        this.mEventTriggers.remove(triggerKey);
    }

    @Nullable
    synchronized EventTrigger getEventTrigger(String triggerKey) {
        if (this.mEventTriggers == null || !this.mEventTriggers.containsKey(triggerKey)) {
            return null;
        }
        return this.mEventTriggers.get(triggerKey);
    }

    public void setSizeSpec(int widthSpec, int heightSpec) {
        this.setSizeSpec(widthSpec, heightSpec, null);
    }

    public void setSizeSpec(int widthSpec, int heightSpec, Size output) {
        this.setRootAndSizeSpecInternal(null, widthSpec, heightSpec, false, output);
    }

    public void setSizeSpecAsync(int widthSpec, int heightSpec) {
        this.setRootAndSizeSpecInternal(null, widthSpec, heightSpec, true, null);
    }

    public void setRootAndSizeSpecAsync(Component<?> root, int widthSpec, int heightSpec) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecInternal(root, widthSpec, heightSpec, true, null);
    }

    public void setRootAndSizeSpec(Component<?> root, int widthSpec, int heightSpec) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecInternal(root, widthSpec, heightSpec, false, null);
    }

    public void setRootAndSizeSpec(Component<?> root, int widthSpec, int heightSpec, Size output) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecInternal(root, widthSpec, heightSpec, false, output);
    }

    @Keep
    @Nullable
    public LithoView getLithoView() {
        ThreadUtils.assertMainThread();
        return this.mLithoView;
    }

    public synchronized StateHandler getStateHandler() {
        return StateHandler.acquireNewInstance(this.mStateHandler);
    }

    @ThreadConfined(value="UI")
    public RenderState consumePreviousRenderState() {
        RenderState previousRenderState = this.mPreviousRenderState;
        this.mPreviousRenderState = null;
        this.mPreviousRenderStateSetFromBuilder = false;
        return previousRenderState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showTooltip(LithoTooltip tooltip, String anchorGlobalKey, TooltipPosition tooltipPosition, int xOffset, int yOffset) {
        Map<String, Rect> componentKeysToBounds;
        ThreadUtils.assertMainThread();
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            componentKeysToBounds = this.mMainThreadLayoutState.getComponentKeyToBounds();
        }
        if (!componentKeysToBounds.containsKey(anchorGlobalKey)) {
            throw new IllegalArgumentException("Cannot find a component with key " + anchorGlobalKey + " to use as anchor.");
        }
        Rect anchorBounds = componentKeysToBounds.get(anchorGlobalKey);
        LithoTooltipController.showOnAnchor(tooltip, anchorBounds, (View)this.mLithoView, tooltipPosition, xOffset, yOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRootAndSizeSpecInternal(Component<?> root, int widthSpec, int heightSpec, boolean isAsync, Size output) {
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            boolean rootDidntChange;
            boolean heightSpecInitialized;
            Map<String, List<ComponentLifecycle.StateUpdate>> pendingStateUpdates = this.mStateHandler.getPendingStateUpdates();
            if (pendingStateUpdates != null && pendingStateUpdates.size() > 0 && root != null) {
                root = root.makeShallowCopyWithNewId();
            }
            boolean rootInitialized = root != null;
            boolean widthSpecInitialized = widthSpec != -1;
            boolean bl = heightSpecInitialized = heightSpec != -1;
            if (this.mHasViewMeasureSpec && !rootInitialized) {
                return;
            }
            boolean widthSpecDidntChange = !widthSpecInitialized || widthSpec == this.mWidthSpec;
            boolean heightSpecDidntChange = !heightSpecInitialized || heightSpec == this.mHeightSpec;
            boolean sizeSpecDidntChange = widthSpecDidntChange && heightSpecDidntChange;
            LayoutState mostRecentLayoutState = this.mBackgroundLayoutState != null ? this.mBackgroundLayoutState : this.mMainThreadLayoutState;
            boolean allSpecsWereInitialized = widthSpecInitialized && heightSpecInitialized && this.mWidthSpec != -1 && this.mHeightSpec != -1;
            boolean sizeSpecsAreCompatible = sizeSpecDidntChange || allSpecsWereInitialized && mostRecentLayoutState != null && LayoutState.hasCompatibleSizeSpec(this.mWidthSpec, this.mHeightSpec, widthSpec, heightSpec, mostRecentLayoutState.getWidth(), mostRecentLayoutState.getHeight());
            boolean bl2 = rootDidntChange = !rootInitialized || root.getId() == this.mRoot.getId();
            if (rootDidntChange && sizeSpecsAreCompatible) {
                if (output == null) {
                    return;
                }
                if (mostRecentLayoutState != null) {
                    output.height = mostRecentLayoutState.getHeight();
                    output.width = mostRecentLayoutState.getWidth();
                    return;
                }
            }
            if (widthSpecInitialized) {
                this.mWidthSpec = widthSpec;
            }
            if (heightSpecInitialized) {
                this.mHeightSpec = heightSpec;
            }
            if (rootInitialized) {
                this.mRoot = root;
            }
        }
        if (isAsync && output != null) {
            throw new IllegalArgumentException("The layout can't be calculated asynchronously if we need the Size back");
        }
        if (isAsync) {
            this.mLayoutThreadHandler.removeCallbacks(this.mCalculateLayoutRunnable);
            this.mLayoutThreadHandler.post(this.mCalculateLayoutRunnable);
        } else {
            this.calculateLayout(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateLayout(Size output) {
        Component<?> root;
        int heightSpec;
        int widthSpec;
        LayoutState previousLayoutState = null;
        this.mLayoutThreadHandler.removeCallbacks(this.mCalculateLayoutRunnable);
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (!this.hasSizeSpec() || this.mRoot == null) {
                return;
            }
            if (this.hasCompatibleComponentAndSpec()) {
                if (output != null) {
                    LayoutState mostRecentLayoutState = this.mBackgroundLayoutState != null ? this.mBackgroundLayoutState : this.mMainThreadLayoutState;
                    output.width = mostRecentLayoutState.getWidth();
                    output.height = mostRecentLayoutState.getHeight();
                }
                return;
            }
            widthSpec = this.mWidthSpec;
            heightSpec = this.mHeightSpec;
            root = this.mRoot.makeShallowCopy();
            if (this.mMainThreadLayoutState != null) {
                previousLayoutState = this.mMainThreadLayoutState.acquireRef();
            }
        }
        ComponentsLogger logger = this.mContext.getLogger();
        LogEvent layoutEvent = null;
        if (logger != null) {
            layoutEvent = logger.newPerformanceEvent(3);
            layoutEvent.addParam("log_tag", this.mContext.getLogTag());
            layoutEvent.addParam("tree_diff_enabled", String.valueOf(this.mIsLayoutDiffingEnabled));
            layoutEvent.addParam("is_background_layout", String.valueOf(!ThreadUtils.isMainThread()));
        }
        LayoutState localLayoutState = this.calculateLayoutState(this.mLayoutLock, this.mContext, root, widthSpec, heightSpec, this.mIsLayoutDiffingEnabled, previousLayoutState != null ? previousLayoutState.getDiffTree() : null);
        if (output != null) {
            output.width = localLayoutState.getWidth();
            output.height = localLayoutState.getHeight();
        }
        if (previousLayoutState != null) {
            previousLayoutState.releaseRef();
            previousLayoutState = null;
        }
        boolean layoutStateUpdated = false;
        ComponentTree componentTree2 = this;
        synchronized (componentTree2) {
            if (!this.hasCompatibleComponentAndSpec() && ComponentTree.isCompatibleSpec(localLayoutState, this.mWidthSpec, this.mHeightSpec)) {
                if (localLayoutState != null) {
                    StateHandler layoutStateStateHandler = localLayoutState.consumeStateHandler();
                    if (layoutStateStateHandler != null && this.mStateHandler != null) {
                        this.mStateHandler.commit(layoutStateStateHandler);
                    }
                    for (Component component : localLayoutState.getComponents()) {
                        this.bindEventHandler(component);
                    }
                    localLayoutState.clearComponents();
                }
                LayoutState tmp = this.mBackgroundLayoutState;
                this.mBackgroundLayoutState = localLayoutState;
                localLayoutState = tmp;
                layoutStateUpdated = true;
            }
        }
        if (localLayoutState != null) {
            localLayoutState.releaseRef();
            localLayoutState = null;
        }
        if (layoutStateUpdated) {
            this.postBackgroundLayoutStateUpdated();
        }
        if (this.mPreAllocateMountContentHandler != null) {
            this.mPreAllocateMountContentHandler.removeCallbacks(this.mPreAllocateMountContentRunnable);
            this.mPreAllocateMountContentHandler.post(this.mPreAllocateMountContentRunnable);
        }
        if (logger != null) {
            logger.log(layoutEvent);
        }
    }

    private void postBackgroundLayoutStateUpdated() {
        if (ThreadUtils.isMainThread()) {
            this.backgroundLayoutStateUpdated();
        } else {
            sMainThreadHandler.obtainMessage(1, (Object)this).sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        LayoutState backgroundLayoutState;
        LayoutState mainThreadLayoutState;
        if (this.mIsMounting) {
            throw new IllegalStateException("Releasing a ComponentTree that is currently being mounted");
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            sMainThreadHandler.removeMessages(1, (Object)this);
            this.mLayoutThreadHandler.removeCallbacks(this.mCalculateLayoutRunnable);
            this.mLayoutThreadHandler.removeCallbacks(this.mUpdateStateSyncRunnable);
            if (this.mPreAllocateMountContentHandler != null) {
                this.mPreAllocateMountContentHandler.removeCallbacks(this.mPreAllocateMountContentRunnable);
            }
            this.mReleased = true;
            if (this.mLithoView != null) {
                this.mLithoView.setComponentTree(null);
            }
            this.mRoot = null;
            mainThreadLayoutState = this.mMainThreadLayoutState;
            this.mMainThreadLayoutState = null;
            backgroundLayoutState = this.mBackgroundLayoutState;
            this.mBackgroundLayoutState = null;
            this.mStateHandler = null;
            if (this.mPreviousRenderState != null && !this.mPreviousRenderStateSetFromBuilder) {
                ComponentsPools.release(this.mPreviousRenderState);
            }
            this.mPreviousRenderState = null;
            this.mPreviousRenderStateSetFromBuilder = false;
        }
        if (mainThreadLayoutState != null) {
            mainThreadLayoutState.releaseRef();
            mainThreadLayoutState = null;
        }
        if (backgroundLayoutState != null) {
            backgroundLayoutState.releaseRef();
            backgroundLayoutState = null;
        }
    }

    private boolean isCompatibleComponentAndSpec(LayoutState layoutState) {
        ThreadUtils.assertHoldsLock(this);
        return this.mRoot != null && ComponentTree.isCompatibleComponentAndSpec(layoutState, this.mRoot.getId(), this.mWidthSpec, this.mHeightSpec);
    }

    private boolean hasCompatibleComponentAndSpec() {
        ThreadUtils.assertHoldsLock(this);
        return this.isCompatibleComponentAndSpec(this.mMainThreadLayoutState) || this.isCompatibleComponentAndSpec(this.mBackgroundLayoutState);
    }

    private boolean hasSizeSpec() {
        ThreadUtils.assertHoldsLock(this);
        return this.mWidthSpec != -1 && this.mHeightSpec != -1;
    }

    private static synchronized Looper getDefaultLayoutThreadLooper() {
        if (sDefaultLayoutThreadLooper == null) {
            HandlerThread defaultThread = new HandlerThread(DEFAULT_LAYOUT_THREAD_NAME, 10);
            defaultThread.start();
            sDefaultLayoutThreadLooper = defaultThread.getLooper();
        }
        return sDefaultLayoutThreadLooper;
    }

    private static boolean isCompatibleSpec(LayoutState layoutState, int widthSpec, int heightSpec) {
        return layoutState != null && layoutState.isCompatibleSpec(widthSpec, heightSpec) && layoutState.isCompatibleAccessibility();
    }

    private static boolean isCompatibleComponentAndSpec(LayoutState layoutState, int componentId, int widthSpec, int heightSpec) {
        return layoutState != null && layoutState.isCompatibleComponentAndSpec(componentId, widthSpec, heightSpec) && layoutState.isCompatibleAccessibility();
    }

    private static boolean isCompatibleComponentAndSize(LayoutState layoutState, int componentId, int width, int height) {
        return layoutState != null && layoutState.isComponentId(componentId) && layoutState.isCompatibleSize(width, height) && layoutState.isCompatibleAccessibility();
    }

    public synchronized boolean isReleased() {
        return this.mReleased;
    }

    public ComponentContext getContext() {
        return this.mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LayoutState calculateLayoutState(@Nullable Object lock, ComponentContext context, Component<?> root, int widthSpec, int heightSpec, boolean diffingEnabled, @Nullable DiffNode diffNode) {
        ComponentContext contextWithStateHandler;
        Object object = this;
        synchronized (object) {
            contextWithStateHandler = new ComponentContext((Context)context, StateHandler.acquireNewInstance(this.mStateHandler), new KeyHandler(this.mContext.getLogger()));
        }
        if (lock != null) {
            object = lock;
            synchronized (object) {
                return LayoutState.calculate(contextWithStateHandler, root, this.mId, widthSpec, heightSpec, diffingEnabled, diffNode, this.mCanPrefetchDisplayLists, this.mCanCacheDrawingDisplayLists, this.mShouldClipChildren);
            }
        }
        return LayoutState.calculate(contextWithStateHandler, root, this.mId, widthSpec, heightSpec, diffingEnabled, diffNode, this.mCanPrefetchDisplayLists, this.mCanCacheDrawingDisplayLists, this.mShouldClipChildren);
    }

    public static int generateComponentTreeId() {
        return sIdGenerator.getAndIncrement();
    }

    static {
        sSyncStateUpdatesHandler = new ThreadLocal();
        sCurrentLocation = new int[2];
        sParentLocation = new int[2];
        sParentBounds = new Rect();
    }

    public static class Builder {
        private ComponentContext context;
        private Component<?> root;
        private boolean incrementalMountEnabled = true;
        private boolean isLayoutDiffingEnabled = true;
        private LayoutHandler layoutThreadHandler;
        private LayoutHandler preAllocateMountContentHandler;
        private Object layoutLock;
        private StateHandler stateHandler;
        private RenderState previousRenderState;
        private boolean asyncStateUpdates = true;
        private int overrideComponentTreeId = -1;
        private boolean canPrefetchDisplayLists = false;
        private boolean canCacheDrawingDisplayLists = false;
        private boolean shouldClipChildren = true;
        private boolean hasMounted = false;

        protected Builder() {
        }

        protected Builder(ComponentContext context, Component<?> root) {
            this.init(context, root);
        }

        protected void init(ComponentContext context, Component<?> root) {
            this.context = context;
            this.root = root;
        }

        protected void release() {
            this.context = null;
            this.root = null;
            this.incrementalMountEnabled = true;
            this.isLayoutDiffingEnabled = true;
            this.layoutThreadHandler = null;
            this.layoutLock = null;
            this.stateHandler = null;
            this.previousRenderState = null;
            this.asyncStateUpdates = true;
            this.overrideComponentTreeId = -1;
            this.canPrefetchDisplayLists = false;
            this.canCacheDrawingDisplayLists = false;
            this.shouldClipChildren = true;
            this.hasMounted = false;
            this.preAllocateMountContentHandler = null;
        }

        public Builder incrementalMount(boolean isEnabled) {
            this.incrementalMountEnabled = isEnabled;
            return this;
        }

        public Builder layoutDiffing(boolean enabled) {
            this.isLayoutDiffingEnabled = enabled;
            return this;
        }

        public Builder layoutThreadLooper(Looper looper) {
            if (looper != null) {
                this.layoutThreadHandler = new DefaultLayoutHandler(looper);
            }
            return this;
        }

        public Builder preAllocateMountContentHandler(LayoutHandler handler) {
            this.preAllocateMountContentHandler = handler;
            return this;
        }

        public Builder layoutThreadHandler(LayoutHandler handler) {
            this.layoutThreadHandler = handler;
            return this;
        }

        public Builder layoutLock(Object layoutLock) {
            this.layoutLock = layoutLock;
            return this;
        }

        public Builder stateHandler(StateHandler stateHandler) {
            this.stateHandler = stateHandler;
            return this;
        }

        public Builder previousRenderState(RenderState previousRenderState) {
            this.previousRenderState = previousRenderState;
            return this;
        }

        public Builder asyncStateUpdates(boolean enabled) {
            this.asyncStateUpdates = enabled;
            return this;
        }

        public Builder overrideComponentTreeId(int overrideComponentTreeId) {
            this.overrideComponentTreeId = overrideComponentTreeId;
            return this;
        }

        public Builder canPrefetchDisplayLists(boolean canPrefetch) {
            this.canPrefetchDisplayLists = canPrefetch;
            return this;
        }

        public Builder canCacheDrawingDisplayLists(boolean canCacheDrawingDisplayLists) {
            this.canCacheDrawingDisplayLists = canCacheDrawingDisplayLists;
            return this;
        }

        public Builder shouldClipChildren(boolean shouldClipChildren) {
            this.shouldClipChildren = shouldClipChildren;
            return this;
        }

        public Builder hasMounted(boolean hasMounted) {
            this.hasMounted = hasMounted;
            return this;
        }

        public ComponentTree build() {
            ComponentTree componentTree = new ComponentTree(this);
            ComponentsPools.release(this);
            return componentTree;
        }
    }

    private static class DefaultLayoutHandler
    extends Handler
    implements LayoutHandler {
        private DefaultLayoutHandler(Looper threadLooper) {
            super(threadLooper);
        }
    }

    private static class ComponentMainThreadHandler
    extends Handler {
        private ComponentMainThreadHandler() {
            super(Looper.getMainLooper());
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ComponentTree that = (ComponentTree)msg.obj;
                    that.backgroundLayoutStateUpdated();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }
}

