/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.support.annotation.Nullable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.Layout;

public class ComponentSelector {
    private ComponentContext mContext;
    private ComponentLayout mLayout;
    private boolean mWillRender;

    private ComponentSelector(ComponentContext context) {
        this.mContext = context;
    }

    public static ComponentSelector create(ComponentContext context) {
        return new ComponentSelector(context);
    }

    public ComponentSelector tryToRender(@Nullable Component.Builder<?, ?> componentBuilder) {
        if (componentBuilder == null || this.mWillRender) {
            return this;
        }
        return this.tryToRender(componentBuilder.buildWithLayout());
    }

    public ComponentSelector tryToRender(@Nullable Component<?> component) {
        if (component == null || this.mWillRender) {
            return this;
        }
        return this.tryToRender(Layout.create(this.mContext, component).build());
    }

    public ComponentSelector tryToRender(@Nullable ComponentLayout.Builder layoutBuilder) {
        if (layoutBuilder == null || this.mWillRender) {
            return this;
        }
        return this.tryToRender(layoutBuilder.build());
    }

    public ComponentSelector tryToRender(@Nullable ComponentLayout layout) {
        if (this.mWillRender) {
            return this;
        }
        this.mLayout = layout;
        this.mWillRender = Component.willRender(layout);
        return this;
    }

    @Nullable
    public ComponentLayout build() {
        return this.mLayout;
    }
}

