/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.AttrRes;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.v4.util.Pools;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.Column;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLayoutAttributes;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.Diff;
import com.facebook.litho.DiffNode;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.EventTrigger;
import com.facebook.litho.EventTriggerTarget;
import com.facebook.litho.InternalNode;
import com.facebook.litho.LayoutState;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.Transition;
import com.facebook.litho.TreeProps;
import com.facebook.yoga.YogaBaselineFunction;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ComponentLifecycle
implements EventDispatcher,
EventTriggerTarget {
    private static final AtomicInteger sComponentTypeId = new AtomicInteger();
    private static final int DEFAULT_MAX_PREALLOCATION = 15;
    private final Object mPreallocationLock = new Object();
    private volatile boolean mPreallocationDone;
    private static final YogaBaselineFunction sBaselineFunction = new YogaBaselineFunction(){

        public float baseline(YogaNode cssNode, float width, float height) {
            InternalNode node = (InternalNode)cssNode.getData();
            return ((ComponentLifecycle)node.getRootComponent().getLifecycle()).onMeasureBaseline(node.getContext(), (int)width, (int)height);
        }
    };
    private static final YogaMeasureFunction sMeasureFunction = new YogaMeasureFunction(){
        private final Pools.SynchronizedPool<Size> mSizePool = new Pools.SynchronizedPool(2);

        private Size acquireSize(int initialValue) {
            Size size = (Size)this.mSizePool.acquire();
            if (size == null) {
                size = new Size();
            }
            size.width = initialValue;
            size.height = initialValue;
            return size;
        }

        private void releaseSize(Size size) {
            this.mSizePool.release((Object)size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"WrongCall"})
        public long measure(YogaNode cssNode, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
            InternalNode node = (InternalNode)cssNode.getData();
            DiffNode diffNode = node.areCachedMeasuresValid() ? node.getDiffNode() : null;
            Component component = node.getRootComponent();
            boolean isTracing = ComponentsSystrace.isTracing();
            if (isTracing) {
                ComponentsSystrace.beginSection("measure:" + component.getSimpleName());
            }
            int widthSpec = SizeSpec.makeSizeSpecFromCssSpec(width, widthMode);
            int heightSpec = SizeSpec.makeSizeSpecFromCssSpec(height, heightMode);
            node.setLastWidthSpec(widthSpec);
            node.setLastHeightSpec(heightSpec);
            int outputWidth = 0;
            int outputHeight = 0;
            if (Component.isNestedTree(component) || node.hasNestedTree()) {
                InternalNode nestedTree = LayoutState.resolveNestedTree(node, widthSpec, heightSpec);
                outputWidth = nestedTree.getWidth();
                outputHeight = nestedTree.getHeight();
            } else if (diffNode != null && diffNode.getLastWidthSpec() == widthSpec && diffNode.getLastHeightSpec() == heightSpec) {
                outputWidth = (int)diffNode.getLastMeasuredWidth();
                outputHeight = (int)diffNode.getLastMeasuredHeight();
            } else {
                Size size = this.acquireSize(Integer.MIN_VALUE);
                try {
                    ((ComponentLifecycle)component.getLifecycle()).onMeasure(node.getContext(), node, widthSpec, heightSpec, size, component);
                    if (size.width < 0 || size.height < 0) {
                        throw new IllegalStateException("MeasureOutput not set, ComponentLifecycle is: " + component.getLifecycle());
                    }
                    outputWidth = size.width;
                    outputHeight = size.height;
                    if (node.getDiffNode() != null) {
                        node.getDiffNode().setLastWidthSpec(widthSpec);
                        node.getDiffNode().setLastHeightSpec(heightSpec);
                        node.getDiffNode().setLastMeasuredWidth(outputWidth);
                        node.getDiffNode().setLastMeasuredHeight(outputHeight);
                    }
                }
                finally {
                    this.releaseSize(size);
                }
            }
            node.setLastMeasuredWidth(outputWidth);
            node.setLastMeasuredHeight(outputHeight);
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
            return YogaMeasureOutput.make((int)outputWidth, (int)outputHeight);
        }
    };
    private final int mTypeId = sComponentTypeId.incrementAndGet();

    protected ComponentLifecycle() {
    }

    int getTypeId() {
        return this.mTypeId;
    }

    @ThreadSafe(enableChecks=false)
    Object createMountContent(ComponentContext c) {
        return this.onCreateMountContent(c);
    }

    void mount(ComponentContext c, Object convertContent, Component<?> component) {
        c.enterNoStateUpdatesMethod("mount");
        this.onMount(c, convertContent, component);
        c.exitNoStateUpdatesMethod();
    }

    void bind(ComponentContext c, Object mountedContent, Component<?> component) {
        c.enterNoStateUpdatesMethod("bind");
        this.onBind(c, mountedContent, component);
        c.exitNoStateUpdatesMethod();
    }

    void unbind(ComponentContext c, Object mountedContent, Component<?> component) {
        this.onUnbind(c, mountedContent, component);
    }

    void unmount(ComponentContext c, Object mountedContent, Component<?> component) {
        this.onUnmount(c, mountedContent, component);
    }

    ComponentLayout createLayout(ComponentContext context, Component<?> component, boolean resolveNestedTree) {
        InternalNode node;
        boolean deferNestedTreeResolution = Component.isNestedTree(component) && !resolveNestedTree;
        TreeProps parentTreeProps = context.getTreeProps();
        context.setTreeProps(this.getTreePropsForChildren(context, component, parentTreeProps));
        ComponentsSystrace.beginSection("createLayout:" + component.getSimpleName());
        if (deferNestedTreeResolution) {
            node = ComponentsPools.acquireInternalNode(context);
            node.markIsNestedTreeHolder(context.getTreeProps());
        } else {
            node = Component.isLayoutSpecWithSizeSpec(component) ? (InternalNode)this.onCreateLayoutWithSizeSpec(context, context.getWidthSpec(), context.getHeightSpec(), component) : (InternalNode)this.onCreateLayout(context, component);
        }
        ComponentsSystrace.endSection();
        if (node == null) {
            return ComponentContext.NULL_LAYOUT;
        }
        ComponentLayoutAttributes layoutAttributes = component.getLayoutAttributes();
        if (layoutAttributes != null && (deferNestedTreeResolution || !Component.isLayoutSpecWithSizeSpec(component))) {
            layoutAttributes.copyInto(node);
        }
        if (node.getRootComponent() == null) {
            boolean isMountSpecWithMeasure;
            node.setBaselineFunction(sBaselineFunction);
            boolean bl = isMountSpecWithMeasure = this.canMeasure() && Component.isMountSpec(component);
            if (isMountSpecWithMeasure || deferNestedTreeResolution) {
                node.setMeasureFunction(sMeasureFunction);
            }
        }
        node.appendComponent(component);
        if (!deferNestedTreeResolution) {
            this.onPrepare(context, component);
        }
        if (context.getTreeProps() != parentTreeProps) {
            ComponentsPools.release(context.getTreeProps());
            context.setTreeProps(parentTreeProps);
        }
        return node;
    }

    void loadStyle(ComponentContext c, @AttrRes int defStyleAttr, @StyleRes int defStyleRes, Component<?> component) {
        c.setDefStyle(defStyleAttr, defStyleRes);
        this.onLoadStyle(c, component);
        c.setDefStyle(0, 0);
    }

    void loadStyle(ComponentContext c, Component<?> component) {
        this.onLoadStyle(c, component);
    }

    protected Output acquireOutput() {
        return ComponentsPools.acquireOutput();
    }

    protected void releaseOutput(Output output) {
        ComponentsPools.release(output);
    }

    protected final <T> Diff<T> acquireDiff(T previousValue, T nextValue) {
        Diff diff = ComponentsPools.acquireDiff(previousValue, nextValue);
        return diff;
    }

    protected void releaseDiff(Diff diff) {
        ComponentsPools.release(diff);
    }

    protected void populateTreeProps(Component<?> component, TreeProps parentTreeProps) {
    }

    protected TreeProps getTreePropsForChildren(ComponentContext c, Component<?> component, TreeProps previousTreeProps) {
        return previousTreeProps;
    }

    protected ComponentLayout onCreateLayout(ComponentContext c, Component<?> component) {
        return Column.create(c).build();
    }

    protected ComponentLayout onCreateLayoutWithSizeSpec(ComponentContext c, int widthSpec, int heightSpec, Component<?> component) {
        return Column.create(c).build();
    }

    protected void onPrepare(ComponentContext c, Component<?> component) {
    }

    protected void onLoadStyle(ComponentContext c, Component<?> component) {
    }

    protected void onBoundsDefined(ComponentContext c, ComponentLayout layout, Component<?> component) {
    }

    protected int onMeasureBaseline(ComponentContext c, int width, int height) {
        return height;
    }

    protected boolean canMeasure() {
        return false;
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size, Component<?> component) {
        throw new IllegalStateException("You must override onMeasure() if you return true in canMeasure(), ComponentLifecycle is: " + component.getLifecycle());
    }

    protected boolean canMountIncrementally() {
        return false;
    }

    protected boolean shouldUseDisplayList() {
        return false;
    }

    protected Object onCreateMountContent(ComponentContext context) {
        throw new RuntimeException("Trying to mount a MountSpec that doesn't implement @OnCreateMountContent");
    }

    protected void onMount(ComponentContext c, Object convertContent, Component<?> component) {
    }

    protected void onUnmount(ComponentContext c, Object mountedContent, Component<?> component) {
    }

    protected void onBind(ComponentContext c, Object mountedContent, Component<?> component) {
    }

    protected void onUnbind(ComponentContext c, Object mountedContent, Component<?> component) {
    }

    public MountType getMountType() {
        return MountType.NONE;
    }

    protected void onPopulateAccessibilityNode(AccessibilityNodeInfoCompat accessibilityNode, Component<?> component) {
    }

    protected void onPopulateExtraAccessibilityNode(AccessibilityNodeInfoCompat accessibilityNode, int extraNodeIndex, int componentBoundsX, int componentBoundsY, Component<?> component) {
    }

    protected int getExtraAccessibilityNodeAt(int x, int y, Component<?> component) {
        return Integer.MIN_VALUE;
    }

    protected int getExtraAccessibilityNodesCount(Component<?> component) {
        return 0;
    }

    protected boolean implementsExtraAccessibilityNodes() {
        return false;
    }

    protected boolean implementsAccessibility() {
        return false;
    }

    protected void transferState(ComponentContext c, StateContainer previousStateContainer, Component component) {
    }

    protected void createInitialState(ComponentContext c, Component<?> component) {
    }

    @Override
    public Object dispatchOnEvent(EventHandler eventHandler, Object eventState) {
        return null;
    }

    @Override
    @Nullable
    public Object acceptTriggerEvent(EventTrigger eventTrigger, Object eventState, Object[] params) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe(enableChecks=false)
    void preAllocateMountContent(ComponentContext context) {
        if (this.mPreallocationDone) {
            return;
        }
        if (ComponentsPools.canAddMountContentToPool((Context)context, this)) {
            ComponentsPools.release((Context)context, this, this.createMountContent(context));
        } else {
            Object object = this.mPreallocationLock;
            synchronized (object) {
                if (this.mPreallocationDone) {
                    return;
                }
                this.mPreallocationDone = true;
            }
        }
    }

    protected boolean isPureRender() {
        return false;
    }

    protected boolean callsShouldUpdateOnMount() {
        return false;
    }

    protected boolean isMountSizeDependent() {
        return false;
    }

    protected boolean canAcceptTrigger() {
        return false;
    }

    @ThreadSafe
    protected int poolSize() {
        return 15;
    }

    final boolean shouldComponentUpdate(Component previous, Component next) {
        if (this.isPureRender()) {
            return this.shouldUpdate(previous, next);
        }
        return true;
    }

    protected boolean shouldUpdate(Component previous, Component next) {
        return !previous.isEquivalentTo(next);
    }

    protected Transition onCreateTransition(ComponentContext c, Component<?> component) {
        return null;
    }

    protected static <E> EventHandler<E> newEventHandler(ComponentContext c, String name, int id2, Object[] params) {
        EventHandler eventHandler = c.newEventHandler(name, id2, params);
        if (c.getComponentTree() != null) {
            c.getComponentTree().recordEventHandler(c.getComponentScope(), eventHandler);
        }
        return eventHandler;
    }

    protected static <E> EventHandler<E> newEventHandler(Component<?> c, String name, int id2, Object[] params) {
        EventHandler eventHandler = new EventHandler(c, name, id2, params);
        if (c.getScopedContext() != null && c.getScopedContext().getComponentTree() != null) {
            c.getScopedContext().getComponentTree().recordEventHandler(c, eventHandler);
        }
        return eventHandler;
    }

    protected static <E> EventTrigger<E> newEventTrigger(ComponentContext c) {
        return c.newEventTrigger();
    }

    @Nullable
    protected static EventTrigger getEventTrigger(ComponentContext c, int methodId, String key) {
        if (c.getComponentScope() == null) {
            return null;
        }
        EventTrigger trigger = c.getComponentTree().getEventTrigger(c.getComponentScope().getGlobalKey() + key);
        if (trigger == null) {
            return null;
        }
        trigger.mId = methodId;
        return trigger;
    }

    protected boolean needsPreviousRenderData() {
        return false;
    }

    protected RenderData recordRenderData(Component component, RenderData toRecycle) {
        return null;
    }

    protected void applyPreviousRenderData(Component component, RenderData previousRenderData) {
    }

    protected boolean hasState() {
        return false;
    }

    public static interface StateUpdate {
        public void updateState(StateContainer var1, Component var2);
    }

    public static interface RenderData {
    }

    public static interface StateContainer {
    }

    public static enum MountType {
        NONE,
        DRAWABLE,
        VIEW;

    }
}

