/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.util.Log;
import android.util.SparseArray;
import android.view.ViewOutlineProvider;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.Border;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.DispatchPopulateAccessibilityEventEvent;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FocusChangedEvent;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.LongClickEvent;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.OnInitializeAccessibilityEventEvent;
import com.facebook.litho.OnInitializeAccessibilityNodeInfoEvent;
import com.facebook.litho.OnPopulateAccessibilityEventEvent;
import com.facebook.litho.OnRequestSendAccessibilityEventEvent;
import com.facebook.litho.PerformAccessibilityActionEvent;
import com.facebook.litho.SendAccessibilityEventEvent;
import com.facebook.litho.SendAccessibilityEventUncheckedEvent;
import com.facebook.litho.TouchEvent;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.reference.Reference;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaPositionType;
import java.util.ArrayList;
import java.util.List;

@ThreadConfined(value="ANY")
class ComponentLayoutAttributes {
    private static final byte PFLAG_POSITION_TYPE_IS_SET = 2;
    private static final byte PFLAG_POSITION_IS_SET = 4;
    private static final byte PFLAG_WIDTH_IS_SET = 8;
    private static final byte PFLAG_HEIGHT_IS_SET = 16;
    private static final byte PFLAG_BACKGROUND_IS_SET = 32;
    private static final byte PFLAG_TEST_KEY_IS_SET = 64;
    @Nullable
    private OtherLayoutAttributes mOtherLayoutAttributes;
    private byte mPrivateFlags;
    @Nullable
    private NodeInfo mNodeInfo;
    private YogaPositionType mPositionType;
    @Nullable
    private YogaEdgesWithInts mPositions;
    private int mWidthPx;
    private int mHeightPx;
    private Reference<? extends Drawable> mBackground;
    private String mTestKey;
    private boolean mWrapInView;

    ComponentLayoutAttributes() {
    }

    private OtherLayoutAttributes getOrCreateOtherLayoutAttributes() {
        if (this.mOtherLayoutAttributes == null) {
            this.mOtherLayoutAttributes = new OtherLayoutAttributes();
        }
        return this.mOtherLayoutAttributes;
    }

    void positionType(YogaPositionType positionType) {
        this.mPrivateFlags = (byte)(this.mPrivateFlags | 2);
        this.mPositionType = positionType;
    }

    void positionPx(YogaEdge edge, @Px int position) {
        this.mPrivateFlags = (byte)(this.mPrivateFlags | 4);
        if (this.mPositions == null) {
            this.mPositions = new YogaEdgesWithInts();
        }
        this.mPositions.add(edge, position);
    }

    void widthPx(@Px int width) {
        this.mPrivateFlags = (byte)(this.mPrivateFlags | 8);
        this.mWidthPx = width;
    }

    void heightPx(@Px int height) {
        this.mPrivateFlags = (byte)(this.mPrivateFlags | 0x10);
        this.mHeightPx = height;
    }

    void background(Reference<? extends Drawable> background) {
        this.mPrivateFlags = (byte)(this.mPrivateFlags | 0x20);
        this.mBackground = background;
    }

    void testKey(String testKey) {
        this.mPrivateFlags = (byte)(this.mPrivateFlags | 0x40);
        this.mTestKey = testKey;
    }

    void wrapInView() {
        this.mWrapInView = true;
    }

    void layoutDirection(YogaDirection direction) {
        this.getOrCreateOtherLayoutAttributes().layoutDirection(direction);
    }

    void alignSelf(YogaAlign alignSelf) {
        this.getOrCreateOtherLayoutAttributes().alignSelf(alignSelf);
    }

    void flex(float flex) {
        this.getOrCreateOtherLayoutAttributes().flex(flex);
    }

    void flexGrow(float flexGrow) {
        this.getOrCreateOtherLayoutAttributes().flexGrow(flexGrow);
    }

    void flexShrink(float flexShrink) {
        this.getOrCreateOtherLayoutAttributes().flexShrink(flexShrink);
    }

    void flexBasisPx(@Px int flexBasis) {
        this.getOrCreateOtherLayoutAttributes().flexBasisPx(flexBasis);
    }

    void flexBasisPercent(float percent) {
        this.getOrCreateOtherLayoutAttributes().flexBasisPercent(percent);
    }

    void importantForAccessibility(int importantForAccessibility) {
        this.getOrCreateOtherLayoutAttributes().importantForAccessibility(importantForAccessibility);
    }

    void duplicateParentState(boolean duplicateParentState) {
        this.getOrCreateOtherLayoutAttributes().duplicateParentState(duplicateParentState);
    }

    void marginPx(YogaEdge edge, @Px int margin) {
        this.getOrCreateOtherLayoutAttributes().marginPx(edge, margin);
    }

    void marginPercent(YogaEdge edge, float percent) {
        this.getOrCreateOtherLayoutAttributes().marginPercent(edge, percent);
    }

    void marginAuto(YogaEdge edge) {
        this.getOrCreateOtherLayoutAttributes().marginAuto(edge);
    }

    void paddingPx(YogaEdge edge, @Px int padding) {
        this.getOrCreateOtherLayoutAttributes().paddingPx(edge, padding);
    }

    void paddingPercent(YogaEdge edge, float percent) {
        this.getOrCreateOtherLayoutAttributes().paddingPercent(edge, percent);
    }

    void border(Border border) {
        this.getOrCreateOtherLayoutAttributes().border(border);
    }

    void positionPercent(YogaEdge edge, float percent) {
        this.getOrCreateOtherLayoutAttributes().positionPercent(edge, percent);
    }

    void widthPercent(float percent) {
        this.getOrCreateOtherLayoutAttributes().widthPercent(percent);
    }

    void minWidthPx(@Px int minWidth) {
        this.getOrCreateOtherLayoutAttributes().minWidthPx(minWidth);
    }

    void minWidthPercent(float percent) {
        this.getOrCreateOtherLayoutAttributes().minWidthPercent(percent);
    }

    void maxWidthPx(@Px int maxWidth) {
        this.getOrCreateOtherLayoutAttributes().maxWidthPx(maxWidth);
    }

    void maxWidthPercent(float percent) {
        this.getOrCreateOtherLayoutAttributes().maxWidthPercent(percent);
    }

    void heightPercent(float percent) {
        this.getOrCreateOtherLayoutAttributes().heightPercent(percent);
    }

    void minHeightPx(@Px int minHeight) {
        this.getOrCreateOtherLayoutAttributes().minHeightPx(minHeight);
    }

    void minHeightPercent(float percent) {
        this.getOrCreateOtherLayoutAttributes().minHeightPercent(percent);
    }

    void maxHeightPx(@Px int maxHeight) {
        this.getOrCreateOtherLayoutAttributes().maxHeightPx(maxHeight);
    }

    void maxHeightPercent(float percent) {
        this.getOrCreateOtherLayoutAttributes().maxHeightPercent(percent);
    }

    void aspectRatio(float aspectRatio) {
        this.getOrCreateOtherLayoutAttributes().aspectRatio(aspectRatio);
    }

    void touchExpansionPx(YogaEdge edge, @Px int touchExpansion) {
        this.getOrCreateOtherLayoutAttributes().touchExpansionPx(edge, touchExpansion);
    }

    void foreground(Drawable foreground) {
        this.getOrCreateOtherLayoutAttributes().foreground(foreground);
    }

    void clickHandler(EventHandler<ClickEvent> clickHandler) {
        this.getOrCreateNodeInfo().setClickHandler(clickHandler);
    }

    void longClickHandler(EventHandler<LongClickEvent> longClickHandler) {
        this.getOrCreateNodeInfo().setLongClickHandler(longClickHandler);
    }

    void focusChangeHandler(EventHandler<FocusChangedEvent> focusChangeHandler) {
        this.getOrCreateNodeInfo().setFocusChangeHandler(focusChangeHandler);
    }

    void touchHandler(EventHandler<TouchEvent> touchHandler) {
        this.getOrCreateNodeInfo().setTouchHandler(touchHandler);
    }

    void interceptTouchHandler(EventHandler<InterceptTouchEvent> interceptTouchHandler) {
        this.getOrCreateNodeInfo().setInterceptTouchHandler(interceptTouchHandler);
    }

    void focusable(boolean isFocusable) {
        this.getOrCreateNodeInfo().setFocusable(isFocusable);
    }

    void enabled(boolean isEnabled) {
        this.getOrCreateNodeInfo().setEnabled(isEnabled);
    }

    void visibleHeightRatio(float visibleHeightRatio) {
        this.getOrCreateOtherLayoutAttributes().visibleHeightRatio(visibleHeightRatio);
    }

    void visibleWidthRatio(float visibleWidthRatio) {
        this.getOrCreateOtherLayoutAttributes().visibleWidthRatio(visibleWidthRatio);
    }

    void visibleHandler(EventHandler<VisibleEvent> visibleHandler) {
        this.getOrCreateOtherLayoutAttributes().visibleHandler(visibleHandler);
    }

    void focusedHandler(EventHandler<FocusedVisibleEvent> focusedHandler) {
        this.getOrCreateOtherLayoutAttributes().focusedHandler(focusedHandler);
    }

    void unfocusedHandler(EventHandler<UnfocusedVisibleEvent> unfocusedHandler) {
        this.getOrCreateOtherLayoutAttributes().unfocusedHandler(unfocusedHandler);
    }

    void fullImpressionHandler(EventHandler<FullImpressionVisibleEvent> fullImpressionHandler) {
        this.getOrCreateOtherLayoutAttributes().fullImpressionHandler(fullImpressionHandler);
    }

    void invisibleHandler(EventHandler<InvisibleEvent> invisibleHandler) {
        this.getOrCreateOtherLayoutAttributes().invisibleHandler(invisibleHandler);
    }

    void contentDescription(CharSequence contentDescription) {
        this.getOrCreateNodeInfo().setContentDescription(contentDescription);
    }

    void viewTag(Object viewTag) {
        this.getOrCreateNodeInfo().setViewTag(viewTag);
    }

    void viewTags(SparseArray<Object> viewTags) {
        this.getOrCreateNodeInfo().setViewTags(viewTags);
    }

    void shadowElevationPx(float shadowElevation) {
        this.getOrCreateNodeInfo().setShadowElevation(shadowElevation);
    }

    void outlineProvider(ViewOutlineProvider outlineProvider) {
        this.getOrCreateNodeInfo().setOutlineProvider(outlineProvider);
    }

    void clipToOutline(boolean clipToOutline) {
        this.getOrCreateNodeInfo().setClipToOutline(clipToOutline);
    }

    void dispatchPopulateAccessibilityEventHandler(EventHandler<DispatchPopulateAccessibilityEventEvent> dispatchPopulateAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setDispatchPopulateAccessibilityEventHandler(dispatchPopulateAccessibilityEventHandler);
    }

    void onInitializeAccessibilityEventHandler(EventHandler<OnInitializeAccessibilityEventEvent> onInitializeAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setOnInitializeAccessibilityEventHandler(onInitializeAccessibilityEventHandler);
    }

    void onInitializeAccessibilityNodeInfoHandler(EventHandler<OnInitializeAccessibilityNodeInfoEvent> onInitializeAccessibilityNodeInfoHandler) {
        this.getOrCreateNodeInfo().setOnInitializeAccessibilityNodeInfoHandler(onInitializeAccessibilityNodeInfoHandler);
    }

    void onPopulateAccessibilityEventHandler(EventHandler<OnPopulateAccessibilityEventEvent> onPopulateAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setOnPopulateAccessibilityEventHandler(onPopulateAccessibilityEventHandler);
    }

    void onRequestSendAccessibilityEventHandler(EventHandler<OnRequestSendAccessibilityEventEvent> onRequestSendAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setOnRequestSendAccessibilityEventHandler(onRequestSendAccessibilityEventHandler);
    }

    void performAccessibilityActionHandler(EventHandler<PerformAccessibilityActionEvent> performAccessibilityActionHandler) {
        this.getOrCreateNodeInfo().setPerformAccessibilityActionHandler(performAccessibilityActionHandler);
    }

    void sendAccessibilityEventHandler(EventHandler<SendAccessibilityEventEvent> sendAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setSendAccessibilityEventHandler(sendAccessibilityEventHandler);
    }

    void sendAccessibilityEventUncheckedHandler(EventHandler<SendAccessibilityEventUncheckedEvent> sendAccessibilityEventUncheckedHandler) {
        this.getOrCreateNodeInfo().setSendAccessibilityEventUncheckedHandler(sendAccessibilityEventUncheckedHandler);
    }

    void scale(float scale) {
        this.getOrCreateNodeInfo().setScale(scale);
    }

    void alpha(float alpha) {
        this.getOrCreateNodeInfo().setAlpha(alpha);
    }

    void transitionKey(String key) {
        this.getOrCreateOtherLayoutAttributes().transitionKey(key);
    }

    private NodeInfo getOrCreateNodeInfo() {
        if (this.mNodeInfo == null) {
            this.mNodeInfo = NodeInfo.acquire();
        }
        return this.mNodeInfo;
    }

    void copyInto(ComponentLayout.Builder node) {
        if (this.mNodeInfo != null) {
            this.mNodeInfo.copyInto(node);
        }
        if ((long)(this.mPrivateFlags & 0x20) != 0L) {
            node.background(this.mBackground);
        }
        if ((long)(this.mPrivateFlags & 0x40) != 0L) {
            node.testKey(this.mTestKey);
        }
        if ((long)(this.mPrivateFlags & 2) != 0L) {
            node.positionType(this.mPositionType);
        }
        if ((long)(this.mPrivateFlags & 4) != 0L) {
            for (int i = 0; i < this.mPositions.mNumEntries; ++i) {
                node.positionPx(this.mPositions.mEdges[i], this.mPositions.mValues[i]);
            }
        }
        if ((long)(this.mPrivateFlags & 8) != 0L) {
            node.widthPx(this.mWidthPx);
        }
        if ((long)(this.mPrivateFlags & 0x10) != 0L) {
            node.heightPx(this.mHeightPx);
        }
        if (this.mWrapInView) {
            node.wrapInView();
        }
        if (this.mOtherLayoutAttributes != null) {
            this.mOtherLayoutAttributes.copyInto(node);
        }
    }

    private static class YogaEdgesWithFloats {
        private YogaEdge[] mEdges = new YogaEdge[2];
        private float[] mValues = new float[2];
        private int mNumEntries;
        private int mSize = 2;

        private YogaEdgesWithFloats() {
        }

        private void add(YogaEdge yogaEdge, float value) {
            if (this.mNumEntries == this.mSize) {
                this.increaseSize();
            }
            this.mEdges[this.mNumEntries] = yogaEdge;
            this.mValues[this.mNumEntries] = value;
            ++this.mNumEntries;
        }

        private void increaseSize() {
            YogaEdge[] oldEdges = this.mEdges;
            float[] oldValues = this.mValues;
            this.mSize *= 2;
            this.mEdges = new YogaEdge[this.mSize];
            this.mValues = new float[this.mSize];
            System.arraycopy(oldEdges, 0, this.mEdges, 0, this.mNumEntries);
            System.arraycopy(oldValues, 0, this.mValues, 0, this.mNumEntries);
        }
    }

    static class YogaEdgesWithInts {
        YogaEdge[] mEdges = new YogaEdge[2];
        int[] mValues = new int[2];
        int mNumEntries;
        int mSize = 2;

        YogaEdgesWithInts() {
        }

        void add(YogaEdge yogaEdge, int value) {
            if (this.mNumEntries == this.mSize) {
                this.increaseSize();
            }
            this.mEdges[this.mNumEntries] = yogaEdge;
            this.mValues[this.mNumEntries] = value;
            ++this.mNumEntries;
        }

        private void increaseSize() {
            YogaEdge[] oldEdges = this.mEdges;
            int[] oldValues = this.mValues;
            this.mSize *= 2;
            this.mEdges = new YogaEdge[this.mSize];
            this.mValues = new int[this.mSize];
            System.arraycopy(oldEdges, 0, this.mEdges, 0, this.mNumEntries);
            System.arraycopy(oldValues, 0, this.mValues, 0, this.mNumEntries);
        }
    }

    private static class OtherLayoutAttributes {
        private static final long PFLAG_LAYOUT_DIRECTION_IS_SET = 1L;
        private static final long PFLAG_ALIGN_SELF_IS_SET = 2L;
        private static final long PFLAG_FLEX_IS_SET = 4L;
        private static final long PFLAG_FLEX_GROW_IS_SET = 8L;
        private static final long PFLAG_FLEX_SHRINK_IS_SET = 16L;
        private static final long PFLAG_FLEX_BASIS_IS_SET = 32L;
        private static final long PFLAG_IMPORTANT_FOR_ACCESSIBILITY_IS_SET = 64L;
        private static final long PFLAG_DUPLICATE_PARENT_STATE_IS_SET = 128L;
        private static final long PFLAG_MARGIN_IS_SET = 256L;
        private static final long PFLAG_PADDING_IS_SET = 512L;
        private static final long PFLAG_POSITION_PERCENT_IS_SET = 1024L;
        private static final long PFLAG_MIN_WIDTH_IS_SET = 2048L;
        private static final long PFLAG_MAX_WIDTH_IS_SET = 4096L;
        private static final long PFLAG_MIN_HEIGHT_IS_SET = 8192L;
        private static final long PFLAG_MAX_HEIGHT_IS_SET = 16384L;
        private static final long PFLAG_FOREGROUND_IS_SET = 32768L;
        private static final long PFLAG_VISIBLE_HANDLER_IS_SET = 65536L;
        private static final long PFLAG_FOCUSED_HANDLER_IS_SET = 131072L;
        private static final long PFLAG_FULL_IMPRESSION_HANDLER_IS_SET = 262144L;
        private static final long PFLAG_INVISIBLE_HANDLER_IS_SET = 524288L;
        private static final long PFLAG_UNFOCUSED_HANDLER_IS_SET = 0x100000L;
        private static final long PFLAG_TOUCH_EXPANSION_IS_SET = 0x200000L;
        private static final long PFLAG_ASPECT_RATIO_IS_SET = 0x400000L;
        private static final long PFLAG_TRANSITION_KEY_IS_SET = 0x800000L;
        private static final long PFLAG_WRAP_IN_VIEW_IS_SET = 0x1000000L;
        private static final long PFLAG_VISIBLE_HEIGHT_RATIO_IS_SET = 0x2000000L;
        private static final long PFLAG_VISIBLE_WIDTH_RATIO_IS_SET = 0x4000000L;
        private static final long PFLAG_FLEX_BASIS_PERCENT_IS_SET = 0x8000000L;
        private static final long PFLAG_MARGIN_PERCENT_IS_SET = 0x10000000L;
        private static final long PFLAG_MARGIN_AUTO_IS_SET = 0x20000000L;
        private static final long PFLAG_PADDING_PERCENT_IS_SET = 0x40000000L;
        private static final long PFLAG_WIDTH_PERCENT_IS_SET = 0x80000000L;
        private static final long PFLAG_MIN_WIDTH_PERCENT_IS_SET = 0x100000000L;
        private static final long PFLAG_MAX_WIDTH_PERCENT_IS_SET = 0x200000000L;
        private static final long PFLAG_HEIGHT_PERCENT_IS_SET = 0x400000000L;
        private static final long PFLAG_MIN_HEIGHT_PERCENT_IS_SET = 0x800000000L;
        private static final long PFLAG_MAX_HEIGHT_PERCENT_IS_SET = 0x1000000000L;
        private static final long PFLAG_BORDER_IS_SET = 0x2000000000L;
        private long mPrivateFlags;
        private float mVisibleHeightRatio;
        private float mVisibleWidthRatio;
        private EventHandler<VisibleEvent> mVisibleHandler;
        private EventHandler<FocusedVisibleEvent> mFocusedHandler;
        private EventHandler<UnfocusedVisibleEvent> mUnfocusedHandler;
        private EventHandler<FullImpressionVisibleEvent> mFullImpressionHandler;
        private EventHandler<InvisibleEvent> mInvisibleHandler;
        private YogaDirection mLayoutDirection;
        private YogaAlign mAlignSelf;
        private float mFlex;
        private float mFlexGrow;
        private float mFlexShrink;
        @Px
        private int mFlexBasisPx;
        private float mFlexBasisPercent;
        private int mImportantForAccessibility;
        private boolean mDuplicateParentState;
        @Nullable
        private YogaEdgesWithInts mMargins;
        @Nullable
        private YogaEdgesWithFloats mMarginPercents;
        @Nullable
        private List<YogaEdge> mMarginAutos;
        @Nullable
        private YogaEdgesWithInts mPaddings;
        @Nullable
        private YogaEdgesWithFloats mPaddingPercents;
        @Nullable
        private YogaEdgesWithFloats mPositionPercents;
        @Nullable
        private YogaEdgesWithInts mTouchExpansions;
        @Nullable
        private float mWidthPercent;
        @Px
        private int mMinWidthPx;
        private float mMinWidthPercent;
        @Px
        private int mMaxWidthPx;
        private float mMaxWidthPercent;
        private float mHeightPercent;
        @Px
        private int mMinHeightPx;
        private float mMinHeightPercent;
        @Px
        private int mMaxHeightPx;
        private float mMaxHeightPercent;
        private float mAspectRatio;
        private Drawable mForeground;
        private String mTransitionKey;
        private Border mBorder;

        private OtherLayoutAttributes() {
        }

        private void layoutDirection(YogaDirection direction) {
            this.mPrivateFlags |= 1L;
            this.mLayoutDirection = direction;
        }

        private void alignSelf(YogaAlign alignSelf) {
            this.mPrivateFlags |= 2L;
            this.mAlignSelf = alignSelf;
        }

        private void flex(float flex) {
            this.mPrivateFlags |= 4L;
            this.mFlex = flex;
        }

        private void flexGrow(float flexGrow) {
            this.mPrivateFlags |= 8L;
            this.mFlexGrow = flexGrow;
        }

        private void flexShrink(float flexShrink) {
            this.mPrivateFlags |= 0x10L;
            this.mFlexShrink = flexShrink;
        }

        private void flexBasisPx(@Px int flexBasis) {
            this.mPrivateFlags |= 0x20L;
            this.mFlexBasisPx = flexBasis;
        }

        private void flexBasisPercent(float percent) {
            this.mPrivateFlags |= 0x8000000L;
            this.mFlexBasisPercent = percent;
        }

        private void importantForAccessibility(int importantForAccessibility) {
            this.mPrivateFlags |= 0x40L;
            this.mImportantForAccessibility = importantForAccessibility;
        }

        private void duplicateParentState(boolean duplicateParentState) {
            this.mPrivateFlags |= 0x80L;
            this.mDuplicateParentState = duplicateParentState;
        }

        private void marginPx(YogaEdge edge, @Px int margin) {
            this.mPrivateFlags |= 0x100L;
            if (this.mMargins == null) {
                this.mMargins = new YogaEdgesWithInts();
            }
            this.mMargins.add(edge, margin);
        }

        private void marginPercent(YogaEdge edge, float percent) {
            this.mPrivateFlags |= 0x10000000L;
            if (this.mMarginPercents == null) {
                this.mMarginPercents = new YogaEdgesWithFloats();
            }
            this.mMarginPercents.add(edge, percent);
        }

        private void marginAuto(YogaEdge edge) {
            this.mPrivateFlags |= 0x20000000L;
            if (this.mMarginAutos == null) {
                this.mMarginAutos = new ArrayList<YogaEdge>(2);
            }
            this.mMarginAutos.add(edge);
        }

        private void paddingPx(YogaEdge edge, @Px int padding) {
            this.mPrivateFlags |= 0x200L;
            if (this.mPaddings == null) {
                this.mPaddings = new YogaEdgesWithInts();
            }
            this.mPaddings.add(edge, padding);
        }

        private void paddingPercent(YogaEdge edge, float percent) {
            this.mPrivateFlags |= 0x40000000L;
            if (this.mPaddingPercents == null) {
                this.mPaddingPercents = new YogaEdgesWithFloats();
            }
            this.mPaddingPercents.add(edge, percent);
        }

        private void border(Border border) {
            this.mPrivateFlags |= 0x2000000000L;
            this.mBorder = border;
        }

        private void positionPercent(YogaEdge edge, float percent) {
            this.mPrivateFlags |= 0x400L;
            if (this.mPositionPercents == null) {
                this.mPositionPercents = new YogaEdgesWithFloats();
            }
            this.mPositionPercents.add(edge, percent);
        }

        private void widthPercent(float percent) {
            this.mPrivateFlags |= 0x80000000L;
            this.mWidthPercent = percent;
        }

        private void minWidthPx(@Px int minWidth) {
            this.mPrivateFlags |= 0x800L;
            this.mMinWidthPx = minWidth;
        }

        private void minWidthPercent(float percent) {
            this.mPrivateFlags |= 0x100000000L;
            this.mMinWidthPercent = percent;
        }

        private void maxWidthPx(@Px int maxWidth) {
            this.mPrivateFlags |= 0x1000L;
            this.mMaxWidthPx = maxWidth;
        }

        private void maxWidthPercent(float percent) {
            this.mPrivateFlags |= 0x200000000L;
            this.mMaxWidthPercent = percent;
        }

        private void heightPercent(float percent) {
            this.mPrivateFlags |= 0x400000000L;
            this.mHeightPercent = percent;
        }

        private void minHeightPx(@Px int minHeight) {
            this.mPrivateFlags |= 0x2000L;
            this.mMinHeightPx = minHeight;
        }

        private void minHeightPercent(float percent) {
            this.mPrivateFlags |= 0x800000000L;
            this.mMinHeightPercent = percent;
        }

        private void maxHeightPx(@Px int maxHeight) {
            this.mPrivateFlags |= 0x4000L;
            this.mMaxHeightPx = maxHeight;
        }

        private void maxHeightPercent(float percent) {
            this.mPrivateFlags |= 0x1000000000L;
            this.mMaxHeightPercent = percent;
        }

        private void aspectRatio(float aspectRatio) {
            this.mPrivateFlags |= 0x400000L;
            this.mAspectRatio = aspectRatio;
        }

        private void touchExpansionPx(YogaEdge edge, @Px int touchExpansion) {
            this.mPrivateFlags |= 0x200000L;
            if (this.mTouchExpansions == null) {
                this.mTouchExpansions = new YogaEdgesWithInts();
            }
            this.mTouchExpansions.add(edge, touchExpansion);
        }

        private void foreground(Drawable foreground) {
            this.mPrivateFlags |= 0x8000L;
            this.mForeground = foreground;
        }

        private void visibleHeightRatio(float visibleHeightRatio) {
            this.mPrivateFlags |= 0x2000000L;
            this.mVisibleHeightRatio = visibleHeightRatio;
        }

        private void visibleWidthRatio(float visibleWidthRatio) {
            this.mPrivateFlags |= 0x4000000L;
            this.mVisibleWidthRatio = visibleWidthRatio;
        }

        private void visibleHandler(EventHandler<VisibleEvent> visibleHandler) {
            this.mPrivateFlags |= 0x10000L;
            this.mVisibleHandler = visibleHandler;
        }

        private void focusedHandler(EventHandler<FocusedVisibleEvent> focusedHandler) {
            this.mPrivateFlags |= 0x20000L;
            this.mFocusedHandler = focusedHandler;
        }

        private void unfocusedHandler(EventHandler<UnfocusedVisibleEvent> unfocusedHandler) {
            this.mPrivateFlags |= 0x100000L;
            this.mUnfocusedHandler = unfocusedHandler;
        }

        private void fullImpressionHandler(EventHandler<FullImpressionVisibleEvent> fullImpressionHandler) {
            this.mPrivateFlags |= 0x40000L;
            this.mFullImpressionHandler = fullImpressionHandler;
        }

        private void invisibleHandler(EventHandler<InvisibleEvent> invisibleHandler) {
            this.mPrivateFlags |= 0x80000L;
            this.mInvisibleHandler = invisibleHandler;
        }

        private void transitionKey(String key) {
            this.mPrivateFlags |= 0x800000L;
            this.mTransitionKey = key;
        }

        void copyInto(ComponentLayout.Builder node) {
            int i;
            Log.e((String)"BOOM", (String)("mPrivateFlags is: " + Long.toHexString(this.mPrivateFlags)));
            if ((this.mPrivateFlags & 1L) != 0L) {
                node.layoutDirection(this.mLayoutDirection);
            }
            if ((this.mPrivateFlags & 0x40L) != 0L) {
                node.importantForAccessibility(this.mImportantForAccessibility);
            }
            if ((this.mPrivateFlags & 0x80L) != 0L) {
                node.duplicateParentState(this.mDuplicateParentState);
            }
            if ((this.mPrivateFlags & 0x8000L) != 0L) {
                node.foreground(this.mForeground);
            }
            if ((this.mPrivateFlags & 0x1000000L) != 0L) {
                node.wrapInView();
            }
            if ((this.mPrivateFlags & 0x10000L) != 0L) {
                node.visibleHandler(this.mVisibleHandler);
            }
            if ((this.mPrivateFlags & 0x20000L) != 0L) {
                node.focusedHandler(this.mFocusedHandler);
            }
            if ((this.mPrivateFlags & 0x40000L) != 0L) {
                node.fullImpressionHandler(this.mFullImpressionHandler);
            }
            if ((this.mPrivateFlags & 0x80000L) != 0L) {
                node.invisibleHandler(this.mInvisibleHandler);
            }
            if ((this.mPrivateFlags & 0x100000L) != 0L) {
                node.unfocusedHandler(this.mUnfocusedHandler);
            }
            if ((this.mPrivateFlags & 0x800000L) != 0L) {
                node.transitionKey(this.mTransitionKey);
            }
            if ((this.mPrivateFlags & 0x2000000L) != 0L) {
                node.visibleHeightRatio(this.mVisibleHeightRatio);
            }
            if ((this.mPrivateFlags & 0x4000000L) != 0L) {
                node.visibleWidthRatio(this.mVisibleWidthRatio);
            }
            if ((this.mPrivateFlags & 2L) != 0L) {
                node.alignSelf(this.mAlignSelf);
            }
            if ((this.mPrivateFlags & 0x400L) != 0L) {
                for (i = 0; i < this.mPositionPercents.mNumEntries; ++i) {
                    node.positionPercent(this.mPositionPercents.mEdges[i], this.mPositionPercents.mValues[i]);
                }
            }
            if ((this.mPrivateFlags & 4L) != 0L) {
                node.flex(this.mFlex);
            }
            if ((this.mPrivateFlags & 8L) != 0L) {
                node.flexGrow(this.mFlexGrow);
            }
            if ((this.mPrivateFlags & 0x10L) != 0L) {
                node.flexShrink(this.mFlexShrink);
            }
            if ((this.mPrivateFlags & 0x20L) != 0L) {
                node.flexBasisPx(this.mFlexBasisPx);
            }
            if ((this.mPrivateFlags & 0x8000000L) != 0L) {
                node.flexBasisPercent(this.mFlexBasisPercent);
            }
            if ((this.mPrivateFlags & 0x80000000L) != 0L) {
                node.widthPercent(this.mWidthPercent);
            }
            if ((this.mPrivateFlags & 0x800L) != 0L) {
                node.minWidthPx(this.mMinWidthPx);
            }
            if ((this.mPrivateFlags & 0x100000000L) != 0L) {
                node.minWidthPercent(this.mMinWidthPercent);
            }
            if ((this.mPrivateFlags & 0x1000L) != 0L) {
                node.maxWidthPx(this.mMaxWidthPx);
            }
            if ((this.mPrivateFlags & 0x200000000L) != 0L) {
                node.maxWidthPercent(this.mMaxWidthPercent);
            }
            if ((this.mPrivateFlags & 0x400000000L) != 0L) {
                node.heightPercent(this.mHeightPercent);
            }
            if ((this.mPrivateFlags & 0x2000L) != 0L) {
                node.minHeightPx(this.mMinHeightPx);
            }
            if ((this.mPrivateFlags & 0x800000000L) != 0L) {
                node.minHeightPercent(this.mMinHeightPercent);
            }
            if ((this.mPrivateFlags & 0x4000L) != 0L) {
                node.maxHeightPx(this.mMaxHeightPx);
            }
            if ((this.mPrivateFlags & 0x1000000000L) != 0L) {
                node.maxHeightPercent(this.mMaxHeightPercent);
            }
            if ((this.mPrivateFlags & 0x400000L) != 0L) {
                node.aspectRatio(this.mAspectRatio);
            }
            if ((this.mPrivateFlags & 0x100L) != 0L) {
                for (i = 0; i < this.mMargins.mNumEntries; ++i) {
                    node.marginPx(this.mMargins.mEdges[i], this.mMargins.mValues[i]);
                }
            }
            if ((this.mPrivateFlags & 0x10000000L) != 0L) {
                for (i = 0; i < this.mMarginPercents.mNumEntries; ++i) {
                    node.marginPercent(this.mMarginPercents.mEdges[i], this.mMarginPercents.mValues[i]);
                }
            }
            if ((this.mPrivateFlags & 0x20000000L) != 0L) {
                for (YogaEdge edge : this.mMarginAutos) {
                    node.marginAuto(edge);
                }
            }
            if ((this.mPrivateFlags & 0x200L) != 0L) {
                for (int i2 = 0; i2 < this.mPaddings.mNumEntries; ++i2) {
                    node.paddingPx(this.mPaddings.mEdges[i2], this.mPaddings.mValues[i2]);
                }
            }
            if ((this.mPrivateFlags & 0x40000000L) != 0L) {
                for (int i3 = 0; i3 < this.mPaddingPercents.mNumEntries; ++i3) {
                    node.paddingPercent(this.mPaddingPercents.mEdges[i3], this.mPaddingPercents.mValues[i3]);
                }
            }
            if ((this.mPrivateFlags & 0x200000L) != 0L) {
                for (int i4 = 0; i4 < this.mTouchExpansions.mNumEntries; ++i4) {
                    node.touchExpansionPx(this.mTouchExpansions.mEdges[i4], this.mTouchExpansions.mValues[i4]);
                }
            }
            if ((this.mPrivateFlags & 0x2000000000L) != 0L) {
                node.border(this.mBorder);
            }
        }
    }
}

