/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.util.SparseArrayCompat;
import android.view.View;
import com.facebook.litho.ImageContent;
import com.facebook.litho.MountItem;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.TextContent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ComponentHostUtils {
    ComponentHostUtils() {
    }

    static <T> void moveItem(int oldIndex, int newIndex, SparseArrayCompat<T> items, SparseArrayCompat<T> scrapItems) {
        Object itemToMove;
        if (ComponentHostUtils.existsScrapItemAt(oldIndex, scrapItems)) {
            itemToMove = scrapItems.get(oldIndex);
            scrapItems.remove(oldIndex);
        } else {
            itemToMove = items.get(oldIndex);
            items.remove(oldIndex);
        }
        items.put(newIndex, itemToMove);
    }

    static <T> void scrapItemAt(int index, SparseArrayCompat<T> items, SparseArrayCompat<T> scrapItems) {
        Object value = items.get(index);
        if (value != null) {
            scrapItems.put(index, value);
        }
    }

    static <T> boolean existsScrapItemAt(int index, SparseArrayCompat<T> scrapItems) {
        return scrapItems != null && scrapItems.get(index) != null;
    }

    static void maybeSetDrawableState(View view, Drawable drawable, int flags, NodeInfo nodeInfo) {
        boolean shouldSetState;
        boolean bl = shouldSetState = nodeInfo != null && nodeInfo.hasTouchEventHandlers() || MountItem.isDuplicateParentState(flags);
        if (shouldSetState && drawable.isStateful()) {
            drawable.setState(view.getDrawableState());
        }
    }

    static <T> void removeItem(int index, SparseArrayCompat<T> items, SparseArrayCompat<T> scrapItems) {
        if (ComponentHostUtils.existsScrapItemAt(index, scrapItems)) {
            scrapItems.remove(index);
        } else {
            items.remove(index);
        }
    }

    static void mountDrawable(View view, Drawable drawable, Rect bounds, int flags, NodeInfo nodeInfo) {
        drawable.setVisible(view.getVisibility() == 0, false);
        drawable.setCallback((Drawable.Callback)view);
        ComponentHostUtils.maybeSetDrawableState(view, drawable, flags, nodeInfo);
        view.invalidate(bounds);
    }

    static List<?> extractContent(SparseArrayCompat<MountItem> items) {
        int size = items.size();
        if (size == 1) {
            return Collections.singletonList(((MountItem)items.valueAt(0)).getContent());
        }
        ArrayList<Object> content = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            content.add(((MountItem)items.valueAt(i)).getContent());
        }
        return content;
    }

    static TextContent extractTextContent(List<?> items) {
        int size = items.size();
        if (size == 1) {
            Object item = items.get(0);
            return item instanceof TextContent ? (TextContent)item : TextContent.EMPTY;
        }
        final ArrayList<CharSequence> textContent = new ArrayList<CharSequence>();
        for (int i = 0; i < size; ++i) {
            Object item = items.get(i);
            if (!(item instanceof TextContent)) continue;
            textContent.addAll(((TextContent)item).getTextItems());
        }
        return new TextContent(){

            @Override
            public List<CharSequence> getTextItems() {
                return textContent;
            }
        };
    }

    static ImageContent extractImageContent(List<?> items) {
        int size = items.size();
        if (size == 1) {
            Object item = items.get(0);
            return item instanceof ImageContent ? (ImageContent)item : ImageContent.EMPTY;
        }
        final ArrayList<Drawable> imageContent = new ArrayList<Drawable>();
        for (int i = 0; i < size; ++i) {
            Object item = items.get(i);
            if (!(item instanceof ImageContent)) continue;
            imageContent.addAll(((ImageContent)item).getImageItems());
        }
        return new ImageContent(){

            @Override
            public List<Drawable> getImageItems() {
                return imageContent;
            }
        };
    }

    static void maybeInvalidateAccessibilityState(MountItem mountItem) {
        if (mountItem.isAccessible()) {
            mountItem.getHost().invalidateAccessibilityState();
        }
    }
}

