/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.util.SparseArrayCompat;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.litho.AccessibilityUtils;
import com.facebook.litho.ComponentAccessibilityDelegate;
import com.facebook.litho.ComponentClickListener;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentFocusChangeListener;
import com.facebook.litho.ComponentHostUtils;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentLongClickListener;
import com.facebook.litho.ComponentTouchListener;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.DebugDraw;
import com.facebook.litho.DisplayListDrawable;
import com.facebook.litho.EventDispatcherUtils;
import com.facebook.litho.EventHandler;
import com.facebook.litho.ImageContent;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.MountItem;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.R;
import com.facebook.litho.TextContent;
import com.facebook.litho.TouchExpansionDelegate;
import com.facebook.litho.Touchable;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.proguard.annotations.DoNotStrip;
import java.util.ArrayList;
import java.util.List;

@DoNotStrip
public class ComponentHost
extends ViewGroup {
    private final SparseArrayCompat<MountItem> mMountItems = new SparseArrayCompat();
    private SparseArrayCompat<MountItem> mScrapMountItemsArray;
    private final SparseArrayCompat<MountItem> mViewMountItems = new SparseArrayCompat();
    private SparseArrayCompat<MountItem> mScrapViewMountItemsArray;
    private final SparseArrayCompat<MountItem> mDrawableMountItems = new SparseArrayCompat();
    private SparseArrayCompat<MountItem> mScrapDrawableMountItems;
    private final SparseArrayCompat<Touchable> mTouchables = new SparseArrayCompat();
    private SparseArrayCompat<Touchable> mScrapTouchables;
    private final ArrayList<MountItem> mDisappearingItems = new ArrayList();
    private CharSequence mContentDescription;
    private Object mViewTag;
    private SparseArray<Object> mViewTags;
    private boolean mWasInvalidatedWhileSuppressed;
    private boolean mWasInvalidatedForAccessibilityWhileSuppressed;
    private boolean mSuppressInvalidations;
    private final InterleavedDispatchDraw mDispatchDraw = new InterleavedDispatchDraw();
    private final List<ComponentHost> mScrapHosts = new ArrayList<ComponentHost>(3);
    private int[] mChildDrawingOrder = new int[0];
    private boolean mIsChildDrawingOrderDirty;
    private long mParentHostMarker;
    private boolean mInLayout;
    private final ComponentAccessibilityDelegate mComponentAccessibilityDelegate;
    private boolean mIsComponentAccessibilityDelegateSet = false;
    private ComponentClickListener mOnClickListener;
    private ComponentLongClickListener mOnLongClickListener;
    private ComponentFocusChangeListener mOnFocusChangeListener;
    private ComponentTouchListener mOnTouchListener;
    private EventHandler<InterceptTouchEvent> mOnInterceptTouchEventHandler;
    private TouchExpansionDelegate mTouchExpansionDelegate;

    public ComponentHost(Context context) {
        this(context, null);
    }

    public ComponentHost(Context context, AttributeSet attrs) {
        this(new ComponentContext(context), attrs);
    }

    public ComponentHost(ComponentContext context) {
        this(context, null);
    }

    public ComponentHost(ComponentContext context, AttributeSet attrs) {
        super((Context)context, attrs);
        this.setWillNotDraw(false);
        this.setChildrenDrawingOrderEnabled(true);
        this.mComponentAccessibilityDelegate = new ComponentAccessibilityDelegate((View)this);
        this.refreshAccessibilityDelegatesIfNeeded(AccessibilityUtils.isAccessibilityEnabled((Context)context));
    }

    void setParentHostMarker(long parentHostMarker) {
        this.mParentHostMarker = parentHostMarker;
    }

    long getParentHostMarker() {
        return this.mParentHostMarker;
    }

    public void mount(int index, MountItem mountItem, Rect bounds) {
        Object content = mountItem.getContent();
        if (content instanceof Drawable) {
            this.mountDrawable(index, mountItem, bounds);
        } else if (content instanceof View) {
            this.mViewMountItems.put(index, (Object)mountItem);
            this.mountView((View)content, mountItem.getFlags());
            this.maybeRegisterTouchExpansion(index, mountItem);
        }
        this.mMountItems.put(index, (Object)mountItem);
        ComponentHostUtils.maybeInvalidateAccessibilityState(mountItem);
    }

    void unmount(MountItem item) {
        int index = this.mMountItems.keyAt(this.mMountItems.indexOfValue((Object)item));
        this.unmount(index, item);
    }

    public void unmount(int index, MountItem mountItem) {
        Object content = mountItem.getContent();
        if (content instanceof Drawable) {
            this.unmountDrawable(index, mountItem);
        } else if (content instanceof View) {
            this.unmountView((View)content);
            ComponentHostUtils.removeItem(index, this.mViewMountItems, this.mScrapViewMountItemsArray);
            this.mIsChildDrawingOrderDirty = true;
            this.maybeUnregisterTouchExpansion(index, mountItem);
        }
        ComponentHostUtils.removeItem(index, this.mMountItems, this.mScrapMountItemsArray);
        this.releaseScrapDataStructuresIfNeeded();
        ComponentHostUtils.maybeInvalidateAccessibilityState(mountItem);
    }

    void startUnmountDisappearingItem(int index, MountItem mountItem) {
        Object content = mountItem.getContent();
        if (!(content instanceof View)) {
            throw new RuntimeException("Cannot unmount non-view item");
        }
        this.mIsChildDrawingOrderDirty = true;
        this.maybeUnregisterTouchExpansion(index, mountItem);
        ComponentHostUtils.removeItem(index, this.mViewMountItems, this.mScrapViewMountItemsArray);
        ComponentHostUtils.removeItem(index, this.mMountItems, this.mScrapMountItemsArray);
        this.releaseScrapDataStructuresIfNeeded();
        this.mDisappearingItems.add(mountItem);
    }

    void unmountDisappearingItem(MountItem disappearingItem) {
        if (!this.mDisappearingItems.remove(disappearingItem)) {
            String key = disappearingItem.getViewNodeInfo() != null ? disappearingItem.getViewNodeInfo().getTransitionKey() : null;
            throw new RuntimeException("Tried to remove non-existent disappearing item, transitionKey: " + key);
        }
        View content = (View)disappearingItem.getContent();
        this.unmountView(content);
        ComponentHostUtils.maybeInvalidateAccessibilityState(disappearingItem);
    }

    boolean hasDisappearingItems() {
        return this.mDisappearingItems.size() > 0;
    }

    List<String> getDisappearingItemKeys() {
        if (!this.hasDisappearingItems()) {
            return null;
        }
        ArrayList<String> keys = new ArrayList<String>();
        int size = this.mDisappearingItems.size();
        for (int i = 0; i < size; ++i) {
            keys.add(this.mDisappearingItems.get(i).getViewNodeInfo().getTransitionKey());
        }
        return keys;
    }

    private void maybeMoveTouchExpansionIndexes(MountItem item, int oldIndex, int newIndex) {
        ViewNodeInfo viewNodeInfo = item.getViewNodeInfo();
        if (viewNodeInfo == null) {
            return;
        }
        Rect expandedTouchBounds = viewNodeInfo.getExpandedTouchBounds();
        if (expandedTouchBounds == null || this.mTouchExpansionDelegate == null) {
            return;
        }
        this.mTouchExpansionDelegate.moveTouchExpansionIndexes(oldIndex, newIndex);
    }

    void maybeRegisterTouchExpansion(int index, MountItem mountItem) {
        ViewNodeInfo viewNodeInfo = mountItem.getViewNodeInfo();
        if (viewNodeInfo == null) {
            return;
        }
        Rect expandedTouchBounds = viewNodeInfo.getExpandedTouchBounds();
        if (expandedTouchBounds == null) {
            return;
        }
        if (this.mTouchExpansionDelegate == null) {
            this.mTouchExpansionDelegate = new TouchExpansionDelegate(this);
            this.setTouchDelegate(this.mTouchExpansionDelegate);
        }
        this.mTouchExpansionDelegate.registerTouchExpansion(index, (View)mountItem.getContent(), expandedTouchBounds);
    }

    void maybeUnregisterTouchExpansion(int index, MountItem mountItem) {
        ViewNodeInfo viewNodeInfo = mountItem.getViewNodeInfo();
        if (viewNodeInfo == null) {
            return;
        }
        if (this.mTouchExpansionDelegate == null || viewNodeInfo.getExpandedTouchBounds() == null) {
            return;
        }
        this.mTouchExpansionDelegate.unregisterTouchExpansion(index);
    }

    ComponentHost recycleHost() {
        if (this.mScrapHosts.size() > 0) {
            ComponentHost host = this.mScrapHosts.remove(0);
            if (Build.VERSION.SDK_INT < 17) {
                this.bringChildToFront((View)host);
            }
            this.mIsChildDrawingOrderDirty = true;
            return host;
        }
        return null;
    }

    int getMountItemCount() {
        return this.mMountItems.size();
    }

    MountItem getMountItemAt(int index) {
        return (MountItem)this.mMountItems.valueAt(index);
    }

    MountItem getAccessibleMountItem() {
        for (int i = 0; i < this.getMountItemCount(); ++i) {
            MountItem item = this.getMountItemAt(i);
            if (!item.isAccessible()) continue;
            return item;
        }
        return null;
    }

    public List<Drawable> getDrawables() {
        ArrayList<Drawable> drawables = new ArrayList<Drawable>(this.mDrawableMountItems.size());
        int size = this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            Drawable drawable = (Drawable)((MountItem)this.mDrawableMountItems.valueAt(i)).getContent();
            drawables.add(drawable);
        }
        return drawables;
    }

    @DoNotStrip
    public TextContent getTextContent() {
        return ComponentHostUtils.extractTextContent(ComponentHostUtils.extractContent(this.mMountItems));
    }

    public ImageContent getImageContent() {
        return ComponentHostUtils.extractImageContent(ComponentHostUtils.extractContent(this.mMountItems));
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public void setContentDescription(CharSequence contentDescription) {
        this.mContentDescription = contentDescription;
        this.invalidateAccessibilityState();
    }

    public void setImportantForAccessibility(int mode) {
        if (mode != ViewCompat.getImportantForAccessibility((View)this)) {
            super.setImportantForAccessibility(mode);
        }
    }

    public void setTag(int key, Object tag) {
        super.setTag(key, tag);
        if (key == R.id.component_node_info && tag != null) {
            this.mComponentAccessibilityDelegate.setNodeInfo((NodeInfo)tag);
            this.refreshAccessibilityDelegatesIfNeeded(AccessibilityUtils.isAccessibilityEnabled(this.getContext()));
        }
    }

    void moveItem(MountItem item, int oldIndex, int newIndex) {
        if (item == null && this.mScrapMountItemsArray != null) {
            item = (MountItem)this.mScrapMountItemsArray.get(oldIndex);
        }
        if (item == null) {
            return;
        }
        this.maybeMoveTouchExpansionIndexes(item, oldIndex, newIndex);
        Object content = item.getContent();
        if (content instanceof Drawable) {
            this.moveDrawableItem(item, oldIndex, newIndex);
        } else if (content instanceof View) {
            this.mIsChildDrawingOrderDirty = true;
            ComponentHost.startTemporaryDetach((View)content);
            if (this.mViewMountItems.get(newIndex) != null) {
                this.ensureScrapViewMountItemsArray();
                ComponentHostUtils.scrapItemAt(newIndex, this.mViewMountItems, this.mScrapViewMountItemsArray);
            }
            ComponentHostUtils.moveItem(oldIndex, newIndex, this.mViewMountItems, this.mScrapViewMountItemsArray);
        }
        if (this.mMountItems.get(newIndex) != null) {
            this.ensureScrapMountItemsArray();
            ComponentHostUtils.scrapItemAt(newIndex, this.mMountItems, this.mScrapMountItemsArray);
        }
        ComponentHostUtils.moveItem(oldIndex, newIndex, this.mMountItems, this.mScrapMountItemsArray);
        this.releaseScrapDataStructuresIfNeeded();
        if (content instanceof View) {
            ComponentHost.finishTemporaryDetach((View)content);
        }
    }

    public void setViewTag(Object viewTag) {
        this.mViewTag = viewTag;
    }

    public void setViewTags(SparseArray<Object> viewTags) {
        this.mViewTags = viewTags;
    }

    void setComponentClickListener(ComponentClickListener listener) {
        this.mOnClickListener = listener;
        this.setOnClickListener(listener);
    }

    ComponentClickListener getComponentClickListener() {
        return this.mOnClickListener;
    }

    void setComponentLongClickListener(ComponentLongClickListener listener) {
        this.mOnLongClickListener = listener;
        this.setOnLongClickListener(listener);
    }

    ComponentLongClickListener getComponentLongClickListener() {
        return this.mOnLongClickListener;
    }

    void setComponentFocusChangeListener(ComponentFocusChangeListener listener) {
        this.mOnFocusChangeListener = listener;
        this.setOnFocusChangeListener(listener);
    }

    ComponentFocusChangeListener getComponentFocusChangeListener() {
        return this.mOnFocusChangeListener;
    }

    void setComponentTouchListener(ComponentTouchListener listener) {
        this.mOnTouchListener = listener;
        this.setOnTouchListener(listener);
    }

    void setInterceptTouchEventHandler(EventHandler<InterceptTouchEvent> interceptTouchEventHandler) {
        this.mOnInterceptTouchEventHandler = interceptTouchEventHandler;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mOnInterceptTouchEventHandler != null) {
            return EventDispatcherUtils.dispatchOnInterceptTouch(this.mOnInterceptTouchEventHandler, ev);
        }
        return super.onInterceptTouchEvent(ev);
    }

    public ComponentTouchListener getComponentTouchListener() {
        return this.mOnTouchListener;
    }

    void suppressInvalidations(boolean suppressInvalidations) {
        if (this.mSuppressInvalidations == suppressInvalidations) {
            return;
        }
        this.mSuppressInvalidations = suppressInvalidations;
        if (!this.mSuppressInvalidations) {
            if (this.mWasInvalidatedWhileSuppressed) {
                this.invalidate();
                this.mWasInvalidatedWhileSuppressed = false;
            }
            if (this.mWasInvalidatedForAccessibilityWhileSuppressed) {
                this.invalidateAccessibilityState();
                this.mWasInvalidatedForAccessibilityWhileSuppressed = false;
            }
        }
    }

    void invalidateAccessibilityState() {
        if (!this.mIsComponentAccessibilityDelegateSet) {
            return;
        }
        if (this.mSuppressInvalidations) {
            this.mWasInvalidatedForAccessibilityWhileSuppressed = true;
            return;
        }
        if (this.mComponentAccessibilityDelegate != null && this.implementsVirtualViews()) {
            this.mComponentAccessibilityDelegate.invalidateRoot();
        }
    }

    public boolean dispatchHoverEvent(MotionEvent event) {
        return this.mComponentAccessibilityDelegate != null && this.implementsVirtualViews() && this.mComponentAccessibilityDelegate.dispatchHoverEvent(event) || super.dispatchHoverEvent(event);
    }

    private boolean implementsVirtualViews() {
        MountItem item = this.getAccessibleMountItem();
        return item != null && ((ComponentLifecycle)item.getComponent().getLifecycle()).implementsExtraAccessibilityNodes();
    }

    public List<CharSequence> getContentDescriptions() {
        ArrayList<CharSequence> contentDescriptions = new ArrayList<CharSequence>();
        int size = this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            CharSequence contentDescription;
            NodeInfo nodeInfo = ((MountItem)this.mDrawableMountItems.valueAt(i)).getNodeInfo();
            if (nodeInfo == null || (contentDescription = nodeInfo.getContentDescription()) == null) continue;
            contentDescriptions.add(contentDescription);
        }
        CharSequence hostContentDescription = this.getContentDescription();
        if (hostContentDescription != null) {
            contentDescriptions.add(hostContentDescription);
        }
        return contentDescriptions;
    }

    private void mountView(View view, int flags) {
        view.setDuplicateParentStateEnabled(MountItem.isDuplicateParentState(flags));
        this.mIsChildDrawingOrderDirty = true;
        if (view instanceof ComponentHost && view.getParent() == this) {
            ComponentHost.finishTemporaryDetach(view);
            view.setVisibility(0);
            return;
        }
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp == null) {
            lp = this.generateDefaultLayoutParams();
            view.setLayoutParams(lp);
        }
        if (this.mInLayout) {
            super.addViewInLayout(view, -1, view.getLayoutParams(), true);
        } else {
            super.addView(view, -1, view.getLayoutParams());
        }
    }

    private void unmountView(View view) {
        this.mIsChildDrawingOrderDirty = true;
        if (view instanceof ComponentHost) {
            ComponentHost componentHost = (ComponentHost)view;
            view.setVisibility(8);
            this.invalidate();
            ComponentHost.startTemporaryDetach((View)componentHost);
            this.mScrapHosts.add(componentHost);
        } else if (this.mInLayout) {
            super.removeViewInLayout(view);
        } else {
            super.removeView(view);
        }
    }

    TouchExpansionDelegate getTouchExpansionDelegate() {
        return this.mTouchExpansionDelegate;
    }

    public void dispatchDraw(Canvas canvas) {
        this.mDispatchDraw.start(canvas);
        super.dispatchDraw(canvas);
        if (this.mDispatchDraw.isRunning()) {
            this.mDispatchDraw.drawNext();
        }
        this.mDispatchDraw.end();
        DebugDraw.draw(this, canvas);
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        this.updateChildDrawingOrderIfNeeded();
        if (this.mDispatchDraw.isRunning()) {
            this.mDispatchDraw.drawNext();
        }
        return this.mChildDrawingOrder[i];
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean handled = false;
        if (this.isEnabled()) {
            int size = this.mTouchables.size();
            for (int i = size - 1; i >= 0; --i) {
                Touchable t = (Touchable)this.mTouchables.valueAt(i);
                if (!t.shouldHandleTouchEvent(event) || !t.onTouchEvent(event, (View)this)) continue;
                handled = true;
                break;
            }
        }
        if (!handled) {
            handled = super.onTouchEvent(event);
        }
        return handled;
    }

    void performLayout(boolean changed, int l, int t, int r, int b) {
    }

    protected final void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mInLayout = true;
        this.performLayout(changed, l, t, r, b);
        this.mInLayout = false;
    }

    public void requestLayout() {
        ComponentHost parent = this;
        while (parent instanceof ComponentHost) {
            ComponentHost host = parent;
            if (!host.shouldRequestLayout()) {
                return;
            }
            parent = parent.getParent();
        }
        super.requestLayout();
    }

    protected boolean shouldRequestLayout() {
        return !this.mInLayout;
    }

    @SuppressLint(value={"MissingSuperCall"})
    protected boolean verifyDrawable(Drawable who) {
        return true;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        int size = this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = (MountItem)this.mDrawableMountItems.valueAt(i);
            ComponentHostUtils.maybeSetDrawableState((View)this, (Drawable)mountItem.getContent(), mountItem.getFlags(), mountItem.getNodeInfo());
        }
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        int size = this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            Drawable drawable = (Drawable)((MountItem)this.mDrawableMountItems.valueAt(i)).getContent();
            DrawableCompat.jumpToCurrentState((Drawable)drawable);
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        int size = this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            Drawable drawable = (Drawable)((MountItem)this.mDrawableMountItems.valueAt(i)).getContent();
            drawable.setVisible(visibility == 0, false);
        }
    }

    @DoNotStrip
    public Object getTag() {
        if (this.mViewTag != null) {
            return this.mViewTag;
        }
        return super.getTag();
    }

    public Object getTag(int key) {
        Object value;
        if (this.mViewTags != null && (value = this.mViewTags.get(key)) != null) {
            return value;
        }
        return super.getTag(key);
    }

    public void invalidate(Rect dirty) {
        if (this.mSuppressInvalidations) {
            this.mWasInvalidatedWhileSuppressed = true;
            return;
        }
        super.invalidate(dirty);
    }

    public void invalidate(int l, int t, int r, int b) {
        if (this.mSuppressInvalidations) {
            this.mWasInvalidatedWhileSuppressed = true;
            return;
        }
        super.invalidate(l, t, r, b);
    }

    public void invalidate() {
        if (this.mSuppressInvalidations) {
            this.mWasInvalidatedWhileSuppressed = true;
            return;
        }
        super.invalidate();
    }

    protected void refreshAccessibilityDelegatesIfNeeded(boolean isAccessibilityEnabled) {
        if (isAccessibilityEnabled == this.mIsComponentAccessibilityDelegateSet) {
            return;
        }
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)(isAccessibilityEnabled ? this.mComponentAccessibilityDelegate : null));
        this.mIsComponentAccessibilityDelegateSet = isAccessibilityEnabled;
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            View child = this.getChildAt(i);
            if (child instanceof ComponentHost) {
                ((ComponentHost)child).refreshAccessibilityDelegatesIfNeeded(isAccessibilityEnabled);
                continue;
            }
            NodeInfo nodeInfo = (NodeInfo)child.getTag(R.id.component_node_info);
            if (nodeInfo == null) continue;
            ViewCompat.setAccessibilityDelegate((View)child, (AccessibilityDelegateCompat)(isAccessibilityEnabled ? new ComponentAccessibilityDelegate(child, nodeInfo) : null));
        }
    }

    public void setAccessibilityDelegate(View.AccessibilityDelegate accessibilityDelegate) {
        super.setAccessibilityDelegate(accessibilityDelegate);
        this.mIsComponentAccessibilityDelegateSet = false;
    }

    @Deprecated
    public void addView(View child) {
        throw new UnsupportedOperationException("Adding Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void addView(View child, int index) {
        throw new UnsupportedOperationException("Adding Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        throw new UnsupportedOperationException("Adding Views manually within LithoViews is not supported");
    }

    @Deprecated
    protected boolean addViewInLayout(View child, int index, ViewGroup.LayoutParams params, boolean preventRequestLayout) {
        throw new UnsupportedOperationException("Adding Views manually within LithoViews is not supported");
    }

    @Deprecated
    protected void attachViewToParent(View child, int index, ViewGroup.LayoutParams params) {
        throw new UnsupportedOperationException("Adding Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeView(View view) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeViewInLayout(View view) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeViewsInLayout(int start, int count) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeViewAt(int index) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeViews(int start, int count) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeAllViewsInLayout() {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    protected void removeDetachedView(View child, boolean animate) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @VisibleForTesting
    public void addViewForTest(View view) {
        ViewGroup.LayoutParams params = view.getLayoutParams() == null ? this.generateDefaultLayoutParams() : view.getLayoutParams();
        super.addView(view, -1, params);
    }

    @Nullable
    public Drawable getLinkedDrawableForAnimation() {
        int size = this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = (MountItem)this.mDrawableMountItems.valueAt(i);
            if ((mountItem.getFlags() & 0x40) == 0) continue;
            return (Drawable)mountItem.getContent();
        }
        return null;
    }

    private void updateChildDrawingOrderIfNeeded() {
        View child;
        int i;
        if (!this.mIsChildDrawingOrderDirty) {
            return;
        }
        int childCount = this.getChildCount();
        if (this.mChildDrawingOrder.length < childCount) {
            this.mChildDrawingOrder = new int[childCount + 5];
        }
        int index = 0;
        int viewMountItemCount = this.mViewMountItems.size();
        int size = viewMountItemCount;
        for (i = 0; i < size; ++i) {
            child = (View)((MountItem)this.mViewMountItems.valueAt(i)).getContent();
            this.mChildDrawingOrder[index++] = this.indexOfChild(child);
        }
        size = this.mDisappearingItems.size();
        for (i = 0; i < size; ++i) {
            child = (View)this.mDisappearingItems.get(i).getContent();
            this.mChildDrawingOrder[index++] = this.indexOfChild(child);
        }
        size = this.mScrapHosts.size();
        for (i = 0; i < size; ++i) {
            child = (View)this.mScrapHosts.get(i);
            this.mChildDrawingOrder[index++] = this.indexOfChild(child);
        }
        this.mIsChildDrawingOrderDirty = false;
    }

    private void ensureScrapViewMountItemsArray() {
        if (this.mScrapViewMountItemsArray == null) {
            this.mScrapViewMountItemsArray = ComponentsPools.acquireScrapMountItemsArray();
        }
    }

    private void ensureScrapMountItemsArray() {
        if (this.mScrapMountItemsArray == null) {
            this.mScrapMountItemsArray = ComponentsPools.acquireScrapMountItemsArray();
        }
    }

    private void releaseScrapDataStructuresIfNeeded() {
        if (this.mScrapMountItemsArray != null && this.mScrapMountItemsArray.size() == 0) {
            ComponentsPools.releaseScrapMountItemsArray(this.mScrapMountItemsArray);
            this.mScrapMountItemsArray = null;
        }
        if (this.mScrapViewMountItemsArray != null && this.mScrapViewMountItemsArray.size() == 0) {
            ComponentsPools.releaseScrapMountItemsArray(this.mScrapViewMountItemsArray);
            this.mScrapViewMountItemsArray = null;
        }
    }

    private void mountDrawable(int index, MountItem mountItem, Rect bounds) {
        this.mDrawableMountItems.put(index, (Object)mountItem);
        Drawable drawable = (Drawable)mountItem.getContent();
        DisplayListDrawable displayListDrawable = mountItem.getDisplayListDrawable();
        ComponentHostUtils.mountDrawable((View)this, displayListDrawable != null ? displayListDrawable : drawable, bounds, mountItem.getFlags(), mountItem.getNodeInfo());
        if (drawable instanceof Touchable && !MountItem.isTouchableDisabled(mountItem.getFlags())) {
            this.mTouchables.put(index, (Object)((Touchable)drawable));
        }
    }

    private void unmountDrawable(int index, MountItem mountItem) {
        Drawable drawable;
        Drawable contentDrawable = (Drawable)mountItem.getContent();
        Object object = drawable = mountItem.getDisplayListDrawable() == null ? contentDrawable : mountItem.getDisplayListDrawable();
        if (ComponentHostUtils.existsScrapItemAt(index, this.mScrapDrawableMountItems)) {
            this.mScrapDrawableMountItems.remove(index);
        } else {
            this.mDrawableMountItems.remove(index);
        }
        drawable.setCallback(null);
        if (contentDrawable instanceof Touchable && !MountItem.isTouchableDisabled(mountItem.getFlags())) {
            if (ComponentHostUtils.existsScrapItemAt(index, this.mScrapTouchables)) {
                this.mScrapTouchables.remove(index);
            } else {
                this.mTouchables.remove(index);
            }
        }
        this.invalidate(drawable.getBounds());
        this.releaseScrapDataStructuresIfNeeded();
    }

    private void moveDrawableItem(MountItem item, int oldIndex, int newIndex) {
        if (this.mDrawableMountItems.get(newIndex) != null) {
            this.ensureScrapDrawableMountItemsArray();
            ComponentHostUtils.scrapItemAt(newIndex, this.mDrawableMountItems, this.mScrapDrawableMountItems);
        }
        if (this.mTouchables.get(newIndex) != null) {
            this.ensureScrapTouchablesArray();
            ComponentHostUtils.scrapItemAt(newIndex, this.mTouchables, this.mScrapTouchables);
        }
        ComponentHostUtils.moveItem(oldIndex, newIndex, this.mDrawableMountItems, this.mScrapDrawableMountItems);
        if (item.getContent() instanceof Touchable) {
            ComponentHostUtils.moveItem(oldIndex, newIndex, this.mTouchables, this.mScrapTouchables);
        }
        this.invalidate();
        this.releaseScrapDataStructuresIfNeeded();
    }

    private void ensureScrapDrawableMountItemsArray() {
        if (this.mScrapDrawableMountItems == null) {
            this.mScrapDrawableMountItems = ComponentsPools.acquireScrapMountItemsArray();
        }
    }

    private void ensureScrapTouchablesArray() {
        if (this.mScrapTouchables == null) {
            this.mScrapTouchables = ComponentsPools.acquireScrapTouchablesArray();
        }
    }

    private static void startTemporaryDetach(View view) {
        if (Build.VERSION.SDK_INT >= 19) {
            view.cancelPendingInputEvents();
        }
        ViewCompat.dispatchStartTemporaryDetach((View)view);
    }

    private static void finishTemporaryDetach(View view) {
        ViewCompat.dispatchFinishTemporaryDetach((View)view);
    }

    @VisibleForTesting
    SparseArrayCompat<Touchable> getHostTouchables() {
        return this.mTouchables;
    }

    private static String getTraceName(MountItem mountItem) {
        String traceName = "draw: " + mountItem.getComponent().getSimpleName();
        DisplayListDrawable displayListDrawable = mountItem.getDisplayListDrawable();
        if (displayListDrawable != null && displayListDrawable.willDrawDisplayList()) {
            traceName = traceName + "DL";
        }
        return traceName;
    }

    private class InterleavedDispatchDraw {
        private Canvas mCanvas;
        private int mDrawIndex;
        private int mItemsToDraw;

        private InterleavedDispatchDraw() {
        }

        private void start(Canvas canvas) {
            this.mCanvas = canvas;
            this.mDrawIndex = 0;
            this.mItemsToDraw = ComponentHost.this.mMountItems.size();
        }

        private boolean isRunning() {
            return this.mCanvas != null && this.mDrawIndex < this.mItemsToDraw;
        }

        private void drawNext() {
            if (this.mCanvas == null) {
                return;
            }
            int size = ComponentHost.this.mMountItems.size();
            for (int i = this.mDrawIndex; i < size; ++i) {
                Object content;
                MountItem mountItem = (MountItem)ComponentHost.this.mMountItems.valueAt(i);
                Object object = content = mountItem.getDisplayListDrawable() != null ? mountItem.getDisplayListDrawable() : mountItem.getContent();
                if (content instanceof View) {
                    this.mDrawIndex = i + 1;
                    return;
                }
                boolean isTracing = ComponentsSystrace.isTracing();
                if (isTracing) {
                    ComponentsSystrace.beginSection(ComponentHost.getTraceName(mountItem));
                }
                ((Drawable)content).draw(this.mCanvas);
                if (!isTracing) continue;
                ComponentsSystrace.endSection();
            }
            this.mDrawIndex = this.mItemsToDraw;
        }

        private void end() {
            this.mCanvas = null;
        }
    }
}

