/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.support.annotation.AttrRes;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.annotation.VisibleForTesting;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.EventHandler;
import com.facebook.litho.EventTrigger;
import com.facebook.litho.InternalNode;
import com.facebook.litho.KeyHandler;
import com.facebook.litho.NoOpInternalNode;
import com.facebook.litho.R;
import com.facebook.litho.ResourceCache;
import com.facebook.litho.StateHandler;
import com.facebook.litho.TreeProps;

public class ComponentContext
extends ContextWrapper {
    static final InternalNode NULL_LAYOUT = new NoOpInternalNode();
    private final String mLogTag;
    private final ComponentsLogger mLogger;
    private final StateHandler mStateHandler;
    private final KeyHandler mKeyHandler;
    private String mNoStateUpdatesMethod;
    @ThreadConfined(value="ANY")
    private Component<?> mComponentScope;
    @ThreadConfined(value="ANY")
    private final ResourceCache mResourceCache;
    @ThreadConfined(value="ANY")
    private int mWidthSpec;
    @ThreadConfined(value="ANY")
    private int mHeightSpec;
    @ThreadConfined(value="ANY")
    protected TreeProps mTreeProps;
    @ThreadConfined(value="ANY")
    private ComponentTree mComponentTree;
    @StyleRes
    @ThreadConfined(value="ANY")
    private int mDefStyleRes = 0;
    @AttrRes
    @ThreadConfined(value="ANY")
    private int mDefStyleAttr = 0;

    public ComponentContext(Context context) {
        this(context, null, null, null, null);
    }

    public ComponentContext(Context context, StateHandler stateHandler) {
        this(context, stateHandler, null);
    }

    public ComponentContext(Context context, StateHandler stateHandler, KeyHandler keyHandler) {
        this(context, null, null, stateHandler, keyHandler);
    }

    public ComponentContext(Context context, String logTag, ComponentsLogger logger) {
        this(context, logTag, logger, null, null);
    }

    private ComponentContext(Context context, String logTag, ComponentsLogger logger, StateHandler stateHandler, KeyHandler keyHandler) {
        super(context instanceof ComponentContext ? ((ComponentContext)context).getBaseContext() : context);
        boolean transferKeyHandler;
        if (logger != null && logTag == null) {
            throw new IllegalStateException("When a ComponentsLogger is set, a LogTag must be set");
        }
        ComponentContext componentContext = context instanceof ComponentContext ? (ComponentContext)context : null;
        boolean transferLogging = componentContext != null && logTag == null && logger == null;
        boolean transferStateHandler = componentContext != null && stateHandler == null;
        boolean bl = transferKeyHandler = componentContext != null && keyHandler == null;
        if (componentContext != null) {
            this.mTreeProps = componentContext.mTreeProps;
            this.mResourceCache = componentContext.mResourceCache;
            this.mWidthSpec = componentContext.mWidthSpec;
            this.mHeightSpec = componentContext.mHeightSpec;
            this.mComponentScope = componentContext.mComponentScope;
            this.mComponentTree = componentContext.mComponentTree;
        } else {
            this.mResourceCache = ResourceCache.getLatest(context.getResources().getConfiguration());
        }
        this.mLogger = transferLogging ? componentContext.mLogger : logger;
        this.mLogTag = transferLogging ? componentContext.mLogTag : logTag;
        this.mStateHandler = transferStateHandler ? componentContext.mStateHandler : stateHandler;
        this.mKeyHandler = transferKeyHandler ? componentContext.mKeyHandler : keyHandler;
    }

    static ComponentContext withComponentTree(ComponentContext context, ComponentTree componentTree) {
        ComponentContext componentContext = new ComponentContext((Context)context, ComponentsPools.acquireStateHandler(), context.mKeyHandler);
        componentContext.mComponentTree = componentTree;
        return componentContext;
    }

    @VisibleForTesting(otherwise=3)
    public static ComponentContext withComponentScope(ComponentContext context, Component scope) {
        ComponentContext componentContext = context.makeNewCopy();
        componentContext.mComponentScope = scope;
        componentContext.mComponentTree = context.mComponentTree;
        return componentContext;
    }

    ComponentContext makeNewCopy() {
        return new ComponentContext((Context)this);
    }

    public Component getComponentScope() {
        return this.mComponentScope;
    }

    public void updateState(ComponentLifecycle.StateUpdate stateUpdate) {
        this.checkIfNoStateUpdatesMethod();
        if (this.mComponentTree == null) {
            return;
        }
        this.mComponentTree.updateState(this.mComponentScope.getGlobalKey(), stateUpdate);
    }

    public void updateStateAsync(ComponentLifecycle.StateUpdate stateUpdate) {
        this.checkIfNoStateUpdatesMethod();
        if (this.mComponentTree == null) {
            return;
        }
        this.mComponentTree.updateStateAsync(this.mComponentScope.getGlobalKey(), stateUpdate);
    }

    public void updateStateLazy(ComponentLifecycle.StateUpdate stateUpdate) {
        if (this.mComponentTree == null) {
            return;
        }
        this.mComponentTree.updateStateLazy(this.mComponentScope.getGlobalKey(), stateUpdate);
    }

    public void enterNoStateUpdatesMethod(String noStateUpdatesMethod) {
        this.mNoStateUpdatesMethod = noStateUpdatesMethod;
    }

    public void exitNoStateUpdatesMethod() {
        this.mNoStateUpdatesMethod = null;
    }

    private void checkIfNoStateUpdatesMethod() {
        if (this.mNoStateUpdatesMethod != null) {
            throw new IllegalStateException("Updating the state of a component during " + this.mNoStateUpdatesMethod + " leads to unexpected behaviour, consider using lazy state updates.");
        }
    }

    void setDefStyle(@AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        this.mDefStyleAttr = defStyleAttr;
        this.mDefStyleRes = defStyleRes;
    }

    public TypedArray obtainStyledAttributes(int[] attrs, @AttrRes int defStyleAttr) {
        return this.obtainStyledAttributes(null, attrs, defStyleAttr != 0 ? defStyleAttr : this.mDefStyleAttr, this.mDefStyleRes);
    }

    public String getLogTag() {
        return this.mLogTag;
    }

    @Nullable
    public ComponentsLogger getLogger() {
        return this.mLogger;
    }

    ComponentTree getComponentTree() {
        return this.mComponentTree;
    }

    protected void setTreeProps(TreeProps treeProps) {
        this.mTreeProps = treeProps;
    }

    @Nullable
    protected TreeProps getTreeProps() {
        return this.mTreeProps;
    }

    public ResourceCache getResourceCache() {
        return this.mResourceCache;
    }

    EventHandler newEventHandler(int id2) {
        return new EventHandler(this.mComponentScope, id2);
    }

    <E> EventHandler<E> newEventHandler(String name, int id2, Object[] params) {
        return new EventHandler(this.mComponentScope, name, id2, params);
    }

    <E> EventTrigger<E> newEventTrigger() {
        return new EventTrigger(this.mComponentScope);
    }

    public void registerTrigger(EventTrigger trigger, String key) {
        if (this.mComponentTree == null) {
            return;
        }
        this.mComponentTree.recordEventTrigger(key, trigger);
    }

    public void unregisterTrigger(String key) {
        if (this.mComponentTree == null) {
            return;
        }
        this.mComponentTree.releaseEventTrigger(key);
    }

    InternalNode newLayoutBuilder(@AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        InternalNode node = ComponentsPools.acquireInternalNode(this);
        this.applyStyle(node, defStyleAttr, defStyleRes);
        return node;
    }

    ComponentLayout.Builder newLayoutBuilder(Component<?> component, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        component.applyStateUpdates(this);
        InternalNode node = (InternalNode)((ComponentLifecycle)component.getLifecycle()).createLayout(component.getScopedContext(), component, false);
        component.getScopedContext().setTreeProps(null);
        if (node != NULL_LAYOUT) {
            this.applyStyle(node, defStyleAttr, defStyleRes);
        }
        return node;
    }

    int getWidthSpec() {
        return this.mWidthSpec;
    }

    void setWidthSpec(int widthSpec) {
        this.mWidthSpec = widthSpec;
    }

    int getHeightSpec() {
        return this.mHeightSpec;
    }

    void setHeightSpec(int heightSpec) {
        this.mHeightSpec = heightSpec;
    }

    StateHandler getStateHandler() {
        return this.mStateHandler;
    }

    KeyHandler getKeyHandler() {
        return this.mKeyHandler;
    }

    private void applyStyle(InternalNode node, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        if (defStyleAttr != 0 || defStyleRes != 0) {
            this.setDefStyle(defStyleAttr, defStyleRes);
            TypedArray typedArray = this.obtainStyledAttributes(null, R.styleable.ComponentLayout, defStyleAttr, defStyleRes);
            node.applyAttributes(typedArray);
            typedArray.recycle();
            this.setDefStyle(0, 0);
        }
    }
}

