/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.view.accessibility.AccessibilityNodeProviderCompat;
import android.support.v4.widget.ExploreByTouchHelper;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.EventDispatcherUtils;
import com.facebook.litho.MountItem;
import com.facebook.litho.NodeInfo;
import java.util.List;

class ComponentAccessibilityDelegate
extends ExploreByTouchHelper {
    private static final String TAG = "ComponentAccessibility";
    private final View mView;
    private NodeInfo mNodeInfo;
    private final AccessibilityDelegateCompat mSuperDelegate;
    private static final Rect sDefaultBounds = new Rect(0, 0, 1, 1);

    ComponentAccessibilityDelegate(View view, NodeInfo nodeInfo) {
        super(view);
        this.mView = view;
        this.mNodeInfo = nodeInfo;
        this.mSuperDelegate = new SuperDelegate();
    }

    ComponentAccessibilityDelegate(View view) {
        this(view, null);
    }

    void setNodeInfo(NodeInfo nodeInfo) {
        this.mNodeInfo = nodeInfo;
    }

    public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat node) {
        MountItem mountItem = ComponentAccessibilityDelegate.getAccessibleMountItem(this.mView);
        if (this.mNodeInfo != null && this.mNodeInfo.getOnInitializeAccessibilityNodeInfoHandler() != null) {
            EventDispatcherUtils.dispatchOnInitializeAccessibilityNodeInfoEvent(this.mNodeInfo.getOnInitializeAccessibilityNodeInfoHandler(), host, node, this.mSuperDelegate);
        } else if (mountItem != null) {
            super.onInitializeAccessibilityNodeInfo(host, node);
            Component<?> component = mountItem.getComponent();
            ((ComponentLifecycle)component.getLifecycle()).onPopulateAccessibilityNode(node, component);
        } else {
            super.onInitializeAccessibilityNodeInfo(host, node);
        }
    }

    protected void getVisibleVirtualViews(List<Integer> virtualViewIds) {
        MountItem mountItem = ComponentAccessibilityDelegate.getAccessibleMountItem(this.mView);
        if (mountItem == null) {
            return;
        }
        Component<?> component = mountItem.getComponent();
        int extraAccessibilityNodesCount = ((ComponentLifecycle)component.getLifecycle()).getExtraAccessibilityNodesCount(component);
        for (int i = 0; i < extraAccessibilityNodesCount; ++i) {
            virtualViewIds.add(i);
        }
    }

    protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfoCompat node) {
        MountItem mountItem = ComponentAccessibilityDelegate.getAccessibleMountItem(this.mView);
        if (mountItem == null) {
            Log.e((String)TAG, (String)("No accessible mount item found for view: " + this.mView));
            node.setContentDescription((CharSequence)"");
            node.setBoundsInParent(ComponentAccessibilityDelegate.getDefaultBounds());
            return;
        }
        Drawable drawable = (Drawable)mountItem.getContent();
        Rect bounds = drawable.getBounds();
        Component<?> component = mountItem.getComponent();
        Object lifecycle = component.getLifecycle();
        node.setClassName((CharSequence)lifecycle.getClass().getName());
        if (virtualViewId >= ((ComponentLifecycle)lifecycle).getExtraAccessibilityNodesCount(component)) {
            Log.e((String)TAG, (String)("Received unrecognized virtual view id: " + virtualViewId));
            node.setContentDescription((CharSequence)"");
            node.setBoundsInParent(ComponentAccessibilityDelegate.getDefaultBounds());
            return;
        }
        ((ComponentLifecycle)lifecycle).onPopulateExtraAccessibilityNode(node, virtualViewId, bounds.left, bounds.top, component);
    }

    protected int getVirtualViewAt(float x, float y) {
        MountItem mountItem = ComponentAccessibilityDelegate.getAccessibleMountItem(this.mView);
        if (mountItem == null) {
            return Integer.MIN_VALUE;
        }
        Component<?> component = mountItem.getComponent();
        Object lifecycle = component.getLifecycle();
        if (((ComponentLifecycle)lifecycle).getExtraAccessibilityNodesCount(component) == 0) {
            return Integer.MIN_VALUE;
        }
        Drawable drawable = (Drawable)mountItem.getContent();
        Rect bounds = drawable.getBounds();
        int virtualViewId = ((ComponentLifecycle)lifecycle).getExtraAccessibilityNodeAt((int)x - bounds.left, (int)y - bounds.top, component);
        return virtualViewId >= 0 ? virtualViewId : Integer.MIN_VALUE;
    }

    protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
        event.setContentDescription((CharSequence)"");
    }

    protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
        return false;
    }

    public AccessibilityNodeProviderCompat getAccessibilityNodeProvider(View host) {
        MountItem mountItem = ComponentAccessibilityDelegate.getAccessibleMountItem(this.mView);
        if (mountItem != null && ((ComponentLifecycle)mountItem.getComponent().getLifecycle()).implementsExtraAccessibilityNodes()) {
            return super.getAccessibilityNodeProvider(host);
        }
        return null;
    }

    private static MountItem getAccessibleMountItem(View view) {
        if (!(view instanceof ComponentHost)) {
            return null;
        }
        return ((ComponentHost)view).getAccessibleMountItem();
    }

    public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
        if (this.mNodeInfo != null && this.mNodeInfo.getOnInitializeAccessibilityEventHandler() != null) {
            EventDispatcherUtils.dispatchOnInitializeAccessibilityEvent(this.mNodeInfo.getOnInitializeAccessibilityEventHandler(), host, event, this.mSuperDelegate);
        } else {
            super.onInitializeAccessibilityEvent(host, event);
        }
    }

    public void sendAccessibilityEvent(View host, int eventType) {
        if (this.mNodeInfo != null && this.mNodeInfo.getSendAccessibilityEventHandler() != null) {
            EventDispatcherUtils.dispatchSendAccessibilityEvent(this.mNodeInfo.getSendAccessibilityEventHandler(), host, eventType, this.mSuperDelegate);
        } else {
            super.sendAccessibilityEvent(host, eventType);
        }
    }

    public void sendAccessibilityEventUnchecked(View host, AccessibilityEvent event) {
        if (this.mNodeInfo != null && this.mNodeInfo.getSendAccessibilityEventUncheckedHandler() != null) {
            EventDispatcherUtils.dispatchSendAccessibilityEventUnchecked(this.mNodeInfo.getSendAccessibilityEventUncheckedHandler(), host, event, this.mSuperDelegate);
        } else {
            super.sendAccessibilityEventUnchecked(host, event);
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
        if (this.mNodeInfo != null && this.mNodeInfo.getDispatchPopulateAccessibilityEventHandler() != null) {
            return EventDispatcherUtils.dispatchDispatchPopulateAccessibilityEvent(this.mNodeInfo.getDispatchPopulateAccessibilityEventHandler(), host, event, this.mSuperDelegate);
        }
        return super.dispatchPopulateAccessibilityEvent(host, event);
    }

    public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
        if (this.mNodeInfo != null && this.mNodeInfo.getOnPopulateAccessibilityEventHandler() != null) {
            EventDispatcherUtils.dispatchOnPopulateAccessibilityEvent(this.mNodeInfo.getOnPopulateAccessibilityEventHandler(), host, event, this.mSuperDelegate);
        } else {
            super.onPopulateAccessibilityEvent(host, event);
        }
    }

    public boolean onRequestSendAccessibilityEvent(ViewGroup host, View child, AccessibilityEvent event) {
        if (this.mNodeInfo != null && this.mNodeInfo.getOnRequestSendAccessibilityEventHandler() != null) {
            return EventDispatcherUtils.dispatchOnRequestSendAccessibilityEvent(this.mNodeInfo.getOnRequestSendAccessibilityEventHandler(), host, child, event, this.mSuperDelegate);
        }
        return super.onRequestSendAccessibilityEvent(host, child, event);
    }

    public boolean performAccessibilityAction(View host, int action, Bundle args) {
        if (this.mNodeInfo != null && this.mNodeInfo.getPerformAccessibilityActionHandler() != null) {
            return EventDispatcherUtils.dispatchPerformAccessibilityActionEvent(this.mNodeInfo.getPerformAccessibilityActionHandler(), host, action, args, this.mSuperDelegate);
        }
        return super.performAccessibilityAction(host, action, args);
    }

    private static Rect getDefaultBounds() {
        return sDefaultBounds;
    }

    private class SuperDelegate
    extends AccessibilityDelegateCompat {
        private SuperDelegate() {
        }

        public boolean dispatchPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
            return ComponentAccessibilityDelegate.super.dispatchPopulateAccessibilityEvent(host, event);
        }

        public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
            ComponentAccessibilityDelegate.super.onInitializeAccessibilityEvent(host, event);
        }

        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat node) {
            ComponentAccessibilityDelegate.super.onInitializeAccessibilityNodeInfo(host, node);
        }

        public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
            ComponentAccessibilityDelegate.super.onPopulateAccessibilityEvent(host, event);
        }

        public boolean onRequestSendAccessibilityEvent(ViewGroup host, View child, AccessibilityEvent event) {
            return ComponentAccessibilityDelegate.super.onRequestSendAccessibilityEvent(host, child, event);
        }

        public boolean performAccessibilityAction(View host, int action, Bundle args) {
            return ComponentAccessibilityDelegate.super.performAccessibilityAction(host, action, args);
        }

        public void sendAccessibilityEvent(View host, int eventType) {
            ComponentAccessibilityDelegate.super.sendAccessibilityEvent(host, eventType);
        }

        public void sendAccessibilityEventUnchecked(View host, AccessibilityEvent event) {
            ComponentAccessibilityDelegate.super.sendAccessibilityEventUnchecked(host, event);
        }
    }
}

