/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.DrawableRes;
import android.support.annotation.Px;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.support.annotation.VisibleForTesting;
import android.util.SparseArray;
import android.view.ViewOutlineProvider;
import com.facebook.infer.annotation.ReturnsOwnership;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.Border;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLayoutAttributes;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.DispatchPopulateAccessibilityEventEvent;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.EventTriggerTarget;
import com.facebook.litho.FocusChangedEvent;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.HasEventDispatcher;
import com.facebook.litho.HasEventTrigger;
import com.facebook.litho.HostComponent;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.InternalNode;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.KeyHandler;
import com.facebook.litho.Layout;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LogEvent;
import com.facebook.litho.LongClickEvent;
import com.facebook.litho.OnInitializeAccessibilityEventEvent;
import com.facebook.litho.OnInitializeAccessibilityNodeInfoEvent;
import com.facebook.litho.OnPopulateAccessibilityEventEvent;
import com.facebook.litho.OnRequestSendAccessibilityEventEvent;
import com.facebook.litho.PerformAccessibilityActionEvent;
import com.facebook.litho.ResourceResolver;
import com.facebook.litho.SendAccessibilityEventEvent;
import com.facebook.litho.SendAccessibilityEventUncheckedEvent;
import com.facebook.litho.Size;
import com.facebook.litho.TouchEvent;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.reference.DrawableReference;
import com.facebook.litho.reference.Reference;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaPositionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public abstract class Component<L extends ComponentLifecycle>
implements HasEventDispatcher,
HasEventTrigger {
    private static final AtomicInteger sIdGenerator = new AtomicInteger(0);
    private int mId = sIdGenerator.getAndIncrement();
    private String mGlobalKey;
    private String mKey;
    private boolean mHasManualKey;
    private final L mLifecycle;
    @ThreadConfined(value="ANY")
    private ComponentContext mScopedContext;
    private boolean mIsLayoutStarted = false;
    @ThreadConfined(value="ANY")
    private InternalNode mLastMeasuredLayout;
    @Nullable
    private ComponentLayoutAttributes mComponentLayoutAttributes;
    private Map<String, Integer> mChildCounters = new HashMap<String, Integer>();

    public abstract String getSimpleName();

    public boolean isEquivalentTo(Component<?> other) {
        return this == other;
    }

    protected ComponentLifecycle.StateContainer getStateContainer() {
        return null;
    }

    public ComponentContext getScopedContext() {
        return this.mScopedContext;
    }

    public void setScopedContext(ComponentContext scopedContext) {
        this.mScopedContext = scopedContext;
    }

    synchronized void markLayoutStarted() {
        if (this.mIsLayoutStarted) {
            throw new IllegalStateException("Duplicate layout of a component: " + this);
        }
        this.mIsLayoutStarted = true;
    }

    protected int getId() {
        return this.mId;
    }

    String getGlobalKey() {
        return this.mGlobalKey;
    }

    @ThreadSafe(enableChecks=false)
    private void setGlobalKey(String key) {
        this.mGlobalKey = key;
    }

    String getKey() {
        return this.mKey;
    }

    void setKey(String key) {
        this.mHasManualKey = true;
        this.mKey = key;
    }

    private String generateUniqueGlobalKeyForChild(Component component, String key) {
        String childType;
        ComponentsLogger logger;
        String childKey = this.getGlobalKey() + key;
        KeyHandler keyHandler = this.mScopedContext.getKeyHandler();
        if (keyHandler == null) {
            return childKey;
        }
        if (!keyHandler.hasKey(childKey)) {
            return childKey;
        }
        if (component.mHasManualKey && (logger = this.mScopedContext.getLogger()) != null) {
            LogEvent event = logger.newEvent(12);
            event.addParam("message", "The manual key " + childKey + " you are setting on this " + component.getSimpleName() + " is a duplicate and will be changed into a unique one. This will result in unexpected behavior if you don't change it.");
            logger.log(event);
        }
        int childIndex = this.mChildCounters.containsKey(childType = component.getSimpleName()) ? this.mChildCounters.get(childType) : 0;
        String uniqueKey = childKey + childIndex;
        while (keyHandler.hasKey(uniqueKey)) {
            uniqueKey = childKey + childIndex++;
        }
        this.mChildCounters.put(childType, childIndex + 1);
        return uniqueKey;
    }

    Component<L> makeCopyWithNullContext() {
        try {
            Component component = (Component)super.clone();
            component.mScopedContext = null;
            return component;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Component<L> makeShallowCopy() {
        try {
            Component component = (Component)super.clone();
            component.mIsLayoutStarted = false;
            component.mChildCounters = new HashMap<String, Integer>();
            component.mHasManualKey = false;
            return component;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    Component<L> makeShallowCopyWithNewId() {
        Component<L> component = this.makeShallowCopy();
        component.mId = sIdGenerator.incrementAndGet();
        return component;
    }

    boolean hasCachedLayout() {
        return this.mLastMeasuredLayout != null;
    }

    InternalNode getCachedLayout() {
        return this.mLastMeasuredLayout;
    }

    @VisibleForTesting(otherwise=3)
    protected void releaseCachedLayout() {
        if (this.mLastMeasuredLayout != null) {
            LayoutState.releaseNodeTree(this.mLastMeasuredLayout, true);
            this.mLastMeasuredLayout = null;
        }
    }

    @VisibleForTesting(otherwise=3)
    protected void clearCachedLayout() {
        this.mLastMeasuredLayout = null;
    }

    void release() {
        this.mIsLayoutStarted = false;
    }

    protected Component(L lifecycle) {
        this.mLifecycle = lifecycle;
        this.mKey = Integer.toString(((ComponentLifecycle)this.mLifecycle).getTypeId());
    }

    public L getLifecycle() {
        return this.mLifecycle;
    }

    public void measure(ComponentContext c, int widthSpec, int heightSpec, Size outputSize) {
        this.releaseCachedLayout();
        this.mLastMeasuredLayout = LayoutState.createAndMeasureTreeForComponent(c, this, widthSpec, heightSpec);
        if (Component.isLayoutSpec(this)) {
            this.mLastMeasuredLayout.setLastWidthSpec(widthSpec);
            this.mLastMeasuredLayout.setLastHeightSpec(heightSpec);
        }
        outputSize.width = this.mLastMeasuredLayout.getWidth();
        outputSize.height = this.mLastMeasuredLayout.getHeight();
    }

    protected void copyInterStageImpl(Component<L> component) {
    }

    static boolean isHostSpec(Component<?> component) {
        return component != null && component.mLifecycle instanceof HostComponent;
    }

    static boolean isLayoutSpec(Component<?> component) {
        return component != null && ((ComponentLifecycle)component.mLifecycle).getMountType() == ComponentLifecycle.MountType.NONE;
    }

    static boolean isMountSpec(Component<?> component) {
        return component != null && ((ComponentLifecycle)component.mLifecycle).getMountType() != ComponentLifecycle.MountType.NONE;
    }

    static boolean isMountDrawableSpec(Component<?> component) {
        return component != null && ((ComponentLifecycle)component.mLifecycle).getMountType() == ComponentLifecycle.MountType.DRAWABLE;
    }

    static boolean isMountViewSpec(Component<?> component) {
        return component != null && ((ComponentLifecycle)component.mLifecycle).getMountType() == ComponentLifecycle.MountType.VIEW;
    }

    static boolean isLayoutSpecWithSizeSpec(Component<?> component) {
        return Component.isLayoutSpec(component) && ((ComponentLifecycle)component.mLifecycle).canMeasure();
    }

    static boolean isNestedTree(Component<?> component) {
        return Component.isLayoutSpecWithSizeSpec(component) || component != null && component.hasCachedLayout();
    }

    public static boolean willRender(ComponentLayout componentLayout) {
        if (componentLayout == null || ComponentContext.NULL_LAYOUT.equals(componentLayout)) {
            return false;
        }
        if (componentLayout instanceof InternalNode && ((InternalNode)componentLayout).isNestedTreeHolder()) {
            throw new IllegalArgumentException("Cannot check willRender on a component that uses @OnCreateLayoutWithSizeSpec! Try wrapping this component in one that uses @OnCreateLayout if possible.");
        }
        return true;
    }

    void applyStateUpdates(ComponentContext c) {
        Component parentScope = c.getComponentScope();
        String key = this.getKey();
        this.setGlobalKey(parentScope == null ? key : parentScope.generateUniqueGlobalKeyForChild(this, key));
        this.setScopedContext(ComponentContext.withComponentScope(c, this));
        ((ComponentLifecycle)this.getLifecycle()).populateTreeProps(this, this.getScopedContext().getTreeProps());
        KeyHandler keyHandler = this.getScopedContext().getKeyHandler();
        if (keyHandler != null && !ComponentsConfiguration.isEndToEndTestRun) {
            keyHandler.registerKey(this);
        }
        this.registerEventTrigger(this.getGlobalKey());
        if (((ComponentLifecycle)this.getLifecycle()).hasState()) {
            c.getStateHandler().applyStateUpdatesForComponent(this);
        }
    }

    private void registerEventTrigger(String globalKey) {
        ComponentContext context = this.getScopedContext();
        if (!((ComponentLifecycle)this.getLifecycle()).canAcceptTrigger()) {
            context.unregisterTrigger(globalKey);
            return;
        }
        context.registerTrigger(context.newEventTrigger(), globalKey);
    }

    ComponentLayoutAttributes getLayoutAttributes() {
        return this.mComponentLayoutAttributes;
    }

    private ComponentLayoutAttributes getOrCreateLayoutAttributes() {
        if (this.mComponentLayoutAttributes == null) {
            this.mComponentLayoutAttributes = new ComponentLayoutAttributes();
        }
        return this.mComponentLayoutAttributes;
    }

    @Override
    public EventDispatcher getEventDispatcher() {
        return this.mLifecycle;
    }

    @Override
    public EventTriggerTarget getEventTriggerTarget() {
        return this.mLifecycle;
    }

    public static abstract class Builder<L extends ComponentLifecycle, T extends Builder<L, T>>
    extends ResourceResolver {
        private ComponentContext mContext;
        @AttrRes
        private int mDefStyleAttr;
        @StyleRes
        private int mDefStyleRes;
        private Component mComponent;

        protected void init(ComponentContext c, @AttrRes int defStyleAttr, @StyleRes int defStyleRes, Component<L> component) {
            super.init(c, c.getResourceCache());
            this.mComponent = component;
            this.mContext = c;
            this.mDefStyleAttr = defStyleAttr;
            this.mDefStyleRes = defStyleRes;
            if (defStyleAttr != 0 || defStyleRes != 0) {
                ((Component)component).mLifecycle.loadStyle(c, defStyleAttr, defStyleRes, component);
            }
        }

        public abstract T getThis();

        public T key(String key) {
            this.mComponent.setKey(key);
            return this.getThis();
        }

        @Override
        protected void release() {
            super.release();
            this.mContext = null;
            this.mDefStyleAttr = 0;
            this.mDefStyleRes = 0;
            this.mComponent = null;
        }

        protected static void checkArgs(int requiredPropsCount, BitSet required, String[] requiredPropsNames) {
            if (required != null && required.nextClearBit(0) < requiredPropsCount) {
                ArrayList<String> missingProps = new ArrayList<String>();
                for (int i = 0; i < requiredPropsCount; ++i) {
                    if (required.get(i)) continue;
                    missingProps.add(requiredPropsNames[i]);
                }
                throw new IllegalStateException("The following props are not marked as optional and were not supplied: " + Arrays.toString(missingProps.toArray()));
            }
        }

        public final ComponentLayout buildWithLayout() {
            return this.withLayout().build();
        }

        @Deprecated
        public final ComponentLayout.Builder withLayout() {
            ComponentContext context = this.mContext;
            int defStyleAttr = this.mDefStyleAttr;
            int defStyleRes = this.mDefStyleRes;
            return Layout.create(context, this.build(), defStyleAttr, defStyleRes);
        }

        @ReturnsOwnership
        public abstract Component<L> build();

        public T layoutDirection(YogaDirection layoutDirection) {
            this.mComponent.getOrCreateLayoutAttributes().layoutDirection(layoutDirection);
            return this.getThis();
        }

        public T alignSelf(YogaAlign alignSelf) {
            this.mComponent.getOrCreateLayoutAttributes().alignSelf(alignSelf);
            return this.getThis();
        }

        public T positionType(YogaPositionType positionType) {
            this.mComponent.getOrCreateLayoutAttributes().positionType(positionType);
            return this.getThis();
        }

        public T flex(float flex) {
            this.mComponent.getOrCreateLayoutAttributes().flex(flex);
            return this.getThis();
        }

        public T flexGrow(float flexGrow) {
            this.mComponent.getOrCreateLayoutAttributes().flexGrow(flexGrow);
            return this.getThis();
        }

        public T flexShrink(float flexShrink) {
            this.mComponent.getOrCreateLayoutAttributes().flexShrink(flexShrink);
            return this.getThis();
        }

        public T flexBasisPx(@Px int flexBasis) {
            this.mComponent.getOrCreateLayoutAttributes().flexBasisPx(flexBasis);
            return this.getThis();
        }

        public T flexBasisPercent(float percent) {
            this.mComponent.getOrCreateLayoutAttributes().flexBasisPercent(percent);
            return this.getThis();
        }

        public T flexBasisAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.flexBasisPx(this.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T flexBasisAttr(@AttrRes int resId) {
            return this.flexBasisAttr(resId, 0);
        }

        public T flexBasisRes(@DimenRes int resId) {
            return this.flexBasisPx(this.resolveDimenSizeRes(resId));
        }

        public T flexBasisDip(@Dimension(unit=0) float flexBasis) {
            return this.flexBasisPx(this.dipsToPixels(flexBasis));
        }

        public T importantForAccessibility(int importantForAccessibility) {
            this.mComponent.getOrCreateLayoutAttributes().importantForAccessibility(importantForAccessibility);
            return this.getThis();
        }

        public T duplicateParentState(boolean duplicateParentState) {
            this.mComponent.getOrCreateLayoutAttributes().duplicateParentState(duplicateParentState);
            return this.getThis();
        }

        public T marginPx(YogaEdge edge, @Px int margin) {
            this.mComponent.getOrCreateLayoutAttributes().marginPx(edge, margin);
            return this.getThis();
        }

        public T marginPercent(YogaEdge edge, float percent) {
            this.mComponent.getOrCreateLayoutAttributes().marginPercent(edge, percent);
            return this.getThis();
        }

        public T marginAuto(YogaEdge edge) {
            this.mComponent.getOrCreateLayoutAttributes().marginAuto(edge);
            return this.getThis();
        }

        public T marginAttr(YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
            return this.marginPx(edge, this.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T marginAttr(YogaEdge edge, @AttrRes int resId) {
            return this.marginAttr(edge, resId, 0);
        }

        public T marginRes(YogaEdge edge, @DimenRes int resId) {
            return this.marginPx(edge, this.resolveDimenSizeRes(resId));
        }

        public T marginDip(YogaEdge edge, @Dimension(unit=0) float margin) {
            return this.marginPx(edge, this.dipsToPixels(margin));
        }

        public T paddingPx(YogaEdge edge, @Px int padding) {
            this.mComponent.getOrCreateLayoutAttributes().paddingPx(edge, padding);
            return this.getThis();
        }

        public T paddingPercent(YogaEdge edge, float percent) {
            this.mComponent.getOrCreateLayoutAttributes().paddingPercent(edge, percent);
            return this.getThis();
        }

        public T paddingAttr(YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
            return this.paddingPx(edge, this.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T paddingAttr(YogaEdge edge, @AttrRes int resId) {
            return this.paddingAttr(edge, resId, 0);
        }

        public T paddingRes(YogaEdge edge, @DimenRes int resId) {
            return this.paddingPx(edge, this.resolveDimenSizeRes(resId));
        }

        public T paddingDip(YogaEdge edge, @Dimension(unit=0) float padding) {
            return this.paddingPx(edge, this.dipsToPixels(padding));
        }

        public T border(Border border) {
            this.mComponent.getOrCreateLayoutAttributes().border(border);
            return this.getThis();
        }

        public T positionPx(YogaEdge edge, @Px int position) {
            this.mComponent.getOrCreateLayoutAttributes().positionPx(edge, position);
            return this.getThis();
        }

        public T positionPercent(YogaEdge edge, float percent) {
            this.mComponent.getOrCreateLayoutAttributes().positionPercent(edge, percent);
            return this.getThis();
        }

        public T positionAttr(YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
            return this.positionPx(edge, this.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T positionAttr(YogaEdge edge, @AttrRes int resId) {
            return this.positionAttr(edge, resId, 0);
        }

        public T positionRes(YogaEdge edge, @DimenRes int resId) {
            return this.positionPx(edge, this.resolveDimenSizeRes(resId));
        }

        public T positionDip(YogaEdge edge, @Dimension(unit=0) float position) {
            return this.positionPx(edge, this.dipsToPixels(position));
        }

        public T widthPx(@Px int width) {
            this.mComponent.getOrCreateLayoutAttributes().widthPx(width);
            return this.getThis();
        }

        public T widthPercent(float percent) {
            this.mComponent.getOrCreateLayoutAttributes().widthPercent(percent);
            return this.getThis();
        }

        public T widthRes(@DimenRes int resId) {
            return this.widthPx(this.resolveDimenSizeRes(resId));
        }

        public T widthAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.widthPx(this.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T widthAttr(@AttrRes int resId) {
            return this.widthAttr(resId, 0);
        }

        public T widthDip(@Dimension(unit=0) float width) {
            return this.widthPx(this.dipsToPixels(width));
        }

        public T minWidthPx(@Px int minWidth) {
            this.mComponent.getOrCreateLayoutAttributes().minWidthPx(minWidth);
            return this.getThis();
        }

        public T minWidthPercent(float percent) {
            this.mComponent.getOrCreateLayoutAttributes().minWidthPercent(percent);
            return this.getThis();
        }

        public T minWidthAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.minWidthPx(this.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T minWidthAttr(@AttrRes int resId) {
            return this.minWidthAttr(resId, 0);
        }

        public T minWidthRes(@DimenRes int resId) {
            return this.minWidthPx(this.resolveDimenSizeRes(resId));
        }

        public T minWidthDip(@Dimension(unit=0) float minWidth) {
            return this.minWidthPx(this.dipsToPixels(minWidth));
        }

        public T maxWidthPx(@Px int maxWidth) {
            this.mComponent.getOrCreateLayoutAttributes().maxWidthPx(maxWidth);
            return this.getThis();
        }

        public T maxWidthPercent(float percent) {
            this.mComponent.getOrCreateLayoutAttributes().maxWidthPercent(percent);
            return this.getThis();
        }

        public T maxWidthAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.maxWidthPx(this.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T maxWidthAttr(@AttrRes int resId) {
            return this.maxWidthAttr(resId, 0);
        }

        public T maxWidthRes(@DimenRes int resId) {
            return this.maxWidthPx(this.resolveDimenSizeRes(resId));
        }

        public T maxWidthDip(@Dimension(unit=0) float maxWidth) {
            return this.maxWidthPx(this.dipsToPixels(maxWidth));
        }

        public T heightPx(@Px int height) {
            this.mComponent.getOrCreateLayoutAttributes().heightPx(height);
            return this.getThis();
        }

        public T heightPercent(float percent) {
            this.mComponent.getOrCreateLayoutAttributes().heightPercent(percent);
            return this.getThis();
        }

        public T heightRes(@DimenRes int resId) {
            return this.heightPx(this.resolveDimenSizeRes(resId));
        }

        public T heightAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.heightPx(this.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T heightAttr(@AttrRes int resId) {
            return this.heightAttr(resId, 0);
        }

        public T heightDip(@Dimension(unit=0) float height) {
            return this.heightPx(this.dipsToPixels(height));
        }

        public T minHeightPx(@Px int minHeight) {
            this.mComponent.getOrCreateLayoutAttributes().minHeightPx(minHeight);
            return this.getThis();
        }

        public T minHeightPercent(float percent) {
            this.mComponent.getOrCreateLayoutAttributes().minHeightPercent(percent);
            return this.getThis();
        }

        public T minHeightAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.minHeightPx(this.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T minHeightAttr(@AttrRes int resId) {
            return this.minHeightAttr(resId, 0);
        }

        public T minHeightRes(@DimenRes int resId) {
            return this.minHeightPx(this.resolveDimenSizeRes(resId));
        }

        public T minHeightDip(@Dimension(unit=0) float minHeight) {
            return this.minHeightPx(this.dipsToPixels(minHeight));
        }

        public T maxHeightPx(@Px int maxHeight) {
            this.mComponent.getOrCreateLayoutAttributes().maxHeightPx(maxHeight);
            return this.getThis();
        }

        public T maxHeightPercent(float percent) {
            this.mComponent.getOrCreateLayoutAttributes().maxHeightPercent(percent);
            return this.getThis();
        }

        public T maxHeightAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.maxHeightPx(this.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T maxHeightAttr(@AttrRes int resId) {
            return this.maxHeightAttr(resId, 0);
        }

        public T maxHeightRes(@DimenRes int resId) {
            return this.maxHeightPx(this.resolveDimenSizeRes(resId));
        }

        public T maxHeightDip(@Dimension(unit=0) float maxHeight) {
            return this.maxHeightPx(this.dipsToPixels(maxHeight));
        }

        public T aspectRatio(float aspectRatio) {
            this.mComponent.getOrCreateLayoutAttributes().aspectRatio(aspectRatio);
            return this.getThis();
        }

        public T touchExpansionPx(YogaEdge edge, @Px int touchExpansion) {
            this.mComponent.getOrCreateLayoutAttributes().touchExpansionPx(edge, touchExpansion);
            return this.getThis();
        }

        public T touchExpansionAttr(YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
            return this.touchExpansionPx(edge, this.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T touchExpansionAttr(YogaEdge edge, @AttrRes int resId) {
            return this.touchExpansionAttr(edge, resId, 0);
        }

        public T touchExpansionRes(YogaEdge edge, @DimenRes int resId) {
            return this.touchExpansionPx(edge, this.resolveDimenSizeRes(resId));
        }

        public T touchExpansionDip(YogaEdge edge, @Dimension(unit=0) float touchExpansion) {
            return this.touchExpansionPx(edge, this.dipsToPixels(touchExpansion));
        }

        public T background(Reference<? extends Drawable> background) {
            this.mComponent.getOrCreateLayoutAttributes().background(background);
            return this.getThis();
        }

        public T background(Reference.Builder<? extends Drawable> builder) {
            return this.background(builder.build());
        }

        public T background(Drawable background) {
            return this.background(DrawableReference.create().drawable(background));
        }

        public T backgroundAttr(@AttrRes int resId, @DrawableRes int defaultResId) {
            return this.backgroundRes(this.resolveResIdAttr(resId, defaultResId));
        }

        public T backgroundAttr(@AttrRes int resId) {
            return this.backgroundAttr(resId, 0);
        }

        public T backgroundRes(@DrawableRes int resId) {
            if (resId == 0) {
                return this.background((Reference<Drawable>)null);
            }
            return this.background(this.mContext.getResources().getDrawable(resId));
        }

        public T backgroundColor(@ColorInt int backgroundColor) {
            return this.background((Drawable)new ColorDrawable(backgroundColor));
        }

        public T foreground(Drawable foreground) {
            this.mComponent.getOrCreateLayoutAttributes().foreground(foreground);
            return this.getThis();
        }

        public T foregroundAttr(@AttrRes int resId, @DrawableRes int defaultResId) {
            return this.foregroundRes(this.resolveResIdAttr(resId, defaultResId));
        }

        public T foregroundAttr(@AttrRes int resId) {
            return this.foregroundAttr(resId, 0);
        }

        public T foregroundRes(@DrawableRes int resId) {
            if (resId == 0) {
                return this.foreground(null);
            }
            return this.foreground(this.mContext.getResources().getDrawable(resId));
        }

        public T foregroundColor(@ColorInt int foregroundColor) {
            return this.foreground((Drawable)new ColorDrawable(foregroundColor));
        }

        public T wrapInView() {
            this.mComponent.getOrCreateLayoutAttributes().wrapInView();
            return this.getThis();
        }

        public T clickHandler(EventHandler<ClickEvent> clickHandler) {
            this.mComponent.getOrCreateLayoutAttributes().clickHandler(clickHandler);
            return this.getThis();
        }

        public T longClickHandler(EventHandler<LongClickEvent> longClickHandler) {
            this.mComponent.getOrCreateLayoutAttributes().longClickHandler(longClickHandler);
            return this.getThis();
        }

        public T focusChangeHandler(EventHandler<FocusChangedEvent> focusChangeHandler) {
            this.mComponent.getOrCreateLayoutAttributes().focusChangeHandler(focusChangeHandler);
            return this.getThis();
        }

        public T touchHandler(EventHandler<TouchEvent> touchHandler) {
            this.mComponent.getOrCreateLayoutAttributes().touchHandler(touchHandler);
            return this.getThis();
        }

        public T interceptTouchHandler(EventHandler<InterceptTouchEvent> interceptTouchHandler) {
            this.mComponent.getOrCreateLayoutAttributes().interceptTouchHandler(interceptTouchHandler);
            return this.getThis();
        }

        public T focusable(boolean isFocusable) {
            this.mComponent.getOrCreateLayoutAttributes().focusable(isFocusable);
            return this.getThis();
        }

        public T enabled(boolean isEnabled) {
            this.mComponent.getOrCreateLayoutAttributes().enabled(isEnabled);
            return this.getThis();
        }

        public T visibleHeightRatio(float visibleHeightRatio) {
            this.mComponent.getOrCreateLayoutAttributes().visibleHeightRatio(visibleHeightRatio);
            return this.getThis();
        }

        public T visibleWidthRatio(float visibleWidthRatio) {
            this.mComponent.getOrCreateLayoutAttributes().visibleWidthRatio(visibleWidthRatio);
            return this.getThis();
        }

        public T visibleHandler(EventHandler<VisibleEvent> visibleHandler) {
            this.mComponent.getOrCreateLayoutAttributes().visibleHandler(visibleHandler);
            return this.getThis();
        }

        public T focusedHandler(EventHandler<FocusedVisibleEvent> focusedHandler) {
            this.mComponent.getOrCreateLayoutAttributes().focusedHandler(focusedHandler);
            return this.getThis();
        }

        public T unfocusedHandler(EventHandler<UnfocusedVisibleEvent> unfocusedHandler) {
            this.mComponent.getOrCreateLayoutAttributes().unfocusedHandler(unfocusedHandler);
            return this.getThis();
        }

        public T fullImpressionHandler(EventHandler<FullImpressionVisibleEvent> fullImpressionHandler) {
            this.mComponent.getOrCreateLayoutAttributes().fullImpressionHandler(fullImpressionHandler);
            return this.getThis();
        }

        public T invisibleHandler(EventHandler<InvisibleEvent> invisibleHandler) {
            this.mComponent.getOrCreateLayoutAttributes().invisibleHandler(invisibleHandler);
            return this.getThis();
        }

        public T contentDescription(CharSequence contentDescription) {
            this.mComponent.getOrCreateLayoutAttributes().contentDescription(contentDescription);
            return this.getThis();
        }

        public T contentDescription(@StringRes int stringId) {
            return this.contentDescription(this.mContext.getResources().getString(stringId));
        }

        public T contentDescription(@StringRes int stringId, Object ... formatArgs) {
            return this.contentDescription(this.mContext.getResources().getString(stringId, formatArgs));
        }

        public T viewTag(Object viewTag) {
            this.mComponent.getOrCreateLayoutAttributes().viewTag(viewTag);
            return this.getThis();
        }

        public T viewTags(SparseArray<Object> viewTags) {
            this.mComponent.getOrCreateLayoutAttributes().viewTags(viewTags);
            return this.getThis();
        }

        public T shadowElevationPx(float shadowElevation) {
            this.mComponent.getOrCreateLayoutAttributes().shadowElevationPx(shadowElevation);
            return this.getThis();
        }

        public T shadowElevationAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.shadowElevationPx(this.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T shadowElevationAttr(@AttrRes int resId) {
            return this.shadowElevationAttr(resId, 0);
        }

        public T shadowElevationRes(@DimenRes int resId) {
            return this.shadowElevationPx(this.resolveDimenSizeRes(resId));
        }

        public T shadowElevationDip(@Dimension(unit=0) float shadowElevation) {
            return this.shadowElevationPx(this.dipsToPixels(shadowElevation));
        }

        public T outlineProvider(ViewOutlineProvider outlineProvider) {
            this.mComponent.getOrCreateLayoutAttributes().outlineProvider(outlineProvider);
            return this.getThis();
        }

        public T clipToOutline(boolean clipToOutline) {
            this.mComponent.getOrCreateLayoutAttributes().clipToOutline(clipToOutline);
            return this.getThis();
        }

        public T testKey(String testKey) {
            this.mComponent.getOrCreateLayoutAttributes().testKey(testKey);
            return this.getThis();
        }

        public T dispatchPopulateAccessibilityEventHandler(EventHandler<DispatchPopulateAccessibilityEventEvent> dispatchPopulateAccessibilityEventHandler) {
            this.mComponent.getOrCreateLayoutAttributes().dispatchPopulateAccessibilityEventHandler(dispatchPopulateAccessibilityEventHandler);
            return this.getThis();
        }

        public T onInitializeAccessibilityEventHandler(EventHandler<OnInitializeAccessibilityEventEvent> onInitializeAccessibilityEventHandler) {
            this.mComponent.getOrCreateLayoutAttributes().onInitializeAccessibilityEventHandler(onInitializeAccessibilityEventHandler);
            return this.getThis();
        }

        public T onInitializeAccessibilityNodeInfoHandler(EventHandler<OnInitializeAccessibilityNodeInfoEvent> onInitializeAccessibilityNodeInfoHandler) {
            this.mComponent.getOrCreateLayoutAttributes().onInitializeAccessibilityNodeInfoHandler(onInitializeAccessibilityNodeInfoHandler);
            return this.getThis();
        }

        public T onPopulateAccessibilityEventHandler(EventHandler<OnPopulateAccessibilityEventEvent> onPopulateAccessibilityEventHandler) {
            this.mComponent.getOrCreateLayoutAttributes().onPopulateAccessibilityEventHandler(onPopulateAccessibilityEventHandler);
            return this.getThis();
        }

        public T onRequestSendAccessibilityEventHandler(EventHandler<OnRequestSendAccessibilityEventEvent> onRequestSendAccessibilityEventHandler) {
            this.mComponent.getOrCreateLayoutAttributes().onRequestSendAccessibilityEventHandler(onRequestSendAccessibilityEventHandler);
            return this.getThis();
        }

        public T performAccessibilityActionHandler(EventHandler<PerformAccessibilityActionEvent> performAccessibilityActionHandler) {
            this.mComponent.getOrCreateLayoutAttributes().performAccessibilityActionHandler(performAccessibilityActionHandler);
            return this.getThis();
        }

        public T sendAccessibilityEventHandler(EventHandler<SendAccessibilityEventEvent> sendAccessibilityEventHandler) {
            this.mComponent.getOrCreateLayoutAttributes().sendAccessibilityEventHandler(sendAccessibilityEventHandler);
            return this.getThis();
        }

        public T sendAccessibilityEventUncheckedHandler(EventHandler<SendAccessibilityEventUncheckedEvent> sendAccessibilityEventUncheckedHandler) {
            this.mComponent.getOrCreateLayoutAttributes().sendAccessibilityEventUncheckedHandler(sendAccessibilityEventUncheckedHandler);
            return this.getThis();
        }

        public T transitionKey(String key) {
            this.mComponent.getOrCreateLayoutAttributes().transitionKey(key);
            return this.getThis();
        }

        public T alpha(float alpha) {
            this.mComponent.getOrCreateLayoutAttributes().alpha(alpha);
            return this.getThis();
        }

        public T scale(float scale) {
            this.mComponent.getOrCreateLayoutAttributes().scale(scale);
            return this.getThis();
        }
    }
}

