/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.facebook.litho.MatrixDrawable;

public class BoundsHelper {
    public static void applyBoundsToView(View view, int left, int top, int right, int bottom, boolean force) {
        int width = right - left;
        int height = bottom - top;
        if (force || view.getMeasuredHeight() != height || view.getMeasuredWidth() != width) {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        }
        if (force || view.getLeft() != left || view.getTop() != top || view.getRight() != right || view.getBottom() != bottom) {
            view.layout(left, top, right, bottom);
        }
    }

    public static void applySizeToDrawableForAnimation(Drawable drawable, int width, int height) {
        Rect bounds = drawable.getBounds();
        drawable.setBounds(bounds.left, bounds.top, bounds.left + width, bounds.right + height);
        if (drawable instanceof MatrixDrawable) {
            ((MatrixDrawable)drawable).bind(width, height);
        }
    }
}

