/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;

public class BorderColorDrawable
extends Drawable {
    private static final int QUICK_REJECT_COLOR = 0;
    private static final float CLIP_ANGLE = 45.0f;
    private static final RectF mClipBounds = new RectF();
    private static final RectF mDrawBounds = new RectF();
    private final Paint mPaint = new Paint();
    private float mBorderLeftWidth;
    private float mBorderTopWidth;
    private float mBorderRightWidth;
    private float mBorderBottomWidth;
    @ColorInt
    private int mBorderLeftColor;
    @ColorInt
    private int mBorderTopColor;
    @ColorInt
    private int mBorderRightColor;
    @ColorInt
    private int mBorderBottomColor;

    BorderColorDrawable() {
    }

    public void init(PathEffect pathEffect, float leftBorderWidth, float topBorderWidth, float rightBorderWidth, float bottomBorderWidth, @ColorInt int leftBorderColor, @ColorInt int topBorderColor, @ColorInt int rightBorderColor, @ColorInt int bottomBorderColor) {
        this.mBorderLeftWidth = leftBorderWidth;
        this.mBorderTopWidth = topBorderWidth;
        this.mBorderRightWidth = rightBorderWidth;
        this.mBorderBottomWidth = bottomBorderWidth;
        this.mBorderLeftColor = leftBorderColor;
        this.mBorderTopColor = topBorderColor;
        this.mBorderRightColor = rightBorderColor;
        this.mBorderBottomColor = bottomBorderColor;
        this.mPaint.setPathEffect(pathEffect);
        this.mPaint.setAntiAlias(pathEffect != null);
        this.mPaint.setStyle(Paint.Style.STROKE);
    }

    public void draw(Canvas canvas) {
        boolean equalBorderWidths;
        boolean equalBorderColors = this.mBorderLeftColor == this.mBorderTopColor && this.mBorderTopColor == this.mBorderRightColor && this.mBorderRightColor == this.mBorderBottomColor;
        boolean bl = equalBorderWidths = this.mBorderLeftWidth == this.mBorderTopWidth && this.mBorderTopWidth == this.mBorderRightWidth && this.mBorderRightWidth == this.mBorderBottomWidth;
        if (equalBorderWidths && this.mBorderLeftWidth == 0.0f) {
            return;
        }
        if (equalBorderWidths && equalBorderColors) {
            this.drawAllBorders(canvas, this.mBorderLeftWidth, this.mBorderLeftColor);
        } else if (equalBorderWidths) {
            this.drawMultiColoredBorders(canvas);
        } else {
            this.drawIndividualBorders(canvas);
        }
    }

    private void drawAllBorders(Canvas canvas, float strokeWidth, @ColorInt int color) {
        float inset = strokeWidth / 2.0f;
        mDrawBounds.set(this.getBounds());
        mDrawBounds.inset(inset, inset);
        this.mPaint.setStrokeWidth(strokeWidth);
        this.mPaint.setColor(color);
        canvas.drawRect(mDrawBounds, this.mPaint);
    }

    private void drawMultiColoredBorders(Canvas canvas) {
        int saveCount;
        float inset = this.mBorderLeftWidth / 2.0f;
        mDrawBounds.set(this.getBounds());
        int translateSaveCount = canvas.save();
        canvas.translate(BorderColorDrawable.mDrawBounds.left, BorderColorDrawable.mDrawBounds.top);
        mDrawBounds.offsetTo(0.0f, 0.0f);
        this.mPaint.setStrokeWidth(this.mBorderLeftWidth);
        int height = Math.round(mDrawBounds.height());
        int width = Math.round(mDrawBounds.width());
        int hypotenuse = (int)Math.round(Math.sqrt(2.0f * ((float)height / 2.0f) * ((float)height / 2.0f)));
        mDrawBounds.inset(inset, inset);
        if (this.mBorderLeftColor != 0) {
            saveCount = canvas.save();
            canvas.rotate(45.0f, 0.0f, 0.0f);
            canvas.clipRect(0.0f, 0.0f, (float)hypotenuse, (float)hypotenuse);
            canvas.rotate(-45.0f, 0.0f, 0.0f);
            this.mPaint.setColor(this.mBorderLeftColor);
            canvas.drawRect(mDrawBounds, this.mPaint);
            canvas.restoreToCount(saveCount);
        }
        if (this.mBorderRightColor != 0) {
            saveCount = canvas.save();
            canvas.rotate(-45.0f, (float)width, 0.0f);
            canvas.clipRect((float)(width - hypotenuse), 0.0f, (float)width, (float)hypotenuse);
            canvas.rotate(45.0f, (float)width, 0.0f);
            this.mPaint.setColor(this.mBorderRightColor);
            canvas.drawRect(mDrawBounds, this.mPaint);
            canvas.restoreToCount(saveCount);
        }
        if (this.mBorderTopColor != 0) {
            saveCount = canvas.save();
            canvas.rotate(-45.0f, 0.0f, 0.0f);
            canvas.clipRect(0.0f, 0.0f, (float)hypotenuse, (float)hypotenuse);
            canvas.rotate(45.0f, 0.0f, 0.0f);
            canvas.rotate(45.0f, (float)width, 0.0f);
            canvas.clipRect((float)(width - hypotenuse), 0.0f, (float)width, (float)hypotenuse, Region.Op.UNION);
            canvas.rotate(-45.0f, (float)width, 0.0f);
            canvas.clipRect((float)hypotenuse, 0.0f, (float)(width - hypotenuse), (float)hypotenuse, Region.Op.UNION);
            this.mPaint.setColor(this.mBorderTopColor);
            canvas.drawRect(mDrawBounds, this.mPaint);
            canvas.restoreToCount(saveCount);
        }
        if (this.mBorderBottomColor != 0) {
            saveCount = canvas.save();
            canvas.rotate(45.0f, 0.0f, (float)height);
            canvas.clipRect(0.0f, (float)(height - hypotenuse), (float)hypotenuse, (float)height);
            canvas.rotate(-45.0f, 0.0f, (float)height);
            canvas.rotate(-45.0f, (float)width, (float)height);
            canvas.clipRect((float)(width - hypotenuse), (float)(height - hypotenuse), (float)width, (float)height, Region.Op.UNION);
            canvas.rotate(45.0f, (float)width, (float)height);
            canvas.clipRect((float)hypotenuse, (float)(height - hypotenuse), (float)(width - hypotenuse), (float)height, Region.Op.UNION);
            this.mPaint.setColor(this.mBorderBottomColor);
            canvas.drawRect(mDrawBounds, this.mPaint);
            canvas.restoreToCount(saveCount);
        }
        canvas.restoreToCount(translateSaveCount);
    }

    private void drawIndividualBorders(Canvas canvas) {
        Rect bounds = this.getBounds();
        if (this.mBorderLeftWidth > 0.0f && this.mBorderLeftColor != 0) {
            this.drawBorder(canvas, this.mBorderLeftColor, this.mBorderLeftWidth, bounds.left, bounds.top, Math.min((float)bounds.left + this.mBorderLeftWidth, (float)bounds.right), bounds.bottom, true);
        }
        if (this.mBorderRightWidth > 0.0f && this.mBorderRightColor != 0) {
            this.drawBorder(canvas, this.mBorderRightColor, this.mBorderRightWidth, Math.max((float)bounds.right - this.mBorderRightWidth, (float)bounds.left), bounds.top, bounds.right, bounds.bottom, true);
        }
        if (this.mBorderTopWidth > 0.0f && this.mBorderTopColor != 0) {
            this.drawBorder(canvas, this.mBorderTopColor, this.mBorderTopWidth, bounds.left, bounds.top, bounds.right, Math.min((float)bounds.top + this.mBorderTopWidth, (float)bounds.bottom), false);
        }
        if (this.mBorderBottomWidth > 0.0f && this.mBorderBottomColor != 0) {
            this.drawBorder(canvas, this.mBorderBottomColor, this.mBorderBottomWidth, bounds.left, Math.max((float)bounds.bottom - this.mBorderBottomWidth, (float)bounds.top), bounds.right, bounds.bottom, false);
        }
    }

    private void drawBorder(Canvas canvas, @ColorInt int color, float strokeWidth, float left, float top, float right, float bottom, boolean insetHorizontal) {
        this.mPaint.setStrokeWidth(strokeWidth);
        this.mPaint.setColor(color);
        mClipBounds.set(left, top, right, bottom);
        mDrawBounds.set(this.getBounds());
        if (insetHorizontal) {
            mDrawBounds.inset(mClipBounds.centerX() - BorderColorDrawable.mClipBounds.left, 0.0f);
        } else {
            mDrawBounds.inset(0.0f, mClipBounds.centerY() - BorderColorDrawable.mClipBounds.top);
        }
        int saveCount = canvas.save();
        canvas.clipRect(mClipBounds);
        canvas.drawRect(mDrawBounds, this.mPaint);
        canvas.restoreToCount(saveCount);
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -1;
    }
}

