/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.ComposePathEffect;
import android.graphics.CornerPathEffect;
import android.graphics.DashPathEffect;
import android.graphics.DiscretePathEffect;
import android.graphics.Path;
import android.graphics.PathDashPathEffect;
import android.graphics.PathEffect;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ResourceResolver;
import com.facebook.yoga.YogaEdge;

public class Border {
    static final int EDGE_LEFT = 0;
    static final int EDGE_TOP = 1;
    static final int EDGE_RIGHT = 2;
    static final int EDGE_BOTTOM = 3;
    static final int EDGE_COUNT = 4;
    final int[] mEdgeWidths = new int[4];
    final int[] mEdgeColors = new int[4];
    PathEffect mPathEffect;

    public static Builder create(ComponentContext context) {
        return new Builder(context);
    }

    private Border() {
    }

    void setEdgeWidth(YogaEdge edge, int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Given negative border width value: " + width + " for edge " + edge.name());
        }
        Border.setEdgeValue(this.mEdgeWidths, edge, width);
    }

    void setEdgeColor(YogaEdge edge, @ColorInt int color) {
        Border.setEdgeValue(this.mEdgeColors, edge, color);
    }

    static int getEdgeColor(int[] colorArray, YogaEdge edge) {
        if (colorArray.length != 4) {
            throw new IllegalArgumentException("Given wrongly sized array");
        }
        return colorArray[Border.edgeIndex(edge)];
    }

    static YogaEdge edgeFromIndex(int i) {
        if (i < 0 || i >= 4) {
            throw new IllegalArgumentException("Given index out of range of acceptable edges: " + i);
        }
        switch (i) {
            case 0: {
                return YogaEdge.LEFT;
            }
            case 1: {
                return YogaEdge.TOP;
            }
            case 2: {
                return YogaEdge.RIGHT;
            }
            case 3: {
                return YogaEdge.BOTTOM;
            }
        }
        throw new IllegalArgumentException("Given unknown edge index: " + i);
    }

    static boolean equalValues(int[] values) {
        if (values.length != 4) {
            throw new IllegalArgumentException("Given wrongly sized array");
        }
        int lastValue = values[0];
        int length = values.length;
        for (int i = 1; i < length; ++i) {
            if (lastValue == values[i]) continue;
            return false;
        }
        return true;
    }

    private static void setEdgeValue(int[] edges, YogaEdge edge, int value) {
        switch (edge) {
            case ALL: {
                for (int i = 0; i < 4; ++i) {
                    edges[i] = value;
                }
                break;
            }
            case VERTICAL: {
                edges[1] = value;
                edges[3] = value;
                break;
            }
            case HORIZONTAL: {
                edges[0] = value;
                edges[2] = value;
                break;
            }
            default: {
                edges[Border.edgeIndex((YogaEdge)edge)] = value;
            }
        }
    }

    private static int edgeIndex(YogaEdge edge) {
        switch (edge) {
            case START: 
            case LEFT: {
                return 0;
            }
            case TOP: {
                return 1;
            }
            case END: 
            case RIGHT: {
                return 2;
            }
            case BOTTOM: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Given unsupported edge " + edge.name());
    }

    public static class Builder {
        private static final int MAX_PATH_EFFECTS = 2;
        private final Border mBorder;
        @Nullable
        private ResourceResolver mResourceResolver;
        private PathEffect[] mPathEffects = new PathEffect[2];
        private int mNumPathEffects;

        Builder(ComponentContext context) {
            this.mResourceResolver = new ResourceResolver();
            this.mResourceResolver.init(context, context.getResourceCache());
            this.mBorder = new Border();
        }

        public Builder widthPx(YogaEdge edge, @Px int width) {
            this.checkNotBuilt();
            this.mBorder.setEdgeWidth(edge, width);
            return this;
        }

        public Builder widthDip(YogaEdge edge, @Dimension(unit=0) int width) {
            this.checkNotBuilt();
            return this.widthPx(edge, this.mResourceResolver.dipsToPixels(width));
        }

        public Builder widthRes(YogaEdge edge, @DimenRes int widthRes) {
            this.checkNotBuilt();
            return this.widthPx(edge, this.mResourceResolver.resolveDimenSizeRes(widthRes));
        }

        public Builder widthAttr(YogaEdge edge, @AttrRes int attrId) {
            this.checkNotBuilt();
            return this.widthAttr(edge, attrId, 0);
        }

        public Builder widthAttr(YogaEdge edge, @AttrRes int attrId, @DimenRes int defaultResId) {
            this.checkNotBuilt();
            return this.widthPx(edge, this.mResourceResolver.resolveDimenSizeAttr(attrId, defaultResId));
        }

        public Builder color(YogaEdge edge, @ColorInt int color) {
            this.checkNotBuilt();
            this.mBorder.setEdgeColor(edge, color);
            return this;
        }

        public Builder colorRes(YogaEdge edge, @ColorRes int colorRes) {
            this.checkNotBuilt();
            return this.color(edge, this.mResourceResolver.resolveColorRes(colorRes));
        }

        public Builder dashEffect(float[] intervals, float phase) {
            this.checkNotBuilt();
            this.checkEffectCount();
            this.mPathEffects[this.mNumPathEffects++] = new DashPathEffect(intervals, phase);
            return this;
        }

        public Builder cornerEffect(float radius) {
            this.checkNotBuilt();
            this.checkEffectCount();
            this.mPathEffects[this.mNumPathEffects++] = new CornerPathEffect(radius);
            return this;
        }

        public Builder discreteEffect(float segmentLength, float deviation) {
            this.checkNotBuilt();
            this.checkEffectCount();
            this.mPathEffects[this.mNumPathEffects++] = new DiscretePathEffect(segmentLength, deviation);
            return this;
        }

        public Builder pathDashEffect(Path shape, float advance, float phase, PathDashPathEffect.Style style) {
            this.checkNotBuilt();
            this.checkEffectCount();
            this.mPathEffects[this.mNumPathEffects++] = new PathDashPathEffect(shape, advance, phase, style);
            return this;
        }

        public Border build() {
            this.checkNotBuilt();
            this.mResourceResolver.release();
            this.mResourceResolver = null;
            if (this.mNumPathEffects == 2) {
                this.mBorder.mPathEffect = new ComposePathEffect(this.mPathEffects[0], this.mPathEffects[1]);
            } else if (this.mNumPathEffects > 0) {
                this.mBorder.mPathEffect = this.mPathEffects[0];
            }
            if (this.mBorder.mPathEffect != null && !Border.equalValues(this.mBorder.mEdgeWidths)) {
                throw new IllegalArgumentException("Borders do not currently support different widths with a path effect");
            }
            return this.mBorder;
        }

        private void checkNotBuilt() {
            if (this.mResourceResolver == null) {
                throw new IllegalStateException("This builder has already been disposed / built!");
            }
        }

        private void checkEffectCount() {
            if (this.mNumPathEffects >= 2) {
                throw new IllegalArgumentException("You cannot specify more than 2 effects to compose");
            }
        }
    }
}

