/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.LogEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class BaseComponentsLogger
implements ComponentsLogger {
    private static final Set<String> sStackTraceKeywords = new HashSet<String>();
    private static final Set<String> sStackTraceBlacklist = new HashSet<String>();

    @Override
    public LogEvent newEvent(int eventId) {
        return ComponentsPools.acquireLogEvent(eventId);
    }

    @Override
    public LogEvent newPerformanceEvent(int eventId) {
        LogEvent event = this.newEvent(eventId);
        event.setIsPerformanceEvent(true);
        this.onPerformanceEventStarted(event);
        return event;
    }

    @Override
    public void log(LogEvent event) {
        if (event.isPerformanceEvent()) {
            this.onPerformanceEventEnded(event);
        } else {
            this.onEvent(event);
        }
        ComponentsPools.release(event);
    }

    @Override
    public Set<String> getKeyCollisionStackTraceKeywords() {
        return Collections.unmodifiableSet(sStackTraceKeywords);
    }

    @Override
    public Set<String> getKeyCollisionStackTraceBlacklist() {
        return Collections.unmodifiableSet(sStackTraceBlacklist);
    }

    public abstract void onPerformanceEventStarted(LogEvent var1);

    public abstract void onPerformanceEventEnded(LogEvent var1);

    public abstract void onEvent(LogEvent var1);

    static {
        sStackTraceKeywords.add("Spec.java");
        sStackTraceKeywords.add("Activity.java");
    }
}

