/*
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

package com.facebook.litho;

import static com.facebook.litho.EventDispatcherUtils.dispatchOnTouch;

import android.view.MotionEvent;
import android.view.View;

/**
 * Touch listener that triggers its underlying event handler.
 */
class ComponentTouchListener implements View.OnTouchListener {
  private EventHandler<TouchEvent> mEventHandler;

  EventHandler<TouchEvent> getEventHandler() {
    return mEventHandler;
  }

  void setEventHandler(EventHandler<TouchEvent> eventHandler) {
    mEventHandler = eventHandler;
  }

  @Override
  public boolean onTouch(View v, MotionEvent event) {
    return mEventHandler != null && dispatchOnTouch(mEventHandler, v, event);
  }
}
