/*
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

package com.facebook.litho;

import android.graphics.Rect;

/**
 * Interface used to expose a limited API of {@link LayoutOutput} to the animations package.
 */
public interface AnimatableItem {

  Rect getBounds();
  float getScale();
  float getAlpha();

  boolean isScaleSet();
  boolean isAlphaSet();
}
