/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.stats;

import androidx.annotation.VisibleForTesting;
import java.util.concurrent.atomic.AtomicLong;

public final class LithoStats {
    private static final AtomicLong sComponentAppliedStateUpdateCount = new AtomicLong(0L);
    private static final AtomicLong sComponentTriggeredSyncStateUpdateCount = new AtomicLong(0L);
    private static final AtomicLong sComponentTriggeredAsyncStateUpdateCount = new AtomicLong(0L);
    private static final AtomicLong sComponentCalculateLayoutCount = new AtomicLong(0L);
    private static final AtomicLong sComponentCalculateLayoutOnUICount = new AtomicLong(0L);
    private static final AtomicLong sComponentMountCount = new AtomicLong(0L);
    private static final AtomicLong sSectionAppliedStateUpdateCount = new AtomicLong(0L);
    private static final AtomicLong sSectionTriggeredSyncStateUpdateCount = new AtomicLong(0L);
    private static final AtomicLong sSectionTriggeredAsyncStateUpdateCount = new AtomicLong(0L);
    private static final AtomicLong sSectionCalculateNewChangesetCount = new AtomicLong(0L);
    private static final AtomicLong sSectionCalculateNewChangesetOnUICount = new AtomicLong(0L);

    public static long getComponentAppliedStateUpdateCount() {
        return sComponentAppliedStateUpdateCount.get();
    }

    public static long getComponentTriggeredSyncStateUpdateCount() {
        return sComponentTriggeredSyncStateUpdateCount.get();
    }

    public static long getComponentTriggeredAsyncStateUpdateCount() {
        return sComponentTriggeredAsyncStateUpdateCount.get();
    }

    public static long getComponentCalculateLayoutCount() {
        return sComponentCalculateLayoutCount.get();
    }

    public static long getComponentCalculateLayoutOnUICount() {
        return sComponentCalculateLayoutOnUICount.get();
    }

    public static long getComponentMountCount() {
        return sComponentMountCount.get();
    }

    public static long getSectionAppliedStateUpdateCount() {
        return sSectionAppliedStateUpdateCount.get();
    }

    public static long getSectionTriggeredSyncStateUpdateCount() {
        return sSectionTriggeredSyncStateUpdateCount.get();
    }

    public static long getSectionTriggeredAsyncStateUpdateCount() {
        return sSectionTriggeredAsyncStateUpdateCount.get();
    }

    public static long getSectionCalculateNewChangesetCount() {
        return sSectionCalculateNewChangesetCount.get();
    }

    public static long getSectionCalculateNewChangesetOnUICount() {
        return sSectionCalculateNewChangesetOnUICount.get();
    }

    public static long incrementComponentAppliedStateUpdateCountBy(long num) {
        return sComponentAppliedStateUpdateCount.addAndGet(num);
    }

    public static long incrementComponentStateUpdateSyncCount() {
        return sComponentTriggeredSyncStateUpdateCount.addAndGet(1L);
    }

    public static long incrementComponentStateUpdateAsyncCount() {
        return sComponentTriggeredAsyncStateUpdateCount.addAndGet(1L);
    }

    @VisibleForTesting
    public static void resetComponentStateUpdateAsyncCount() {
        sComponentTriggeredAsyncStateUpdateCount.set(0L);
    }

    public static long incrementComponentCalculateLayoutCount() {
        return sComponentCalculateLayoutCount.addAndGet(1L);
    }

    public static long incrementComponentCalculateLayoutOnUICount() {
        return sComponentCalculateLayoutOnUICount.addAndGet(1L);
    }

    public static long incrementComponentMountCount() {
        return sComponentMountCount.addAndGet(1L);
    }

    public static long incrementSectionAppliedStateUpdateCountBy(long num) {
        return sSectionAppliedStateUpdateCount.addAndGet(num);
    }

    public static long incrementSectionStateUpdateSyncCount() {
        return sSectionTriggeredSyncStateUpdateCount.addAndGet(1L);
    }

    public static long incrementSectionStateUpdateAsyncCount() {
        return sSectionTriggeredAsyncStateUpdateCount.addAndGet(1L);
    }

    public static long incrementSectionCalculateNewChangesetCount() {
        return sSectionCalculateNewChangesetCount.addAndGet(1L);
    }

    public static long incrementSectionCalculateNewChangesetOnUICount() {
        return sSectionCalculateNewChangesetOnUICount.addAndGet(1L);
    }

    @VisibleForTesting
    public static synchronized void resetAllCounters() {
        sComponentAppliedStateUpdateCount.set(0L);
        sComponentTriggeredSyncStateUpdateCount.set(0L);
        sComponentTriggeredAsyncStateUpdateCount.set(0L);
        sComponentCalculateLayoutCount.set(0L);
        sComponentCalculateLayoutOnUICount.set(0L);
        sComponentMountCount.set(0L);
        sSectionAppliedStateUpdateCount.set(0L);
        sSectionTriggeredSyncStateUpdateCount.set(0L);
        sSectionTriggeredAsyncStateUpdateCount.set(0L);
        sSectionCalculateNewChangesetCount.set(0L);
        sSectionCalculateNewChangesetOnUICount.set(0L);
    }
}

