/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.internal;

import androidx.annotation.Nullable;
import java.util.Arrays;

public class SparseFloatArray
implements Cloneable {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    private int[] mKeys;
    private float[] mValues;
    private int mSize;

    public SparseFloatArray() {
        this(2);
    }

    public SparseFloatArray(int initialCapacity) {
        if (initialCapacity == 0) {
            this.mKeys = EMPTY_INT_ARRAY;
            this.mValues = EMPTY_FLOAT_ARRAY;
        } else {
            this.mKeys = new int[initialCapacity];
            this.mValues = new float[this.mKeys.length];
        }
        this.mSize = 0;
    }

    @Nullable
    public SparseFloatArray clone() {
        try {
            SparseFloatArray clone = (SparseFloatArray)super.clone();
            clone.mKeys = (int[])this.mKeys.clone();
            clone.mValues = (float[])this.mValues.clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    public float get(int key) {
        return this.get(key, 0.0f);
    }

    public float get(int key, float valueIfKeyNotFound) {
        int i = SparseFloatArray.binarySearch(this.mKeys, this.mSize, key);
        if (i < 0) {
            return valueIfKeyNotFound;
        }
        return this.mValues[i];
    }

    public void delete(int key) {
        int i = SparseFloatArray.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.removeAt(i);
        }
    }

    public void removeAt(int index) {
        System.arraycopy(this.mKeys, index + 1, this.mKeys, index, this.mSize - (index + 1));
        System.arraycopy(this.mValues, index + 1, this.mValues, index, this.mSize - (index + 1));
        --this.mSize;
    }

    public void put(int key, float value) {
        int i = SparseFloatArray.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = value;
        } else {
            this.mKeys = SparseFloatArray.insert(this.mKeys, this.mSize, i ^= 0xFFFFFFFF, key);
            this.mValues = SparseFloatArray.insert(this.mValues, this.mSize, i, value);
            ++this.mSize;
        }
    }

    public int size() {
        return this.mSize;
    }

    public int keyAt(int index) {
        return this.mKeys[index];
    }

    public float valueAt(int index) {
        return this.mValues[index];
    }

    public void setValueAt(int index, float value) {
        this.mValues[index] = value;
    }

    public int indexOfKey(int key) {
        return SparseFloatArray.binarySearch(this.mKeys, this.mSize, key);
    }

    public int indexOfValue(float value) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.mSize = 0;
    }

    public void append(int key, float value) {
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        this.mKeys = SparseFloatArray.append(this.mKeys, this.mSize, key);
        this.mValues = SparseFloatArray.append(this.mValues, this.mSize, value);
        ++this.mSize;
    }

    @Nullable
    public int[] copyKeys() {
        if (this.size() == 0) {
            return null;
        }
        return Arrays.copyOf(this.mKeys, this.size());
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            int key = this.keyAt(i);
            buffer.append(key);
            buffer.append('=');
            float value = this.valueAt(i);
            buffer.append(value);
        }
        buffer.append('}');
        return buffer.toString();
    }

    private static int binarySearch(int[] array, int size, int value) {
        int lo = 0;
        int hi = size - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midVal = array[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    private static int[] append(int[] array, int currentSize, int element) {
        if (currentSize + 1 > array.length) {
            int[] newArray = new int[SparseFloatArray.growSize(currentSize)];
            System.arraycopy(array, 0, newArray, 0, currentSize);
            array = newArray;
        }
        array[currentSize] = element;
        return array;
    }

    private static int[] insert(int[] array, int currentSize, int index, int element) {
        if (currentSize + 1 <= array.length) {
            System.arraycopy(array, index, array, index + 1, currentSize - index);
            array[index] = element;
            return array;
        }
        int[] newArray = new int[SparseFloatArray.growSize(currentSize)];
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = element;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    private static float[] append(float[] array, int currentSize, float element) {
        if (currentSize + 1 > array.length) {
            float[] newArray = new float[SparseFloatArray.growSize(currentSize)];
            System.arraycopy(array, 0, newArray, 0, currentSize);
            array = newArray;
        }
        array[currentSize] = element;
        return array;
    }

    private static float[] insert(float[] array, int currentSize, int index, float element) {
        if (currentSize + 1 <= array.length) {
            System.arraycopy(array, index, array, index + 1, currentSize - index);
            array[index] = element;
            return array;
        }
        float[] newArray = new float[SparseFloatArray.growSize(currentSize)];
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = element;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    private static int growSize(int currentSize) {
        return currentSize <= 2 ? 4 : currentSize * 2;
    }
}

