/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.drawable;

import android.content.res.ColorStateList;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import com.facebook.litho.CommonUtils;
import com.facebook.litho.drawable.ComparableDrawable;
import java.util.Arrays;

public class ComparableGradientDrawable
extends GradientDrawable
implements ComparableDrawable {
    protected int color;
    protected ColorStateList colorStateList;
    protected int[] colors;
    protected float cornerRadius;
    protected float[] cornerRadii;
    protected int gradientType = 0;
    protected float gradientRadius;
    protected int shape = 0;
    protected int width = -1;
    protected int height = -1;
    protected int strokeWidth = -1;
    protected float strokeDashWidth = 0.0f;
    protected float strokeDashGap = 0.0f;
    protected int strokeColor;
    protected ColorStateList strokeColorStateList;

    public static ComparableGradientDrawable create() {
        return new ComparableGradientDrawable();
    }

    public ComparableGradientDrawable() {
    }

    public ComparableGradientDrawable(GradientDrawable.Orientation orientation, int[] colors) {
        super(orientation, colors);
        this.colors = colors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComparableGradientDrawable)) {
            return false;
        }
        ComparableGradientDrawable that = (ComparableGradientDrawable)o;
        return this.color == that.color && CommonUtils.equals(this.colorStateList, that.colorStateList) && this.cornerRadius == that.cornerRadius && this.gradientType == that.gradientType && this.gradientRadius == that.gradientRadius && this.shape == that.shape && this.width == that.width && this.height == that.height && this.strokeWidth == that.strokeWidth && this.strokeDashWidth == that.strokeDashWidth && this.strokeDashGap == that.strokeDashGap && this.strokeColor == that.strokeColor && this.getOrientationOrNullOnAPI15() == that.getOrientationOrNullOnAPI15() && Arrays.equals(this.colors, that.colors) && Arrays.equals(this.cornerRadii, that.cornerRadii) && CommonUtils.equals(this.strokeColorStateList, that.strokeColorStateList);
    }

    public int hashCode() {
        int result = Arrays.hashCode(new Object[]{this.getOrientationOrNullOnAPI15(), this.color, this.colorStateList, Float.valueOf(this.cornerRadius), this.gradientType, Float.valueOf(this.gradientRadius), this.shape, this.width, this.height, this.strokeWidth, Float.valueOf(this.strokeDashWidth), Float.valueOf(this.strokeDashGap), this.strokeColor, this.strokeColorStateList});
        result = 31 * result + Arrays.hashCode(this.colors);
        result = 31 * result + Arrays.hashCode(this.cornerRadii);
        return result;
    }

    @Nullable
    private GradientDrawable.Orientation getOrientationOrNullOnAPI15() {
        if (Build.VERSION.SDK_INT < 16) {
            return null;
        }
        return this.getOrientation();
    }

    @Override
    public boolean isEquivalentTo(ComparableDrawable other) {
        return this.equals(other);
    }

    public void setColor(int color) {
        super.setColor(color);
        this.color = color;
    }

    public void setColor(ColorStateList color) {
        super.setColor(color);
        this.colorStateList = color;
    }

    public void setColors(int[] colors) {
        super.setColors(colors);
        this.colors = colors;
    }

    public void setCornerRadius(float cornerRadius) {
        super.setCornerRadius(cornerRadius);
        this.cornerRadius = cornerRadius;
    }

    public void setCornerRadii(float[] cornerRadii) {
        super.setCornerRadii(cornerRadii);
        this.cornerRadii = cornerRadii;
    }

    public void setGradientType(int gradientType) {
        super.setGradientType(gradientType);
        this.gradientType = gradientType;
    }

    public void setGradientRadius(float gradientRadius) {
        super.setGradientRadius(gradientRadius);
        this.gradientRadius = gradientRadius;
    }

    public void setShape(int shape) {
        super.setShape(shape);
        this.shape = shape;
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.width = width;
        this.height = height;
    }

    public void setStroke(int width, @ColorInt int color, float dashWidth, float dashGap) {
        super.setStroke(width, color, dashWidth, dashGap);
        this.strokeWidth = width;
        this.strokeDashWidth = dashWidth;
        this.strokeDashGap = dashGap;
        this.strokeColor = color;
    }

    public void setStroke(int width, ColorStateList colorStateList, float dashWidth, float dashGap) {
        super.setStroke(width, colorStateList, dashWidth, dashGap);
        this.strokeWidth = width;
        this.strokeDashWidth = dashWidth;
        this.strokeDashGap = dashGap;
        this.strokeColorStateList = colorStateList;
    }
}

