/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.config;

import android.os.Build;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class DeviceInfoUtils {
    public static final int DEVICEINFO_UNKNOWN = -1;
    public static final int NUM_CORES_NOT_SET = -2;
    private static int sNumCores = -2;
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getName();
            if (path.startsWith("cpu")) {
                for (int i = 3; i < path.length(); ++i) {
                    if (Character.isDigit(path.charAt(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    public static int getNumberOfCPUCores() {
        int cores;
        if (sNumCores != -2) {
            return sNumCores;
        }
        if (Build.VERSION.SDK_INT <= 10) {
            return 1;
        }
        try {
            cores = DeviceInfoUtils.getCoresFromFileInfo("/sys/devices/system/cpu/possible");
            if (cores == -1) {
                cores = DeviceInfoUtils.getCoresFromFileInfo("/sys/devices/system/cpu/present");
            }
            if (cores == -1) {
                cores = DeviceInfoUtils.getCoresFromCPUFileList();
            }
        }
        catch (SecurityException e) {
            cores = -1;
        }
        catch (NullPointerException e) {
            cores = -1;
        }
        sNumCores = cores;
        return cores;
    }

    public static boolean hasMultipleCores() {
        int numCores = DeviceInfoUtils.getNumberOfCPUCores();
        return numCores != -1 && numCores > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCoresFromFileInfo(String fileLocation) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileLocation);
            BufferedReader buf = new BufferedReader(new InputStreamReader(is));
            String fileContents = buf.readLine();
            buf.close();
            int n = DeviceInfoUtils.getCoresFromFileString(fileContents);
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static int getCoresFromFileString(String str) {
        if (str == null || !str.matches("0-[\\d]+$")) {
            return -1;
        }
        int cores = Integer.valueOf(str.substring(2)) + 1;
        return cores;
    }

    private static int getCoresFromCPUFileList() {
        return new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
    }
}

