/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.InternalNode;
import com.facebook.litho.Layout;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.RequiredProp;
import java.util.BitSet;
import javax.annotation.Nullable;

public final class Wrapper
extends Component {
    @Nullable
    @Prop
    Component delegate;

    private Wrapper() {
        super("Wrapper");
    }

    @Override
    protected boolean canResolve() {
        return true;
    }

    public static Builder create(ComponentContext context) {
        return Wrapper.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = new Builder();
        builder.init(context, defStyleAttr, defStyleRes, new Wrapper());
        return builder;
    }

    @Override
    protected Component onCreateLayout(ComponentContext c) {
        return this;
    }

    @Override
    protected InternalNode resolve(ComponentContext c) {
        if (this.delegate == null) {
            return ComponentContext.NULL_LAYOUT;
        }
        return Layout.create(c, this.delegate);
    }

    @Override
    public boolean isEquivalentTo(Component other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Wrapper wrapper = (Wrapper)other;
        if (this.getId() == wrapper.getId()) {
            return true;
        }
        return !(this.delegate != null ? !this.delegate.isEquivalentTo(wrapper.delegate) : wrapper.delegate != null);
    }

    @Override
    protected Component getSimpleNameDelegate() {
        return this.delegate;
    }

    public static class Builder
    extends Component.Builder<Builder> {
        private static final String[] REQUIRED_PROPS_NAMES = new String[]{"delegate"};
        private static final int REQUIRED_PROPS_COUNT = 1;
        private final BitSet mRequired = new BitSet(1);
        private Wrapper mWrapper;

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, Wrapper wrapper) {
            super.init(context, defStyleAttr, defStyleRes, wrapper);
            this.mWrapper = wrapper;
        }

        @RequiredProp(value="delegate")
        public Builder delegate(@Nullable Component delegate) {
            this.mRequired.set(0);
            this.mWrapper.delegate = delegate;
            return this;
        }

        @Override
        protected void setComponent(Component component) {
            this.mWrapper = (Wrapper)component;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        @Override
        public Wrapper build() {
            Builder.checkArgs(1, this.mRequired, REQUIRED_PROPS_NAMES);
            return this.mWrapper;
        }
    }
}

