/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.VisibleForTesting;
import com.facebook.litho.Component;
import com.facebook.litho.LayoutStateContext;
import com.facebook.litho.WorkingRange;
import com.facebook.litho.WorkingRangeStatusHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class WorkingRangeContainer {
    @Nullable
    private Map<String, RangeTuple> mWorkingRanges;

    WorkingRangeContainer() {
    }

    void registerWorkingRange(String name, WorkingRange workingRange, Component component, String globalKey) {
        String key;
        RangeTuple rangeTuple;
        if (this.mWorkingRanges == null) {
            this.mWorkingRanges = new LinkedHashMap<String, RangeTuple>();
        }
        if ((rangeTuple = this.mWorkingRanges.get(key = name + "_" + workingRange.hashCode())) == null) {
            this.mWorkingRanges.put(key, new RangeTuple(name, workingRange, component, globalKey));
        } else {
            rangeTuple.addComponent(component, globalKey);
        }
    }

    void checkWorkingRangeAndDispatch(LayoutStateContext layoutStateContext, int position, int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex, WorkingRangeStatusHandler statusHandler) {
        if (this.mWorkingRanges == null) {
            return;
        }
        for (String key : this.mWorkingRanges.keySet()) {
            RangeTuple rangeTuple = this.mWorkingRanges.get(key);
            int size = rangeTuple.mComponents.size();
            for (int i = 0; i < size; ++i) {
                String globalKey;
                Component component = rangeTuple.mComponents.get(i);
                if (!statusHandler.isInRange(rangeTuple.mName, component, globalKey = rangeTuple.mComponentKeys.get(i)) && WorkingRangeContainer.isEnteringRange(rangeTuple.mWorkingRange, position, firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex)) {
                    component.dispatchOnEnteredRange(component.getScopedContext(layoutStateContext, globalKey), rangeTuple.mName);
                    statusHandler.setEnteredRangeStatus(rangeTuple.mName, component, globalKey);
                    continue;
                }
                if (!statusHandler.isInRange(rangeTuple.mName, component, globalKey) || !WorkingRangeContainer.isExitingRange(rangeTuple.mWorkingRange, position, firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex)) continue;
                component.dispatchOnExitedRange(component.getScopedContext(layoutStateContext, globalKey), rangeTuple.mName);
                statusHandler.setExitedRangeStatus(rangeTuple.mName, component, globalKey);
            }
        }
    }

    void dispatchOnExitedRangeIfNeeded(LayoutStateContext layoutStateContext, WorkingRangeStatusHandler statusHandler) {
        if (this.mWorkingRanges == null) {
            return;
        }
        for (String key : this.mWorkingRanges.keySet()) {
            RangeTuple rangeTuple = this.mWorkingRanges.get(key);
            int size = rangeTuple.mComponents.size();
            for (int i = 0; i < size; ++i) {
                String globalKey;
                Component component = rangeTuple.mComponents.get(i);
                if (!statusHandler.isInRange(rangeTuple.mName, component, globalKey = rangeTuple.mComponentKeys.get(i))) continue;
                component.dispatchOnExitedRange(component.getScopedContext(layoutStateContext, globalKey), rangeTuple.mName);
            }
        }
    }

    static boolean isEnteringRange(WorkingRange workingRange, int position, int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex) {
        return workingRange.shouldEnterRange(position, firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex);
    }

    static boolean isExitingRange(WorkingRange workingRange, int position, int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex) {
        return workingRange.shouldExitRange(position, firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex);
    }

    @VisibleForTesting
    Map<String, RangeTuple> getWorkingRangesForTestOnly() {
        return this.mWorkingRanges != null ? this.mWorkingRanges : new LinkedHashMap<String, RangeTuple>();
    }

    static class Registration {
        final String mName;
        final WorkingRange mWorkingRange;
        final Component mComponent;
        final String mKey;

        Registration(String name, WorkingRange workingRange, Component component, String key) {
            this.mName = name;
            this.mWorkingRange = workingRange;
            this.mComponent = component;
            this.mKey = key;
        }
    }

    @VisibleForTesting
    static class RangeTuple {
        final String mName;
        final WorkingRange mWorkingRange;
        final List<Component> mComponents;
        final List<String> mComponentKeys;

        RangeTuple(String name, WorkingRange workingRange, Component component, String key) {
            this.mName = name;
            this.mWorkingRange = workingRange;
            this.mComponents = new ArrayList<Component>();
            this.mComponentKeys = new ArrayList<String>();
            this.mComponents.add(component);
            this.mComponentKeys.add(key);
        }

        void addComponent(Component component, String key) {
            this.mComponents.add(component);
            this.mComponentKeys.add(key);
        }
    }
}

