/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.animation.StateListAnimator;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import com.facebook.litho.CommonUtils;
import com.facebook.litho.LayerType;
import com.facebook.litho.LithoLayoutResult;
import com.facebook.litho.drawable.DrawableUtils;
import com.facebook.yoga.YogaDirection;
import javax.annotation.Nullable;

class ViewNodeInfo {
    @Nullable
    private Drawable mBackground;
    @Nullable
    private Drawable mForeground;
    private Rect mPadding;
    private Rect mExpandedTouchBounds;
    private YogaDirection mLayoutDirection;
    @Nullable
    private StateListAnimator mStateListAnimator;
    @DrawableRes
    private int mStateListAnimatorRes;
    private int mLayoutType = -1;
    @Nullable
    private Paint mLayerPaint;

    ViewNodeInfo() {
    }

    void setBackground(@Nullable Drawable background) {
        this.mBackground = background;
    }

    @Nullable
    Drawable getBackground() {
        return this.mBackground;
    }

    void setForeground(@Nullable Drawable foreground) {
        this.mForeground = foreground;
    }

    @Nullable
    Drawable getForeground() {
        return this.mForeground;
    }

    @Nullable
    Rect getPadding() {
        return this.mPadding;
    }

    int getPaddingLeft() {
        return this.mPadding != null ? this.mPadding.left : 0;
    }

    int getPaddingTop() {
        return this.mPadding != null ? this.mPadding.top : 0;
    }

    int getPaddingRight() {
        return this.mPadding != null ? this.mPadding.right : 0;
    }

    int getPaddingBottom() {
        return this.mPadding != null ? this.mPadding.bottom : 0;
    }

    void setPadding(int l, int t, int r, int b) {
        if (this.mPadding != null) {
            throw new IllegalStateException("Padding already initialized for this ViewNodeInfo.");
        }
        this.mPadding = new Rect();
        this.mPadding.set(l, t, r, b);
    }

    boolean hasPadding() {
        return this.mPadding != null;
    }

    void setLayoutDirection(YogaDirection layoutDirection) {
        this.mLayoutDirection = layoutDirection;
    }

    YogaDirection getLayoutDirection() {
        return this.mLayoutDirection;
    }

    void setExpandedTouchBounds(LithoLayoutResult result, int l, int t, int r, int b) {
        if (!result.hasTouchExpansion()) {
            return;
        }
        int touchExpansionLeft = result.getTouchExpansionLeft();
        int touchExpansionTop = result.getTouchExpansionTop();
        int touchExpansionRight = result.getTouchExpansionRight();
        int touchExpansionBottom = result.getTouchExpansionBottom();
        if (touchExpansionLeft == 0 && touchExpansionTop == 0 && touchExpansionRight == 0 && touchExpansionBottom == 0) {
            return;
        }
        if (this.mExpandedTouchBounds != null) {
            throw new IllegalStateException("ExpandedTouchBounds already initialized for this ViewNodeInfo.");
        }
        this.mExpandedTouchBounds = new Rect();
        this.mExpandedTouchBounds.set(l - touchExpansionLeft, t - touchExpansionTop, r + touchExpansionRight, b + touchExpansionBottom);
    }

    @Nullable
    Rect getExpandedTouchBounds() {
        if (this.mExpandedTouchBounds == null || this.mExpandedTouchBounds.isEmpty()) {
            return null;
        }
        return this.mExpandedTouchBounds;
    }

    @Nullable
    StateListAnimator getStateListAnimator() {
        return this.mStateListAnimator;
    }

    void setStateListAnimator(@Nullable StateListAnimator stateListAnimator) {
        this.mStateListAnimator = stateListAnimator;
    }

    @DrawableRes
    int getStateListAnimatorRes() {
        return this.mStateListAnimatorRes;
    }

    void setStateListAnimatorRes(@DrawableRes int resId) {
        this.mStateListAnimatorRes = resId;
    }

    void setLayerType(@LayerType int type, @Nullable Paint paint) {
        this.mLayoutType = type;
        this.mLayerPaint = paint;
    }

    @LayerType
    int getLayerType() {
        return this.mLayoutType;
    }

    @Nullable
    public Paint getLayoutPaint() {
        return this.mLayerPaint;
    }

    public boolean isEquivalentTo(ViewNodeInfo other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!DrawableUtils.isEquivalentTo(this.mBackground, other.mBackground)) {
            return false;
        }
        if (!DrawableUtils.isEquivalentTo(this.mForeground, other.mForeground)) {
            return false;
        }
        if (!CommonUtils.equals(this.mPadding, other.mPadding)) {
            return false;
        }
        if (!CommonUtils.equals(this.mExpandedTouchBounds, other.mExpandedTouchBounds)) {
            return false;
        }
        if (!CommonUtils.equals(this.mLayoutDirection, other.mLayoutDirection)) {
            return false;
        }
        if (this.mStateListAnimatorRes != other.mStateListAnimatorRes) {
            return false;
        }
        return CommonUtils.equals(this.mStateListAnimator, other.mStateListAnimator);
    }
}

