/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@ThreadConfined(value="ANY")
public class TreeProps {
    private final Map<Class, Object> mMap = Collections.synchronizedMap(new HashMap());

    public void put(Class key, @Nullable Object value) {
        this.mMap.put(key, value);
    }

    @Nullable
    public <T> T get(Class<T> key) {
        return (T)this.mMap.get(key);
    }

    @ThreadSafe(enableChecks=false)
    @Nullable
    public static TreeProps copy(@Nullable TreeProps source) {
        if (source == null) {
            return null;
        }
        return TreeProps.acquire(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe(enableChecks=false)
    public static TreeProps acquire(@Nullable TreeProps source) {
        TreeProps newProps = new TreeProps();
        if (source != null) {
            Map<Class, Object> map = source.mMap;
            synchronized (map) {
                newProps.mMap.putAll(source.mMap);
            }
        }
        return newProps;
    }

    void reset() {
        this.mMap.clear();
    }
}

