/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.SparseArrayCompat;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentHostUtils;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.rendercore.MountItem;

class TouchExpansionDelegate
extends TouchDelegate {
    private static final Rect IGNORED_RECT = new Rect();
    private final SparseArrayCompat<InnerTouchDelegate> mDelegates = new SparseArrayCompat();
    @Nullable
    private SparseArrayCompat<InnerTouchDelegate> mScrapDelegates;

    TouchExpansionDelegate(ComponentHost host) {
        super(IGNORED_RECT, (View)host);
    }

    void registerTouchExpansion(int index, View view, MountItem item) {
        this.mDelegates.put(index, (Object)new InnerTouchDelegate(view, item));
    }

    void unregisterTouchExpansion(int index) {
        if (this.maybeUnregisterFromScrap(index)) {
            return;
        }
        this.mDelegates.remove(index);
    }

    private boolean maybeUnregisterFromScrap(int index) {
        InnerTouchDelegate touchDelegate;
        if (this.mScrapDelegates != null && (touchDelegate = (InnerTouchDelegate)this.mScrapDelegates.get(index)) != null) {
            this.mScrapDelegates.remove(index);
            return true;
        }
        return false;
    }

    void draw(Canvas canvas, Paint paint) {
        for (int i = this.mDelegates.size() - 1; i >= 0; --i) {
            Rect bounds;
            InnerTouchDelegate delegate = (InnerTouchDelegate)this.mDelegates.valueAt(i);
            if (delegate == null || (bounds = delegate.getDelegateBounds()) == null) continue;
            canvas.drawRect(bounds, paint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        for (int i = this.mDelegates.size() - 1; i >= 0; --i) {
            InnerTouchDelegate touchDelegate = (InnerTouchDelegate)this.mDelegates.valueAt(i);
            if (touchDelegate == null || !touchDelegate.onTouchEvent(event)) continue;
            return true;
        }
        return false;
    }

    void moveTouchExpansionIndexes(int oldIndex, int newIndex) {
        if (this.mDelegates.get(newIndex) != null) {
            this.ensureScrapDelegates();
            ComponentHostUtils.scrapItemAt(newIndex, this.mDelegates, this.mScrapDelegates);
        }
        ComponentHostUtils.moveItem(oldIndex, newIndex, this.mDelegates, this.mScrapDelegates);
        this.releaseScrapDelegatesIfNeeded();
    }

    private void ensureScrapDelegates() {
        if (this.mScrapDelegates == null) {
            this.mScrapDelegates = new SparseArrayCompat(4);
        }
    }

    @VisibleForTesting
    public int size() {
        return this.mDelegates.size();
    }

    private void releaseScrapDelegatesIfNeeded() {
        if (this.mScrapDelegates != null && this.mScrapDelegates.size() == 0) {
            this.mScrapDelegates = null;
        }
    }

    private static class InnerTouchDelegate {
        private final View mDelegateView;
        private final MountItem mItem;
        private boolean mIsHandlingTouch;

        InnerTouchDelegate(View delegateView, MountItem item) {
            this.mDelegateView = delegateView;
            this.mItem = item;
        }

        @Nullable
        Rect getDelegateBounds() {
            ViewNodeInfo info = LayoutOutput.getLayoutOutput(this.mItem).getViewNodeInfo();
            if (info == null) {
                return null;
            }
            return info.getExpandedTouchBounds();
        }

        boolean onTouchEvent(MotionEvent event) {
            int x = (int)event.getX();
            int y = (int)event.getY();
            Rect delegateBounds = this.getDelegateBounds();
            if (delegateBounds == null) {
                return false;
            }
            int slop = ViewConfiguration.get((Context)this.mDelegateView.getContext()).getScaledTouchSlop();
            Rect delegateSlopBounds = new Rect();
            delegateSlopBounds.set(delegateBounds);
            delegateSlopBounds.inset(-slop, -slop);
            boolean shouldDelegateTouchEvent = false;
            boolean touchWithinViewBounds = true;
            boolean handled = false;
            switch (event.getAction()) {
                case 0: {
                    shouldDelegateTouchEvent = this.mIsHandlingTouch = delegateBounds.contains(x, y);
                    break;
                }
                case 1: 
                case 2: {
                    shouldDelegateTouchEvent = this.mIsHandlingTouch;
                    if (this.mIsHandlingTouch && !delegateSlopBounds.contains(x, y)) {
                        touchWithinViewBounds = false;
                    }
                    if (event.getAction() != 1) break;
                    this.mIsHandlingTouch = false;
                    break;
                }
                case 3: {
                    shouldDelegateTouchEvent = this.mIsHandlingTouch;
                    this.mIsHandlingTouch = false;
                }
            }
            if (shouldDelegateTouchEvent) {
                if (touchWithinViewBounds) {
                    event.setLocation((float)(this.mDelegateView.getWidth() / 2), (float)(this.mDelegateView.getHeight() / 2));
                } else {
                    event.setLocation((float)(-(slop * 2)), (float)(-(slop * 2)));
                }
                handled = this.mDelegateView.dispatchTouchEvent(event);
            }
            return handled;
        }
    }
}

