/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.util.Log;
import androidx.annotation.Nullable;
import com.facebook.litho.config.ComponentsConfiguration;

public abstract class ThreadTracingRunnable
implements Runnable {
    private static final String MESSAGE_PART_1 = "Runnable instantiated on thread id: ";
    private static final String MESSAGE_PART_2 = ", name: ";
    @Nullable
    private final Throwable mTracingThrowable;

    private ThreadTracingRunnable(boolean isTracingEnabled) {
        if (isTracingEnabled) {
            Thread thread = Thread.currentThread();
            this.mTracingThrowable = new Throwable(MESSAGE_PART_1 + thread.getId() + MESSAGE_PART_2 + thread.getName());
        } else {
            this.mTracingThrowable = null;
        }
    }

    public ThreadTracingRunnable() {
        this(ComponentsConfiguration.enableThreadTracingStacktrace);
    }

    public ThreadTracingRunnable(@Nullable ThreadTracingRunnable prevTracingRunnable) {
        this(prevTracingRunnable != null ? prevTracingRunnable.mTracingThrowable != null : ComponentsConfiguration.enableThreadTracingStacktrace);
        if (this.mTracingThrowable != null && prevTracingRunnable != null) {
            this.mTracingThrowable.initCause(prevTracingRunnable.mTracingThrowable);
        }
    }

    public abstract void tracedRun(ThreadTracingRunnable var1);

    public void resetTrace() {
        if (this.mTracingThrowable != null) {
            this.mTracingThrowable.fillInStackTrace();
        }
    }

    @Override
    public final void run() {
        try {
            this.tracedRun(this);
        }
        catch (Throwable t) {
            if (this.mTracingThrowable != null) {
                Log.w((String)"LithoThreadTracing", (String)"--- start debug trace");
                Log.w((String)"LithoThreadTracing", (String)"Thread tracing stacktrace", (Throwable)this.mTracingThrowable);
                Log.w((String)"LithoThreadTracing", (String)"--- end debug trace");
            }
            throw t;
        }
    }
}

