/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.LayoutThreadPoolConfigurationImpl;
import com.facebook.litho.LayoutThreadPoolExecutor;
import com.facebook.litho.LithoHandler;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.config.LayoutThreadPoolConfiguration;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;

public class ThreadPoolLayoutHandler
implements LithoHandler {
    public static final LayoutThreadPoolConfiguration DEFAULT_LAYOUT_THREAD_POOL_CONFIGURATION = new LayoutThreadPoolConfigurationImpl(2, 2, ComponentsConfiguration.DEFAULT_BACKGROUND_THREAD_PRIORITY);
    private static ThreadPoolLayoutHandler sInstance;
    private final ThreadPoolExecutor mLayoutThreadPoolExecutor;

    private ThreadPoolLayoutHandler(LayoutThreadPoolConfiguration configuration) {
        this.mLayoutThreadPoolExecutor = new LayoutThreadPoolExecutor(configuration.getCorePoolSize(), configuration.getMaxPoolSize(), configuration.getThreadPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolLayoutHandler getDefaultInstance() {
        if (sInstance != null) return sInstance;
        Class<ThreadPoolLayoutHandler> clazz = ThreadPoolLayoutHandler.class;
        synchronized (ThreadPoolLayoutHandler.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ThreadPoolLayoutHandler(DEFAULT_LAYOUT_THREAD_POOL_CONFIGURATION);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public static ThreadPoolLayoutHandler getNewInstance(LayoutThreadPoolConfiguration configuration) {
        return new ThreadPoolLayoutHandler(configuration);
    }

    @Override
    public boolean isTracing() {
        return false;
    }

    @Override
    public void post(Runnable runnable, String tag) {
        try {
            this.mLayoutThreadPoolExecutor.execute(runnable);
        }
        catch (RejectedExecutionException e) {
            throw new RuntimeException("Cannot execute layout calculation task; " + e);
        }
    }

    @Override
    public void postAtFront(Runnable runnable, String tag) {
        throw new IllegalStateException("postAtFront is not supported for ThreadPoolLayoutHandler");
    }

    @Override
    public void remove(Runnable runnable) {
        this.mLayoutThreadPoolExecutor.remove(runnable);
    }
}

