/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.LayoutThreadFactory;
import com.facebook.litho.LithoHandler;
import com.facebook.litho.config.LayoutThreadPoolConfiguration;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolDynamicPriorityLayoutHandler
implements LithoHandler {
    private final ThreadPoolExecutor mLayoutThreadPoolExecutor;
    private final LayoutThreadFactory mLayoutThreadFactory;

    public ThreadPoolDynamicPriorityLayoutHandler(LayoutThreadPoolConfiguration configuration) {
        this.mLayoutThreadFactory = new LayoutThreadFactory(configuration.getThreadPriority());
        this.mLayoutThreadPoolExecutor = new ThreadPoolExecutor(configuration.getCorePoolSize(), configuration.getMaxPoolSize(), 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), this.mLayoutThreadFactory);
    }

    @Override
    public boolean isTracing() {
        return false;
    }

    @Override
    public void post(Runnable runnable, String tag) {
        try {
            this.mLayoutThreadPoolExecutor.execute(runnable);
        }
        catch (RejectedExecutionException e) {
            throw new RuntimeException("Cannot execute layout calculation task; " + e);
        }
    }

    @Override
    public void postAtFront(Runnable runnable, String tag) {
        throw new IllegalStateException("postAtFront is not supported for ThreadPoolLayoutHandler");
    }

    @Override
    public void remove(Runnable runnable) {
        this.mLayoutThreadPoolExecutor.remove(runnable);
    }

    public void setThreadPriority(int updatePriority) {
        this.mLayoutThreadFactory.setThreadPriority(updatePriority);
    }
}

