/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.widget.Checkable;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentHostUtils;
import com.facebook.proguard.annotations.DoNotStrip;
import java.util.Collections;
import java.util.List;

@DoNotStrip
public class TestItem {
    private String mTestKey;
    private final Rect mBounds = new Rect();
    private ComponentHost mHost;
    private Object mContent;
    private final AcquireKey mAcquireKey = new AcquireKey();

    @DoNotStrip
    @VisibleForTesting
    public String getTestKey() {
        return this.mTestKey;
    }

    void setTestKey(String testKey) {
        this.mTestKey = testKey;
    }

    @DoNotStrip
    @VisibleForTesting
    public Rect getBounds() {
        return this.mBounds;
    }

    void setBounds(Rect bounds) {
        this.mBounds.set(bounds);
    }

    void setBounds(int left, int top, int right, int bottom) {
        this.mBounds.set(left, top, right, bottom);
    }

    @DoNotStrip
    @VisibleForTesting
    public ComponentHost getHost() {
        return this.mHost;
    }

    @DoNotStrip
    @VisibleForTesting
    public String getTextContent() {
        List<CharSequence> textItems = this.getTextItems();
        StringBuilder sb = new StringBuilder();
        int size = textItems.size();
        for (int i = 0; i < size; ++i) {
            sb.append(textItems.get(i));
        }
        return sb.toString();
    }

    public List<CharSequence> getTextItems() {
        return ComponentHostUtils.extractTextContent(Collections.singletonList(this.mContent)).getTextItems();
    }

    public boolean isChecked() {
        if (this.mContent instanceof Checkable) {
            return ((Checkable)this.mContent).isChecked();
        }
        throw new UnsupportedOperationException("This Litho component can't be checked, we can't determine its check state.");
    }

    void setHost(ComponentHost host) {
        this.mHost = host;
    }

    void setContent(@Nullable Object content) {
        this.mContent = content;
    }

    Object getContent() {
        return this.mContent;
    }

    @DoNotStrip
    public AcquireKey getAcquireKey() {
        return this.mAcquireKey;
    }

    @DoNotStrip
    public static final class AcquireKey {
    }
}

