/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.HookUpdater;
import com.facebook.litho.LayoutStateContext;
import com.facebook.litho.StateContainer;
import com.facebook.litho.Transition;
import com.facebook.litho.stats.LithoStats;
import com.facebook.rendercore.transitions.TransitionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;

public class StateHandler {
    private static final int INITIAL_STATE_UPDATE_LIST_CAPACITY = 4;
    private static final int INITIAL_MAP_CAPACITY = 4;
    @GuardedBy(value="this")
    private Map<String, List<StateContainer.StateUpdate>> mPendingStateUpdates;
    @GuardedBy(value="this")
    @Nullable
    private Map<String, List<StateContainer.StateUpdate>> mPendingLazyStateUpdates;
    @GuardedBy(value="this")
    @Nullable
    private Map<String, List<Transition>> mPendingStateUpdateTransitions;
    @GuardedBy(value="this")
    private Map<String, List<StateContainer.StateUpdate>> mAppliedStateUpdates;
    @GuardedBy(value="this")
    public Map<String, StateContainer> mStateContainers;
    @GuardedBy(value="this")
    public HashSet<String> mNeededStateContainers;
    @GuardedBy(value="this")
    @Nullable
    private Map<Object, Object> mCachedValues;
    private Map<String, Object> mHookState;
    private List<HookUpdater> mPendingHookUpdates;
    private List<HookUpdater> mAppliedHookUpdates;

    public StateHandler() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateHandler(@Nullable StateHandler stateHandler) {
        if (stateHandler == null) {
            return;
        }
        StateHandler stateHandler2 = this;
        synchronized (stateHandler2) {
            this.copyStateUpdatesMap(stateHandler.getPendingStateUpdates(), stateHandler.getPendingLazyStateUpdates(), stateHandler.getAppliedStateUpdates());
            this.copyCurrentStateContainers(stateHandler.getStateContainers());
            this.copyPendingStateTransitions(stateHandler.getPendingStateUpdateTransitions());
            this.copyAndRunHooks(stateHandler);
        }
    }

    public static StateHandler createNewInstance(@Nullable StateHandler stateHandler) {
        return new StateHandler(stateHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StateHandler createShallowCopyForLazyStateUpdates(StateHandler stateHandler) {
        StateHandler copy = new StateHandler();
        StateHandler stateHandler2 = stateHandler;
        synchronized (stateHandler2) {
            copy.copyPendingLazyStateUpdates(stateHandler.mPendingLazyStateUpdates);
        }
        return copy;
    }

    public synchronized boolean isEmpty() {
        return !(this.mStateContainers != null && !this.mStateContainers.isEmpty() || this.mHookState != null && !this.mHookState.isEmpty());
    }

    synchronized boolean hasPendingUpdates() {
        return this.mPendingStateUpdates != null && !this.mPendingStateUpdates.isEmpty() || this.mPendingHookUpdates != null && !this.mPendingHookUpdates.isEmpty();
    }

    synchronized void queueStateUpdate(String key, StateContainer.StateUpdate stateUpdate, boolean isLazyStateUpdate) {
        this.maybeInitStateUpdatesMap();
        StateHandler.addStateUpdateForKey(key, stateUpdate, this.mPendingStateUpdates);
        if (isLazyStateUpdate) {
            this.maybeInitLazyStateUpdatesMap();
            StateHandler.addStateUpdateForKey(key, stateUpdate, this.mPendingLazyStateUpdates);
        }
    }

    private static void addStateUpdateForKey(String key, StateContainer.StateUpdate stateUpdate, Map<String, List<StateContainer.StateUpdate>> map) {
        List<StateContainer.StateUpdate> pendingStateUpdatesForKey = map.get(key);
        if (pendingStateUpdatesForKey == null) {
            pendingStateUpdatesForKey = StateHandler.createStateUpdatesList();
            map.put(key, pendingStateUpdatesForKey);
        }
        pendingStateUpdatesForKey.add(stateUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe(enableChecks=false)
    void applyStateUpdatesForComponent(LayoutStateContext layoutStateContext, Component component, String key) {
        Object object;
        List<StateContainer.StateUpdate> stateUpdatesForKey;
        StateContainer currentStateContainer;
        this.maybeInitStateContainers();
        this.maybeInitNeededStateContainers();
        if (!component.hasState()) {
            return;
        }
        ComponentContext scopedContext = component.getScopedContext(layoutStateContext, key);
        StateHandler stateHandler = this;
        synchronized (stateHandler) {
            currentStateContainer = this.mStateContainers.get(key);
            this.mNeededStateContainers.add(key);
        }
        if (currentStateContainer != null) {
            component.transferState(currentStateContainer, component.getStateContainer(scopedContext));
        } else {
            ComponentTree componentTree = scopedContext.getComponentTree();
            if (componentTree != null && componentTree.getInitialStateContainer() != null) {
                componentTree.getInitialStateContainer().createOrGetInitialStateForComponent(component, scopedContext);
            } else {
                component.createInitialState(scopedContext);
            }
        }
        StateHandler stateHandler2 = this;
        synchronized (stateHandler2) {
            stateUpdatesForKey = this.mPendingStateUpdates == null ? null : this.mPendingStateUpdates.get(key);
        }
        ArrayList<Transition> transitionsFromStateUpdate = null;
        if (stateUpdatesForKey != null) {
            for (StateContainer.StateUpdate update : stateUpdatesForKey) {
                StateContainer stateContainer = component.getStateContainer(scopedContext);
                stateContainer.applyStateUpdate(update);
                Transition transition = StateHandler.obtainTransitionFromStateContainer(stateContainer);
                if (transition == null) continue;
                if (transitionsFromStateUpdate == null) {
                    transitionsFromStateUpdate = new ArrayList<Transition>();
                }
                transitionsFromStateUpdate.add(transition);
            }
            LithoStats.incrementComponentAppliedStateUpdateCountBy(stateUpdatesForKey.size());
            object = this;
            synchronized (object) {
                this.mPendingStateUpdates.remove(key);
                if (this.mPendingLazyStateUpdates != null) {
                    this.mPendingLazyStateUpdates.remove(key);
                }
                this.mAppliedStateUpdates.put(key, stateUpdatesForKey);
            }
        }
        object = this;
        synchronized (object) {
            StateContainer stateContainer = component.getStateContainer(scopedContext);
            this.mStateContainers.put(key, stateContainer);
            if (transitionsFromStateUpdate != null && !transitionsFromStateUpdate.isEmpty()) {
                this.maybeInitPendingStateUpdateTransitions();
                this.mPendingStateUpdateTransitions.put(key, (List<Transition>)transitionsFromStateUpdate);
            }
        }
    }

    @Nullable
    private static Transition obtainTransitionFromStateContainer(StateContainer stateContainer) {
        if (stateContainer instanceof ComponentLifecycle.TransitionContainer) {
            return ((ComponentLifecycle.TransitionContainer)((Object)stateContainer)).consumeTransition();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyLazyStateUpdatesForContainer(String componentKey, StateContainer container) {
        List<StateContainer.StateUpdate> stateUpdatesForKey;
        StateHandler stateHandler = this;
        synchronized (stateHandler) {
            stateUpdatesForKey = this.mPendingLazyStateUpdates == null ? null : this.mPendingLazyStateUpdates.get(componentKey);
        }
        if (stateUpdatesForKey != null) {
            for (StateContainer.StateUpdate update : stateUpdatesForKey) {
                container.applyStateUpdate(update);
            }
        }
    }

    void commit(StateHandler stateHandler) {
        this.clearStateUpdates(stateHandler.getAppliedStateUpdates());
        StateHandler.clearUnusedStateContainers(stateHandler);
        this.copyCurrentStateContainers(stateHandler.getStateContainers());
        this.copyPendingStateTransitions(stateHandler.getPendingStateUpdateTransitions());
        this.commitHookState(stateHandler);
    }

    synchronized Set<String> getKeysForPendingUpdates() {
        HashSet<String> keys = new HashSet<String>();
        if (this.mAppliedStateUpdates != null) {
            keys.addAll(this.mAppliedStateUpdates.keySet());
        }
        if (this.mPendingStateUpdates != null) {
            keys.addAll(this.mPendingStateUpdates.keySet());
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearStateUpdates(@Nullable Map<String, List<StateContainer.StateUpdate>> appliedStateUpdates) {
        StateHandler stateHandler = this;
        synchronized (stateHandler) {
            if (appliedStateUpdates == null || this.mPendingStateUpdates == null || this.mPendingStateUpdates.isEmpty()) {
                return;
            }
        }
        for (Map.Entry entry : appliedStateUpdates.entrySet()) {
            List<StateContainer.StateUpdate> pendingLazyStateUpdatesForKey;
            List<StateContainer.StateUpdate> pendingStateUpdatesForKey;
            String appliedStateUpdateKey = (String)entry.getKey();
            StateHandler stateHandler2 = this;
            synchronized (stateHandler2) {
                pendingStateUpdatesForKey = this.mPendingStateUpdates.get(appliedStateUpdateKey);
                pendingLazyStateUpdatesForKey = this.mPendingLazyStateUpdates == null ? null : this.mPendingLazyStateUpdates.get(appliedStateUpdateKey);
            }
            if (pendingStateUpdatesForKey == null) continue;
            List appliedStateUpdatesForKey = (List)entry.getValue();
            if (pendingStateUpdatesForKey.size() == appliedStateUpdatesForKey.size()) {
                StateHandler stateHandler3 = this;
                synchronized (stateHandler3) {
                    this.mPendingStateUpdates.remove(appliedStateUpdateKey);
                    if (this.mPendingLazyStateUpdates != null) {
                        this.mPendingLazyStateUpdates.remove(appliedStateUpdateKey);
                    }
                    continue;
                }
            }
            pendingStateUpdatesForKey.removeAll(appliedStateUpdatesForKey);
            if (pendingLazyStateUpdatesForKey == null) continue;
            pendingLazyStateUpdatesForKey.removeAll(appliedStateUpdatesForKey);
        }
    }

    private static List<StateContainer.StateUpdate> createStateUpdatesList() {
        return StateHandler.createStateUpdatesList(null);
    }

    private static List<StateContainer.StateUpdate> createStateUpdatesList(@Nullable List<StateContainer.StateUpdate> copyFrom) {
        ArrayList<StateContainer.StateUpdate> list = new ArrayList<StateContainer.StateUpdate>(copyFrom == null ? 4 : copyFrom.size());
        if (copyFrom != null) {
            list.addAll(copyFrom);
        }
        return list;
    }

    @Nullable
    synchronized Map<String, StateContainer> getStateContainers() {
        return this.mStateContainers;
    }

    @Nullable
    synchronized Map<String, List<StateContainer.StateUpdate>> getPendingStateUpdates() {
        return this.mPendingStateUpdates;
    }

    @Nullable
    synchronized Map<String, List<StateContainer.StateUpdate>> getPendingLazyStateUpdates() {
        return this.mPendingLazyStateUpdates;
    }

    @Nullable
    synchronized Map<String, List<Transition>> getPendingStateUpdateTransitions() {
        return this.mPendingStateUpdateTransitions;
    }

    @Nullable
    @VisibleForTesting
    synchronized Map<String, List<StateContainer.StateUpdate>> getAppliedStateUpdates() {
        return this.mAppliedStateUpdates;
    }

    synchronized void consumePendingStateUpdateTransitions(List<Transition> outList, @Nullable String logContext) {
        if (this.mPendingStateUpdateTransitions == null) {
            return;
        }
        for (List<Transition> pendingTransitions : this.mPendingStateUpdateTransitions.values()) {
            int size = pendingTransitions.size();
            for (int i = 0; i < size; ++i) {
                TransitionUtils.addTransitions((Transition)pendingTransitions.get(i), outList, (String)logContext);
            }
        }
        this.mPendingStateUpdateTransitions = null;
    }

    @Nullable
    synchronized Object getCachedValue(Object cachedValueInputs) {
        if (this.mCachedValues == null) {
            this.mCachedValues = new HashMap<Object, Object>();
        }
        return this.mCachedValues.get(cachedValueInputs);
    }

    synchronized void putCachedValue(Object cachedValueInputs, Object cachedValue) {
        if (this.mCachedValues == null) {
            this.mCachedValues = new HashMap<Object, Object>();
        }
        this.mCachedValues.put(cachedValueInputs, cachedValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStateUpdatesMap(@Nullable Map<String, List<StateContainer.StateUpdate>> pendingStateUpdates, @Nullable Map<String, List<StateContainer.StateUpdate>> pendingLazyStateUpdates, @Nullable Map<String, List<StateContainer.StateUpdate>> appliedStateUpdates) {
        if ((pendingStateUpdates == null || pendingStateUpdates.isEmpty()) && (appliedStateUpdates == null || appliedStateUpdates.isEmpty())) {
            return;
        }
        this.maybeInitStateUpdatesMap();
        StateHandler stateHandler = this;
        synchronized (stateHandler) {
            if (pendingStateUpdates != null) {
                for (String string : pendingStateUpdates.keySet()) {
                    this.mPendingStateUpdates.put(string, StateHandler.createStateUpdatesList(pendingStateUpdates.get(string)));
                }
            }
            this.copyPendingLazyStateUpdates(pendingLazyStateUpdates);
            if (appliedStateUpdates != null) {
                for (Map.Entry entry : appliedStateUpdates.entrySet()) {
                    this.mAppliedStateUpdates.put((String)entry.getKey(), StateHandler.createStateUpdatesList((List)entry.getValue()));
                }
            }
        }
    }

    private void copyPendingLazyStateUpdates(@Nullable Map<String, List<StateContainer.StateUpdate>> pendingLazyStateUpdates) {
        if (pendingLazyStateUpdates == null || pendingLazyStateUpdates.isEmpty()) {
            return;
        }
        this.maybeInitLazyStateUpdatesMap();
        for (Map.Entry<String, List<StateContainer.StateUpdate>> pendingLazyStateUpdate : pendingLazyStateUpdates.entrySet()) {
            this.mPendingLazyStateUpdates.put(pendingLazyStateUpdate.getKey(), StateHandler.createStateUpdatesList(pendingLazyStateUpdate.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCurrentStateContainers(@Nullable Map<String, StateContainer> stateContainers) {
        if (stateContainers == null || stateContainers.isEmpty()) {
            return;
        }
        StateHandler stateHandler = this;
        synchronized (stateHandler) {
            this.maybeInitStateContainers();
            this.mStateContainers.clear();
            this.mStateContainers.putAll(stateContainers);
        }
    }

    private static void clearUnusedStateContainers(StateHandler currentStateHandler) {
        HashSet<String> neededStateContainers = currentStateHandler.mNeededStateContainers;
        ArrayList<String> stateContainerKeys = new ArrayList<String>();
        if (neededStateContainers == null || currentStateHandler.mStateContainers == null) {
            return;
        }
        stateContainerKeys.addAll(currentStateHandler.mStateContainers.keySet());
        for (String key : stateContainerKeys) {
            if (neededStateContainers.contains(key)) continue;
            currentStateHandler.mStateContainers.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPendingStateTransitions(@Nullable Map<String, List<Transition>> pendingStateUpdateTransitions) {
        if (pendingStateUpdateTransitions == null || pendingStateUpdateTransitions.isEmpty()) {
            return;
        }
        StateHandler stateHandler = this;
        synchronized (stateHandler) {
            this.maybeInitPendingStateUpdateTransitions();
            this.mPendingStateUpdateTransitions.putAll(pendingStateUpdateTransitions);
        }
    }

    private synchronized void maybeInitStateContainers() {
        if (this.mStateContainers == null) {
            this.mStateContainers = new HashMap<String, StateContainer>(4);
        }
    }

    private synchronized void maybeInitNeededStateContainers() {
        if (this.mNeededStateContainers == null) {
            this.mNeededStateContainers = new HashSet();
        }
    }

    private synchronized void maybeInitPendingStateUpdateTransitions() {
        if (this.mPendingStateUpdateTransitions == null) {
            this.mPendingStateUpdateTransitions = new HashMap<String, List<Transition>>();
        }
    }

    private synchronized void maybeInitStateUpdatesMap() {
        if (this.mPendingStateUpdates == null) {
            this.mPendingStateUpdates = new HashMap<String, List<StateContainer.StateUpdate>>(4);
        }
        if (this.mAppliedStateUpdates == null) {
            this.mAppliedStateUpdates = new HashMap<String, List<StateContainer.StateUpdate>>(4);
        }
    }

    private synchronized void maybeInitLazyStateUpdatesMap() {
        if (this.mPendingLazyStateUpdates == null) {
            this.mPendingLazyStateUpdates = new HashMap<String, List<StateContainer.StateUpdate>>(4);
        }
    }

    Map<String, Object> getHookState() {
        if (this.mHookState == null) {
            this.mHookState = new HashMap<String, Object>();
        }
        return this.mHookState;
    }

    void queueHookStateUpdate(HookUpdater updater) {
        if (this.mPendingHookUpdates == null) {
            this.mPendingHookUpdates = new ArrayList<HookUpdater>();
        }
        this.mPendingHookUpdates.add(updater);
    }

    private void copyAndRunHooks(StateHandler other) {
        if (other.mHookState != null) {
            this.mHookState = new HashMap<String, Object>(other.mHookState);
        }
        if (other.mPendingHookUpdates != null) {
            ArrayList<HookUpdater> updaters = new ArrayList<HookUpdater>(other.mPendingHookUpdates);
            for (HookUpdater updater : updaters) {
                updater.apply(this);
            }
            this.mAppliedHookUpdates = updaters;
        }
    }

    private void commitHookState(StateHandler stateHandler) {
        if (this.mHookState != null) {
            this.mHookState.clear();
        }
        if (stateHandler.mHookState != null && !stateHandler.mHookState.isEmpty()) {
            if (this.mHookState == null) {
                this.mHookState = new HashMap<String, Object>(stateHandler.mHookState);
            } else {
                this.mHookState.putAll(stateHandler.mHookState);
            }
        }
        if (this.mPendingHookUpdates != null && stateHandler.mAppliedHookUpdates != null) {
            this.mPendingHookUpdates.removeAll(stateHandler.mAppliedHookUpdates);
        }
    }
}

