/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.view.View;
import com.facebook.litho.FastMath;
import com.facebook.yoga.YogaMeasureMode;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SizeSpec {
    public static final int UNSPECIFIED = 0;
    public static final int EXACTLY = 0x40000000;
    public static final int AT_MOST = Integer.MIN_VALUE;

    public static int makeSizeSpec(int size, int mode) {
        return View.MeasureSpec.makeMeasureSpec((int)size, (int)mode);
    }

    public static int getMode(int sizeSpec) {
        return View.MeasureSpec.getMode((int)sizeSpec);
    }

    public static int getSize(int sizeSpec) {
        return View.MeasureSpec.getSize((int)sizeSpec);
    }

    public static String toString(int sizeSpec) {
        return View.MeasureSpec.toString((int)sizeSpec);
    }

    public static int resolveSize(int sizeSpec, int preferredSize) {
        switch (SizeSpec.getMode(sizeSpec)) {
            case 0x40000000: {
                return SizeSpec.getSize(sizeSpec);
            }
            case -2147483648: {
                return Math.min(SizeSpec.getSize(sizeSpec), preferredSize);
            }
            case 0: {
                return preferredSize;
            }
        }
        throw new IllegalStateException("Unexpected size mode: " + SizeSpec.getMode(sizeSpec));
    }

    public static int makeSizeSpecFromCssSpec(float cssSize, YogaMeasureMode cssMode) {
        switch (cssMode) {
            case EXACTLY: {
                return SizeSpec.makeSizeSpec(FastMath.round(cssSize), 0x40000000);
            }
            case UNDEFINED: {
                return SizeSpec.makeSizeSpec(0, 0);
            }
            case AT_MOST: {
                return SizeSpec.makeSizeSpec(FastMath.round(cssSize), Integer.MIN_VALUE);
            }
        }
        throw new IllegalArgumentException("Unexpected YogaMeasureMode: " + cssMode);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MeasureSpecMode {
    }
}

