/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.util.SparseIntArray;
import com.facebook.litho.Component;
import com.facebook.litho.InterStagePropsContainer;
import com.facebook.litho.InternalNode;
import com.facebook.litho.StateContainer;
import com.facebook.litho.WorkingRange;
import com.facebook.litho.WorkingRangeContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class ScopedComponentInfo {
    private StateContainer mStateContainer;
    @Nullable
    private InterStagePropsContainer mInterStagePropsContainer;
    @Nullable
    private SparseIntArray mChildCounters;
    @Nullable
    private Map<String, Integer> mManualKeysCounter;
    @Nullable
    private List<WorkingRangeContainer.Registration> mWorkingRangeRegistrations;

    ScopedComponentInfo(Component component) {
        this.mStateContainer = component.createStateContainer();
        this.mInterStagePropsContainer = component.createInterStagePropsContainer();
    }

    StateContainer getStateContainer() {
        return this.mStateContainer;
    }

    void setStateContainer(StateContainer stateContainer) {
        this.mStateContainer = stateContainer;
    }

    int getChildCountAndIncrement(Component component) {
        if (this.mChildCounters == null) {
            this.mChildCounters = new SparseIntArray();
        }
        int count = this.mChildCounters.get(component.getTypeId(), 0);
        this.mChildCounters.put(component.getTypeId(), count + 1);
        return count;
    }

    int getManualKeyUsagesCountAndIncrement(String manualKey) {
        if (this.mManualKeysCounter == null) {
            this.mManualKeysCounter = new HashMap<String, Integer>();
        }
        int manualKeyIndex = this.mManualKeysCounter.containsKey(manualKey) ? this.mManualKeysCounter.get(manualKey) : 0;
        this.mManualKeysCounter.put(manualKey, manualKeyIndex + 1);
        return manualKeyIndex;
    }

    @Nullable
    InterStagePropsContainer getInterStagePropsContainer() {
        return this.mInterStagePropsContainer;
    }

    void registerWorkingRange(String name, WorkingRange workingRange, Component component, String globalKey) {
        if (this.mWorkingRangeRegistrations == null) {
            this.mWorkingRangeRegistrations = new ArrayList<WorkingRangeContainer.Registration>();
        }
        this.mWorkingRangeRegistrations.add(new WorkingRangeContainer.Registration(name, workingRange, component, globalKey));
    }

    void addWorkingRangeToNode(InternalNode node) {
        if (this.mWorkingRangeRegistrations != null && !this.mWorkingRangeRegistrations.isEmpty()) {
            node.addWorkingRanges(this.mWorkingRangeRegistrations);
        }
    }
}

