/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.InternalNode;
import com.facebook.litho.InternalNodeUtils;
import com.facebook.litho.annotations.Prop;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaWrap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class Row
extends Component {
    @Nullable
    @Prop(optional=true)
    private List<Component> children;
    @Nullable
    @Prop(optional=true)
    private YogaAlign alignContent;
    @Nullable
    @Prop(optional=true)
    private YogaAlign alignItems;
    @Nullable
    @Prop(optional=true)
    private YogaJustify justifyContent;
    @Nullable
    @Prop(optional=true)
    private YogaWrap wrap;
    @Prop(optional=true)
    private boolean reverse;

    Row(String simpleName) {
        super(simpleName);
    }

    Row(@Nullable YogaAlign alignContent, @Nullable YogaAlign alignItems, @Nullable YogaJustify justifyContent, @Nullable YogaWrap wrap, boolean reverse) {
        this(alignContent, alignItems, justifyContent, wrap, reverse, null);
    }

    Row(@Nullable YogaAlign alignContent, @Nullable YogaAlign alignItems, @Nullable YogaJustify justifyContent, @Nullable YogaWrap wrap, boolean reverse, @Nullable List<Component> children) {
        this.alignContent = alignContent;
        this.alignItems = alignItems;
        this.justifyContent = justifyContent;
        this.wrap = wrap;
        this.reverse = reverse;
        this.children = children;
    }

    @Override
    protected boolean canResolve() {
        return true;
    }

    public static Builder create(ComponentContext context) {
        return Row.create(context, 0, 0, "Row");
    }

    public static Builder create(ComponentContext context, String simpleName) {
        return Row.create(context, 0, 0, simpleName);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        return Row.create(context, defStyleAttr, defStyleRes, "Row");
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes, String simpleName) {
        Builder builder = new Builder();
        builder.init(context, defStyleAttr, defStyleRes, new Row(simpleName));
        return builder;
    }

    @Override
    protected Component onCreateLayout(ComponentContext c) {
        return this;
    }

    @Override
    protected InternalNode resolve(ComponentContext c) {
        InternalNode node = InternalNodeUtils.create(c).flexDirection(this.reverse ? YogaFlexDirection.ROW_REVERSE : YogaFlexDirection.ROW);
        if (this.alignItems != null) {
            node.alignItems(this.alignItems);
        }
        if (this.alignContent != null) {
            node.alignContent(this.alignContent);
        }
        if (this.justifyContent != null) {
            node.justifyContent(this.justifyContent);
        }
        if (this.wrap != null) {
            node.wrap(this.wrap);
        }
        if (this.children != null) {
            for (Component child : this.children) {
                if (c.wasLayoutCanceled()) {
                    return ComponentContext.NULL_LAYOUT;
                }
                if (c.wasLayoutInterrupted()) {
                    node.appendUnresolvedComponent(child);
                    continue;
                }
                node.child(child);
            }
        }
        return node;
    }

    @Override
    public boolean isEquivalentTo(Component other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Row row = (Row)other;
        if (this.getId() == row.getId()) {
            return true;
        }
        if (this.children != null) {
            if (row.children == null || this.children.size() != row.children.size()) {
                return false;
            }
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                if (this.children.get(i).isEquivalentTo(row.children.get(i))) continue;
                return false;
            }
        } else if (row.children != null) {
            return false;
        }
        if (this.alignItems != null ? !this.alignItems.equals((Object)row.alignItems) : row.alignItems != null) {
            return false;
        }
        if (this.alignContent != null ? !this.alignContent.equals((Object)row.alignContent) : row.alignContent != null) {
            return false;
        }
        if (this.justifyContent != null ? !this.justifyContent.equals((Object)row.justifyContent) : row.justifyContent != null) {
            return false;
        }
        return this.reverse == row.reverse;
    }

    public static class Builder
    extends Component.ContainerBuilder<Builder> {
        Row mRow;
        ComponentContext mContext;

        void init(ComponentContext context, int defStyleAttr, int defStyleRes, Row row) {
            super.init(context, defStyleAttr, defStyleRes, row);
            this.mRow = row;
            this.mContext = context;
        }

        @Override
        protected void setComponent(Component component) {
            this.mRow = (Row)component;
        }

        @Override
        public Builder child(@Nullable Component child) {
            if (child == null) {
                return this;
            }
            if (this.mRow.children == null) {
                this.mRow.children = new ArrayList();
            }
            this.mRow.children.add(child);
            return this;
        }

        @Override
        public Builder child(@Nullable Component.Builder<?> child) {
            if (child == null) {
                return this;
            }
            return this.child(child.build());
        }

        @Override
        public Builder alignContent(YogaAlign alignContent) {
            this.mRow.alignContent = alignContent;
            return this;
        }

        @Override
        public Builder alignItems(YogaAlign alignItems) {
            this.mRow.alignItems = alignItems;
            return this;
        }

        @Override
        public Builder justifyContent(YogaJustify justifyContent) {
            this.mRow.justifyContent = justifyContent;
            return this;
        }

        @Override
        public Builder wrap(YogaWrap wrap) {
            this.mRow.wrap = wrap;
            return this;
        }

        @Override
        public Builder reverse(boolean reverse) {
            this.mRow.reverse = reverse;
            return this;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        @Override
        public Row build() {
            return this.mRow;
        }
    }
}

