/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentUtils;
import com.facebook.litho.LayoutStateContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RenderState {
    private final Map<String, ComponentLifecycle.RenderData> mRenderData = new HashMap<String, ComponentLifecycle.RenderData>();
    private final Set<String> mSeenGlobalKeys = new HashSet<String>();

    void recordRenderData(LayoutStateContext layoutStateContext, List<Component> components, List<String> componentGlobalKeys) {
        if (components == null) {
            return;
        }
        int size = components.size();
        for (int i = 0; i < size; ++i) {
            this.recordRenderData(layoutStateContext, components.get(i), componentGlobalKeys.get(i));
        }
        this.mSeenGlobalKeys.clear();
    }

    void applyPreviousRenderData(List<Component> components, List<String> componentGlobalKeys) {
        if (components == null) {
            return;
        }
        int size = components.size();
        for (int i = 0; i < size; ++i) {
            this.applyPreviousRenderData(components.get(i), componentGlobalKeys.get(i));
        }
    }

    private void recordRenderData(LayoutStateContext layoutStateContext, Component component, String globalKey) {
        if (!component.needsPreviousRenderData()) {
            throw new RuntimeException("Trying to record previous render data for component that doesn't support it");
        }
        String key = ComponentUtils.getGlobalKey(component, globalKey);
        if (this.mSeenGlobalKeys.contains(key)) {
            throw new RuntimeException("Cannot record previous render data for " + component.getSimpleName() + ", found another Component with the same key: " + key);
        }
        this.mSeenGlobalKeys.add(key);
        ComponentContext scopedContext = component.getScopedContext(layoutStateContext, globalKey);
        ComponentLifecycle.RenderData existingInfo = this.mRenderData.get(key);
        ComponentLifecycle.RenderData newInfo = component.recordRenderData(scopedContext, existingInfo);
        this.mRenderData.put(key, newInfo);
    }

    private void applyPreviousRenderData(Component component, String globalKey) {
        if (!component.needsPreviousRenderData()) {
            throw new RuntimeException("Trying to apply previous render data to component that doesn't support it");
        }
        String key = ComponentUtils.getGlobalKey(component, globalKey);
        ComponentLifecycle.RenderData previousRenderData = this.mRenderData.get(key);
        component.applyPreviousRenderData(previousRenderData);
    }
}

