/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import androidx.core.util.Pools;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.PoolWithDebugInfo;

@ThreadSafe(enableChecks=false)
public class RecyclePool<T>
implements PoolWithDebugInfo {
    private final String mName;
    private final int mMaxSize;
    private final boolean mIsSync;
    private Pools.Pool<T> mPool;
    private int mCurrentSize = 0;

    public RecyclePool(String name, int maxSize, boolean sync) {
        this.mIsSync = sync;
        this.mName = name;
        this.mMaxSize = maxSize;
        this.mPool = sync ? new Pools.SynchronizedPool(maxSize) : new Pools.SimplePool(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T acquire() {
        Object item;
        if (this.mIsSync) {
            RecyclePool recyclePool = this;
            synchronized (recyclePool) {
                item = this.mPool.acquire();
                this.mCurrentSize = Math.max(0, this.mCurrentSize - 1);
            }
        } else {
            item = this.mPool.acquire();
            this.mCurrentSize = Math.max(0, this.mCurrentSize - 1);
        }
        return (T)item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(T item) {
        if (this.mIsSync) {
            RecyclePool recyclePool = this;
            synchronized (recyclePool) {
                this.mPool.release(item);
                this.mCurrentSize = Math.min(this.mMaxSize, this.mCurrentSize + 1);
            }
        } else {
            this.mPool.release(item);
            this.mCurrentSize = Math.min(this.mMaxSize, this.mCurrentSize + 1);
        }
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public int getMaxSize() {
        return this.mMaxSize;
    }

    @Override
    public int getCurrentSize() {
        return this.mCurrentSize;
    }

    public boolean isFull() {
        return this.mCurrentSize >= this.mMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.mIsSync) {
            RecyclePool recyclePool = this;
            synchronized (recyclePool) {
                while (this.acquire() != null) {
                }
            }
        } else {
            while (this.acquire() != null) {
            }
        }
    }
}

