/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.animation.AnimatorInflater;
import android.animation.StateListAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.LongSparseArray;
import androidx.core.view.ViewCompat;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentClickListener;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentFocusChangeListener;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentHostUtils;
import com.facebook.litho.ComponentLongClickListener;
import com.facebook.litho.ComponentTouchListener;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.ComponentsReporter;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.DrawableComponent;
import com.facebook.litho.DynamicPropsManager;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FocusChangedEvent;
import com.facebook.litho.HasLithoViewChildren;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoMountData;
import com.facebook.litho.LithoView;
import com.facebook.litho.LogTreePopulator;
import com.facebook.litho.LongClickEvent;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.PerfEvent;
import com.facebook.litho.R;
import com.facebook.litho.TestItem;
import com.facebook.litho.TestOutput;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.TouchEvent;
import com.facebook.litho.TransitionsExtension;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.stats.LithoStats;
import com.facebook.rendercore.ErrorReporter;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.LogLevel;
import com.facebook.rendercore.MountDelegate;
import com.facebook.rendercore.MountDelegateTarget;
import com.facebook.rendercore.MountItem;
import com.facebook.rendercore.RenderTree;
import com.facebook.rendercore.RenderTreeNode;
import com.facebook.rendercore.UnmountDelegateExtension;
import com.facebook.rendercore.extensions.ExtensionState;
import com.facebook.rendercore.extensions.MountExtension;
import com.facebook.rendercore.incrementalmount.IncrementalMountOutput;
import com.facebook.rendercore.transitions.TransitionsExtensionInput;
import com.facebook.rendercore.utils.BoundsUtils;
import com.facebook.rendercore.visibility.VisibilityExtensionInput;
import com.facebook.rendercore.visibility.VisibilityItem;
import com.facebook.rendercore.visibility.VisibilityMountExtension;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ThreadConfined(value="UI")
class MountState
implements MountDelegateTarget {
    private static final String INVALID_REENTRANT_MOUNTS = "MountState:InvalidReentrantMounts";
    private static final double NS_IN_MS = 1000000.0;
    private static final Rect sTempRect = new Rect();
    private final LongSparseArray<MountItem> mIndexToItemMap;
    private final LongSparseArray<MountItem> mCanMountIncrementallyMountItems;
    private final Map<String, Deque<TestItem>> mTestItemMap;
    @Nullable
    private long[] mLayoutOutputsIds;
    private boolean mIsDirty;
    private boolean mIsMounting;
    private boolean mNeedsRemount;
    private final LongSparseArray<ComponentHost> mHostsByMarker = new LongSparseArray();
    private final ComponentContext mContext;
    private final LithoView mLithoView;
    private final Rect mPreviousLocalVisibleRect = new Rect();
    private final PrepareMountStats mPrepareMountStats = new PrepareMountStats();
    private final MountStats mMountStats = new MountStats();
    private final boolean mUseStatelessComponent = ComponentsConfiguration.useStatelessComponent;
    private int mPreviousTopsIndex;
    private int mPreviousBottomsIndex;
    private int mLastMountedComponentTreeId = -1;
    @Nullable
    private LayoutState mLayoutState;
    @Nullable
    private LayoutState mLastMountedLayoutState;
    private int mLastDisappearRangeStart = -1;
    private int mLastDisappearRangeEnd = -1;
    private final MountItem mRootHostMountItem;
    private final VisibilityMountExtension mVisibilityExtension;
    private final ExtensionState mVisibilityExtensionState;
    private final Set<Long> mComponentIdsMountedInThisFrame = new HashSet<Long>();
    private final DynamicPropsManager mDynamicPropsManager = new DynamicPropsManager();
    @Nullable
    private MountDelegate mMountDelegate;
    @Nullable
    private UnmountDelegateExtension mUnmountDelegateExtension;
    @Nullable
    private TransitionsExtension mTransitionsExtension;
    @Nullable
    private ExtensionState mTransitionsExtensionState;
    @ComponentTree.RecyclingMode
    private int mRecyclingMode = 0;

    public MountState(LithoView view) {
        this.mIndexToItemMap = new LongSparseArray();
        this.mCanMountIncrementallyMountItems = new LongSparseArray();
        this.mContext = view.getComponentContext();
        this.mLithoView = view;
        this.mIsDirty = true;
        this.mTestItemMap = ComponentsConfiguration.isEndToEndTestRun ? new HashMap() : null;
        this.mRootHostMountItem = LithoMountData.createRootHostMountItem(this.mLithoView);
        this.mVisibilityExtension = VisibilityMountExtension.getInstance();
        this.mVisibilityExtensionState = this.mVisibilityExtension.createExtensionState(new MountDelegate((MountDelegateTarget)this));
        VisibilityMountExtension.setRootHost((ExtensionState)this.mVisibilityExtensionState, (Host)this.mLithoView);
        if (!this.mLithoView.usingExtensionsWithMountDelegate()) {
            this.mTransitionsExtension = TransitionsExtension.getInstance();
            this.registerMountDelegateExtension((MountExtension)this.mTransitionsExtension);
            this.mTransitionsExtensionState = this.getExtensionState((MountExtension)this.mTransitionsExtension);
        }
    }

    public void registerMountDelegateExtension(MountExtension mountExtension) {
        if (this.mMountDelegate == null) {
            this.mMountDelegate = new MountDelegate((MountDelegateTarget)this);
        }
        this.mMountDelegate.addExtension(mountExtension);
    }

    public void unregisterMountDelegateExtension(MountExtension mountExtension) {
        if (this.mMountDelegate == null) {
            return;
        }
        this.mMountDelegate.removeExtension(mountExtension);
    }

    void setDirty() {
        ThreadUtils.assertMainThread();
        this.mIsDirty = true;
        this.mPreviousLocalVisibleRect.setEmpty();
    }

    boolean isDirty() {
        ThreadUtils.assertMainThread();
        return this.mIsDirty;
    }

    public boolean needsRemount() {
        ThreadUtils.assertMainThread();
        return this.mNeedsRemount;
    }

    void setRecyclingMode(@ComponentTree.RecyclingMode int recyclingMode) {
        this.mRecyclingMode = recyclingMode;
    }

    void mount(LayoutState layoutState, @Nullable Rect localVisibleRect, boolean processVisibilityOutputs) {
        PerfEvent mountPerfEvent;
        ComponentTree componentTree = this.mLithoView.getComponentTree();
        boolean isIncrementalMountEnabled = componentTree.isIncrementalMountEnabled();
        boolean isVisibilityProcessingEnabled = componentTree.isVisibilityProcessingEnabled();
        ThreadUtils.assertMainThread();
        if (layoutState == null) {
            throw new IllegalStateException("Trying to mount a null layoutState");
        }
        if (this.mVisibilityExtension != null && this.mIsDirty) {
            this.mVisibilityExtension.beforeMount(this.mVisibilityExtensionState, (VisibilityExtensionInput)layoutState, localVisibleRect);
        }
        if (this.mTransitionsExtension != null && this.mIsDirty) {
            this.mTransitionsExtension.beforeMount(this.mTransitionsExtensionState, (TransitionsExtensionInput)layoutState, localVisibleRect);
        }
        this.mLayoutState = layoutState;
        if (this.mIsMounting) {
            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.FATAL, INVALID_REENTRANT_MOUNTS, "Trying to mount while already mounting! " + this.getMountItemDebugMessage(this.mRootHostMountItem));
        }
        this.mIsMounting = true;
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            String sectionName = isIncrementalMountEnabled ? "incrementalMount" : "mount";
            ComponentsSystrace.beginSectionWithArgs(sectionName).arg("treeId", layoutState.getComponentTreeId()).arg("component", componentTree.getSimpleName()).arg("logTag", componentTree.getContext().getLogTag()).flush();
            ComponentsSystrace.beginSection(sectionName + "_" + componentTree.getSimpleName());
        }
        ComponentsLogger logger = componentTree.getContext().getLogger();
        int componentTreeId = layoutState.getComponentTreeId();
        if (componentTreeId != this.mLastMountedComponentTreeId) {
            this.mLastMountedLayoutState = null;
        }
        PerfEvent perfEvent = mountPerfEvent = logger == null ? null : LogTreePopulator.populatePerfEventFromLogger(componentTree.getContext(), logger, logger.newPerformanceEvent(componentTree.getContext(), 6));
        if (this.mIsDirty) {
            if (mountPerfEvent != null) {
                mountPerfEvent.markerPoint("PREPARE_MOUNT_START");
            }
            this.prepareMount(layoutState, mountPerfEvent);
            if (mountPerfEvent != null) {
                mountPerfEvent.markerPoint("PREPARE_MOUNT_END");
            }
        }
        this.mMountStats.reset();
        if (mountPerfEvent != null && logger.isTracing(mountPerfEvent)) {
            this.mMountStats.enableLogging();
        }
        if (!isIncrementalMountEnabled || !this.performIncrementalMount(layoutState, localVisibleRect, processVisibilityOutputs)) {
            MountItem rootMountItem = (MountItem)this.mIndexToItemMap.get(0L);
            int size = layoutState.getMountableOutputCount();
            for (int i = 0; i < size; ++i) {
                boolean isMountable;
                MountItem currentMountItem;
                RenderTreeNode node = layoutState.getMountableOutputAt(i);
                LayoutOutput layoutOutput = LayoutOutput.getLayoutOutput(node);
                Component component = layoutOutput.getComponent();
                if (isTracing) {
                    ComponentsSystrace.beginSection(component.getSimpleName());
                }
                boolean isMounted = (currentMountItem = this.getItemAt(i)) != null;
                boolean isRoot = currentMountItem != null && currentMountItem == rootMountItem;
                boolean bl = isMountable = !isIncrementalMountEnabled || MountState.isMountedHostWithChildContent(currentMountItem) || Rect.intersects((Rect)localVisibleRect, (Rect)layoutOutput.getBounds()) || this.isAnimationLocked(node) || isRoot;
                if (isMountable && !isMounted) {
                    this.mountLayoutOutput(i, node, layoutOutput, layoutState);
                    if (isIncrementalMountEnabled) {
                        this.applyMountBinders(layoutOutput, this.getItemAt(i), i);
                    }
                } else if (!isMountable && isMounted) {
                    this.unmountItem(i, this.mHostsByMarker);
                } else if (isMounted) {
                    if (this.mIsDirty || isRoot && this.mNeedsRemount) {
                        boolean useUpdateValueFromLayoutOutput = this.mLastMountedLayoutState != null && this.mLastMountedLayoutState.getId() == layoutState.getPreviousLayoutStateId();
                        long startTime = System.nanoTime();
                        boolean itemUpdated = this.updateMountItemIfNeeded(node, currentMountItem, useUpdateValueFromLayoutOutput, componentTreeId, i);
                        if (this.mMountStats.isLoggingEnabled) {
                            if (itemUpdated) {
                                this.mMountStats.updatedNames.add(component.getSimpleName());
                                this.mMountStats.updatedTimes.add((double)(System.nanoTime() - startTime) / 1000000.0);
                                this.mMountStats.updatedCount++;
                            } else {
                                this.mMountStats.noOpCount++;
                            }
                        }
                    }
                    if (isIncrementalMountEnabled && component.hasChildLithoViews()) {
                        MountState.mountItemIncrementally(currentMountItem, processVisibilityOutputs);
                    }
                }
                if (!isTracing) continue;
                ComponentsSystrace.endSection();
            }
            if (isIncrementalMountEnabled) {
                this.setupPreviousMountableOutputData(layoutState, localVisibleRect);
            }
        }
        this.afterMountMaybeUpdateAnimations();
        if (isVisibilityProcessingEnabled) {
            if (isTracing) {
                ComponentsSystrace.beginSection("processVisibilityOutputs");
            }
            if (mountPerfEvent != null) {
                mountPerfEvent.markerPoint("EVENT_PROCESS_VISIBILITY_OUTPUTS_START");
            }
            this.processVisibilityOutputs(layoutState, localVisibleRect, this.mPreviousLocalVisibleRect, this.mIsDirty, mountPerfEvent);
            if (mountPerfEvent != null) {
                mountPerfEvent.markerPoint("EVENT_PROCESS_VISIBILITY_OUTPUTS_END");
            }
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
        boolean wasDirty = this.mIsDirty;
        this.mIsDirty = false;
        this.mNeedsRemount = false;
        if (localVisibleRect != null) {
            this.mPreviousLocalVisibleRect.set(localVisibleRect);
        }
        this.mLastMountedLayoutState = null;
        this.mLastMountedComponentTreeId = componentTreeId;
        this.mLastMountedLayoutState = layoutState;
        this.processTestOutputs(layoutState);
        if (mountPerfEvent != null) {
            this.logMountPerfEvent(logger, mountPerfEvent, wasDirty);
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
            ComponentsSystrace.endSection();
        }
        LithoStats.incrementComponentMountCount();
        this.mIsMounting = false;
    }

    private void afterMountMaybeUpdateAnimations() {
        if (this.mTransitionsExtension != null && this.mIsDirty) {
            this.mTransitionsExtension.afterMount(this.mTransitionsExtensionState);
        }
    }

    public void mount(RenderTree renderTree) {
        LayoutState layoutState = (LayoutState)renderTree.getRenderTreeData();
        this.mount(layoutState, true);
    }

    void mount(LayoutState layoutState, boolean processVisibilityOutputs) {
        PerfEvent mountPerfEvent;
        ThreadUtils.assertMainThread();
        if (layoutState == null) {
            throw new IllegalStateException("Trying to mount a null layoutState");
        }
        this.mLayoutState = layoutState;
        if (this.mIsMounting) {
            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.FATAL, INVALID_REENTRANT_MOUNTS, "Trying to mount while already mounting! " + this.getMountItemDebugMessage(this.mRootHostMountItem));
        }
        this.mIsMounting = true;
        ComponentTree componentTree = this.mLithoView.getComponentTree();
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSectionWithArgs("mount").arg("treeId", layoutState.getComponentTreeId()).arg("component", componentTree.getSimpleName()).arg("logTag", componentTree.getContext().getLogTag()).flush();
        }
        ComponentsLogger logger = componentTree.getContext().getLogger();
        int componentTreeId = layoutState.getComponentTreeId();
        if (componentTreeId != this.mLastMountedComponentTreeId) {
            this.mLastMountedLayoutState = null;
        }
        PerfEvent perfEvent = mountPerfEvent = logger == null ? null : LogTreePopulator.populatePerfEventFromLogger(componentTree.getContext(), logger, logger.newPerformanceEvent(componentTree.getContext(), 6));
        if (mountPerfEvent != null) {
            mountPerfEvent.markerPoint("PREPARE_MOUNT_START");
        }
        this.prepareMount(layoutState, mountPerfEvent);
        if (mountPerfEvent != null) {
            mountPerfEvent.markerPoint("PREPARE_MOUNT_END");
        }
        this.mMountStats.reset();
        if (mountPerfEvent != null && logger.isTracing(mountPerfEvent)) {
            this.mMountStats.enableLogging();
        }
        int size = layoutState.getMountableOutputCount();
        for (int i = 0; i < size; ++i) {
            MountItem currentMountItem;
            RenderTreeNode renderTreeNode = layoutState.getMountableOutputAt(i);
            LayoutOutput layoutOutput = LayoutOutput.getLayoutOutput(renderTreeNode);
            Component component = layoutOutput.getComponent();
            if (isTracing) {
                ComponentsSystrace.beginSection(component.getSimpleName());
            }
            boolean isMounted = (currentMountItem = this.getItemAt(i)) != null;
            boolean isMountable = this.isMountable(renderTreeNode, i);
            if (!isMountable) {
                if (isMounted) {
                    this.unmountItem(i, this.mHostsByMarker);
                }
            } else if (!isMounted) {
                this.mountLayoutOutput(i, renderTreeNode, layoutOutput, layoutState);
                this.applyMountBinders(layoutOutput, this.getItemAt(i), i);
            } else {
                boolean useUpdateValueFromLayoutOutput = this.mLastMountedLayoutState != null && this.mLastMountedLayoutState.getId() == layoutState.getPreviousLayoutStateId();
                long startTime = System.nanoTime();
                boolean itemUpdated = this.updateMountItemIfNeeded(renderTreeNode, currentMountItem, useUpdateValueFromLayoutOutput, componentTreeId, i);
                if (this.mMountStats.isLoggingEnabled) {
                    if (itemUpdated) {
                        this.mMountStats.updatedNames.add(component.getSimpleName());
                        this.mMountStats.updatedTimes.add((double)(System.nanoTime() - startTime) / 1000000.0);
                        this.mMountStats.updatedCount++;
                    } else {
                        this.mMountStats.noOpCount++;
                    }
                }
                this.applyBindBinders(currentMountItem);
            }
            if (!isTracing) continue;
            ComponentsSystrace.endSection();
        }
        boolean wasDirty = this.mIsDirty;
        this.mIsDirty = false;
        this.mNeedsRemount = false;
        this.mLastMountedLayoutState = null;
        this.mLastMountedComponentTreeId = componentTreeId;
        this.mLastMountedLayoutState = layoutState;
        if (mountPerfEvent != null) {
            this.logMountPerfEvent(logger, mountPerfEvent, wasDirty);
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
        LithoStats.incrementComponentMountCount();
        this.mIsMounting = false;
    }

    private void applyMountBinders(LayoutOutput layoutOutput, MountItem mountItem, int position) {
        if (this.mTransitionsExtension != null) {
            this.mTransitionsExtension.onMountItem(this.mTransitionsExtensionState, mountItem.getRenderTreeNode().getRenderUnit(), mountItem.getContent(), mountItem.getRenderTreeNode().getLayoutData());
        } else if (this.mMountDelegate != null) {
            this.mMountDelegate.onMountItem(mountItem.getRenderTreeNode().getRenderUnit(), mountItem.getContent(), mountItem.getRenderTreeNode().getLayoutData());
        }
    }

    private void applyBindBinders(MountItem mountItem) {
        if (this.mMountDelegate == null) {
            return;
        }
    }

    private void applyUnbindBinders(LayoutOutput output, MountItem mountItem) {
        if (this.mTransitionsExtension != null) {
            this.mTransitionsExtension.onUnbindItem(this.mTransitionsExtensionState, mountItem.getRenderTreeNode().getRenderUnit(), (Object)output, mountItem.getContent());
        } else if (this.mMountDelegate != null) {
            this.mMountDelegate.onUnmountItem(mountItem.getRenderTreeNode().getRenderUnit(), (Object)output, mountItem.getContent());
        }
    }

    private boolean isMountable(RenderTreeNode renderTreeNode, int position) {
        if (this.mMountDelegate == null) {
            return true;
        }
        boolean isLockedForMount = this.mMountDelegate.maybeLockForMount(renderTreeNode, position);
        return isLockedForMount;
    }

    public void notifyMount(long id2) {
        if (this.mLayoutState == null) {
            return;
        }
        int position = this.mLayoutState.getPositionForId(id2);
        if (position < 0 || this.getItemAt(position) != null) {
            return;
        }
        RenderTreeNode node = this.mLayoutState.getMountableOutputAt(position);
        this.mountLayoutOutput(position, node, LayoutOutput.getLayoutOutput(node), this.mLayoutState);
    }

    public void notifyUnmount(long id2) {
        MountItem item = (MountItem)this.mIndexToItemMap.get(id2);
        if (item == null) {
            return;
        }
        int position = LayoutOutput.getLayoutOutput(item).getIndex();
        this.unmountItem(position, this.mHostsByMarker);
    }

    private void logMountPerfEvent(ComponentsLogger logger, PerfEvent mountPerfEvent, boolean isDirty) {
        if (!this.mMountStats.isLoggingEnabled) {
            logger.cancelPerfEvent(mountPerfEvent);
            return;
        }
        if (this.mMountStats.mountedCount == 0 || this.mMountStats.mountedNames.isEmpty()) {
            logger.cancelPerfEvent(mountPerfEvent);
            return;
        }
        mountPerfEvent.markerAnnotate("mounted_count", this.mMountStats.mountedCount);
        mountPerfEvent.markerAnnotate("mounted_content", this.mMountStats.mountedNames.toArray(new String[0]));
        mountPerfEvent.markerAnnotate("mounted_time_ms", this.mMountStats.mountTimes.toArray(new Double[0]));
        mountPerfEvent.markerAnnotate("unmounted_count", this.mMountStats.unmountedCount);
        mountPerfEvent.markerAnnotate("unmounted_content", this.mMountStats.unmountedNames.toArray(new String[0]));
        mountPerfEvent.markerAnnotate("unmounted_time_ms", this.mMountStats.unmountedTimes.toArray(new Double[0]));
        mountPerfEvent.markerAnnotate("mounted_extras", this.mMountStats.extras.toArray(new String[0]));
        mountPerfEvent.markerAnnotate("updated_count", this.mMountStats.updatedCount);
        mountPerfEvent.markerAnnotate("updated_content", this.mMountStats.updatedNames.toArray(new String[0]));
        mountPerfEvent.markerAnnotate("updated_time_ms", this.mMountStats.updatedTimes.toArray(new Double[0]));
        mountPerfEvent.markerAnnotate("visibility_handlers_total_time_ms", this.mMountStats.visibilityHandlersTotalTime);
        mountPerfEvent.markerAnnotate("visibility_handler", this.mMountStats.visibilityHandlerNames.toArray(new String[0]));
        mountPerfEvent.markerAnnotate("visibility_handler_time_ms", this.mMountStats.visibilityHandlerTimes.toArray(new Double[0]));
        mountPerfEvent.markerAnnotate("no_op_count", this.mMountStats.noOpCount);
        mountPerfEvent.markerAnnotate("is_dirty", isDirty);
        logger.logPerfEvent(mountPerfEvent);
    }

    void processVisibilityOutputs(LayoutState layoutState, @Nullable Rect localVisibleRect, Rect previousLocalVisibleRect, boolean isDirty, @Nullable PerfEvent mountPerfEvent) {
        if (isDirty) {
            this.mVisibilityExtension.afterMount(this.mVisibilityExtensionState);
        } else {
            this.mVisibilityExtension.onVisibleBoundsChanged(this.mVisibilityExtensionState, localVisibleRect);
        }
    }

    @VisibleForTesting
    Map<String, VisibilityItem> getVisibilityIdToItemMap() {
        return VisibilityMountExtension.getVisibilityIdToItemMap((ExtensionState)this.mVisibilityExtensionState);
    }

    @VisibleForTesting
    public ArrayList<Host> getHosts() {
        ArrayList<Host> hosts = new ArrayList<Host>();
        int size = this.mHostsByMarker.size();
        for (int i = 0; i < size; ++i) {
            hosts.add((Host)this.mHostsByMarker.valueAt(i));
        }
        return hosts;
    }

    public int getMountItemCount() {
        return this.mIndexToItemMap.size();
    }

    public int getRenderUnitCount() {
        ThreadUtils.assertMainThread();
        return this.mLayoutOutputsIds == null ? 0 : this.mLayoutOutputsIds.length;
    }

    @Nullable
    public MountItem getMountItemAt(int position) {
        return this.getItemAt(position);
    }

    public void setUnmountDelegateExtension(UnmountDelegateExtension unmountDelegateExtension) {
        this.mUnmountDelegateExtension = unmountDelegateExtension;
    }

    public void removeUnmountDelegateExtension() {
        this.mUnmountDelegateExtension = null;
    }

    @Nullable
    public ExtensionState getExtensionState(MountExtension mountExtension) {
        if (mountExtension == this.mVisibilityExtension) {
            return this.mVisibilityExtensionState;
        }
        return this.mMountDelegate.getExtensionState(mountExtension);
    }

    private void processTestOutputs(LayoutState layoutState) {
        if (this.mTestItemMap == null) {
            return;
        }
        this.mTestItemMap.clear();
        int size = layoutState.getTestOutputCount();
        for (int i = 0; i < size; ++i) {
            TestOutput testOutput = layoutState.getTestOutputAt(i);
            long hostMarker = testOutput.getHostMarker();
            long layoutOutputId = testOutput.getLayoutOutputId();
            MountItem mountItem = layoutOutputId == -1L ? null : (MountItem)this.mIndexToItemMap.get(layoutOutputId);
            TestItem testItem = new TestItem();
            testItem.setHost(hostMarker == -1L ? null : (ComponentHost)((Object)this.mHostsByMarker.get(hostMarker)));
            testItem.setBounds(testOutput.getBounds());
            testItem.setTestKey(testOutput.getTestKey());
            testItem.setContent(mountItem == null ? null : mountItem.getContent());
            LinkedList<TestItem> items = this.mTestItemMap.get(testOutput.getTestKey());
            LinkedList<TestItem> updatedItems = items == null ? new LinkedList<TestItem>() : items;
            updatedItems.add(testItem);
            this.mTestItemMap.put(testOutput.getTestKey(), updatedItems);
        }
    }

    private static boolean isMountedHostWithChildContent(@Nullable MountItem mountItem) {
        if (mountItem == null) {
            return false;
        }
        Object content = mountItem.getContent();
        if (!(content instanceof ComponentHost)) {
            return false;
        }
        ComponentHost host = (ComponentHost)((Object)content);
        return host.getMountItemCount() > 0;
    }

    private void setupPreviousMountableOutputData(LayoutState layoutState, Rect localVisibleRect) {
        int i;
        if (localVisibleRect.isEmpty()) {
            return;
        }
        List layoutOutputTops = layoutState.getOutputsOrderedByTopBounds();
        List layoutOutputBottoms = layoutState.getOutputsOrderedByBottomBounds();
        int mountableOutputCount = layoutState.getMountableOutputCount();
        this.mPreviousTopsIndex = layoutState.getMountableOutputCount();
        for (i = 0; i < mountableOutputCount; ++i) {
            if (localVisibleRect.bottom > layoutState.getLayoutOutput((IncrementalMountOutput)((IncrementalMountOutput)((ArrayList)layoutOutputTops).get((int)i))).getBounds().top) continue;
            this.mPreviousTopsIndex = i;
            break;
        }
        this.mPreviousBottomsIndex = layoutState.getMountableOutputCount();
        for (i = 0; i < mountableOutputCount; ++i) {
            if (localVisibleRect.top >= layoutState.getLayoutOutput((IncrementalMountOutput)((IncrementalMountOutput)((ArrayList)layoutOutputBottoms).get((int)i))).getBounds().bottom) continue;
            this.mPreviousBottomsIndex = i;
            break;
        }
    }

    List<LithoView> getChildLithoViewsFromCurrentlyMountedItems() {
        ArrayList<LithoView> childLithoViews = new ArrayList<LithoView>();
        for (int i = 0; i < this.mIndexToItemMap.size(); ++i) {
            long layoutOutputId = this.mIndexToItemMap.keyAt(i);
            MountItem mountItem = (MountItem)this.mIndexToItemMap.get(layoutOutputId);
            if (mountItem == null || !(mountItem.getContent() instanceof HasLithoViewChildren)) continue;
            ((HasLithoViewChildren)mountItem.getContent()).obtainLithoViewChildren(childLithoViews);
        }
        return childLithoViews;
    }

    void clearVisibilityItems() {
        VisibilityMountExtension.clearVisibilityItems((ExtensionState)this.mVisibilityExtensionState);
    }

    private void registerHost(long id2, ComponentHost host) {
        this.mHostsByMarker.put(id2, (Object)host);
    }

    private static int computeRectArea(Rect rect) {
        return rect.isEmpty() ? 0 : rect.width() * rect.height();
    }

    private boolean updateMountItemIfNeeded(RenderTreeNode node, MountItem currentMountItem, boolean useUpdateValueFromLayoutOutput, int componentTreeId, int index) {
        boolean shouldUpdateViewInfo;
        LayoutOutput nextLayoutOutput = LayoutOutput.getLayoutOutput(node);
        Component layoutOutputComponent = nextLayoutOutput.getComponent();
        LayoutOutput currentLayoutOutput = LayoutOutput.getLayoutOutput(currentMountItem);
        Component itemComponent = currentLayoutOutput.getComponent();
        Object currentContent = currentMountItem.getContent();
        ComponentHost host = (ComponentHost)currentMountItem.getHost();
        if (layoutOutputComponent == null) {
            throw new RuntimeException("Trying to update a MountItem with a null Component.");
        }
        boolean shouldUpdate = MountState.shouldUpdateMountItem(nextLayoutOutput, currentLayoutOutput, useUpdateValueFromLayoutOutput);
        boolean bl = shouldUpdateViewInfo = shouldUpdate || MountState.shouldUpdateViewInfo(nextLayoutOutput, currentLayoutOutput);
        if (shouldUpdateViewInfo) {
            MountState.maybeUnsetViewAttributes(currentMountItem);
        }
        if (currentMountItem.isBound()) {
            this.unbindComponentFromContent(currentMountItem, itemComponent, currentMountItem.getContent());
        }
        currentMountItem.update(node);
        if (shouldUpdate) {
            this.updateMountedContent(currentMountItem, nextLayoutOutput, currentLayoutOutput);
        }
        if (shouldUpdateViewInfo) {
            MountState.setViewAttributes(currentMountItem);
        }
        this.bindComponentToContent(currentMountItem, layoutOutputComponent, currentContent);
        MountState.updateBoundsForMountedLayoutOutput(nextLayoutOutput, currentMountItem);
        if (currentMountItem.getContent() instanceof Drawable) {
            ComponentHostUtils.maybeSetDrawableState((View)host, (Drawable)currentContent, currentLayoutOutput.getFlags(), currentLayoutOutput.getNodeInfo());
        }
        return shouldUpdate;
    }

    static boolean shouldUpdateViewInfo(LayoutOutput nextLayoutOutput, LayoutOutput currentLayoutOutput) {
        ViewNodeInfo nextViewNodeInfo = nextLayoutOutput.getViewNodeInfo();
        ViewNodeInfo currentViewNodeInfo = currentLayoutOutput.getViewNodeInfo();
        if (currentViewNodeInfo == null && nextViewNodeInfo != null || currentViewNodeInfo != null && !currentViewNodeInfo.isEquivalentTo(nextViewNodeInfo)) {
            return true;
        }
        NodeInfo nextNodeInfo = nextLayoutOutput.getNodeInfo();
        NodeInfo currentNodeInfo = currentLayoutOutput.getNodeInfo();
        return currentNodeInfo == null && nextNodeInfo != null || currentNodeInfo != null && !currentNodeInfo.isEquivalentTo(nextNodeInfo);
    }

    static boolean shouldUpdateMountItem(LayoutOutput nextLayoutOutput, LayoutOutput currentLayoutOutput, boolean useUpdateValueFromLayoutOutput) {
        int updateState = nextLayoutOutput.getUpdateState();
        Component currentComponent = currentLayoutOutput.getComponent();
        Component nextComponent = nextLayoutOutput.getComponent();
        if (ComponentsConfiguration.shouldForceComponentUpdateOnOrientationChange && nextLayoutOutput.getOrientation() != currentLayoutOutput.getOrientation()) {
            return true;
        }
        if (nextComponent.isMountSizeDependent() && !MountState.sameSize(nextLayoutOutput, currentLayoutOutput)) {
            return true;
        }
        if (useUpdateValueFromLayoutOutput) {
            if (updateState == 1) {
                return currentComponent instanceof DrawableComponent && nextComponent instanceof DrawableComponent && currentComponent.shouldComponentUpdate(currentLayoutOutput.getScopedContext(), currentComponent, nextLayoutOutput.getScopedContext(), nextComponent);
            }
            if (updateState == 2) {
                return true;
            }
        }
        return currentComponent.shouldComponentUpdate(currentLayoutOutput.getScopedContext(), currentComponent, nextLayoutOutput.getScopedContext(), nextComponent);
    }

    static boolean sameSize(LayoutOutput nextOutput, LayoutOutput currentOutput) {
        Rect nextBounds = nextOutput.getBounds();
        Rect currentBounds = currentOutput.getBounds();
        return nextBounds.width() == currentBounds.width() && nextBounds.height() == currentBounds.height();
    }

    private static void updateBoundsForMountedLayoutOutput(LayoutOutput layoutOutput, MountItem item) {
        if (layoutOutput.getId() == 0L) {
            return;
        }
        layoutOutput.getMountBounds(sTempRect);
        boolean forceTraversal = Component.isMountViewSpec(layoutOutput.getComponent()) && ((View)item.getContent()).isLayoutRequested();
        MountState.applyBoundsToMountContent(item.getContent(), MountState.sTempRect.left, MountState.sTempRect.top, MountState.sTempRect.right, MountState.sTempRect.bottom, forceTraversal);
    }

    private void prepareMount(LayoutState layoutState, @Nullable PerfEvent perfEvent) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("prepareMount");
        }
        PrepareMountStats stats = this.unmountOrMoveOldItems(layoutState);
        if (perfEvent != null) {
            perfEvent.markerAnnotate("unmounted_count", stats.unmountedCount);
            perfEvent.markerAnnotate("moved_count", stats.movedCount);
            perfEvent.markerAnnotate("unchanged_count", stats.unchangedCount);
        }
        if (this.mHostsByMarker.get(0L) == null) {
            this.registerHost(0L, this.mLithoView);
            this.mIndexToItemMap.put(0L, (Object)this.mRootHostMountItem);
        }
        int outputCount = layoutState.getMountableOutputCount();
        if (this.mLayoutOutputsIds == null || outputCount != this.mLayoutOutputsIds.length) {
            this.mLayoutOutputsIds = new long[outputCount];
        }
        for (int i = 0; i < outputCount; ++i) {
            this.mLayoutOutputsIds[i] = LayoutOutput.getLayoutOutput(layoutState.getMountableOutputAt(i)).getId();
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    private PrepareMountStats unmountOrMoveOldItems(LayoutState newLayoutState) {
        this.mPrepareMountStats.reset();
        if (this.mLayoutOutputsIds == null) {
            return this.mPrepareMountStats;
        }
        for (int i = 0; i < this.mLayoutOutputsIds.length; ++i) {
            boolean hasUnmountDelegate;
            LayoutOutput newLayoutOutput = newLayoutState.getLayoutOutput(this.mLayoutOutputsIds[i]);
            int newPosition = newLayoutOutput == null ? -1 : newLayoutOutput.getIndex();
            MountItem oldItem = this.getItemAt(i);
            boolean bl = hasUnmountDelegate = this.mUnmountDelegateExtension != null && oldItem != null ? this.mUnmountDelegateExtension.shouldDelegateUnmount(this.mMountDelegate.getUnmountDelegateExtensionState(), oldItem) : false;
            if (hasUnmountDelegate) continue;
            if (newPosition == -1) {
                this.unmountItem(i, this.mHostsByMarker);
                this.mPrepareMountStats.unmountedCount++;
                continue;
            }
            long newHostMarker = newLayoutOutput.getHostMarker();
            if (oldItem == null) {
                this.mPrepareMountStats.unmountedCount++;
                continue;
            }
            if (oldItem.getHost() != this.mHostsByMarker.get(newHostMarker)) {
                this.unmountItem(i, this.mHostsByMarker);
                this.mPrepareMountStats.unmountedCount++;
                continue;
            }
            if (newPosition != i) {
                oldItem.getHost().moveItem(oldItem, i, newPosition);
                this.mPrepareMountStats.movedCount++;
                continue;
            }
            this.mPrepareMountStats.unchangedCount++;
        }
        return this.mPrepareMountStats;
    }

    private void updateMountedContent(MountItem item, LayoutOutput newLayoutOutput, LayoutOutput previousLayoutOutput) {
        Component newComponent = newLayoutOutput.getComponent();
        Component previousComponent = previousLayoutOutput.getComponent();
        if (Component.isHostSpec(newComponent)) {
            return;
        }
        Object previousContent = item.getContent();
        previousComponent.unmount(this.getContextForComponent(previousComponent, previousLayoutOutput), previousContent);
        newComponent.mount(this.getContextForComponent(newComponent, newLayoutOutput), previousContent);
    }

    private void mountLayoutOutput(int index, RenderTreeNode node, LayoutOutput layoutOutput, LayoutState layoutState) {
        Component component;
        long startTime = System.nanoTime();
        long hostMarker = layoutOutput.getHostMarker();
        ComponentHost host = (ComponentHost)((Object)this.mHostsByMarker.get(hostMarker));
        if (host == null) {
            int hostMountIndex = layoutState.getPositionForId(hostMarker);
            RenderTreeNode hostNode = layoutState.getMountableOutputAt(hostMountIndex);
            LayoutOutput hostLayoutOutput = LayoutOutput.getLayoutOutput(hostNode);
            this.mountLayoutOutput(hostMountIndex, hostNode, hostLayoutOutput, layoutState);
            host = (ComponentHost)((Object)this.mHostsByMarker.get(hostMarker));
        }
        if ((component = layoutOutput.getComponent()) == null) {
            throw new RuntimeException("Trying to mount a LayoutOutput with a null Component.");
        }
        Object content = ComponentsPools.acquireMountContent(this.mContext.getAndroidContext(), component, this.mRecyclingMode);
        ComponentContext context = this.getContextForComponent(component, layoutOutput);
        component.mount(context, content);
        if (Component.isHostSpec(component)) {
            ComponentHost componentHost = (ComponentHost)((Object)content);
            this.registerHost(layoutOutput.getId(), componentHost);
        }
        MountItem item = this.mountContent(index, component, content, host, node, layoutOutput);
        this.bindComponentToContent(item, component, content);
        layoutOutput.getMountBounds(sTempRect);
        MountState.applyBoundsToMountContent(item.getContent(), MountState.sTempRect.left, MountState.sTempRect.top, MountState.sTempRect.right, MountState.sTempRect.bottom, true);
        if (this.mMountStats.isLoggingEnabled) {
            this.mMountStats.mountTimes.add((double)(System.nanoTime() - startTime) / 1000000.0);
            this.mMountStats.mountedNames.add(component.getSimpleName());
            this.mMountStats.mountedCount++;
            ComponentContext scopedContext = this.mUseStatelessComponent ? layoutOutput.getScopedContext() : component.getScopedContext(null, null);
            this.mMountStats.extras.add(LogTreePopulator.getAnnotationBundleFromLogger(scopedContext, context.getLogger()));
        }
    }

    private MountItem mountContent(int index, Component component, Object content, ComponentHost host, RenderTreeNode node, LayoutOutput layoutOutput) {
        MountItem item = new MountItem(node, (Host)host, content);
        item.setMountData((Object)new LithoMountData(content));
        this.mIndexToItemMap.put(this.mLayoutOutputsIds[index], (Object)item);
        if (component.hasChildLithoViews()) {
            this.mCanMountIncrementallyMountItems.put(this.mLayoutOutputsIds[index], (Object)item);
        }
        MountState.mount(host, index, content, item, layoutOutput);
        MountState.setViewAttributes(item);
        return item;
    }

    private static void mount(ComponentHost host, int index, Object content, MountItem item, LayoutOutput output) {
        output.getMountBounds(sTempRect);
        host.mount(index, item, sTempRect);
    }

    private static void unmount(ComponentHost host, int index, Object content, MountItem item, LayoutOutput output) {
        host.unmount(index, item);
    }

    private static void applyBoundsToMountContent(Object content, int left, int top, int right, int bottom, boolean force) {
        ThreadUtils.assertMainThread();
        BoundsUtils.applyBoundsToMountContent((int)left, (int)top, (int)right, (int)bottom, null, (Object)content, (boolean)force);
    }

    private static void setViewAttributes(MountItem item) {
        MountState.setViewAttributes(item.getContent(), LayoutOutput.getLayoutOutput(item));
    }

    static void setViewAttributes(Object content, LayoutOutput output) {
        Component component = output.getComponent();
        if (!Component.isMountViewSpec(component)) {
            return;
        }
        View view = (View)content;
        NodeInfo nodeInfo = output.getNodeInfo();
        if (nodeInfo != null) {
            MountState.setClickHandler(nodeInfo.getClickHandler(), view);
            MountState.setLongClickHandler(nodeInfo.getLongClickHandler(), view);
            MountState.setFocusChangeHandler(nodeInfo.getFocusChangeHandler(), view);
            MountState.setTouchHandler(nodeInfo.getTouchHandler(), view);
            MountState.setInterceptTouchHandler(nodeInfo.getInterceptTouchHandler(), view);
            MountState.setAccessibilityDelegate(view, nodeInfo);
            MountState.setViewTag(view, nodeInfo.getViewTag());
            MountState.setViewTags(view, nodeInfo.getViewTags());
            MountState.setShadowElevation(view, nodeInfo.getShadowElevation());
            MountState.setOutlineProvider(view, nodeInfo.getOutlineProvider());
            MountState.setClipToOutline(view, nodeInfo.getClipToOutline());
            MountState.setClipChildren(view, nodeInfo);
            MountState.setContentDescription(view, nodeInfo.getContentDescription());
            MountState.setFocusable(view, nodeInfo.getFocusState());
            MountState.setClickable(view, nodeInfo.getClickableState());
            MountState.setEnabled(view, nodeInfo.getEnabledState());
            MountState.setSelected(view, nodeInfo.getSelectedState());
            MountState.setScale(view, nodeInfo);
            MountState.setAlpha(view, nodeInfo);
            MountState.setRotation(view, nodeInfo);
            MountState.setRotationX(view, nodeInfo);
            MountState.setRotationY(view, nodeInfo);
            MountState.setTransitionName(view, nodeInfo.getTransitionName());
        }
        MountState.setImportantForAccessibility(view, output.getImportantForAccessibility());
        ViewNodeInfo viewNodeInfo = output.getViewNodeInfo();
        if (viewNodeInfo != null) {
            boolean isHostSpec = Component.isHostSpec(component);
            MountState.setViewLayerType(view, viewNodeInfo);
            MountState.setViewStateListAnimator(view, viewNodeInfo);
            if (LayoutOutput.areDrawableOutputsDisabled(output.getFlags())) {
                MountState.setViewBackground(view, viewNodeInfo);
                MountState.setViewForeground(view, viewNodeInfo);
                if (isHostSpec) {
                    view.setPadding(0, 0, 0, 0);
                }
            }
            if (!isHostSpec) {
                MountState.setViewBackground(view, viewNodeInfo);
                MountState.setViewPadding(view, viewNodeInfo);
                MountState.setViewForeground(view, viewNodeInfo);
                MountState.setViewLayoutDirection(view, viewNodeInfo);
            }
        }
    }

    private static void setViewLayerType(View view, ViewNodeInfo info) {
        int type = info.getLayerType();
        if (type != -1) {
            view.setLayerType(info.getLayerType(), info.getLayoutPaint());
        }
    }

    private static void unsetViewLayerType(View view, int mountFlags) {
        int type = LithoMountData.getOriginalLayerType(mountFlags);
        if (type != -1) {
            view.setLayerType(type, null);
        }
    }

    private static void maybeUnsetViewAttributes(MountItem item) {
        LayoutOutput output = LayoutOutput.getLayoutOutput(item);
        int flags = LithoMountData.getMountData(item).getDefaultAttributeValuesFlags();
        MountState.unsetViewAttributes(item.getContent(), output, flags);
    }

    static void unsetViewAttributes(Object content, LayoutOutput output, int mountFlags) {
        Component component = output.getComponent();
        boolean isHostView = Component.isHostSpec(component);
        if (!Component.isMountViewSpec(component)) {
            return;
        }
        View view = (View)content;
        NodeInfo nodeInfo = output.getNodeInfo();
        if (nodeInfo != null) {
            if (nodeInfo.getClickHandler() != null) {
                MountState.unsetClickHandler(view);
            }
            if (nodeInfo.getLongClickHandler() != null) {
                MountState.unsetLongClickHandler(view);
            }
            if (nodeInfo.getFocusChangeHandler() != null) {
                MountState.unsetFocusChangeHandler(view);
            }
            if (nodeInfo.getTouchHandler() != null) {
                MountState.unsetTouchHandler(view);
            }
            if (nodeInfo.getInterceptTouchHandler() != null) {
                MountState.unsetInterceptTouchEventHandler(view);
            }
            MountState.unsetViewTag(view);
            MountState.unsetViewTags(view, nodeInfo.getViewTags());
            MountState.unsetShadowElevation(view, nodeInfo.getShadowElevation());
            MountState.unsetOutlineProvider(view, nodeInfo.getOutlineProvider());
            MountState.unsetClipToOutline(view, nodeInfo.getClipToOutline());
            MountState.unsetClipChildren(view, nodeInfo.getClipChildren());
            if (!TextUtils.isEmpty((CharSequence)nodeInfo.getContentDescription())) {
                MountState.unsetContentDescription(view);
            }
            MountState.unsetScale(view, nodeInfo);
            MountState.unsetAlpha(view, nodeInfo);
            MountState.unsetRotation(view, nodeInfo);
            MountState.unsetRotationX(view, nodeInfo);
            MountState.unsetRotationY(view, nodeInfo);
        }
        view.setClickable(LithoMountData.isViewClickable(mountFlags));
        view.setLongClickable(LithoMountData.isViewLongClickable(mountFlags));
        MountState.unsetFocusable(view, mountFlags);
        MountState.unsetEnabled(view, mountFlags);
        MountState.unsetSelected(view, mountFlags);
        if (output.getImportantForAccessibility() != 0) {
            MountState.unsetImportantForAccessibility(view);
        }
        MountState.unsetAccessibilityDelegate(view);
        ViewNodeInfo viewNodeInfo = output.getViewNodeInfo();
        if (viewNodeInfo != null) {
            MountState.unsetViewStateListAnimator(view, viewNodeInfo);
            if (LayoutOutput.areDrawableOutputsDisabled(output.getFlags())) {
                MountState.unsetViewBackground(view, viewNodeInfo);
                MountState.unsetViewForeground(view, viewNodeInfo);
            }
            if (!isHostView) {
                MountState.unsetViewPadding(view, output, viewNodeInfo);
                MountState.unsetViewBackground(view, viewNodeInfo);
                MountState.unsetViewForeground(view, viewNodeInfo);
                MountState.unsetViewLayoutDirection(view);
            }
        }
        MountState.unsetViewLayerType(view, mountFlags);
    }

    private static void setAccessibilityDelegate(View view, NodeInfo nodeInfo) {
        if (!(view instanceof ComponentHost) && !nodeInfo.needsAccessibilityDelegate()) {
            return;
        }
        view.setTag(R.id.component_node_info, (Object)nodeInfo);
    }

    private static void unsetAccessibilityDelegate(View view) {
        if (!(view instanceof ComponentHost) && view.getTag(R.id.component_node_info) == null) {
            return;
        }
        view.setTag(R.id.component_node_info, null);
        if (!(view instanceof ComponentHost)) {
            ViewCompat.setAccessibilityDelegate((View)view, null);
        }
    }

    private static void setClickHandler(@Nullable EventHandler<ClickEvent> clickHandler, View view) {
        if (clickHandler == null) {
            return;
        }
        ComponentClickListener listener = MountState.getComponentClickListener(view);
        if (listener == null) {
            listener = new ComponentClickListener();
            MountState.setComponentClickListener(view, listener);
        }
        listener.setEventHandler(clickHandler);
        view.setClickable(true);
    }

    private static void unsetClickHandler(View view) {
        ComponentClickListener listener = MountState.getComponentClickListener(view);
        if (listener != null) {
            listener.setEventHandler(null);
        }
    }

    @Nullable
    static ComponentClickListener getComponentClickListener(View v) {
        if (v instanceof ComponentHost) {
            return ((ComponentHost)v).getComponentClickListener();
        }
        return (ComponentClickListener)v.getTag(R.id.component_click_listener);
    }

    static void setComponentClickListener(View v, ComponentClickListener listener) {
        if (v instanceof ComponentHost) {
            ((ComponentHost)v).setComponentClickListener(listener);
        } else {
            v.setOnClickListener((View.OnClickListener)listener);
            v.setTag(R.id.component_click_listener, (Object)listener);
        }
    }

    private static void setLongClickHandler(@Nullable EventHandler<LongClickEvent> longClickHandler, View view) {
        if (longClickHandler != null) {
            ComponentLongClickListener listener = MountState.getComponentLongClickListener(view);
            if (listener == null) {
                listener = new ComponentLongClickListener();
                MountState.setComponentLongClickListener(view, listener);
            }
            listener.setEventHandler(longClickHandler);
            view.setLongClickable(true);
        }
    }

    private static void unsetLongClickHandler(View view) {
        ComponentLongClickListener listener = MountState.getComponentLongClickListener(view);
        if (listener != null) {
            listener.setEventHandler(null);
        }
    }

    @Nullable
    static ComponentLongClickListener getComponentLongClickListener(View v) {
        if (v instanceof ComponentHost) {
            return ((ComponentHost)v).getComponentLongClickListener();
        }
        return (ComponentLongClickListener)v.getTag(R.id.component_long_click_listener);
    }

    static void setComponentLongClickListener(View v, ComponentLongClickListener listener) {
        if (v instanceof ComponentHost) {
            ((ComponentHost)v).setComponentLongClickListener(listener);
        } else {
            v.setOnLongClickListener((View.OnLongClickListener)listener);
            v.setTag(R.id.component_long_click_listener, (Object)listener);
        }
    }

    private static void setFocusChangeHandler(@Nullable EventHandler<FocusChangedEvent> focusChangeHandler, View view) {
        if (focusChangeHandler == null) {
            return;
        }
        ComponentFocusChangeListener listener = MountState.getComponentFocusChangeListener(view);
        if (listener == null) {
            listener = new ComponentFocusChangeListener();
            MountState.setComponentFocusChangeListener(view, listener);
        }
        listener.setEventHandler(focusChangeHandler);
    }

    private static void unsetFocusChangeHandler(View view) {
        ComponentFocusChangeListener listener = MountState.getComponentFocusChangeListener(view);
        if (listener != null) {
            listener.setEventHandler(null);
        }
    }

    static ComponentFocusChangeListener getComponentFocusChangeListener(View v) {
        if (v instanceof ComponentHost) {
            return ((ComponentHost)v).getComponentFocusChangeListener();
        }
        return (ComponentFocusChangeListener)v.getTag(R.id.component_focus_change_listener);
    }

    static void setComponentFocusChangeListener(View v, ComponentFocusChangeListener listener) {
        if (v instanceof ComponentHost) {
            ((ComponentHost)v).setComponentFocusChangeListener(listener);
        } else {
            v.setOnFocusChangeListener((View.OnFocusChangeListener)listener);
            v.setTag(R.id.component_focus_change_listener, (Object)listener);
        }
    }

    private static void setTouchHandler(@Nullable EventHandler<TouchEvent> touchHandler, View view) {
        if (touchHandler != null) {
            ComponentTouchListener listener = MountState.getComponentTouchListener(view);
            if (listener == null) {
                listener = new ComponentTouchListener();
                MountState.setComponentTouchListener(view, listener);
            }
            listener.setEventHandler(touchHandler);
        }
    }

    private static void unsetTouchHandler(View view) {
        ComponentTouchListener listener = MountState.getComponentTouchListener(view);
        if (listener != null) {
            listener.setEventHandler(null);
        }
    }

    private static void setInterceptTouchHandler(@Nullable EventHandler<InterceptTouchEvent> interceptTouchHandler, View view) {
        if (interceptTouchHandler == null) {
            return;
        }
        if (view instanceof ComponentHost) {
            ((ComponentHost)view).setInterceptTouchEventHandler(interceptTouchHandler);
        }
    }

    private static void unsetInterceptTouchEventHandler(View view) {
        if (view instanceof ComponentHost) {
            ((ComponentHost)view).setInterceptTouchEventHandler(null);
        }
    }

    @Nullable
    static ComponentTouchListener getComponentTouchListener(View v) {
        if (v instanceof ComponentHost) {
            return ((ComponentHost)v).getComponentTouchListener();
        }
        return (ComponentTouchListener)v.getTag(R.id.component_touch_listener);
    }

    static void setComponentTouchListener(View v, ComponentTouchListener listener) {
        if (v instanceof ComponentHost) {
            ((ComponentHost)v).setComponentTouchListener(listener);
        } else {
            v.setOnTouchListener((View.OnTouchListener)listener);
            v.setTag(R.id.component_touch_listener, (Object)listener);
        }
    }

    private static void setViewTag(View view, @Nullable Object viewTag) {
        view.setTag(viewTag);
    }

    private static void setViewTags(View view, @Nullable SparseArray<Object> viewTags) {
        if (viewTags == null) {
            return;
        }
        if (view instanceof ComponentHost) {
            ComponentHost host = (ComponentHost)view;
            host.setViewTags(viewTags);
        } else {
            int size = viewTags.size();
            for (int i = 0; i < size; ++i) {
                view.setTag(viewTags.keyAt(i), viewTags.valueAt(i));
            }
        }
    }

    private static void unsetViewTag(View view) {
        view.setTag(null);
    }

    private static void unsetViewTags(View view, @Nullable SparseArray<Object> viewTags) {
        if (view instanceof ComponentHost) {
            ComponentHost host = (ComponentHost)view;
            host.setViewTags(null);
        } else if (viewTags != null) {
            int size = viewTags.size();
            for (int i = 0; i < size; ++i) {
                view.setTag(viewTags.keyAt(i), null);
            }
        }
    }

    private static void setShadowElevation(View view, float shadowElevation) {
        if (shadowElevation != 0.0f) {
            ViewCompat.setElevation((View)view, (float)shadowElevation);
        }
    }

    private static void unsetShadowElevation(View view, float shadowElevation) {
        if (shadowElevation != 0.0f) {
            ViewCompat.setElevation((View)view, (float)0.0f);
        }
    }

    private static void setOutlineProvider(View view, @Nullable ViewOutlineProvider outlineProvider) {
        if (outlineProvider != null && Build.VERSION.SDK_INT >= 21) {
            view.setOutlineProvider(outlineProvider);
        }
    }

    private static void unsetOutlineProvider(View view, @Nullable ViewOutlineProvider outlineProvider) {
        if (outlineProvider != null && Build.VERSION.SDK_INT >= 21) {
            view.setOutlineProvider(ViewOutlineProvider.BACKGROUND);
        }
    }

    private static void setClipToOutline(View view, boolean clipToOutline) {
        if (clipToOutline && Build.VERSION.SDK_INT >= 21) {
            view.setClipToOutline(clipToOutline);
        }
    }

    private static void unsetClipToOutline(View view, boolean clipToOutline) {
        if (clipToOutline && Build.VERSION.SDK_INT >= 21) {
            view.setClipToOutline(false);
        }
    }

    private static void setClipChildren(View view, NodeInfo nodeInfo) {
        if (nodeInfo.isClipChildrenSet() && view instanceof ViewGroup) {
            ((ViewGroup)view).setClipChildren(nodeInfo.getClipChildren());
        }
    }

    private static void unsetClipChildren(View view, boolean clipChildren) {
        if (!clipChildren && view instanceof ViewGroup) {
            ((ViewGroup)view).setClipChildren(true);
        }
    }

    private static void setContentDescription(View view, @Nullable CharSequence contentDescription) {
        if (TextUtils.isEmpty((CharSequence)contentDescription)) {
            return;
        }
        view.setContentDescription(contentDescription);
    }

    private static void unsetContentDescription(View view) {
        view.setContentDescription(null);
    }

    private static void setImportantForAccessibility(View view, int importantForAccessibility) {
        if (importantForAccessibility == 0) {
            return;
        }
        ViewCompat.setImportantForAccessibility((View)view, (int)importantForAccessibility);
    }

    private static void unsetImportantForAccessibility(View view) {
        ViewCompat.setImportantForAccessibility((View)view, (int)0);
    }

    private static void setFocusable(View view, int focusState) {
        if (focusState == 1) {
            view.setFocusable(true);
        } else if (focusState == 2) {
            view.setFocusable(false);
        }
    }

    private static void unsetFocusable(View view, int flags) {
        view.setFocusable(LithoMountData.isViewFocusable(flags));
    }

    private static void setTransitionName(View view, @Nullable String transitionName) {
        ViewCompat.setTransitionName((View)view, (String)transitionName);
    }

    private static void setClickable(View view, int clickableState) {
        if (clickableState == 1) {
            view.setClickable(true);
        } else if (clickableState == 2) {
            view.setClickable(false);
        }
    }

    private static void setEnabled(View view, int enabledState) {
        if (enabledState == 1) {
            view.setEnabled(true);
        } else if (enabledState == 2) {
            view.setEnabled(false);
        }
    }

    private static void unsetEnabled(View view, int flags) {
        view.setEnabled(LithoMountData.isViewEnabled(flags));
    }

    private static void setSelected(View view, int selectedState) {
        if (selectedState == 1) {
            view.setSelected(true);
        } else if (selectedState == 2) {
            view.setSelected(false);
        }
    }

    private static void unsetSelected(View view, int flags) {
        view.setSelected(LithoMountData.isViewSelected(flags));
    }

    private static void setScale(View view, NodeInfo nodeInfo) {
        if (nodeInfo.isScaleSet()) {
            float scale = nodeInfo.getScale();
            view.setScaleX(scale);
            view.setScaleY(scale);
        }
    }

    private static void unsetScale(View view, NodeInfo nodeInfo) {
        if (nodeInfo.isScaleSet()) {
            if (view.getScaleX() != 1.0f) {
                view.setScaleX(1.0f);
            }
            if (view.getScaleY() != 1.0f) {
                view.setScaleY(1.0f);
            }
        }
    }

    private static void setAlpha(View view, NodeInfo nodeInfo) {
        if (nodeInfo.isAlphaSet()) {
            view.setAlpha(nodeInfo.getAlpha());
        }
    }

    private static void unsetAlpha(View view, NodeInfo nodeInfo) {
        if (nodeInfo.isAlphaSet() && view.getAlpha() != 1.0f) {
            view.setAlpha(1.0f);
        }
    }

    private static void setRotation(View view, NodeInfo nodeInfo) {
        if (nodeInfo.isRotationSet()) {
            view.setRotation(nodeInfo.getRotation());
        }
    }

    private static void unsetRotation(View view, NodeInfo nodeInfo) {
        if (nodeInfo.isRotationSet() && view.getRotation() != 0.0f) {
            view.setRotation(0.0f);
        }
    }

    private static void setRotationX(View view, NodeInfo nodeInfo) {
        if (nodeInfo.isRotationXSet()) {
            view.setRotationX(nodeInfo.getRotationX());
        }
    }

    private static void unsetRotationX(View view, NodeInfo nodeInfo) {
        if (nodeInfo.isRotationXSet() && view.getRotationX() != 0.0f) {
            view.setRotationX(0.0f);
        }
    }

    private static void setRotationY(View view, NodeInfo nodeInfo) {
        if (nodeInfo.isRotationYSet()) {
            view.setRotationY(nodeInfo.getRotationY());
        }
    }

    private static void unsetRotationY(View view, NodeInfo nodeInfo) {
        if (nodeInfo.isRotationYSet() && view.getRotationY() != 0.0f) {
            view.setRotationY(0.0f);
        }
    }

    private static void setViewPadding(View view, ViewNodeInfo viewNodeInfo) {
        if (!viewNodeInfo.hasPadding()) {
            return;
        }
        view.setPadding(viewNodeInfo.getPaddingLeft(), viewNodeInfo.getPaddingTop(), viewNodeInfo.getPaddingRight(), viewNodeInfo.getPaddingBottom());
    }

    private static void unsetViewPadding(View view, LayoutOutput output, ViewNodeInfo viewNodeInfo) {
        if (!viewNodeInfo.hasPadding()) {
            return;
        }
        try {
            view.setPadding(0, 0, 0, 0);
        }
        catch (NullPointerException e) {
            ErrorReporter.getInstance().report(LogLevel.ERROR, "LITHO:NPE:UNSET_PADDING", "From component: " + output.getComponent().getSimpleName(), (Throwable)e);
        }
    }

    private static void setViewBackground(View view, ViewNodeInfo viewNodeInfo) {
        Drawable background = viewNodeInfo.getBackground();
        if (background != null) {
            MountState.setBackgroundCompat(view, background);
        }
    }

    private static void unsetViewBackground(View view, ViewNodeInfo viewNodeInfo) {
        Drawable background = viewNodeInfo.getBackground();
        if (background != null) {
            MountState.setBackgroundCompat(view, null);
        }
    }

    private static void setBackgroundCompat(View view, Drawable drawable) {
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(drawable);
        } else {
            view.setBackground(drawable);
        }
    }

    private static void setViewForeground(View view, ViewNodeInfo viewNodeInfo) {
        Drawable foreground = viewNodeInfo.getForeground();
        if (foreground != null) {
            if (Build.VERSION.SDK_INT < 23) {
                throw new IllegalStateException("MountState has a ViewNodeInfo with foreground however the current Android version doesn't support foreground on Views");
            }
            view.setForeground(foreground);
        }
    }

    private static void unsetViewForeground(View view, ViewNodeInfo viewNodeInfo) {
        Drawable foreground = viewNodeInfo.getForeground();
        if (foreground != null) {
            if (Build.VERSION.SDK_INT < 23) {
                throw new IllegalStateException("MountState has a ViewNodeInfo with foreground however the current Android version doesn't support foreground on Views");
            }
            view.setForeground(null);
        }
    }

    private static void setViewLayoutDirection(View view, ViewNodeInfo viewNodeInfo) {
        int viewLayoutDirection;
        if (Build.VERSION.SDK_INT < 17) {
            return;
        }
        switch (viewNodeInfo.getLayoutDirection()) {
            case LTR: {
                viewLayoutDirection = 0;
                break;
            }
            case RTL: {
                viewLayoutDirection = 1;
                break;
            }
            default: {
                viewLayoutDirection = 2;
            }
        }
        view.setLayoutDirection(viewLayoutDirection);
    }

    private static void unsetViewLayoutDirection(View view) {
        if (Build.VERSION.SDK_INT < 17) {
            return;
        }
        view.setLayoutDirection(2);
    }

    private static void setViewStateListAnimator(View view, ViewNodeInfo viewNodeInfo) {
        StateListAnimator stateListAnimator = viewNodeInfo.getStateListAnimator();
        int stateListAnimatorRes = viewNodeInfo.getStateListAnimatorRes();
        if (stateListAnimator == null && stateListAnimatorRes == 0) {
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            throw new IllegalStateException("MountState has a ViewNodeInfo with stateListAnimator, however the current Android version doesn't support stateListAnimator on Views");
        }
        if (stateListAnimator == null) {
            stateListAnimator = AnimatorInflater.loadStateListAnimator((Context)view.getContext(), (int)stateListAnimatorRes);
        }
        view.setStateListAnimator(stateListAnimator);
    }

    private static void unsetViewStateListAnimator(View view, ViewNodeInfo viewNodeInfo) {
        if (viewNodeInfo.getStateListAnimator() == null && viewNodeInfo.getStateListAnimatorRes() == 0) {
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            throw new IllegalStateException("MountState has a ViewNodeInfo with stateListAnimator, however the current Android version doesn't support stateListAnimator on Views");
        }
        view.setStateListAnimator(null);
    }

    private static void mountItemIncrementally(MountItem item, boolean processVisibilityOutputs) {
        Component component = LayoutOutput.getLayoutOutput(item).getComponent();
        if (!Component.isMountViewSpec(component)) {
            return;
        }
        View view = (View)item.getContent();
        MountState.mountViewIncrementally(view, processVisibilityOutputs);
    }

    private static void mountViewIncrementally(View view, boolean processVisibilityOutputs) {
        ThreadUtils.assertMainThread();
        if (view instanceof LithoView) {
            LithoView lithoView = (LithoView)view;
            if (lithoView.isIncrementalMountEnabled()) {
                if (!processVisibilityOutputs) {
                    lithoView.notifyVisibleBoundsChanged(new Rect(0, 0, view.getWidth(), view.getHeight()), false);
                } else {
                    lithoView.notifyVisibleBoundsChanged();
                }
            }
        } else if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View childView = viewGroup.getChildAt(i);
                MountState.mountViewIncrementally(childView, processVisibilityOutputs);
            }
        }
    }

    private String getMountItemDebugMessage(MountItem item) {
        ComponentTree componentTree;
        int index = this.mIndexToItemMap.indexOfValue((Object)item);
        long id2 = -1L;
        int layoutOutputIndex = -1;
        if (index > -1) {
            id2 = this.mIndexToItemMap.keyAt(index);
            for (int i = 0; i < this.mLayoutOutputsIds.length; ++i) {
                if (id2 != this.mLayoutOutputsIds[i]) continue;
                layoutOutputIndex = i;
                break;
            }
        }
        String rootComponent = (componentTree = this.mLithoView.getComponentTree()) == null ? "<null_component_tree>" : componentTree.getRoot().getSimpleName();
        return "rootComponent=" + rootComponent + ", index=" + layoutOutputIndex + ", mapIndex=" + index + ", id=" + id2 + ", disappearRange=[" + this.mLastDisappearRangeStart + "," + this.mLastDisappearRangeEnd + "], contentType=" + (item.getContent() != null ? item.getContent().getClass() : "<null_content>") + ", component=" + (LayoutOutput.getLayoutOutput(item).getComponent() != null ? LayoutOutput.getLayoutOutput(item).getComponent().getSimpleName() : "<null_component>") + ", transitionId=" + LayoutOutput.getLayoutOutput(item).getTransitionId() + ", host=" + (item.getHost() != null ? item.getHost().getClass() : "<null_host>") + ", isRootHost=" + (this.mHostsByMarker.get(0L) == item.getHost());
    }

    public void unmountAllItems() {
        ThreadUtils.assertMainThread();
        if (this.mLayoutOutputsIds == null) {
            return;
        }
        for (int i = this.mLayoutOutputsIds.length - 1; i >= 0; --i) {
            this.unmountItem(i, this.mHostsByMarker);
        }
        this.mPreviousLocalVisibleRect.setEmpty();
        this.mNeedsRemount = true;
        if (this.mMountDelegate != null) {
            this.mMountDelegate.releaseAllAcquiredReferences();
        }
        if (this.mVisibilityExtension != null) {
            this.mVisibilityExtension.onUnmount(this.mVisibilityExtensionState);
        }
        if (this.mTransitionsExtension != null) {
            this.mTransitionsExtension.onUnmount(this.mTransitionsExtensionState);
        }
        this.clearLastMountedTree();
        this.clearVisibilityItems();
    }

    private void unmountItem(int index, LongSparseArray<ComponentHost> hostsByMarker) {
        Component component;
        ComponentHost host;
        boolean hasUnmountDelegate;
        MountItem item = this.getItemAt(index);
        long startTime = System.nanoTime();
        if (item == null) {
            return;
        }
        if (this.mLayoutOutputsIds[index] == 0L) {
            MountState.maybeUnsetViewAttributes(item);
            return;
        }
        long layoutOutputId = this.mLayoutOutputsIds[index];
        this.mIndexToItemMap.remove(layoutOutputId);
        Object content = item.getContent();
        boolean bl = hasUnmountDelegate = this.mUnmountDelegateExtension != null && this.mUnmountDelegateExtension.shouldDelegateUnmount(this.mMountDelegate.getUnmountDelegateExtensionState(), item);
        if (content instanceof ComponentHost && !(content instanceof LithoView)) {
            host = (ComponentHost)((Object)content);
            block0: for (int i = host.getMountItemCount() - 1; i >= 0; --i) {
                MountItem mountItem = host.getMountItemAt(i);
                if (this.mIndexToItemMap.indexOfValue((Object)mountItem) == -1) {
                    LayoutOutput output = LayoutOutput.getLayoutOutput(mountItem);
                    Component component2 = output.getComponent();
                    ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.ERROR, "UnmountItem:ChildNotFound", "Child of mount item not found in MountSate mIndexToItemMap, child_component: " + (component2 != null ? component2.getSimpleName() : null) + ", child_transitionId: " + output.getTransitionId());
                }
                long childLayoutOutputId = this.mIndexToItemMap.keyAt(this.mIndexToItemMap.indexOfValue((Object)mountItem));
                for (int mountIndex = this.mLayoutOutputsIds.length - 1; mountIndex >= 0; --mountIndex) {
                    if (this.mLayoutOutputsIds[mountIndex] != childLayoutOutputId) continue;
                    this.unmountItem(mountIndex, hostsByMarker);
                    continue block0;
                }
            }
            if (!hasUnmountDelegate && host.getMountItemCount() > 0) {
                LayoutOutput output = LayoutOutput.getLayoutOutput(item);
                component = output.getComponent();
                ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.ERROR, "UnmountItem:ChildsNotUnmounted", "Recursively unmounting items from a ComponentHost, left some items behind maybe because not tracked by its MountState, component: " + (component != null ? component.getSimpleName() : null) + ", transitionId: " + output.getTransitionId());
                throw new IllegalStateException("Recursively unmounting items from a ComponentHost, left some items behind maybe because not tracked by its MountState");
            }
        }
        host = (ComponentHost)item.getHost();
        LayoutOutput output = LayoutOutput.getLayoutOutput(item);
        component = output.getComponent();
        if (component.hasChildLithoViews()) {
            this.mCanMountIncrementallyMountItems.delete(this.mLayoutOutputsIds[index]);
        }
        if (Component.isHostSpec(component)) {
            ComponentHost componentHost = (ComponentHost)((Object)content);
            hostsByMarker.removeAt(hostsByMarker.indexOfValue((Object)componentHost));
        }
        if (hasUnmountDelegate) {
            this.mUnmountDelegateExtension.unmount(this.mMountDelegate.getUnmountDelegateExtensionState(), item, (Host)host);
        } else {
            if (content instanceof HasLithoViewChildren) {
                ArrayList<LithoView> lithoViews = new ArrayList<LithoView>();
                ((HasLithoViewChildren)content).obtainLithoViewChildren(lithoViews);
                for (int i = lithoViews.size() - 1; i >= 0; --i) {
                    LithoView lithoView = lithoViews.get(i);
                    lithoView.unmountAllItems();
                }
            }
            MountState.unmount(host, index, content, item, output);
            this.unbindMountItem(item);
        }
        if (this.mMountStats.isLoggingEnabled) {
            this.mMountStats.unmountedTimes.add((double)(System.nanoTime() - startTime) / 1000000.0);
            this.mMountStats.unmountedNames.add(component.getSimpleName());
            this.mMountStats.unmountedCount++;
        }
    }

    public void unbindMountItem(MountItem mountItem) {
        LayoutOutput output = LayoutOutput.getLayoutOutput(mountItem);
        long layoutOutputId = output.getId();
        MountState.maybeUnsetViewAttributes(mountItem);
        this.unbindAndUnmountLifecycle(mountItem);
        this.applyUnbindBinders(output, mountItem);
        try {
            LithoMountData.getMountData(mountItem).releaseMountContent(this.mContext.getAndroidContext(), mountItem, "unmountItem", this.mRecyclingMode);
        }
        catch (LithoMountData.ReleasingReleasedMountContentException e) {
            throw new RuntimeException(e.getMessage() + " " + this.getMountItemDebugMessage(mountItem));
        }
    }

    private void unbindAndUnmountLifecycle(MountItem item) {
        LayoutOutput layoutOutput = LayoutOutput.getLayoutOutput(item);
        Component component = layoutOutput.getComponent();
        Object content = item.getContent();
        ComponentContext context = this.getContextForComponent(component, layoutOutput);
        if (item.isBound()) {
            this.unbindComponentFromContent(item, component, content);
        }
        if (this.mRecyclingMode != 3) {
            component.unmount(context, content);
        }
    }

    public boolean isRootItem(int position) {
        MountItem mountItem = this.getItemAt(position);
        if (mountItem == null) {
            return false;
        }
        return mountItem == this.mIndexToItemMap.get(0L);
    }

    @Nullable
    public MountItem getRootItem() {
        return this.mIndexToItemMap != null ? (MountItem)this.mIndexToItemMap.get(0L) : null;
    }

    @Nullable
    MountItem getItemAt(int i) {
        ThreadUtils.assertMainThread();
        if (this.mIndexToItemMap == null || this.mLayoutOutputsIds == null) {
            return null;
        }
        if (i >= this.mLayoutOutputsIds.length) {
            return null;
        }
        return (MountItem)this.mIndexToItemMap.get(this.mLayoutOutputsIds[i]);
    }

    public Object getContentAt(int i) {
        MountItem mountItem = this.getItemAt(i);
        if (mountItem == null) {
            return null;
        }
        return mountItem.getContent();
    }

    @Nullable
    public Object getContentById(long id2) {
        if (this.mIndexToItemMap == null) {
            return null;
        }
        MountItem mountItem = (MountItem)this.mIndexToItemMap.get(id2);
        if (mountItem == null) {
            return null;
        }
        return mountItem.getContent();
    }

    public LongSparseArray<MountItem> getIndexToItemMap() {
        return this.mIndexToItemMap;
    }

    private static int findLastDescendantIndex(LayoutState layoutState, int index) {
        LayoutOutput host = LayoutOutput.getLayoutOutput(layoutState.getMountableOutputAt(index));
        long hostId = host.getId();
        int size = layoutState.getMountableOutputCount();
        for (int i = index + 1; i < size; ++i) {
            LayoutOutput layoutOutput = LayoutOutput.getLayoutOutput(layoutState.getMountableOutputAt(i));
            long curentHostId = layoutOutput.getHostMarker();
            while (curentHostId != hostId) {
                if (curentHostId == 0L) {
                    return i - 1;
                }
                int parentIndex = layoutState.getPositionForId(curentHostId);
                LayoutOutput parent = LayoutOutput.getLayoutOutput(layoutState.getMountableOutputAt(parentIndex));
                curentHostId = parent.getHostMarker();
            }
        }
        return layoutState.getMountableOutputCount() - 1;
    }

    public void clearLastMountedTree() {
        if (this.mTransitionsExtension != null) {
            this.mTransitionsExtension.clearLastMountedTreeId(this.mTransitionsExtensionState);
        }
        this.mLastMountedComponentTreeId = -1;
    }

    void unbind() {
        ThreadUtils.assertMainThread();
        if (this.mLayoutOutputsIds == null) {
            return;
        }
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("MountState.unbind");
        }
        int size = this.mLayoutOutputsIds.length;
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = this.getItemAt(i);
            if (mountItem == null || !mountItem.isBound()) continue;
            this.unbindComponentFromContent(mountItem, LayoutOutput.getLayoutOutput(mountItem).getComponent(), mountItem.getContent());
        }
        this.clearVisibilityItems();
        if (this.mVisibilityExtension != null) {
            this.mVisibilityExtension.onUnbind(this.mVisibilityExtensionState);
        }
        if (this.mTransitionsExtension != null) {
            this.mTransitionsExtension.onUnbind(this.mTransitionsExtensionState);
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    public void detach() {
        ThreadUtils.assertMainThread();
        this.unbind();
    }

    public void attach() {
        this.rebind();
    }

    void rebind() {
        ThreadUtils.assertMainThread();
        if (this.mLayoutOutputsIds == null) {
            return;
        }
        int size = this.mLayoutOutputsIds.length;
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = this.getItemAt(i);
            if (mountItem == null || mountItem.isBound()) continue;
            Component component = LayoutOutput.getLayoutOutput(mountItem).getComponent();
            Object content = mountItem.getContent();
            this.bindComponentToContent(mountItem, component, content);
            if (!(content instanceof View) || content instanceof ComponentHost || !((View)content).isLayoutRequested()) continue;
            View view = (View)content;
            MountState.applyBoundsToMountContent(view, view.getLeft(), view.getTop(), view.getRight(), view.getBottom(), true);
        }
    }

    private boolean isAnimationLocked(RenderTreeNode renderTreeNode) {
        if (this.mTransitionsExtension != null) {
            if (this.mTransitionsExtensionState == null) {
                throw new IllegalStateException("Need a state when using the TransitionsExtension.");
            }
            return this.mTransitionsExtensionState.ownsReference(renderTreeNode.getRenderUnit().getId());
        }
        return false;
    }

    private boolean performIncrementalMount(LayoutState layoutState, Rect localVisibleRect, boolean processVisibilityOutputs) {
        int height;
        int layoutOutputIndex;
        if (this.mPreviousLocalVisibleRect.isEmpty()) {
            return false;
        }
        if (localVisibleRect.left != this.mPreviousLocalVisibleRect.left || localVisibleRect.right != this.mPreviousLocalVisibleRect.right) {
            return false;
        }
        List layoutOutputTops = layoutState.getOutputsOrderedByTopBounds();
        List layoutOutputBottoms = layoutState.getOutputsOrderedByBottomBounds();
        int count = layoutState.getMountableOutputCount();
        if (localVisibleRect.top >= 0 || this.mPreviousLocalVisibleRect.top >= 0) {
            RenderTreeNode node;
            while (this.mPreviousBottomsIndex < count && localVisibleRect.top >= layoutState.getLayoutOutput((IncrementalMountOutput)((IncrementalMountOutput)((ArrayList)layoutOutputBottoms).get((int)this.mPreviousBottomsIndex))).getBounds().bottom) {
                node = layoutState.getRenderTreeNode((IncrementalMountOutput)((ArrayList)layoutOutputBottoms).get(this.mPreviousBottomsIndex));
                long id2 = LayoutOutput.getLayoutOutput(node).getId();
                layoutOutputIndex = layoutState.getPositionForId(id2);
                if (!this.isAnimationLocked(node)) {
                    this.unmountItem(layoutOutputIndex, this.mHostsByMarker);
                }
                ++this.mPreviousBottomsIndex;
            }
            while (this.mPreviousBottomsIndex > 0 && localVisibleRect.top <= layoutState.getLayoutOutput((IncrementalMountOutput)((IncrementalMountOutput)((ArrayList)layoutOutputBottoms).get((int)(this.mPreviousBottomsIndex - 1)))).getBounds().bottom) {
                --this.mPreviousBottomsIndex;
                node = layoutState.getRenderTreeNode((IncrementalMountOutput)((ArrayList)layoutOutputBottoms).get(this.mPreviousBottomsIndex));
                LayoutOutput layoutOutput = LayoutOutput.getLayoutOutput(node);
                int layoutOutputIndex2 = layoutState.getPositionForId(layoutOutput.getId());
                if (this.getItemAt(layoutOutputIndex2) != null) continue;
                this.mountLayoutOutput(layoutState.getPositionForId(layoutOutput.getId()), node, layoutOutput, layoutState);
                this.mComponentIdsMountedInThisFrame.add(layoutOutput.getId());
            }
        }
        if (localVisibleRect.bottom < (height = this.mLithoView.getHeight()) || this.mPreviousLocalVisibleRect.bottom < height) {
            while (this.mPreviousTopsIndex < count && localVisibleRect.bottom >= layoutState.getLayoutOutput((IncrementalMountOutput)((IncrementalMountOutput)((ArrayList)layoutOutputTops).get((int)this.mPreviousTopsIndex))).getBounds().top) {
                RenderTreeNode node = layoutState.getRenderTreeNode((IncrementalMountOutput)((ArrayList)layoutOutputTops).get(this.mPreviousTopsIndex));
                LayoutOutput layoutOutput = LayoutOutput.getLayoutOutput(node);
                layoutOutputIndex = layoutState.getPositionForId(layoutOutput.getId());
                if (this.getItemAt(layoutOutputIndex) == null) {
                    this.mountLayoutOutput(layoutState.getPositionForId(layoutOutput.getId()), node, layoutOutput, layoutState);
                    this.mComponentIdsMountedInThisFrame.add(layoutOutput.getId());
                }
                ++this.mPreviousTopsIndex;
            }
            while (this.mPreviousTopsIndex > 0 && localVisibleRect.bottom < layoutState.getLayoutOutput((IncrementalMountOutput)((IncrementalMountOutput)((ArrayList)layoutOutputTops).get((int)(this.mPreviousTopsIndex - 1)))).getBounds().top) {
                --this.mPreviousTopsIndex;
                RenderTreeNode node = layoutState.getRenderTreeNode((IncrementalMountOutput)((ArrayList)layoutOutputTops).get(this.mPreviousTopsIndex));
                long id3 = LayoutOutput.getLayoutOutput(node).getId();
                int layoutOutputIndex3 = layoutState.getPositionForId(id3);
                if (this.isAnimationLocked(node)) continue;
                this.unmountItem(layoutOutputIndex3, this.mHostsByMarker);
            }
        }
        int size = this.mCanMountIncrementallyMountItems.size();
        for (int i = 0; i < size; ++i) {
            int layoutOutputPosition;
            MountItem mountItem = (MountItem)this.mCanMountIncrementallyMountItems.valueAt(i);
            long layoutOutputId = this.mCanMountIncrementallyMountItems.keyAt(i);
            if (this.mComponentIdsMountedInThisFrame.contains(layoutOutputId) || (layoutOutputPosition = layoutState.getPositionForId(layoutOutputId)) == -1) continue;
            MountState.mountItemIncrementally(mountItem, processVisibilityOutputs);
        }
        this.mComponentIdsMountedInThisFrame.clear();
        return true;
    }

    void collectAllTransitions(LayoutState layoutState, ComponentTree componentTree) {
        ThreadUtils.assertMainThread();
        if (this.mTransitionsExtension != null) {
            TransitionsExtension.collectAllTransitions((ExtensionState)this.mTransitionsExtensionState, (TransitionsExtensionInput)layoutState);
            return;
        }
    }

    @VisibleForTesting(otherwise=2)
    Deque<TestItem> findTestItems(String testKey) {
        if (this.mTestItemMap == null) {
            throw new UnsupportedOperationException("Trying to access TestItems while ComponentsConfiguration.isEndToEndTestRun is false.");
        }
        LinkedList items = this.mTestItemMap.get(testKey);
        return items == null ? new LinkedList() : items;
    }

    private ComponentContext getContextForComponent(Component component, LayoutOutput layoutOutput) {
        ComponentContext c = this.mUseStatelessComponent ? layoutOutput.getScopedContext() : component.getScopedContext(null, null);
        return c == null ? this.mContext : c;
    }

    private void bindComponentToContent(MountItem mountItem, Component component, Object content) {
        LayoutOutput layoutOutput = LayoutOutput.getLayoutOutput(mountItem);
        component.bind(this.getContextForComponent(component, layoutOutput), content);
        this.mDynamicPropsManager.onBindComponentToContent(component, content);
        mountItem.setIsBound(true);
    }

    private void unbindComponentFromContent(MountItem mountItem, Component component, Object content) {
        LayoutOutput layoutOutput = LayoutOutput.getLayoutOutput(mountItem);
        this.mDynamicPropsManager.onUnbindComponent(component, content);
        component.unbind(this.getContextForComponent(component, layoutOutput), content);
        mountItem.setIsBound(false);
    }

    @VisibleForTesting
    DynamicPropsManager getDynamicPropsManager() {
        return this.mDynamicPropsManager;
    }

    private static class MountStats {
        private List<String> mountedNames;
        private List<String> unmountedNames;
        private List<String> updatedNames;
        private List<String> visibilityHandlerNames;
        private List<String> extras;
        private List<Double> mountTimes;
        private List<Double> unmountedTimes;
        private List<Double> updatedTimes;
        private List<Double> visibilityHandlerTimes;
        private int mountedCount;
        private int unmountedCount;
        private int updatedCount;
        private int noOpCount;
        private double visibilityHandlersTotalTime;
        private boolean isLoggingEnabled;
        private boolean isInitialized;

        private MountStats() {
        }

        private void enableLogging() {
            this.isLoggingEnabled = true;
            if (!this.isInitialized) {
                this.isInitialized = true;
                this.mountedNames = new ArrayList<String>();
                this.unmountedNames = new ArrayList<String>();
                this.updatedNames = new ArrayList<String>();
                this.visibilityHandlerNames = new ArrayList<String>();
                this.extras = new ArrayList<String>();
                this.mountTimes = new ArrayList<Double>();
                this.unmountedTimes = new ArrayList<Double>();
                this.updatedTimes = new ArrayList<Double>();
                this.visibilityHandlerTimes = new ArrayList<Double>();
            }
        }

        private void reset() {
            this.mountedCount = 0;
            this.unmountedCount = 0;
            this.updatedCount = 0;
            this.noOpCount = 0;
            this.visibilityHandlersTotalTime = 0.0;
            if (this.isInitialized) {
                this.mountedNames.clear();
                this.unmountedNames.clear();
                this.updatedNames.clear();
                this.visibilityHandlerNames.clear();
                this.extras.clear();
                this.mountTimes.clear();
                this.unmountedTimes.clear();
                this.updatedTimes.clear();
                this.visibilityHandlerTimes.clear();
            }
            this.isLoggingEnabled = false;
        }
    }

    private static class PrepareMountStats {
        private int unmountedCount = 0;
        private int movedCount = 0;
        private int unchangedCount = 0;

        private PrepareMountStats() {
        }

        private void reset() {
            this.unchangedCount = 0;
            this.movedCount = 0;
            this.unmountedCount = 0;
        }
    }
}

