/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.SizeSpec;

public class MeasureComparisonUtils {
    private static boolean newSizeIsExactAndMatchesOldMeasuredSize(int newSizeSpecMode, int newSizeSpecSize, int oldMeasuredSize) {
        return newSizeSpecMode == 0x40000000 && newSizeSpecSize == oldMeasuredSize;
    }

    private static boolean oldSizeIsUnspecifiedAndStillFits(int oldSizeSpecMode, int newSizeSpecMode, int newSizeSpecSize, int oldMeasuredSize) {
        return newSizeSpecMode == Integer.MIN_VALUE && oldSizeSpecMode == 0 && newSizeSpecSize >= oldMeasuredSize;
    }

    private static boolean newMeasureSizeIsStricterAndStillValid(int oldSizeSpecMode, int newSizeSpecMode, int oldSizeSpecSize, int newSizeSpecSize, int oldMeasuredSize) {
        return oldSizeSpecMode == Integer.MIN_VALUE && newSizeSpecMode == Integer.MIN_VALUE && oldSizeSpecSize > newSizeSpecSize && oldMeasuredSize <= newSizeSpecSize;
    }

    public static boolean areMeasureSpecsEquivalent(int specA, int specB) {
        return specA == specB || SizeSpec.getMode(specA) == 0 && SizeSpec.getMode(specB) == 0;
    }

    public static boolean isMeasureSpecCompatible(int oldSizeSpec, int sizeSpec, int oldMeasuredSize) {
        int newSpecMode = SizeSpec.getMode(sizeSpec);
        int newSpecSize = SizeSpec.getSize(sizeSpec);
        int oldSpecMode = SizeSpec.getMode(oldSizeSpec);
        int oldSpecSize = SizeSpec.getSize(oldSizeSpec);
        return oldSizeSpec == sizeSpec || oldSpecMode == 0 && newSpecMode == 0 || MeasureComparisonUtils.newSizeIsExactAndMatchesOldMeasuredSize(newSpecMode, newSpecSize, oldMeasuredSize) || MeasureComparisonUtils.oldSizeIsUnspecifiedAndStillFits(oldSpecMode, newSpecMode, newSpecSize, oldMeasuredSize) || MeasureComparisonUtils.newMeasureSizeIsStricterAndStillValid(oldSpecMode, newSpecMode, oldSpecSize, newSpecSize, oldMeasuredSize);
    }
}

