/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.PerfEvent;
import com.facebook.litho.TreeProps;
import java.util.Map;
import javax.annotation.CheckReturnValue;

public final class LogTreePopulator {
    private LogTreePopulator() {
    }

    @CheckReturnValue
    @Nullable
    public static PerfEvent populatePerfEventFromLogger(ComponentContext c, ComponentsLogger logger, @Nullable PerfEvent perfEvent) {
        return LogTreePopulator.populatePerfEventFromLogger(logger, c.getLogTag(), perfEvent, c.getTreeProps());
    }

    @CheckReturnValue
    @Nullable
    public static PerfEvent populatePerfEventFromLogger(ComponentContext c, ComponentsLogger logger, @Nullable String logTag, @Nullable PerfEvent perfEvent) {
        return LogTreePopulator.populatePerfEventFromLogger(logger, logTag, perfEvent, c.getTreeProps());
    }

    @CheckReturnValue
    @Nullable
    static PerfEvent populatePerfEventFromLogger(ComponentsLogger logger, @Nullable String logTag, @Nullable PerfEvent perfEvent, @Nullable TreeProps treeProps) {
        if (perfEvent == null) {
            return null;
        }
        if (logTag == null) {
            logger.cancelPerfEvent(perfEvent);
            return null;
        }
        perfEvent.markerAnnotate("log_tag", logTag);
        if (treeProps == null) {
            return perfEvent;
        }
        Map<String, String> extraAnnotations = logger.getExtraAnnotations(treeProps);
        if (extraAnnotations == null) {
            return perfEvent;
        }
        for (Map.Entry<String, String> e : extraAnnotations.entrySet()) {
            perfEvent.markerAnnotate(e.getKey(), e.getValue());
        }
        return perfEvent;
    }

    @Nullable
    public static String getAnnotationBundleFromLogger(ComponentContext scopedContext, ComponentsLogger logger) {
        if (scopedContext == null) {
            return null;
        }
        TreeProps treeProps = scopedContext.getTreeProps();
        if (treeProps == null) {
            return null;
        }
        Map<String, String> extraAnnotations = logger.getExtraAnnotations(treeProps);
        if (extraAnnotations == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(extraAnnotations.size() * 16);
        for (Map.Entry<String, String> entry : extraAnnotations.entrySet()) {
            sb.append(entry.getKey());
            sb.append(':');
            sb.append(entry.getValue());
            sb.append(';');
        }
        return sb.toString();
    }
}

