/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.annotation.SuppressLint;
import androidx.annotation.Nullable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentUtils;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.DiffNode;
import com.facebook.litho.InternalNode;
import com.facebook.litho.Layout;
import com.facebook.litho.LayoutStateContext;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;

public class LithoYogaMeasureFunction
implements YogaMeasureFunction {
    @Nullable
    private final LayoutStateContext mLayoutStateContext;
    @Nullable
    private final LayoutStateContext mPrevLayoutStateContext;

    private Size acquireSize(int initialValue) {
        return new Size(initialValue, initialValue);
    }

    public LithoYogaMeasureFunction(@Nullable LayoutStateContext layoutStateContext, @Nullable LayoutStateContext prevLayoutStateContext) {
        if (ComponentsConfiguration.useStatelessComponent && layoutStateContext == null) {
            throw new IllegalStateException("You must pass a non-null LayoutStateContext instance");
        }
        this.mLayoutStateContext = layoutStateContext;
        this.mPrevLayoutStateContext = prevLayoutStateContext;
    }

    @SuppressLint(value={"WrongCall"})
    public long measure(YogaNode cssNode, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
        InternalNode node = (InternalNode)cssNode.getData();
        Component component = node.getTailComponent();
        String componentGlobalKey = node.getTailComponentKey();
        ComponentContext componentScopedContext = component.getScopedContext(this.mLayoutStateContext, componentGlobalKey);
        try {
            if (componentScopedContext != null && componentScopedContext.wasLayoutCanceled()) {
                return 0L;
            }
            DiffNode diffNode = node.areCachedMeasuresValid() ? node.getDiffNode() : null;
            boolean isTracing = ComponentsSystrace.isTracing();
            int widthSpec = SizeSpec.makeSizeSpecFromCssSpec(width, widthMode);
            int heightSpec = SizeSpec.makeSizeSpecFromCssSpec(height, heightMode);
            if (isTracing) {
                ComponentsSystrace.beginSectionWithArgs("measure:" + component.getSimpleName()).arg("widthSpec", SizeSpec.toString(widthSpec)).arg("heightSpec", SizeSpec.toString(heightSpec)).arg("componentId", component.getId()).flush();
            }
            node.setLastWidthSpec(widthSpec);
            node.setLastHeightSpec(heightSpec);
            int outputWidth = 0;
            int outputHeight = 0;
            ComponentContext context = node.getContext();
            if (Component.isNestedTree(context, component) || node.hasNestedTree()) {
                String parentKey;
                Component parent;
                Component head = node.getHeadComponent();
                String headKey = node.getHeadComponentKey();
                if (component != head) {
                    parent = head;
                    parentKey = headKey;
                } else if (node.getParent() != null) {
                    parent = node.getParent().getTailComponent();
                    parentKey = node.getParent().getTailComponentKey();
                } else {
                    parent = null;
                    parentKey = null;
                }
                if (parent != null) {
                    context = parent.getScopedContext(this.mLayoutStateContext, parentKey);
                }
                InternalNode nestedTree = Layout.create(context, node, widthSpec, heightSpec, this.mPrevLayoutStateContext);
                outputWidth = nestedTree.getWidth();
                outputHeight = nestedTree.getHeight();
            } else if (diffNode != null && diffNode.getLastWidthSpec() == widthSpec && diffNode.getLastHeightSpec() == heightSpec && !component.shouldAlwaysRemeasure()) {
                outputWidth = (int)diffNode.getLastMeasuredWidth();
                outputHeight = (int)diffNode.getLastMeasuredHeight();
            } else {
                Size size = this.acquireSize(Integer.MIN_VALUE);
                component.onMeasure(componentScopedContext, node, widthSpec, heightSpec, size);
                if (size.width < 0 || size.height < 0) {
                    throw new IllegalStateException("MeasureOutput not set, ComponentLifecycle is: " + component);
                }
                outputWidth = size.width;
                outputHeight = size.height;
                if (node.getDiffNode() != null) {
                    node.getDiffNode().setLastWidthSpec(widthSpec);
                    node.getDiffNode().setLastHeightSpec(heightSpec);
                    node.getDiffNode().setLastMeasuredWidth(outputWidth);
                    node.getDiffNode().setLastMeasuredHeight(outputHeight);
                }
            }
            node.setLastMeasuredWidth(outputWidth);
            node.setLastMeasuredHeight(outputHeight);
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
            return YogaMeasureOutput.make((int)outputWidth, (int)outputHeight);
        }
        catch (Exception e) {
            throw ComponentUtils.wrapWithMetadata(componentScopedContext, e);
        }
    }
}

